//************************************************************************************
// 1701hul1.inc -- Primary hull (saucer section) of the original USS
// Enterprise.
//
// Written April 1998 by Jeff Lee <shipbrk@gate.net>
//
// Permission is granted to use these include files for any noncommercial
// purpose, as long as credit is given to the original author.  When
// distributing these files, please distribute the original archive only,
// or clearly label the files as modified from the original versions,
// retaining the original author's name and email address and adding the
// name of the modifier.
//
//====================================================================================
//============================================================================
//
// Unfortunately, this file is kind of ugly.  I calculated positions for all
// of the features by scanning in the Enterprise blueprints and using
// CorelDRAW! to determine the placement.  Unfortunately, I neglected to
// scale the cross-section of the primary hull to the proper size, so it
// required doing a lot of scaling in order to bring things to the correct
// size.
//
//============================================================================
//============================================================================
// Formation lights: green, red, yellow, salmon.  These lights include actual
// POV-Ray light sources, which will slow down rendering.  If you wish to
// prevent the use of the light sources, set the variable E1701_No_Lights
// (the value is irrelevant) before including the main file.
//
// All lights except for the yellow one can be turned on or off by setting
// the value of E1701_Lights_On to 1 or 0, respectively.
//
#declare E1701_Hull1_Green_Light = union {
  torus { 0.6929,0.1732258 }
  cylinder { <0,0,0>, <0,0.1732258,0>, 0.6929 }
  sphere { <0,0.1732258,0>, 0.4 texture { t_green_light }}
  #ifndef (E1701_No_Lights)
    #if (E1701_Lights_On = 1)
      light_source { <0,0.7,0>
      colour rgb <0,0.25,0>
      fade_distance 3*E1701_Scale
      fade_power 2
    }
    #end
  #end
}

#declare E1701_Hull1_Red_Light = union {
  torus { 0.6929,0.1732258 }
  cylinder { <0,0,0>, <0,0.1732258,0>, 0.6929 }
  sphere { <0,0.1732258,0>, 0.4 texture { t_red_light }}
  #ifndef (E1701_No_Lights)
    #if (E1701_Lights_On = 1)
      light_source { <0,0.7,0>
      colour rgb <0.35,0,0>
      fade_distance 3*E1701_Scale
      fade_power 2
    }
    #end
  #end
}

#declare E1701_Hull1_Yellow_Light = union {
  torus { 0.6929,0.1732258 }
  cylinder { <0,0,0>, <0,0.1732258,0>, 0.6929 }
  sphere { <0,0.1732258,0>, 0.4
    texture { t_yellow_light }
  }
  #ifndef (E1701_No_Lights)
    light_source { <0,0.7,0>
    colour rgb <0.4,0.4,0>
    fade_distance 3*E1701_Scale
    fade_power 2
  }
  #end
}

#declare E1701_Hull1_Formation_Light = union {
  torus { 0.6929,0.1732258 }
  cylinder { <0,0,0>, <0,0.1732258,0>, 0.6929 }
  sphere { <0,0.1732258,0>, 0.4 texture { t_salmon_light }}
  #ifndef (E1701_No_Lights)
    #if (E1701_Lights_On = 1)
      light_source { <0,0.7,0>
      colour rgb <0.35,0.25,0.2>
      fade_distance 2*E1701_Scale
      fade_power 2
    }
    #end
  #end
}

//============================================================================
// Various square formation lights.  These are not actual light sources,
//
#declare E1701_Hull1_Access1 = box { <-0.22,-2.64,26.00>, <0.22,-2.66,25.00>
  texture { t_formation_lights }
}

#declare E1701_Hull1_FormLight1 = box { <-1.11,-0.01,-23.38>, <1.11,0.01,-25.6>
  texture { t_formation_lights }
}

#declare E1701_Hull1_FormLight2 = box { <-0.622,-0.01,21.69>, <0.622,0.01,22.67>
  texture { t_formation_lights }
}


//============================================================================
// L-shaped cargo hatches (?) on the top of the main saucer, aft.
//
#declare E1701_Hull1_Cargo1 = union {
  box { <1.4225, -0.01, 26.85>, <6.22, 0.01, 24.71> }
  box { <1.4225, -0.01, 24.71>, <3.37, 0.01, 23.30> }
  texture { t_dark_hull }
}  

//============================================================================
// Cone for the windows on the edge of the saucer.  All windows on the
// Enterprise are created by taking the shape of the thing they're attached
// to, making it just a fraction bigger than the original, and intersecting
// the window shapes with it.  This is much faster than differencing the
// windows from the hull, which was what I originally tried.
//
#declare E1701_Hull1_WindowCone = cone { <0,0,0>, 28.45, <0,-2.45,0>, 27.25 scale 1.001}

#declare E1701_Hull1_Scanner = intersection {
  object { E1701_Hull1_WindowCone }
  cylinder { <0,-1.6,-28.5>, <0,-1.6,-27.2>, 0.3 }
  texture { t_lit_window }
}

#declare E1701_Hull1_Porthole6 = intersection {
  object { E1701_Hull1_WindowCone }
  cylinder { <0,-0.65,-28.5>, <0,-0.65,-27.2>, 0.1 }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window6_Lit = intersection {
  object { E1701_Hull1_WindowCone }
  box { <-0.25,-0.55,-28.5>, <0.25,-0.80,-27.2> }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window6_Dark = intersection {
  object { E1701_Hull1_WindowCone }
  box { <-0.25,-0.55,-28.5>, <0.25,-0.80,-27.2> }
  texture { t_dark_window }
}

#declare E1701_Hull1_Porthole7 = intersection {
  object { E1701_Hull1_WindowCone }
  cylinder { <0,-1.6,-28.5>, <0,-1.6,-27.2>, 0.1 }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window7_Lit = intersection {
  object { E1701_Hull1_WindowCone }
  box { <-0.25,-1.5,-28.5>, <0.25,-1.75,-27.2> }
  texture { t_lit_window }
}

#declare E1701_Hull1_DiscWindows = union {
  object { E1701_Hull1_Scanner }
  object { E1701_Hull1_Scanner rotate y*-2}
  object { E1701_Hull1_Scanner rotate y* 2}
  object { E1701_Hull1_Window6_Lit  rotate y*43.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*41.0 }
  object { E1701_Hull1_Window6_Dark rotate y*39.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*37.0 }
  object { E1701_Hull1_Porthole6    rotate y*31.5 }
  object { E1701_Hull1_Porthole6    rotate y*90.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*131.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*129.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*127.0 }
  object { E1701_Hull1_Window6_Dark  rotate y*125.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*-43.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*-41.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*-39.0 }
  object { E1701_Hull1_Window6_Dark rotate y*-37.0 }
  object { E1701_Hull1_Porthole6    rotate y*-31.5 }
  object { E1701_Hull1_Porthole6    rotate y*-90.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*-131.0 }
  object { E1701_Hull1_Window6_Dark  rotate y*-129.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*-127.0 }
  object { E1701_Hull1_Window6_Lit  rotate y*-125.0 }
  object { E1701_Hull1_Window7_Lit rotate y*35.0 }
  object { E1701_Hull1_Porthole7   rotate y*46.5 }
  object { E1701_Hull1_Window7_Lit rotate y*133.0 }
  object { E1701_Hull1_Window7_Lit rotate y*-35.0 }
  object { E1701_Hull1_Porthole7   rotate y*-46.5 }
  object { E1701_Hull1_Window7_Lit rotate y*-133.0 }
}

//============================================================================
// The main saucer is hollow, since the lower "bulge" actually cuts into the
// bottom.
//
#declare E1701_Hull1_DiscDecks = difference {
  cone { <0,0,0>, 28.45, <0,-2.45,0>, 27.25 }
  cone { <0,0.01,0>, 28.30, <0,-2.46,0>, 27.10 }
}  

//============================================================================
// The side of the impulse engines.  In retrospect, this would have been made
// much easier by using the matrix transformation... 
//
#declare E1701_Hull1_Impulse_Edge = union {
  intersection {
    cylinder { <0,0,3>, <0,0,-3>, 0.5 rotate y*30 }
    plane { z, 0 }
  }
  triangle { <0, 0.5,0>, <0, 0.5,-2.598076>, <-1.5, 0.5,-2.598076> }
  triangle { <0,-0.5,0>, <0,-0.5,-2.598076>, <-1.5,-0.5,-2.598076> }
}

//============================================================================
// Features on the aft edge of the impulse engines.
//
#declare E1701_Hull1_Impulse_Grille = box { <-0.15,-0.15,-0.05>, <0.15,0.15,0.05>
  texture { t_grille }
}

#declare E1701_Hull1_Impulse_Dot = sphere { <0,0,0>, 0.05 }

//============================================================================
// Impulse engine.
//
#declare E1701_Hull1_Impulse_Engine = union {
  object { E1701_Hull1_Impulse_Edge translate x*-2.9 }
  object { E1701_Hull1_Impulse_Edge rotate z*180 translate x*2.9 }
  box { <-2.9,-0.5,0>, <2.9,0.5,-2.598076> }
  object { E1701_Hull1_Impulse_Grille translate x*-2.25 }
  object { E1701_Hull1_Impulse_Grille translate x*-1.80 }
  object { E1701_Hull1_Impulse_Grille translate x*-0.90 }
  object { E1701_Hull1_Impulse_Grille translate x*-0.45 }
  object { E1701_Hull1_Impulse_Grille translate x* 0.45 }
  object { E1701_Hull1_Impulse_Grille translate x* 0.90 }
  object { E1701_Hull1_Impulse_Grille translate x* 1.80 }
  object { E1701_Hull1_Impulse_Grille translate x* 2.25 }
  object { E1701_Hull1_Impulse_Dot translate x*-2.7 }
  object { E1701_Hull1_Impulse_Dot translate x*-1.35 }
  object { E1701_Hull1_Impulse_Dot }
  object { E1701_Hull1_Impulse_Dot translate x* 1.35 }
  object { E1701_Hull1_Impulse_Dot translate x* 2.7 }
  scale 1.7781255
}

//============================================================================
// The main disc of the saucer section.  The curved bottom edge is created by
// using an open cubic_spline lathe.
//
#declare E1701_Hull1_Disc = union {
  disc { <0,0,0>, y, 28.45 }
  object{ E1701_Hull1_DiscDecks }
  #ifndef (Quick)
    object{ E1701_Hull1_DiscWindows }
  #end
  object { E1701_Hull1_Impulse_Engine translate <0,-0.88906275,29.7781255> }
/*
  lathe {
    cubic_spline 4,
    <27.35, -2.30>, <27.25, -2.45>, <26.85, -2.65>, <25.00, -2.65>
//    sturm
  }
*/
  intersection {
    lathe {
      cubic_spline 15,
      <26.10,-1.90>, <26.55,-1.80>, <27.10,-1.80>, <27.55,-2.00>, <27.45,-2.15>,
      <27.35,-2.30>, <27.25,-2.45>, <26.85,-2.65>, <26.50,-2.65>, <26.32,-2.65>, 
      <26.15,-2.65>, <26.00,-2.35>, <26.10,-1.90>, <26.55,-1.80>, <27.10,-1.80>
//      sturm
    }
    cylinder {
      <0,-2.45,0>, <0,-2.65,0>, 27.25
    }
  }
  disc { <0,-2.65,0>, -y, 26.85, 24.05 }
  object { E1701_Hull1_Access1 rotate y*-49.0 }
  object { E1701_Hull1_Access1 rotate y*-51.0 }
  object { E1701_Hull1_Access1 rotate y*-53.0 }
  object { E1701_Hull1_Access1 rotate y* 49.0 }
  object { E1701_Hull1_Access1 rotate y* 51.0 }
  object { E1701_Hull1_Access1 rotate y* 53.0 }
  object { E1701_Hull1_Yellow_Light translate <0,0,-26.9366129> }
  object { E1701_Hull1_Green_Light translate <-26.9366129,0,0> }
  object { E1701_Hull1_Red_Light   translate < 26.9366129,0,0> }
  object { E1701_Hull1_Green_Light rotate x*180 translate <-25.6374184,-2.65,0> }
  object { E1701_Hull1_Red_Light   rotate x*180 translate < 25.6374184,-2.65,0> }
  object { E1701_Hull1_Formation_Light translate <0,0,26.9366129> rotate y*30 }
  object { E1701_Hull1_Formation_Light translate <0,0,26.9366129> rotate y*-30 }
  object { E1701_Hull1_Cargo1 }
  object { E1701_Hull1_Cargo1 rotate z*180}
  object { E1701_Hull1_FormLight1 rotate y*37.5 }
  object { E1701_Hull1_FormLight1 rotate y*127.5 }
  object { E1701_Hull1_FormLight1 rotate y*-127.5 }
  object { E1701_Hull1_FormLight1 rotate y*-37.5 }
  object { E1701_Hull1_FormLight2 rotate y*18 }
  object { E1701_Hull1_FormLight2 rotate y*-18 }
}

//============================================================================
// The top and bottom "bulges" are made in one piece, as a cubic_spline lathe.
//
#declare E1701_Hull1_Bulges = intersection {
  lathe {
    cubic_spline 32,
    < 0.30,-4.55>, < 0.30, 0.45>, < 0.30, 1.60>, < 0.30, 2.15>, < 0.55, 2.45>, 
    < 0.99, 2.54>, < 3.05, 2.40>, <19.80, 0.00>, <24.45,-0.98>, <26.00,-1.85>, 
    <26.35,-2.40>, <26.10,-3.00>, <25.70,-3.15>, <25.35,-3.00>, <24.05,-2.65>, 
    <21.50,-2.20>, <18.45,-2.20>, <15.60,-2.45>, <13.05,-3.05>, <11.25,-3.75>, 
    < 9.40,-4.58>, < 7.50,-5.50>, < 5.55,-6.35>, < 4.45,-6.65>, < 3.35,-6.80>, 
    < 1.85,-6.90>, < 0.85,-6.90>, < 0.50,-6.60>, < 0.30,-6.10>, < 0.30,-4.55>, 
    < 0.30, 0.45>, < 0.30, 1.60>
//    sturm
  }
  cylinder { <0,2.55,0>, <0,-6.91,0>, 24.05 }
  bounded_by { cylinder { <0,2.551,0>, <0,-6.911,0>, 24.051 }}
  texture { t_Hull1_HullTexture }
}

//============================================================================
// There are three rings on the lower bulge.  Unfortunately, since they're so
// thin, they don't look good unless you use an anti-aliasing threshold of
// 0.1 or lower -- which drastically increases render time.  I have therefore
// commented them out.
//
/*
#declare E1701_Hull1_Rings = union {
  torus { 13.90, 0.05 translate y*-2.79 }
  torus { 11.10, 0.05 translate y*-3.79 }
  torus {  8.90, 0.07 translate y*-4.79 }
  texture { t_Hull1_HullTexture }
}
*/

//============================================================================
// Intersection shape for the windows on the lower bulge.
//
#declare E1701_Hull1_WindowBulge = lathe {
  cubic_spline 32,
  < 0.30,-4.55>, < 0.30, 0.45>, < 0.30, 1.60>, < 0.30, 2.15>, < 0.55, 2.45>, 
  < 0.99, 2.54>, < 3.05, 2.40>, <19.80, 0.00>, <24.45,-0.98>, <26.00,-1.85>, 
  <26.35,-2.40>, <26.10,-3.00>, <25.70,-3.15>, <25.35,-3.00>, <24.05,-2.65>, 
  <21.50,-2.20>, <18.45,-2.20>, <15.60,-2.45>, <13.05,-3.05>, <11.25,-3.75>, 
  < 9.40,-4.58>, < 7.50,-5.50>, < 5.55,-6.35>, < 4.45,-6.65>, < 3.35,-6.80>, 
  < 1.85,-6.90>, < 0.85,-6.90>, < 0.50,-6.60>, < 0.30,-6.10>, < 0.30,-4.55>, 
  < 0.30, 0.45>, < 0.30, 1.60>
  scale 1.001
}

#declare E1701_Hull1_Window9_Lit = intersection {
  object { E1701_Hull1_WindowBulge }
  box { <-0.266,-3.98832,-12.5>, <0.266,-4.16558,-9.0> }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window9_Dark = intersection {
  object { E1701_Hull1_WindowBulge }
  box { <-0.266,-3.98832,-12.5>, <0.266,-4.16558,-9.0> }
  texture { t_dark_window }
}

#declare E1701_Hull1_Windows9 = union {
  object { E1701_Hull1_Window9_Lit }
  object { E1701_Hull1_Window9_Lit  rotate y*-4.5 }
  object { E1701_Hull1_Window9_Lit  rotate y* 4.5 }
  object { E1701_Hull1_Window9_Lit  rotate y*-85.5 }
  object { E1701_Hull1_Window9_Dark rotate y*-94.5 }
  object { E1701_Hull1_Window9_Dark rotate y* 85.5 }
  object { E1701_Hull1_Window9_Lit  rotate y* 94.5 }
}

#declare E1701_Hull1_Window10_Lit = intersection {
  object { E1701_Hull1_WindowBulge }
  box { <-0.266,-5.22913,-9.0>, <0.266,-5.40639,-7.0> }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window10_Dark = intersection {
  object { E1701_Hull1_WindowBulge }
  box { <-0.266,-5.22913,-9.0>, <0.266,-5.40639,-7.0> }
  texture { t_dark_window }
}

#declare E1701_Hull1_Window10_Half = intersection {
  object { E1701_Hull1_WindowBulge }
  box { <-0.133,-5.22913,-9.0>, <0.133,-5.40639,-7.0> }
  texture { t_lit_window }
}

#declare E1701_Hull1_Windows10 = union {
  object { E1701_Hull1_Window10_Lit  rotate y*-16 }
  object { E1701_Hull1_Window10_Dark  rotate y*-10 }
  object { E1701_Hull1_Window10_Half rotate y*-5 }
  object { E1701_Hull1_Window10_Lit }
  object { E1701_Hull1_Window10_Half rotate y*5 }
  object { E1701_Hull1_Window10_Lit  rotate y*10 }
  object { E1701_Hull1_Window10_Lit  rotate y*16 }

  object { E1701_Hull1_Window10_Lit  rotate y*78 }
  object { E1701_Hull1_Window10_Dark  rotate y*84 }
  object { E1701_Hull1_Window10_Lit  rotate y*90 }
  object { E1701_Hull1_Window10_Lit  rotate y*96 }
  object { E1701_Hull1_Window10_Dark  rotate y*102 }

  object { E1701_Hull1_Window10_Dark  rotate y*-78 }
  object { E1701_Hull1_Window10_Lit  rotate y*-84 }
  object { E1701_Hull1_Window10_Lit  rotate y*-90 }
  object { E1701_Hull1_Window10_Lit  rotate y*-96 }
  object { E1701_Hull1_Window10_Lit  rotate y*-102 }
}

//============================================================================
// Lower sensor array, and the stuff around it.  The windows on the lower
// bulge are also included here.
//
#declare E1701_Hull1_BottomStuff = union {
  #ifndef (Quick)
    object { E1701_Hull1_Windows9 }
    object { E1701_Hull1_Windows10 }
  #end
  cylinder { <0,-6.65,0>, <0,-7.15,0>, 3.35 }
  torus { 2.95, 0.40 scale <1,0.625,1> translate y*-7.15 }
  disc { <0,-7.40,0>, -y, 2.95 }
  cylinder { <0,-7.40,0>, <0,-7.60,0>, 2.40 open }
  torus { 2.20, 0.20 scale <1,0.75,01> translate y*-7.60 }
  disc { <0,-7.75,0>, -y, 2.20, 1.60 }
  merge {
    intersection { 
      sphere { <0,-3.77,0>, 4.275 }
      cylinder { <0,-7.4,0>, <0,-8.15,0>, 2.4 }
    }
    sphere { <0,-8.045,0>, 0.3 }
    texture { t_white_glass }
  }
  #ifndef (E1701_No_Lights)
    light_source { <0,-8.145,0>
      colour rgb <2,2,2>
      fade_distance 7*E1701_Scale
      fade_power 2
    }
  #end
}

//============================================================================
// Decks 1, 2 and 3.  Decks 2-3 are created by using a torus, a sphere, and
// two cylinders.  Ideally, the aft shape should be a smaller torus, but
// since the minor radius had to be bigger than the major radius, it didn't
// work properly.  Decks 2-3 are therefore slightly deformed; they should be
// wider at the aft end.
//
#declare E1701_Hull1_Bridge_Outer = union {
  torus { 2.05, 3.50 sturm translate <0.00,1.30,-0.75> } // Decks 2 & 3
  sphere { <0,1.30,5.70>, 3.50 }
  cylinder { < 1.95,1.30,-0.11>, <0,1.30,5.70>, 3.50 }
  cylinder { <-1.95,1.30,-0.11>, <0,1.30,5.70>, 3.50 }

  torus { 2.53, 0.95 sturm translate y*4.93 } // Deck 1
  cylinder { <0,4.93,0>, <0,4.00,0>, 3.48 }
  cylinder { <0,4.00,0>, <0,5.88,0>, 2.53 }
  cylinder { <0,4.00,3.43>, <0,5.88,3.43>, 0.65 }
  torus { 2.0, 0.10 sturm translate y*5.88 }
}

//============================================================================
// This is called "inner" because originally, I tried differencing the windows
// from the hull.  That took too long, but I haven't changed the names to
// reflect the difference.
//
#declare E1701_Hull1_Bridge_Inner = union {
  torus { 2.05, 3.50 sturm translate <0.00,1.30,-0.75> }
  sphere { <0,1.30,5.70>, 3.50 }
  cylinder { < 1.95,1.30,-0.11>, <0,1.30,5.70>, 3.50 }
  cylinder { <-1.95,1.30,-0.11>, <0,1.30,5.70>, 3.50 }
  torus { 2.53, 0.95 sturm translate y*4.93 }
  scale 1.001
}

#declare E1701_Hull1_Window1 = intersection {
  object { E1701_Hull1_Bridge_Inner }
  cylinder { <-4.44,5,0>, <4.44,5,0>, 0.1 }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window2 = box { <-0.3556251,3.9,0>, <0.3556251,3.5,-7.25> }

#declare E1701_Hull1_Windows2 = intersection {
  object { E1701_Hull1_Bridge_Inner }
  union {
    object { E1701_Hull1_Window2 rotate y*45.0 }
    object { E1701_Hull1_Window2 rotate y*57.5 }
    object { E1701_Hull1_Window2 rotate y*69.7 }
    object { E1701_Hull1_Window2 rotate y*82.2 }
    object { E1701_Hull1_Window2 rotate y*107.2 }
    object { E1701_Hull1_Window2 rotate y*-45.0 }
    object { E1701_Hull1_Window2 rotate y*-57.5 }
    object { E1701_Hull1_Window2 rotate y*-69.7 }
    object { E1701_Hull1_Window2 rotate y*-82.2 }
    object { E1701_Hull1_Window2 rotate y*-107.2 }
  }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window2a = intersection {
  object { E1701_Hull1_Bridge_Inner }
  cylinder { <-7.5,3.0,0>, <7.5,3.0,0>, 0.2 }
  texture { t_lit_window }
}

#declare E1701_Hull1_Window3a = box { <-0.3556251,2.7,0>, <0.3556251,2.3,-7.0> }
#declare E1701_Hull1_Window3b = cylinder { <0,2.5,0>, <0,2.5,-7.0>, 0.2 }
#declare E1701_Hull1_Window3c = cylinder { <0,2.6,0>, <0,2.6,-7.0>, 0.1 }

#declare E1701_Hull1_Windows3 = intersection {
  object { E1701_Hull1_Bridge_Inner }
  union {
    object { E1701_Hull1_Window3a rotate y*40.0 }
    object { E1701_Hull1_Window3a rotate y*-40.0 }
    object { E1701_Hull1_Window3a rotate y*120 }
    object { E1701_Hull1_Window3a rotate y*-120 }
    object { E1701_Hull1_Window3b rotate y*10 }
    object { E1701_Hull1_Window3b rotate y*-10 }
    object { E1701_Hull1_Window3c rotate y*110 }
    object { E1701_Hull1_Window3c rotate y*-110 }
  }
  texture { t_lit_window }
}


//============================================================================
// Okay, here's the whole bridge.
//
#declare E1701_Hull1_Bridge = union {
  object { E1701_Hull1_Bridge_Outer }
  #ifndef (Quick)
    object { E1701_Hull1_Window1 }
    object { E1701_Hull1_Windows2 }
    object { E1701_Hull1_Window2a }
    object { E1701_Hull1_Windows3 }
  #end
  disc { <0.00,4.80,-0.75>, -y, 2.05 }
  triangle { <-2.05,4.80,-0.75>, <2.05,4.80,-0.75>, <0,4.80,5.70> }
  intersection { 
    sphere { <0,-3.77,0>, 4.275 }
    cylinder { <0,-7.4,0>, <0,-8.15,0>, 2.4 }
    rotate x*180
    translate y*-1.52
    texture { t_white_glass }
  }
  #ifndef (E1701_No_Lights)
    light_source { <0,6.45,0>
      colour rgb <2,2,2>
      fade_distance 7*E1701_Scale
      fade_power 2
    }
  #end
}  

//============================================================================
// Piping/wiring trunk running from the aft part of the top bulge out to the
// edge of the impulse engine.
//
#declare E1701_Hull1_PWT = union {
  prism {
    linear_sweep cubic_spline
    0.0, 0.5, 25
    < 0.00, 0.00>, <-0.50, 0.00>, <-0.65, 0.00>, <-0.80,-0.25>, <-0.73,-0.33>, 
    <-0.55,-0.70>, <-0.45,-1.15>, <-0.50,-2.35>, <-0.65,-4.65>, <-0.74,-6.36>, 
    <-0.80,-7.45>, < 0.00,-8.35>, < 0.80,-7.45>, < 0.74,-6.36>, < 0.65,-4.65>,
    < 0.50,-2.35>, < 0.45,-1.15>, < 0.55,-0.70>, < 0.73,-0.33>, < 0.80,-0.25>,
    < 0.65, 0.00>, < 0.50, 0.00>, < 0.00, 0.00>, <-0.50, 0.00>, <-0.65, 0.00>
  }
  sphere { <0,0.5,-0.15>, 0.15 }
  sphere { <0,0.5,-8.20>, 0.15 }
  cylinder { <0,0.5,-0.15>, <0,0.5,-8.20>, 0.15 }
  scale 1.77258566
  translate z*29.5
}

//============================================================================
// Stick a fork in it, it's done.
//
#declare E1701_Hull1 = union {
  object { E1701_Hull1_Disc }
  object { E1701_Hull1_Bulges }
  object { E1701_Hull1_BottomStuff }
  object { E1701_Hull1_Bridge }
  object { E1701_Hull1_PWT }
  texture { t_hull1_streaky }
  scale 0.56414763
}
