//************************************************************************************
// 1701colr.inc -- specific textures for use with the original USS Enterprise.
//
// Written April 1998 by Jeff Lee <shipbrk@gate.net>
//
// Permission is granted to use these include files for any noncommercial
// purpose, as long as credit is given to the original author.  When
// distributing these files, please distribute the original archive only,
// or clearly label the files as modified from the original versions,
// retaining the original author's name and email address and adding the
// name of the modifier.
//
//====================================================================================
//====================================================================================
//
// Pigments.  The p_trek_* pigments are a subset of the colours from the original Star
// Trek technical manual (TM:379260-0, TO:00:10:10).  If you want the complete set of
// colours, send email to <shipbrk@gate.net> requesting the include file.
//
#declare p_trek_silver      = pigment { colour rgb <0.650980, 0.670588, 0.690196>} // 01
#declare p_trek_copper      = pigment { colour rgb <0.776471, 0.619608, 0.494118>} // 05
#declare p_trek_sky_blue    = pigment { colour rgb <0.690196, 0.862745, 0.882353>} // 16
#declare p_trek_brown       = pigment { colour rgb <0.501961, 0.000000, 0.011765>} // 24
#declare p_trek_taupe       = pigment { colour rgb <0.780392, 0.780392, 0.721569>} // 28
#declare p_trek_bluegrey    = pigment { colour rgb <0.533333, 0.713725, 0.745098>} // 31

#declare p_dirtyhull=pigment{colour rgb<0.690196,0.862745,0.882353>*0.80}


//====================================================================================
// Finishes.  If Quick is defined, no reflection is used, to speed up rendering.
//
#declare f_metallic1 = finish { specular 0.9 roughness 0.05 metallic }
#declare f_metallic2 = finish { phong 0.5 phong_size 25 metallic }
#declare f_metallic3 = finish { phong 1.0 phong_size 200 metallic
  #ifndef (Quick)
    reflection 0.2
  #end
}
#declare f_metallic4 = finish {
  ambient 0.20 diffuse 0.55 brilliance 4.5
  specular 0.8 roughness 0.011 metallic
  #ifndef (Quick)
    reflection 0.6
  #end
}

//====================================================================================
// Normals.  These aren't used if Quick is defined, in order to speed up rendering.
//
#ifndef (Quick)
  #declare n_grille = normal { gradient y 0.1 frequency 20 translate y*-100 }
  #declare n_hull = normal { bumps 0.05 scale 0.1 }
#end

//====================================================================================
//====================================================================================
// Nacelle textures.  The user has a choice of three types, which may be selected
// before the main include file is loaded.  Type 0 is a plain dark brown, type 1 is
// similar to the one used in the animated series, and type 2 is the "warp drive
// active" glow.  Types 1 and 2 may be animated by setting the variable
// E1701_Nacelle_Rotate.  This value is multiplied by 360, so if you set it to
// the clock value, it will rotate once over the duration of animation; setting it
// to twice the clock value will cause it to rotate twice, and so forth.
//
//------------------------------------------------------------------------------------
// t_NacTip1: plain dark brown.
//
#declare t_NacTip1 = texture {
  pigment { colour rgb <0.31176, 0.15118, 0.07519> }
  finish { ambient 0.1 specular 1.0 roughness 0.005
    #ifndef (Quick)
      reflection 0.2
    #end
  }
}

//------------------------------------------------------------------------------------
// t_NacTip1: Bright orange.
//
#declare t_NacTip2 = texture {
  pigment { colour rgb <1.5,0.5,0> }
  finish { ambient 0.4 specular 1.0 roughness 0.005
    #ifndef (Quick)
      reflection 0.2
    #end
  }
}

//------------------------------------------------------------------------------------
// t_NacTip3: Radial stripes of bright orange on dark brown.
//
#declare t_NacTip3 = texture {
  radial
  texture_map {
    [0.00 t_NacTip1]
    [0.65 t_NacTip1]
    [0.80 t_NacTip2]
    [0.85 t_NacTip2]
    [1.00 t_NacTip1]
  }
  frequency 12
}

//------------------------------------------------------------------------------------
// t_NacTip4: Centre of dark brown, thin ring of bright orange, and then radial
// stripes outward (animated series nacelle tips)
//
#declare t_NacTip4 = texture {
  #ifdef (Quick)
    t_NacTip1
  #else
    wood
    texture_map {
      [0.00 t_NacTip1]
      [0.27 t_NacTip1]
      [0.30 t_NacTip2]
      [0.33 t_NacTip3 rotate x*-90 scale 0.5]
      [1.00 t_NacTip3 rotate x*-90 scale 0.5]
    }
    scale 2
  #end
}

//------------------------------------------------------------------------------------
// t_NacTip5a: Mostly red, with a tint of orange.  If Quick is defined, this is the
// texture that is used if E1701_Nacelle_Type is set to 2 (the default).
//
#declare p_NacTip5a = pigment { colour rgb <1,0.33,0> }

//------------------------------------------------------------------------------------
// t_NacTip5b: extremely bright orange.
// t_NacTip5c: clear.
// t_NacTip5d: transparent glowing yellow.
// t_NacTip5e: transparent glowing green.
// t_NacTip5f: transparent glowing cyan.
//
#ifndef (Quick)
  #declare p_NacTip5b = pigment { colour rgb <3,2.00,0> }
  #declare p_NacTip5c = pigment { colour rgbt <1,1,1,1> }
  #declare p_NacTip5d = pigment { colour rgbt <2,2,0,0.45> }
  #declare p_NacTip5e = pigment { colour rgbt <0,2,0,0.55> }
  #declare p_NacTip5f = pigment { colour rgbt <0,2,2,0.65> }

//------------------------------------------------------------------------------------
// t_NacTip5g: used for making the "star" on the nacelle.
//
  #declare p_NacTip5g = pigment {
    wood
    pigment_map {
      [0.00 p_NacTip5b]
      [0.20 p_NacTip5c]
      [1.00 p_NacTip5c]
    }
    scale <1.5,4,4>
    translate y*0.65
  }

//------------------------------------------------------------------------------------
// t_NacTip5h: Glowing splotch of yellow which rotates around nacelle tip.
// t_NacTip5i: Glowing splotch of green  which rotates around nacelle tip.
// t_NacTip5j: Glowing splotch of cyan   which rotates around nacelle tip.
//
  #declare p_NacTip5h = pigment {
    wood
    pigment_map {
      [0.00 p_NacTip5d]
      [0.35 p_NacTip5c]
      [1.00 p_NacTip5c]
    }
    scale <4,4,4>
    translate y*0.5
    rotate z*120
  }

  #declare p_NacTip5i = pigment {
    wood
    pigment_map {
      [0.00 p_NacTip5e]
      [0.40 p_NacTip5c]
      [1.00 p_NacTip5c]
    }
    scale <4,4,4>
    translate y*0.60
    rotate z*240
  }

  #declare p_NacTip5j = pigment {
    wood
    pigment_map {
      [0.00 p_NacTip5f]
      [0.35 p_NacTip5c]
      [1.00 p_NacTip5c]
    }
    scale <4,4,4>
    translate y*0.50
  }
#end

//------------------------------------------------------------------------------------
// t_NacTip5Port and t_NacTip5Starboard: Layered textures.  The "stars" stay in place,
// while the glowing splotches rotate around the nacelle tips.  The two textures
// rotate in opposite directions.  If Quick is defined, the textures are just a plain
// red.
//
#ifdef (Quick)
  #declare t_NacTip5Port = texture { pigment { p_NacTip5a }}
  #declare t_NacTip5Starboard = texture { pigment { p_NacTip5a }}
#else
  #declare t_NacTip5Port = 
    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z* 72 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z*144 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z*216 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z*288 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5h rotate z*360*E1701_Nacelle_Rotate} finish { ambient 0.4 }}
    texture { pigment { p_NacTip5i rotate z*360*E1701_Nacelle_Rotate} finish { ambient 0.4 }}
    texture { pigment { p_NacTip5j rotate z*360*E1701_Nacelle_Rotate}
      finish { ambient 0.4 specular 1.0 roughness 0.005 reflection 0.2 }
    }

  #declare t_NacTip5Starboard = 
    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z* 72 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z*144 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z*216 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5g rotate z*288 } finish { ambient 0.4 }}
    texture { pigment { p_NacTip5h rotate z*360*-E1701_Nacelle_Rotate} finish { ambient 0.4 }}
    texture { pigment { p_NacTip5i rotate z*360*-E1701_Nacelle_Rotate} finish { ambient 0.4 }}
    texture { pigment { p_NacTip5j rotate z*360*-E1701_Nacelle_Rotate}
      finish { ambient 0.4 specular 1.0 roughness 0.005 reflection 0.2 }
    }

#end


//====================================================================================
//====================================================================================
// Window textures.
//
#declare t_lit_window = texture { pigment { colour rgb <2,2,2> } finish { ambient 0.9 }}
#declare t_dark_window = texture { pigment { colour rgb <0.25,0.25,0.25> }}
#declare t_formation_lights = texture { pigment { colour rgb <1,0.9,0.8> } finish { ambient 1.0 diffuse 0.0 }}

//====================================================================================
// White glass used for the sensor arrays on the top and bottom of the primary hull,
// and for the beacon on the aft end of the secondary hull.
//
#declare t_white_glass = texture {
  pigment { colour rgbf <1, 1, 1, 0.5> }
  finish { ambient 0.8 diffuse 0.0 specular 1.0 roughness 0.005
    #ifndef (Quick)
      reflection 0.4
    #end
  }
}

//====================================================================================
// Basic hull texture.
//
#declare t_Hull_BasicTexture = texture {
  pigment{ p_trek_sky_blue }
  #ifndef (Quick)
    finish{ f_metallic2 }
    normal { n_hull }
  #end
}

//====================================================================================
// Dark hull texture (cargo hatches)
//
#declare t_dark_hull = texture {
  pigment { p_trek_bluegrey }
  #ifndef (Quick)
    finish { f_metallic2 }
    normal { n_hull }
  #end
}

//====================================================================================
// Grille texture used on warp nacelles and pylons.
//
#declare t_grille = texture {
  pigment { p_trek_bluegrey }
  #ifndef (Quick)
    finish { f_metallic2 }
    normal { n_grille }
  #end
}

//====================================================================================
// Grille texture used on inboard warp coolers.
//
#declare t_grille2 = texture {
  pigment { p_trek_silver }
  #ifndef (Quick)
    finish { f_metallic2 }
    normal { n_grille }
  #end
}

//====================================================================================
// Dark streaks at forward ends of nacelles, to make it look a bit weathered.
//
#declare t_nacelle_streaky = texture {
  #ifdef (Quick)
     pigment { p_trek_sky_blue }
  #else
    pigment { p_trek_sky_blue
      gradient z
      pigment_map {
        [0.00 p_dirtyhull]
        [0.10 p_trek_sky_blue]
        [1.00 p_trek_sky_blue]
      }
      turbulence z*0.2
      scale <0.1,0.1,40>
    }
    finish { f_metallic2 }
    normal{ n_hull }
  #end
}

//====================================================================================
// Dark streaks at forward end of secondary hull, to make it look more weathered.
//
#declare t_hull2_streaky = texture {
  #ifdef (Quick)
    pigment { p_trek_sky_blue }
  #else
    pigment { p_trek_sky_blue
      gradient z
      pigment_map {
        [0.00 p_dirtyhull]
        [0.20 p_trek_sky_blue]
        [1.00 p_trek_sky_blue]
      }
      turbulence z*0.2
      scale <0.1,0.1,30>
    }
    finish { f_metallic2 }
    normal{ n_hull }
  #end
}

//====================================================================================
// Texture for the "clamshell" shuttle bay doors.  Basically puts a dark line at
// either end of the door segment, because without such lines, the doors look like
// a plain sphere.
//
#declare t_clamshell = texture {
  #ifdef (Quick)
    pigment { p_trek_sky_blue }
  #else
    pigment { p_trek_sky_blue
      radial
      pigment_map {
        [0.00 p_trek_bluegrey]
        [0.05 p_trek_bluegrey]
        [0.05 p_trek_sky_blue]
        [0.95 p_trek_sky_blue]
        [0.95 p_trek_bluegrey]
        [1.00 p_trek_bluegrey]
      }
      frequency 12
      rotate y*15
    }
    finish { f_metallic2 }
    normal { n_hull }
  #end
}


//====================================================================================
// Dark streaks at forward end of the primary hull, to make it look more weathered.
//
#declare p_hull1_streaks = pigment {
  #ifdef (Quick)
    p_trek_sky_blue
  #else
    bozo
    pigment_map {
      [0.00 p_trek_sky_blue]
      [0.50 p_dirtyhull]
      [1.00 p_trek_sky_blue]
    }
    turbulence 1.0
    scale <0.1,10,10>
  #end
}

#declare t_hull1_streaky = texture {
  #ifdef (Quick)
     pigment { p_trek_sky_blue }
  #else
    pigment { p_trek_sky_blue
      gradient z
      pigment_map {
        [0.00 p_hull1_streaks]
        [0.40 p_trek_sky_blue]
        [1.00 p_trek_sky_blue]
      }
      turbulence z*0.2
      translate z*-0.5
     scale <0.1,10,90>
     translate x*100
    }
    finish { f_metallic2 }
    normal{ n_hull }
  #end
}

//====================================================================================
// Top texture for the primary hull -- applies the name and registration number to
// the top of the saucer (can be altered by editing 1701h1a.gif).
//
#declare t_Hull1_Top_Texture = texture {
  #ifdef (Quick)
    pigment{ p_trek_sky_blue }
  #else
    material_map {
      gif "1701h1a.gif" once
      texture { t_hull1_streaky scale <1/26.6718835,1,1/9.424> rotate x*-90 translate <0.5,0.25,0> }
      texture { pigment { colour rgb <0,0,0> } finish { f_metallic2 } normal { n_hull }}
    }
    translate <-0.5,-0.25,0>
    rotate x*90
    scale <26.6718835,1,9.424>
    translate z*-15
  #end
}

//====================================================================================
// Bottom texture for the primary hull -- applies the registration number and the
// dark grey features to the underside of the saucer (can be altered by editing
// 1701h1b.gif).
//
#declare t_Hull1_Bot_Texture = texture {
  #ifdef (Quick)
    pigment{ p_trek_sky_blue }
  #else
    material_map {
      gif "1701h1b.gif"
      texture { pigment { colour rgb <0,0,0> } finish { f_metallic2 } normal { n_hull }}
      texture { t_hull1_streaky rotate x*90 scale <1/48.1,1/48.1,1> translate <0.5,0.5,0> }
      texture { pigment { p_trek_silver } finish { f_metallic2 }}
      texture { pigment{ colour rgb <2,2,2> } finish { ambient 1 diffuse 0 }}
      texture { pigment { colour rgb <0.25,0.25,0.25> }}
    }
    translate <-0.5,-0.5,0>
    scale <48.10,48.10,1>
    rotate x*-90
  #end
}

//====================================================================================
// Primary hull texture -- puts the top and bottom textures together so it can be
// applied to the saucer in one fell swoop.
//
#declare t_Hull1_HullTexture = texture {
  #ifdef (Quick)
    pigment { p_trek_sky_blue }
  #else
    gradient y
    texture_map {
      [0.00 t_Hull1_Bot_Texture]
      [0.50 t_Hull1_Bot_Texture]
      [0.50 t_Hull1_Top_Texture]
      [1.00 t_Hull1_Top_Texture]
    }
    translate y*-0.5
    scale <1,20,1>
  #end
}

//====================================================================================
// Texture for the green running lights on the primary hull.
//
#declare t_green_light = texture {
  #if (E1701_Lights_On = 1)
    pigment { colour rgbt <0,1,0,0.5> }
    finish { ambient 0.8 diffuse 0.0 specular 1.0 roughness 0.005 reflection 0.4 }
  #else
    pigment { colour rgbt <0.25,0.25,0.25,0.5> }
    finish { specular 1.0 roughness 0.0005 reflection 0.4 }
  #end
}

//====================================================================================
// Texture for the red running lights on the primary hull.
//
#declare t_red_light = texture {
  #if (E1701_Lights_On = 1)
    pigment { colour rgbt <1,0,0,0.5> }
    finish { ambient 0.8 diffuse 0.0 specular 1.0 roughness 0.005 reflection 0.4 }
  #else
    pigment { colour rgbt <0.25,0.25,0.25,0.5> }
    finish { specular 1.0 roughness 0.0005 reflection 0.4 }
  #end
}

//====================================================================================
// Texture for the yellow forward formation light on the primary hull.
//
#declare t_yellow_light = texture {
  pigment { colour rgbt <2,2,1,0.25> }
  finish { ambient 0.8 diffuse 0.0 specular 1.0 roughness 0.005 reflection 0.4 }
}

//====================================================================================
// Texture for the salmon aft formation lights on the primary hull.
//
#declare t_salmon_light = texture {
  #if (E1701_Lights_On = 1)
    pigment { colour rgbt <1,0.9,0.8,0.5> }
    finish { ambient 0.8 diffuse 0.0 specular 1.0 roughness 0.005 reflection 0.4 }
  #else
    pigment { colour rgbt <0.25,0.25,0.25,0.5> }
    finish { specular 1.0 roughness 0.0005 reflection 0.4 }
  #end
}

//====================================================================================
// Image map containing the Federation pennant on the secondary hull.
//
#declare p_hull2_label = pigment {
  image_map { gif "1701h2a.gif" once transmit 1,1 }
  rotate y*-90
  translate y*-0.42
  scale <1,1.2,9.35>
  translate z*3.1
}

//====================================================================================
// Hull texture incorporating the above image map.
//
#declare t_Hull2_HullTexture = texture {
  pigment { p_hull2_label }
  #ifndef (Quick)
    finish { f_metallic2 }
    normal { n_hull }
  #end
}

//====================================================================================
// Texture for the forward sensor dish on the secondary hull.
//
#declare t_sensor_dish = texture {
  pigment { p_trek_brown }
  finish { f_metallic3 }
}

//====================================================================================
// Texture for the antenna for the secondary hull forward sensor dish.
//
#declare t_sensor_antenna = texture {
  pigment { p_trek_silver }
  finish { f_metallic3 }
}

//====================================================================================
// Texture for the bay behind the secondary hull forward sensor dish.
//
#declare t_sensor_bay = texture {
  pigment { p_trek_copper }
  finish { f_metallic4 }
}

//====================================================================================
// Texture for the tubes on the "prongs".
//
#declare t_hull2_prongtubes = texture {
  pigment { p_trek_taupe }
  #ifndef (Quick)
    finish { f_metallic2 }
    normal { n_hull }
  #end
}

//====================================================================================
// Texture for the three "sensors" at the forward end of the nacelle.
//
#declare t_nacelle_sensor = texture {
  pigment { p_trek_silver } 
  finish { f_metallic1 }
}

//====================================================================================
// Texture for the aft nacelle cowl
//
#declare t_nacelle_cowl = texture {
  pigment { p_trek_bluegrey }
  #ifndef (Quick)
    finish { f_metallic2 }
    normal { radial 0.1 frequency 60 rotate x*-90}
  #end
}

//====================================================================================
// Image map for Federation pennant and ship's registration, port nacelle
//
#declare p_port_nacelle_label = pigment {
  image_map { gif "1701pnac.gif" once transmit 1,1 }
  rotate y*-90
  translate y*-0.42
  scale <1,1.2,22.5>
  translate z*5.1
}

//====================================================================================
// Restricts the above image map to the outboard half of the nacelle.
//
#declare p_port_nacelle_label_half = pigment {
  gradient x
  pigment_map {
    [0.0 p_trek_sky_blue]
    [0.5 p_trek_sky_blue]
    [0.5 p_port_nacelle_label]
    [1.0 p_port_nacelle_label]
  }
  translate x*-0.5
  scale <5,1,1>
}

//====================================================================================
// Texture incorporating the above pigment.
//
#declare t_port_nacelle_label = texture {
  pigment { p_port_nacelle_label_half }
  finish { f_metallic2 }
  #ifndef (Quick)
    normal { n_hull }
  #end
}

//====================================================================================
// Image map for Federation pennant and ship's registration, starboard nacelle
//
#declare p_starboard_nacelle_label = pigment {
  image_map { gif "1701snac.gif" once transmit 1,1 }
  translate x*-1
  rotate y*90
  translate y*-0.42
  scale <1,1.2,22.5>
  translate z*5.1
}

//====================================================================================
// Restricts the above image map to the outboard half of the nacelle.
//
#declare p_starboard_nacelle_label_half = pigment {
  gradient x
  pigment_map {
    [0.0 p_starboard_nacelle_label]
    [0.5 p_starboard_nacelle_label]
    [0.5 p_trek_sky_blue]
    [1.0 p_trek_sky_blue]
  }
  translate x*-0.5
  scale <10,1,1>
}

//====================================================================================
// Texture incorporating the above pigment.
//
#declare t_starboard_nacelle_label = texture {
  pigment { p_starboard_nacelle_label_half }
  finish { f_metallic2 }
  #ifndef (Quick)
    normal { n_hull }
  #end
}
