/*==================================================================================================
 This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
 letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

 Persistence of Vision Ray Tracer Scene Description File
 File: SouthernGrayGranite.inc
 Vers: 3.7+
 Desc: Southern Gray Granite colour_map and pigment_pattern entries, based on the original code 
       (SGrayPol & SGrayFro) by Daniel Mecklenburg Jr. from 1996.
       
       To be read by the Granite_21 macro.
       
 Date: 27 June 2021
 Auth: Thomas de Groot

====================================================================================================*/
// The colour_maps of the Southern Gray Granite
#local not_0 = 1/265;

#declare Map1_entries = 17;
#declare A_Granite_map1 =
array mixed [Map1_entries][2] {
  {0.00, <0.880, 0.880, 0.880>},
  {0.07, <0.745, 0.745, 0.745>},
  {0.10, <0.880, 0.880, 0.880>},

  {0.10, <not_0, not_0, not_0>},
  {0.15, <not_0, not_0, not_0>},

  {0.15, <0.980, 0.980, 0.980>},
  {0.22, <0.745, 0.745, 0.745>},
  {0.30, <0.980, 0.980, 0.980>},

  {0.30, <0.745, 0.745, 0.745>},
  {0.42, <0.845, 0.845, 0.845>},
  {0.60, <0.745, 0.745, 0.745>},

  {0.60, <0.345, 0.345, 0.345>},
  {0.80, <0.345, 0.345, 0.345>}, 

  {0.80, <0.549, 0.549, 0.549>},
  {0.90, <0.549, 0.549, 0.549>},

  {0.90, <0.149, 0.149, 0.149>},
  {1.00, <0.149, 0.149, 0.149>}
}

#declare Map2_entries = 5;
#declare A_Granite_map2 =
array mixed [Map2_entries][4] {
  {0.000, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.005, <0.800, 0.800, 0.800>, 0.001, 0.000},
  {0.010, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.011, <1.000, 1.000, 1.000>, 0.000, 1.000},
  {1.000, <1.000, 1.000, 1.000>, 0.000, 1.000}
}

// The mask used for the Southern Gray Granite pigment_pattern 
#declare Mask_entries = 14;
#declare A_Granite_mask = 
array mixed [Mask_entries][2] {
  {0.00, <0.001, 0.001, 0.001>},
  {0.10, <0.001, 0.001, 0.001>},

  {0.10, <0.100, 0.100, 0.100>},
  {0.15, <0.100, 0.100, 0.100>},

  {0.15, <0.001, 0.001, 0.001>},
  {0.30, <0.001, 0.001, 0.001>},

  {0.30, <0.300, 0.300, 0.300>},
  {0.60, <0.300, 0.300, 0.300>},

  {0.60, <0.700, 0.700, 0.700>},
  {0.80, <0.700, 0.700, 0.700>},

  {0.80, <0.500, 0.500, 0.500>},
  {0.90, <0.500, 0.500, 0.500>},

  {0.90, <0.900, 0.900, 0.900>},
  {1.00, <0.900, 0.900, 0.900>}
}

// The pigment_map and normal_map entries [0], normal strength [1], and for both the scale [2], variations for the Southern Gray Granite
#declare Var_entries = 8;
#declare A_Granite_var =
array [Var_entries][3] {
  {0.20, 0.50, 0.15},
  {0.25, 1.00, 0.20},
  {0.35, 1.00, 0.20},
  {0.40, 0.50, 0.18},
  {0.60, 1.00, 0.18},
  {0.65, 0.50, 0.20},
  {0.75, 1.00, 0.20},
  {0.80, 0.50, 0.15}
}

// The tranlucency colour for the subsurface light transport
#declare Translucency = <0.745, 0.745, 0.745>*1;

