/*==================================================================================================
 This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
 letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

 Persistence of Vision Ray Tracer Scene Description File
 File: SaintAndreGreenGranite.inc
 Vers: 3.7+
 Desc: Saint-Andre Green Granite colour_map and pigment_pattern entries, based on the original code 
       (StAndGPol & StAndGFro) by Daniel Mecklenburg Jr. from 1996.
       
       To be read by the Granite_21 macro.
       
 Date: 5 June 2021
 Auth: Thomas de Groot

====================================================================================================*/
// The colour_maps of the Saint-Andre Green Granite
#local not_0 = 1/265;

#declare Map1_entries = 16;
#declare A_Granite_map1 =
array mixed [Map1_entries][2] {
  {0.00, <0.098, 0.098, 0.098>},
  {0.15, <0.128, 0.148, 0.128>},
  {0.25, <0.128, 0.148, 0.128>},
  {0.30, <0.098, 0.098, 0.098>},

  {0.30, <0.259, 0.259, 0.259>},
  {0.40, <0.289, 0.359, 0.289>},
  {0.55, <0.259, 0.259, 0.259>},

  {0.55, <0.329, 0.388, 0.357>},
  {0.70, <0.369, 0.488, 0.387>},
  {0.80, <0.329, 0.388, 0.357>},

  {0.80, <0.420, 0.420, 0.376>},
  {0.85, <0.420, 0.420, 0.376>},

  {0.85, <0.376, 0.337, 0.310>},
  {0.95, <0.376, 0.337, 0.310>},

  {0.95, <0.518, 0.529, 0.498>},
  {1.00, <0.518, 0.529, 0.498>}
}

#declare Map2_entries = 5;
#declare A_Granite_map2 =
array mixed [Map2_entries][4] {
  {0.000, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.005, <0.800, 0.800, 0.800>, 0.001, 0.000},
  {0.010, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.011, <1.000, 1.000, 1.000>, 0.000, 1.000},
  {1.000, <1.000, 1.000, 1.000>, 0.000, 1.000}
}

// The mask used for the Saint-Andre Green Granite pigment_pattern 
#declare Mask_entries = 12;
#declare A_Granite_mask = 
array mixed [Mask_entries][2] {
  {0.00, <0.001, 0.001, 0.001>},
  {0.30, <0.001, 0.001, 0.001>},

  {0.30, <0.300, 0.300, 0.300>},
  {0.55, <0.300, 0.300, 0.300>},

  {0.55, <0.700, 0.700, 0.700>},
  {0.80, <0.700, 0.700, 0.700>},

  {0.80, <0.500, 0.500, 0.500>},
  {0.85, <0.500, 0.500, 0.500>},

  {0.85, <0.700, 0.700, 0.700>},
  {0.95, <0.700, 0.700, 0.700>},
    
  {0.95, <0.900, 0.900, 0.900>},
  {1.00, <0.900, 0.900, 0.900>}
}

// The pigment_map and normal_map entries [0], normal strength [1], and for both the scale [2], variations for the Saint-Andre Green Granite
#declare Var_entries = 8;
#declare A_Granite_var =
array [Var_entries][3] {
  {0.20, 0.50, 0.15},
  {0.25, 1.00, 0.18},
  {0.35, 1.00, 0.18},
  {0.40, 0.50, 0.15},
  {0.60, 1.00, 0.15},
  {0.65, 0.50, 0.18},
  {0.75, 1.00, 0.18},
  {0.80, 0.50, 0.15}
}

// The tranlucency colour for the subsurface light transport
#declare Translucency = <0.518, 0.529, 0.498>*1;

