/*==================================================================================================
 This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
 letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

 Persistence of Vision Ray Tracer Scene Description File
 File: SaintAndreGreenDarkGranite.inc
 Vers: 3.7+
 Desc: Saint-Andre Green Dark Granite colour_map and pigment_pattern entries, based on the original code 
       (StAndGPol & StAndGFro) by Daniel Mecklenburg Jr. from 1996.
       
       To be read by the Granite_21 macro.
       
 Date: 13 July 2021
 Auth: Thomas de Groot

====================================================================================================*/
// The colour_maps of the Saint-Andre Green DarkGranite
#local not_0 = 1/265;
#declare Multiplicator1 = 0.3;
#declare Multiplicator2 = 0.2;

#declare Map1_entries = 16;
#declare A_Granite_map1 =
array mixed [Map1_entries][2] {
  {0.00, <0.0196, 0.0196, 0.0196>},
  {0.15, <0.0256, 0.0444, 0.0256>},
  {0.25, <0.0256, 0.0444, 0.0256>},
  {0.30, <0.0196, 0.0196, 0.0196>},

  {0.30, <0.0518, 0.0518, 0.0518>},
  {0.40, <0.0578, 0.1077, 0.0578>},
  {0.55, <0.0518, 0.0518, 0.0518>},

  {0.55, <0.0658, 0.1164, 0.0714>},
  {0.70, <0.0738, 0.1464, 0.0774>},
  {0.80, <0.0658, 0.1164, 0.0714>},

  {0.80, <0.084, 0.126, 0.0752>},
  {0.85, <0.084, 0.126, 0.0752>},

  {0.85, <0.0752, 0.1011, 0.062>},
  {0.99, <0.0752, 0.1011, 0.062>},

  {0.99, <0.518, 0.529, 0.498>},
  {1.00, <0.518, 0.529, 0.498>}
}

#declare Map2_entries = 5;
#declare A_Granite_map2 =
array mixed [Map2_entries][4] {
  {0.000, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.005, <0.800, 0.800, 0.800>, 0.001, 0.000},
  {0.010, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.011, <1.000, 1.000, 1.000>, 0.000, 1.000},
  {1.000, <1.000, 1.000, 1.000>, 0.000, 1.000}
}

// The mask used for the Saint-Andre Green Dark Granite pigment_pattern 
#declare Mask_entries = 12;
#declare A_Granite_mask = 
array mixed [Mask_entries][2] {
  {0.00, <0.001, 0.001, 0.001>},
  {0.30, <0.001, 0.001, 0.001>},

  {0.30, <0.300, 0.300, 0.300>},
  {0.55, <0.300, 0.300, 0.300>},

  {0.55, <0.700, 0.700, 0.700>},
  {0.80, <0.700, 0.700, 0.700>},

  {0.80, <0.500, 0.500, 0.500>},
  {0.85, <0.500, 0.500, 0.500>},

  {0.85, <0.700, 0.700, 0.700>},
  {0.99, <0.700, 0.700, 0.700>},
    
  {0.99, <0.900, 0.900, 0.900>},
  {1.00, <0.900, 0.900, 0.900>}
}

// The pigment_map and normal_map entries [0], normal strength [1], and for both the scale [2], variations for the Saint-Andre Green Dark Granite
#declare Var_entries = 8;
#declare A_Granite_var =
array [Var_entries][3] {
  {0.20, 0.50, 0.15},
  {0.25, 1.00, 0.18},
  {0.35, 1.00, 0.18},
  {0.40, 0.50, 0.15},
  {0.60, 1.00, 0.15},
  {0.65, 0.50, 0.18},
  {0.75, 1.00, 0.18},
  {0.80, 0.50, 0.15}
}

// The tranlucency colour for the subsurface light transport
#declare Translucency = <0.376, 0.337, 0.310>*1;

