/*==================================================================================================
 This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
 letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

 Persistence of Vision Ray Tracer Scene Description File
 File: NorthAmericanPinkGranite.inc
 Vers: 3.7+
 Desc: North American Pink Granite colour_map and pigment_pattern entries, based on the original code 
       (NAPPol & NAPFro) by Daniel Mecklenburg Jr. from 1996.
       
       To be read by the Granite_21 macro.
       
 Date: 29 May 2021
 Auth: Thomas de Groot

====================================================================================================*/
// The colour_maps of the North American Pink Granite
#local not_0 = 1/265;

#declare Map1_entries = 14;
#declare A_Granite_map1 =
array mixed [Map1_entries][2] {
  {0.00, <not_0, not_0, not_0>},
  {0.15, <not_0, not_0, not_0>},

  {0.15, <0.576, 0.435*0.50, 0.482*0.50>},
  {0.35, <0.576, 0.435*0.50, 0.482*0.50>},

  {0.35, <0.635, 0.506*0.25, 0.455*0.25>},
  {0.45, <0.635, 0.506*0.25, 0.455*0.25>},

  {0.45, <0.675, 0.506*0.75, 0.455*0.75>},
  {0.57, <0.675, 0.506*0.75, 0.455*0.75>},

  {0.57, <0.961, 0.863, 0.843>},
  {0.63, <0.961, 0.863, 0.843>},

  {0.63, <0.275, 0.275, 0.275>},
  {0.72, <0.275, 0.275, 0.275>},

  {0.72, <0.196, 0.196, 0.196>},
  {1.00, <0.196, 0.196, 0.196>}
}

#declare Map2_entries = 5;
#declare A_Granite_map2 =
array mixed [Map2_entries][4] {
  {0.000, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.005, <0.800, 0.800, 0.800>, 0.001, 0.000},
  {0.010, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.011, <1.000, 1.000, 1.000>, 0.000, 1.000},
  {1.000, <1.000, 1.000, 1.000>, 0.000, 1.000}
}

// The mask used for the North American Pink Granite pigment_pattern 
#declare Mask_entries = 14;
#declare A_Granite_mask = 
array mixed [Mask_entries][2] {
  {0.00, <0.010, 0.010, 0.010>},
  {0.15, <0.010, 0.010, 0.0510>},

  {0.15, <0.100, 0.100, 0.100>},
  {0.35, <0.100, 0.100, 0.100>},

  {0.35, <0.250, 0.250, 0.250>},
  {0.45, <0.250, 0.250, 0.250>},

  {0.45, <0.500, 0.500, 0.500>},
  {0.57, <0.500, 0.500, 0.500>},

  {0.57, <0.600, 0.600, 0.600>},
  {0.63, <0.600, 0.600, 0.600>},

  {0.63, <0.700, 0.700, 0.700>},
  {0.72, <0.700, 0.700, 0.700>},

  {0.72, <0.900, 0.900, 0.900>},
  {1.00, <0.900, 0.900, 0.900>}
}

// The pigment_map and normal_map entries [0], normal strength [1], and for both the scale [2], variations for the North American Pink Granite texture
#declare Var_entries = 8;
#declare A_Granite_var =
array [Var_entries][3] {
  {0.20, 0.50, 0.15},
  {0.25, 1.00, 0.18},
  {0.35, 1.00, 0.18},
  {0.40, 0.50, 0.10},
  {0.60, 1.00, 0.15},
  {0.65, 0.50, 0.18},
  {0.75, 1.00, 0.18},
  {0.80, 0.50, 0.15}
}

// The tranlucency colour for the subsurface light transport
#declare Translucency = <0.669, 0.229, 0.198>*1;

