/*==================================================================================================
 This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
 letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

 Persistence of Vision Ray Tracer Scene Description File
 File: MediumBarreGrayGranite.inc
 Vers: 3.7+
 Desc: Medium Barre Gray Granite colour_map and pigment_pattern entries, based on the original code 
       (MGrayPol & MGrayFro) by Daniel Mecklenburg Jr. from 1996.
       
       To be read by the Granite_21 macro.
       
 Date: 30 June 2021
 Auth: Thomas de Groot

====================================================================================================*/
// The colour_maps of the Medium Barre Gray Granite
#local not_0 = 1/265;

#declare Map1_entries = 12;
#declare A_Granite_map1 =
array mixed [Map1_entries][2] {
  {0.00, <not_0, not_0, not_0>},
  {0.15, <not_0, not_0, not_0>},

  {0.15, <0.356, 0.356, 0.356>},
  {0.22, <0.271, 0.271, 0.271>},
  {0.40, <0.356, 0.356, 0.356>},

  {0.40, <0.863, 0.863, 0.863>},
  {0.52, <0.745, 0.745, 0.745>},
  {0.60, <0.863, 0.863, 0.863>},

  {0.60, <0.267, 0.306, 0.267>},
  {0.70, <0.267, 0.306, 0.267>}, 

  {0.70, <0.471, 0.529, 0.471>},
  {1.00, <0.471, 0.529, 0.471>}
}

#declare Map2_entries = 5;
#declare A_Granite_map2 =
array mixed [Map2_entries][4] {
  {0.000, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.005, <0.800, 0.800, 0.800>, 0.001, 0.000},
  {0.010, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.011, <1.000, 1.000, 1.000>, 0.000, 1.000},
  {1.000, <1.000, 1.000, 1.000>, 0.000, 1.000}
}

// The mask used for the Medium Barre Gray Granite pigment_pattern 
#declare Mask_entries = 10;
#declare A_Granite_mask = 
array mixed [Mask_entries][2] {
  {0.00, <0.001, 0.001, 0.001>},
  {0.15, <0.001, 0.001, 0.001>},

  {0.15, <0.100, 0.100, 0.100>},
  {0.40, <0.100, 0.100, 0.100>},

  {0.40, <0.300, 0.300, 0.300>},
  {0.60, <0.300, 0.300, 0.300>},

  {0.60, <0.700, 0.700, 0.700>},
  {0.70, <0.700, 0.700, 0.700>},

  {0.70, <0.900, 0.900, 0.900>},
  {1.00, <0.900, 0.900, 0.900>}
}

// The pigment_map and normal_map entries [0], normal strength [1], and for both the scale [2], variations for the Medium Barre Gray Granite
#declare Var_entries = 8;
#declare A_Granite_var =
array [Var_entries][3] {
  {0.20, 0.50, 0.10},
  {0.25, 1.00, 0.18},
  {0.35, 1.00, 0.18},
  {0.40, 0.50, 0.15},
  {0.60, 1.00, 0.15},
  {0.65, 0.50, 0.12},
  {0.75, 1.00, 0.12},
  {0.80, 0.50, 0.10}
}

// The tranlucency colour for the subsurface light transport
#declare Translucency = <0.471, 0.529, 0.471>*1;

