/*==================================================================================================
 This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
 letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

 Persistence of Vision Ray Tracer Scene Description File
 File: ImpalaBlackGranite.inc
 Vers: 3.7+
 Desc: Impala Black Granite colour_map and pigment_pattern entries, based on the original code 
       (ImpalaPol & ImpalaFro) by Daniel Mecklenburg Jr. from 1996.
       
       To be read by the Granite_21 macro.
       
 Date: 10 July 2021
 Auth: Thomas de Groot

====================================================================================================*/
// The colour_maps of the Impala Black Granite
#local not_0 = 1/265;
#declare Map1_entries = 14;
#declare A_Granite_map1 =
array mixed [Map1_entries][2] {
  {0.00, <0.298, 0.298, 0.298>*0.1},
  {0.15, <0.298, 0.298, 0.298>*0.1},

  {0.15, <0.376, 0.337, 0.369>*0.1},
  {0.45, <0.376, 0.337, 0.369>*0.1},

  {0.45, <0.486, 0.529, 0.557>*0.1},
  {0.50, <0.486, 0.529, 0.557>*0.1},

  {0.50, <0.298, 0.298, 0.298>*0.1},
  {0.55, <0.298, 0.298, 0.298>*0.1},

  {0.55, <0.486, 0.529, 0.557>*0.8},
  {0.60, <0.486, 0.529, 0.557>*0.8},

  {0.60, <0.298, 0.298, 0.298>*0.1},
  {0.75, <0.298, 0.298, 0.298>*0.1},

  {0.75, <0.357, 0.318, 0.329>*0.1},
  {1.00, <0.357, 0.318, 0.329>*0.1}
}

#declare Map2_entries = 5;
#declare A_Granite_map2 =
array mixed [Map2_entries][4] {
  {0.000, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.005, <0.800, 0.800, 0.800>, 0.001, 0.000},
  {0.010, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.011, <1.000, 1.000, 1.000>, 0.000, 1.000},
  {1.000, <1.000, 1.000, 1.000>, 0.000, 1.000}
}

// The mask used for the Impala Black Granite pigment_pattern 
#declare Mask_entries = 14;
#declare A_Granite_mask = 
array mixed [Mask_entries][2] {
  {0.00, <0.100, 0.100, 0.100>},
  {0.15, <0.100, 0.100, 0.100>},

  {0.15, <0.001, 0.001, 0.001>},
  {0.45, <0.001, 0.001, 0.001>},

  {0.45, <0.300, 0.300, 0.300>},
  {0.50, <0.300, 0.300, 0.300>},

  {0.50, <0.001, 0.001, 0.001>},
  {0.55, <0.001, 0.001, 0.001>},

  {0.55, <0.700, 0.700, 0.700>},
  {0.60, <0.900, 0.900, 0.900>},

  {0.60, <0.100, 0.100, 0.100>},
  {0.75, <0.100, 0.100, 0.100>},

  {0.75, <0.300, 0.300, 0.300>},
  {1.00, <0.350, 0.350, 0.350>}
}

// The pigment_map and normal_map entries [0], normal strength [1], and for both the scale [2], variations for the Impala Black Granite
#declare Var_entries = 8;
#declare A_Granite_var =
array [Var_entries][3] {
  {0.20, 0.50, 0.15},
  {0.25, 1.00, 0.16},
  {0.35, 1.00, 0.14},
  {0.40, 0.50, 0.15},
  {0.60, 1.00, 0.13},
  {0.65, 0.50, 0.16},
  {0.75, 1.00, 0.14},
  {0.80, 0.50, 0.12}
}

// The tranlucency colour for the subsurface light transport
#declare Translucency = <0.486, 0.529, 0.557>*0.8;

