// File: Granite_21_demo.pov
// Vers: 3.8+
// Desc: Demo scene for the Granite_21 macro
// Date: September 2021
// Auth: Thomas de Groot
//--------------------------------------------------------------------------

//+w600 +h400 +am2 +a0.1 +bm2 +bs8
//+w1200 +h800 +am2 +a0.1 +bm2 +bs8
//stochastic:
//+w600 +h400 +am3 +a0.01 +ac0.99 +r3
//+w1200 +h800 +am3 +a0.01 +ac0.99 +r3

#version 3.8;

// Choose a camera:
#local Camera     = 0;  //0=overview; 1=ovus closeup; 2=superelipsoid closeup;
#local Stochastic = on;

//---------------------------------------------------------------------------
// global settings ----------------------------------------------------------
global_settings{ 
  assumed_gamma 1.0
  //--- settings for subsurface translucency
    mm_per_unit 10
    subsurface {
      radiosity off
      samples 100, 40
    }
  //---
  radiosity {
    pretrace_start 16/max(image_width,image_height)
    pretrace_end    4/max(image_width,image_height) 
    #if (Stochastic)
      count 10
    #else
      count 50, 1000
    #end
    nearest_count 10, 5
    error_bound 1
    recursion_limit 2
    low_error_factor .3
    gray_threshold 0.0
    minimum_reuse 0.015
    maximum_reuse 0.1
    brightness 1

    adc_bailout 0.01/2
    normal on
    media off
    always_sample off
    //max_sample 1.0
  }
}

//--------------------------------------------------------------------------
#include "colors.inc"
#include "logo.inc"

#include "Granite_21.mcr"

//Basic scale values for decimal system.
//Taken from Bruno Cabasson's SSLT Candle Experiment (BC_SSLT Candle Experiment.pov)
#declare m  = 1;
#declare cm = m/100;
#declare mm = m/1000;

//Pre-declarations that kick in when using subsurface translucency
#local Dim1= off;
#local Dim2= Dim1;

//---------------------------------------------------------------------------
//---------------------------- objects in scene -----------------------------
//---------------------------------------------------------------------------

/*--- NOTE ------------------------------------------------------------------
  It is possible to use Granite_21 without declaring any parameter. The
  default values are used in that case, like in the following object.
---------------------------------------------------------------------------*/
  
//---------------------------------------------------- small Ovus
//Basic object scaled to decimal system:
#local SmallOvus =
  ovus {1.00, 0.65 scale 0.10*m
  material {Granite_21 ()}
  translate <-0.08, 0.1, -1.15>*m
}

SmallOvus

/*--- NOTE ------------------------------------------------------------------
  For each of your object, you can declare the parameters you want to use. 
  Those parameters which have not been chosen will use the default values 
  instead.
  
  You are invited to play with the parameters for the two objects below. 
  See the macro or the documentation for the default values.
---------------------------------------------------------------------------*/

//----------------------------------------------------Ovus
#declare Granite_file = "DakotaRedGranite.inc"
//#declare Granite_file = "NorthAmericanPinkGranite.inc"
//#declare Granite_file = "SouthernGrayGranite.inc"
//#declare Granite_file = "MediumBarreGrayGranite.inc"
//#declare Granite_file = "SaintAndreGreenGranite.inc"
//#declare Granite_file = "SaintAndreGreenDarkGranite.inc"
//#declare Granite_file = "ImpalaBlackGranite.inc"
#declare CSC   = 2;    //1 = 'raw' sRGB; 2 = sRGB conversion; every other value is rgb
#declare Pol   = on;  //on = polished; off = frosted
#declare Type  = off;    //off = no veins; on = veins    [on = still EXPERIMENTAL]
#declare Pat1  = 3;    //stone pattern: 1 = cells; 2 = step noise; 3 = crackle solid
#declare Pat2  = 3;    //pigment_pattern: 1 = cells mask; 2 = step noise mask; 3 = crackle solid mask
//#declare Blend = off;   //on = the granite pattern is blended/blurred (weathering); off = the pattern is 'fresh'
//#declare M_scale = <1.0, 1.0, 1.0>;
//#declare M_rotat = <0, 0, 0>;
//#declare M_trans = <0, 0, 0>;
#declare SubS    = off;  //subsurface translucency
#declare Translucency = <0.350, 0.287, 0.260>*1;
//----------------------------------------------------
#if(SubS) light_source {<-0.55, 0.5, 0.4>*m color <1,1,1>*1} #local Dim1 = on; #end //a lightsource behind the object

//Basic object scaled to decimal system:
#local Ovus =
  ovus {1.00, 0.65 scale 0.5*m
  #if (SubS) scale <1, 1, 0.1> #end //translucency works best with a thin object
  material {Granite_21 ()}
  translate <-0.55, 0.5, -0.5>*m
}

//----------------------------------------------------Superellipsoid
#declare Granite_file = "DakotaRedGranite.inc"
//#declare Granite_file = "NorthAmericanPinkGranite.inc"
//#declare Granite_file = "SouthernGrayGranite.inc"
//#declare Granite_file = "MediumBarreGrayGranite.inc"
//#declare Granite_file = "SaintAndreGreenGranite.inc"
//#declare Granite_file = "SaintAndreGreenDarkGranite.inc"
//#declare Granite_file = "ImpalaBlackGranite.inc"
#declare Pol   = off;  //on = polished; off = frosted
#declare Type  = on;    //off = no veins; on = veins    [on = still EXPERIMENTAL]
#declare Pat1  = 3;    //stone pattern: 1 = cells; 2 = step noise; 3 = crackle solid
#declare Pat2  = 3;    //pigment_pattern: 1 = cells mask; 2 = step noise mask; 3 = crackle solid mask
//#declare Blend = off;   //on = the granite pattern is blended/blurred (weathering); off = the pattern is 'fresh'
//#declare M_scale = <1.0, 1.0, 1.0>;
#declare M_rotat = <0, 30, 60>;
#declare M_trans = <0, 0, 1>;
#declare SubS    = off;  //subsurface translucency
#declare Translucency = <0.350, 0.287, 0.260>*1;
//----------------------------------------------------
#if(SubS) light_source {<0.55, 0.5, 0.4>*m color <1,1,1>*1} #local Dim2 =on; #end //a lightsource behind the object

//Basic object scaled to decimal system:
#local SuperEl =
union {
  superellipsoid { <0.1, 0.1> scale 0.5*m}
  object {Povray_Logo  
    scale 0.25*m
    rotate <0, 0, 0>
    translate <0, 0, -0.5>*m
  }
  #if (SubS) scale <1, 1, 0.1> #end //translucency works best with a thin object
  material {Granite_21 ()}
  translate <0.55, 0.5, -0.5>*m
}

//----------------------------------------------------The two objects
Ovus
SuperEl


//===========================================================================
// scene lighting -----------------------------------------------------------
#if (Dim1 | Dim2) #local Dimmer = 0.25; #else #local Dimmer = 1.0; #end
light_source {< 3000,1000,-3000>*m color <1,1,1>*Dimmer}
light_source {<-3000,1000,-3000>*m color <1,1,1>*Dimmer shadowless}

// camera ------------------------------------------------------------------
#declare Camera_0 = 
#switch (Camera)
#case (0)
  camera {
    perspective 
    angle 60
    location  <0.0, 0.5, -3.0>*m
    right     x*image_width/image_height
    look_at   <0.0, 0.5, 0.0>*m
  }
#break
#case (1)
  camera {
    orthographic
    angle 15
    location  <-0.55, 0.5,-1.25>*m
    right     x*image_width/image_height
    look_at   <-0.55, 0.5, 0.0>*m
  }
#break
#case (2)
  camera {
    orthographic
    angle 15
    location  <0.55, 0.5,-1.25>*m
    right     x*image_width/image_height
    look_at   <0.55, 0.5, 0.0>*m
  }
#end

camera {Camera_0}

// environment --------------------------------------------------------------
sphere {
  <0, 0, 0>, 1.0
  hollow
  pigment { 
    gradient <0, 1, 0>
    color_map { 
      [0.00 rgb <0.9, 0.9, 0.9>]
      [0.35 rgb <0.7, 0.7, 0.7>]
      [0.65 rgb <0.7, 0.7, 0.7>]
      [1.00 rgb <0.9, 0.9, 0.9>] 
    } 
    scale 2
  }
  finish {emission 0.5 diffuse 0}
  scale 10e4
}

union {
  plane { y, 0}
  plane {-z, 0}
  texture {
    checker 
    texture {pigment {srgb <0.9, 0.9, 0.9>} finish {diffuse albedo 0.8 specular albedo 0.2 roughness 0.001}}, 
    texture {pigment {srgb <0.8, 0.8, 0.8>} finish {diffuse albedo 0.8 specular albedo 0.2 roughness 0.001}}
    scale 1*m
    translate 0.5*x*m
  }
  translate 0.5*z
}

// scales -------------------------------------------------------------------
#local DecimalScale =
union {
  cylinder {<-0.5, 0, 0>*m, < 0.5, 0.00, 0>*m, 0.010*m}
  cylinder {<-0.5, 0, 0>*m, <-0.5, 0.10, 0>*m, 0.007*m}
  cylinder {< 0.5, 0, 0>*m, < 0.5, 0.10, 0>*m, 0.007*m}
  cylinder {< 0.0, 0, 0>*m, < 0.0, 0.07, 0>*m, 0.007*m}
  #for (I, -0.4, -0.1, 0.1)
    cylinder {< 0.0, 0, 0>*m, < 0.0, 0.03, 0>*m, 0.005*m translate I*x*m}
  #end
  #for (I, 0.1, 0.4, 0.1)
    cylinder {< 0.0, 0, 0>*m, < 0.0, 0.03, 0>*m, 0.005*m translate I*x*m}
  #end
}

#switch (Camera)
#case (0)
//overview
union {
  object {DecimalScale translate -1.25*z*m}
  text {
    internal 1 "100 cm"
    0.1, 0
    scale 0.1
    translate <-0.15, 0.01, -1.6>
  }
  pigment {srgb <0.9, 0.1, 0.1>}
  finish {diffuse 0.8 emission 0.1}
  no_shadow
}
#break
#case (1)
//Ovus closeup
union {
  object {DecimalScale scale 10*cm translate <-0.5, 0.435, -1.1>*m}
  text {
    internal 1 "10 cm"
    0.1, 0
    scale 0.02
    translate <-0.524, 0.415, -1.1>
  }
  pigment {srgb <0.9, 0.1, 0.1>}
  finish {diffuse 0.8 emission 0.1}
  no_shadow
}
#break
#case (2)
//Superellipsoid closeup
union {
  object {DecimalScale scale 10*cm translate < 0.5, 0.435, -1.1>*m }
  text {
    internal 1 "10 cm"
    0.1, 0
    scale 0.02
    translate <0.476, 0.415, -1.1>
  }
  pigment {srgb <0.9, 0.1, 0.1>}
  finish {diffuse 0.8 emission 0.1}
  no_shadow
}
#end

