/*==================================================================================================
 This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
 To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
 letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

 Persistence of Vision Ray Tracer Scene Description File
 File: DakotaRedGranite.inc
 Vers: 3.7+
 Desc: Dakota Red Granite colour_map and pigment_pattern entries, based on the original code 
       (MahoganyPol & MahoganyFro) by Daniel Mecklenburg Jr. from 1996.
       
       To be read by the Granite_21 macro.
       
 Date: 29 May 2021
 Auth: Thomas de Groot

====================================================================================================*/
// The colour_maps of the Dakota Red Granite
#local not_0 = 1/265;

#declare Map1_entries = 18;
#declare A_Granite_map1 =
array mixed [Map1_entries][2] {
  {0.00, <not_0, not_0, not_0>},
  {0.25, <0.059, 0.059, 0.059>},

  {0.25, <0.086, 0.027, 0.059>},
  {0.35, <0.086, 0.027, 0.059>},

  {0.35, <0.118, 0.118, 0.078>},
  {0.45, <0.118, 0.118, 0.078>},

  {0.45, <0.200, 0.137, 0.110>},
  {0.50, <0.150, 0.087, 0.060>},
  {0.57, <0.200, 0.137, 0.110>},

  {0.57, <0.400, 0.337, 0.310>},
  {0.60, <0.350, 0.287, 0.260>},
  {0.63, <0.400, 0.337, 0.310>},

  {0.63, <0.769, 0.329, 0.298>},
  {0.70, <0.669, 0.229, 0.198>},
  {0.75, <0.769, 0.329, 0.298>},

  {0.75, <0.600, 0.600, 0.600>},
  {0.85, <0.550, 0.550, 0.550>},
  {1.00, <0.650, 0.650, 0.650>}
}

#declare Map2_entries = 5;
#declare A_Granite_map2 =
array mixed [Map2_entries][4] {
  {0.000, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.005, <0.800, 0.800, 0.800>, 0.001, 0.000},
  {0.010, <0.800, 0.800, 0.800>, 0.050, 0.150},
  {0.011, <1.000, 1.000, 1.000>, 0.000, 1.000},
  {1.000, <1.000, 1.000, 1.000>, 0.000, 1.000}
}

// The mask used for the Dakota Red Granite pigment_pattern 
#declare Mask_entries = 14;
#declare A_Granite_mask = 
array mixed [Mask_entries][2] {
  {0.00, <not_0, not_0, not_0>},
  {0.25, <not_0, not_0, not_0>},

  {0.25, <0.100, 0.100, 0.100>},
  {0.35, <0.100, 0.100, 0.100>},

  {0.35, <0.250, 0.250, 0.250>},
  {0.45, <0.250, 0.250, 0.250>},

  {0.45, <0.500, 0.500, 0.500>},
  {0.57, <0.500, 0.500, 0.500>},

  {0.57, <0.600, 0.600, 0.600>},
  {0.63, <0.600, 0.600, 0.600>},

  {0.63, <0.700, 0.700, 0.700>},
  {0.75, <0.700, 0.700, 0.700>},

  {0.75, <0.900, 0.900, 0.900>},
  {1.00, <0.900, 0.900, 0.900>}
}

// The pigment_map and normal_map entries [0], normal strength [1], and for both the scale [2], variations for the Dakota Red Granite texture
#declare Var_entries = 8;
#declare A_Granite_var =
array [Var_entries][3] {
  {0.20, 0.50, 0.15},
  {0.25, 1.00, 0.18},
  {0.35, 1.00, 0.18},
  {0.40, 0.50, 0.15},
  {0.60, 1.00, 0.15},
  {0.65, 0.50, 0.18},
  {0.75, 1.00, 0.18},
  {0.80, 0.50, 0.15}
}

// The tranlucency colour for the subsurface light transport
#declare Translucency = <0.669, 0.229, 0.198>*1;

