// This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
// To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
// letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

// Persistence of Vision Ray Tracer Scene Description File
// File: granites_original.inc
// Vers: 2.2+
// Desc: Probably the original posting of granites.inc
// Date: January 1996
// Auth: Daniel Meklenburg Jr (aka Code Warrior)
// At  : https://groups.google.com/g/comp.graphics.rendering.raytracing/c/OH1eY_l2WxI
// POV-Ray archeology by: Thomas de Groot (2014 & 2021)

/*-------------------------------------------------------------------------

Looking For Stone Texture
=========================
R. Lusk
16 jan. 1996 09:00:00
I am currently working on a project that requires many different
types of stone textures for use in stone walls. Does anyone have
any really good ones? Thanks.

Andy McConnell
16 jan. 1996 09:00:00
I've always had excellent results with the stones.inc file distributed with
the standard POV documentation.

Code Warrior
17 jan. 1996 09:00:00
However these 'granites' are not based on any REAL granite. I work in the
granite industry and have come up with my own real granite textures to be used
with POV. If someone wants to use a reallife texture, they either are stuck
with using an image map or creating their own.

Mario Cormier
20 jan. 1996 09:00:00
So why don't you post your own granite textures? I'm sure lots of people
could benefit from it...

Code Warrior
22 jan. 1996

GRANITES.INC : Predefined granite textures for Persistence of Vision
Raytracer version 2.2

By Daniel Mecklenburg Jr

Brown Granites
MohoganyPol : Mohogany polished
MohoganyFro : Mohogany frosted

Black Granites
ImpalaPol : Impala polished
ImpalaFro : Impala frosted

Pink Granites
NAPPol : North American Pink polished
NAPFro : North American Pink frosted
CanPPol : Canadian Pink polished
CanPFro : Canadian Pink frosted

Gray Granites
SGrayPol : Southern Gray polished
SGrayFro : Southern Gray frosted
MGrayPol : Medium Gray polished
MGrayFro : Medium Gray frosted

Green Granites
StAndGPol : St. Andre Green polished
StAndGFro : St. Andre Green frosted

To be completed at some point:
RDeerBPol : Red Deer Brown polished
RDeerBPol : Red Deer Brown frosted
IndiaBPol : India Black polished
IndiaBFro : India Black frosted
SalisPPol : Salisbury Pink polished
SalisPFro : Salisbury Pink frosted
BPearlPol : Blue Pearl polished
BPearlFro : Blue Pearl frosted
TranasRPol : Tranas Red polished
TranasRFro : Tranas Red frosted
MissoRPol : Missouri Red polished
MissoRFro : Missouri Red frosted

-------------------------------------------------------------------------*/

#declare PolishFinish =
finish { ambient 0.5 phong 0.9 phong_size 80 brilliance 1.5 }

/*-------------------------------------------------------------------------
BLACK GRANITES : Impala, India Black
-------------------------------------------------------------------------*/
#declare IndiaBPol =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.450 color rgb < 0.00, 0.00, 0.00 >
color rgb < 0.01, 0.02, 0.01 > ]
}
scale 1.2
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.2
color_map {
/* Quartz */
[ 0.000, 0.250 color rgbf < 0.20, 0.20, 0.20, 0.15 >
color rgbf < 0.20, 0.20, 0.20, 0.95 > ]
[ 0.250, 1.000 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
}
translate < 20, 20, 33 >
rotate < 0.30, 0.20, 0.00 >
}
finish { PolishFinish }
}

#declare IndiaBFro =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.450 color rgb < 0.30, 0.30, 0.30 >
color rgb < 0.30, 0.32, 0.32 > ]
[ 0.450, 1.000 color rgb < 0.29, 0.33, 0.36 >
color rgb < 0.30, 0.32, 0.32 > ]
}
scale 1.2
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
}


#declare ImpalaPol =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.450 color rgb < 0.00, 0.00, 0.00 >
color rgb < 0.08, 0.04, 0.07 > ]
[ 0.450, 1.000 color rgb < 0.29, 0.33, 0.36 >
color rgb < 0.16, 0.12, 0.13 > ]
}
scale 1.2
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.2
color_map {
/* Quartz */
[ 0.000, 0.250 color rgbf < 0.66, 0.66, 0.70, 0.15 >
color rgbf < 0.50, 0.50, 0.55, 0.95 > ]
[ 0.250, 1.000 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
}
translate < 20, 20, 33 >
rotate < 0.30, 0.20, 0.00 >
}
finish { PolishFinish }
}

#declare ImpalaFro =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.450 color rgb < 0.30, 0.30, 0.30 >
color rgb < 0.38, 0.34, 0.37 > ]
[ 0.450, 1.000 color rgb < 0.49, 0.53, 0.56 >
color rgb < 0.36, 0.32, 0.33 > ]
}
scale 1.2
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
}

/*-------------------------------------------------------------------------
PINK GRANITES : North American Pink, Canadian Pink
-------------------------------------------------------------------------*/
#declare NAPPol =
texture {
pigment {
granite
turbulence 0.8
color_map {
[ 0.000, 0.500 color rgb < 97/255, 51/255, 63/255 >
color rgb < 178/255, 118/255, 86/255 > ]
[ 0.500, 1.000 color rgb < 172/255, 129/255, 116/255 >
color rgb < 235/255, 215/255, 205/255 > ]
}
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.8
color_map {
[ 0.000, 0.600 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.600, 1.000 color rgbf < 0.10, 0.08, 0.08, 0.50 >
color rgbf < 0.05, 0.04, 0.04, 0.00 > ]
}
scale 0.5
translate < 20, 20, 20 >
rotate < 30, 30, 30 >
}
finish { PolishFinish }
}

#declare NAPFro =
texture {
pigment {
granite
turbulence 0.8
color_map {
[ 0.000, 0.500 color rgb < 147/255, 111/255, 123/255 >
color rgb < 162/255, 129/255, 116/255 > ]
[ 0.500, 0.720 color rgb < 172/255, 129/255, 116/255 >
color rgb < 245/255, 220/255, 215/255 > ]
[ 0.720, 1.000 color rgb < 70/255, 70/255, 70/255 >
color rgb < 50/255, 50/255, 50/255 > ]
}
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
}

#declare CanPPol =
texture {
pigment {
granite
turbulence 0.8
color_map {
[ 0.000, 0.500 color rgb < 97/255, 51/255, 63/255 >
color rgb < 194/255, 124/255, 92/255 > ]
[ 0.500, 1.000 color rgb < 172/255, 129/255, 116/255 >
color rgb < 205/255, 150/255, 136/255 > ]
}
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.8
color_map {
[ 0.000, 0.600 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.600, 1.000 color rgbf < 0.10, 0.08, 0.08, 0.50 >
color rgbf < 0.05, 0.04, 0.04, 0.00 > ]
}
scale 0.5
translate < 20, 20, 20 >
rotate < 30, 30, 30 >
}
finish { PolishFinish }
}

#declare CanPFro =
texture {
pigment {
granite
turbulence 0.8
color_map {
[ 0.000, 0.500 color rgb < 147/255, 111/255, 123/255 >
color rgb < 162/255, 129/255, 116/255 > ]
[ 0.500, 0.720 color rgb < 172/255, 129/255, 116/255 >
color rgb < 245/255, 220/255, 215/255 > ]
[ 0.720, 1.000 color rgb < 70/255, 70/255, 70/255 >
color rgb < 50/255, 50/255, 50/255 > ]
}
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
}

/*-------------------------------------------------------------------------
BROWN GRANITES : Mohogany
-------------------------------------------------------------------------*/
#declare MohoganyPol =
texture {
pigment {
granite
turbulence 0.4
color_map {
[ 0.000, 0.250 color rgb < 0.00, 0.00, 0.00 >
color rgb < 0.06, 0.06, 0.06 > ]
[ 0.250, 0.350 color rgb < 0.09, 0.03, 0.06 >
color rgb < 0.12, 0.12, 0.08 > ]
[ 0.350, 1.000 color rgb < 0.20, 0.14, 0.11 >
color rgb < 0.77, 0.33, 0.30 > ]
}
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.2
color_map {
[ 0.000, 0.250 color rgbf < 0.66, 0.66, 0.70, 0.15 >
color rgbf < 0.50, 0.50, 0.55, 0.95 > ]
[ 0.250, 0.500 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.500, 0.505 color rgbf < 0.00, 0.00, 0.00, 0.00 >
color rgbf < 0.00, 0.00, 0.00, 0.00 > ]
[ 0.505, 0.900 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.900, 0.902 color rgbf < 0.90, 0.90, 0.96, 0.00 >
color rgbf < 1.00, 1.00, 1.00, 0.00 > ]
[ 0.902, 1.000 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
}
translate < 20, 20, 33 >
rotate < 0.30, 0.20, 0.00 >
scale 0.5
}
finish { PolishFinish }
}

#declare MohoganyFro =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.250 color rgb < 0.20, 0.20, 0.20 >
color rgb < 0.26, 0.26, 0.26 > ]
[ 0.250, 0.500 color rgb < 0.39, 0.33, 0.36 >
color rgb < 0.42, 0.42, 0.38 > ]
[ 0.500, 1.000 color rgb < 0.40, 0.34, 0.31 >
color rgb < 0.77, 0.66, 0.64 > ]
}
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
}

/*-------------------------------------------------------------------------
BLACK GRANITES : Impala
-------------------------------------------------------------------------*/
#declare ImpalaPol =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.450 color rgb < 0.00, 0.00, 0.00 >
color rgb < 0.08, 0.04, 0.07 > ]
[ 0.450, 1.000 color rgb < 0.29, 0.33, 0.36 >
color rgb < 0.16, 0.12, 0.13 > ]
}
scale 1.2
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.2
color_map {
/* Quartz */
[ 0.000, 0.250 color rgbf < 0.66, 0.66, 0.70, 0.15 >
color rgbf < 0.50, 0.50, 0.55, 0.95 > ]
[ 0.250, 1.000 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
}
translate < 20, 20, 33 >
rotate < 0.30, 0.20, 0.00 >
}
finish { PolishFinish }
}

#declare ImpalaFro =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.450 color rgb < 0.30, 0.30, 0.30 >
color rgb < 0.38, 0.34, 0.37 > ]
[ 0.450, 1.000 color rgb < 0.49, 0.53, 0.56 >
color rgb < 0.36, 0.32, 0.33 > ]
}
scale 1.2
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
}

/*-------------------------------------------------------------------------
GRAY GRANITES : Southern Gray, Medium (Barre) Gray
-------------------------------------------------------------------------*/
#declare SGrayPol =
texture {
pigment {
granite
turbulence 0.9
color_map {
[ 0.000, 0.200 color rgb < 240/255, 240/255. 240/255 >
color rgb < 200/255, 200/255, 200/255 > ]
[ 0.200, 1.000 color rgb < 200/255, 200/255. 200/255 >
color rgb < 120/255, 120/255, 120/255 > ]
}
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.8
color_map {
[ 0.000, 0.500 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.500, 1.000 color rgbf < 0.20, 0.16, 0.16, 0.50 >
color rgbf < 0.00, 0.00, 0.00, 0.00 > ]
}
scale 0.2
translate < 20, 20, 33 >
rotate < 0.30, 0.20, 0.00 >
}
finish { PolishFinish }
}

#declare SGrayFro =
texture {
pigment {
granite
turbulence 0.9
color_map {
[ 0.000, 0.600 color rgb < 250/255, 250/255. 250/255 >
color rgb < 190/255, 190/255, 190/255 > ]
[ 0.600, 1.000 color rgb < 88/255, 88/255. 88/255 >
color rgb < 140/255, 140/255, 140/255 > ]
}
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
scale 0.25
}

#declare MGrayPol =
texture {
pigment {
agate
color_map {
[ 0.000, 0.500 color rgb < 245/255, 245/255. 245/255 >
color rgb < 220/255, 220/255, 220/255 > ]
[ 0.500, 1.000 color rgb < 130/255, 130/255. 130/255 >
color rgb < 80/255, 80/255, 80/255 > ]
}
}
scale 0.12
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.9
color_map {
[ 0.000, 0.600 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.600, 1.000 color rgbf < 0.20, 0.26, 0.16, 0.60 >
color rgbf < 0.00, 0.00, 0.00, 0.00 > ]
}
scale 0.3
translate < 20, 20, 33 >
rotate < 0.30, 0.20, 0.00 >
}
finish { PolishFinish }
}

#declare MGrayFro =
texture {
pigment {
granite
turbulence 0.9
color_map {
[ 0.000, 0.700 color rgb < 255/255, 255/255. 255/255 >
color rgb < 220/255, 220/255, 220/255 > ]
[ 0.700, 1.000 color rgb < 68/255, 78/255. 68/255 >
color rgb < 120/255, 140/255, 120/255 > ]
}
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
scale 0.25
}

/*-------------------------------------------------------------------------
GREEN GRANITES : St. Andre Green
-------------------------------------------------------------------------*/
#declare StAndGPol =
texture {
pigment {
agate
turbulence 0.7
color_map {
[ 0.000, 0.650 color rgb < 0.00, 0.00, 0.00 >
color rgb < 0.06, 0.03, 0.05 > ]
[ 0.650, 0.850 color rgb < 0.07, 0.07, 0.05 >
color rgb < 0.12, 0.12, 0.08 > ]
[ 0.850, 0.940 color rgb < 0.15, 0.16, 0.13 >
color rgb < 0.35, 0.26, 0.20 > ]
[ 0.940, 1.000 color rgb < 0.35, 0.26, 0.20 >
color rgb < 0.37, 0.26, 0.25 > ]
}
}
finish { PolishFinish }
}
texture {
pigment {
granite
turbulence 0.4
color_map {
[ 0.000, 0.450 color rgbf < 0.16, 0.16, 0.20, 0.15 >
color rgbf < 0.00, 0.00, 0.05, 0.75 > ]
[ 0.450, 0.500 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.500, 0.625 color rgbf < 0.00, 0.00, 0.00, 0.00 >
color rgbf < 0.00, 0.00, 0.00, 0.00 > ]
[ 0.625, 0.900 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
[ 0.900, 0.905 color rgbf < 0.80, 0.90, 0.84, 0.00 >
color rgbf < 1.00, 1.00, 1.00, 0.00 > ]
[ 0.905, 1.000 color rgbf < 1.00, 1.00, 1.00, 1.00 >
color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
}
translate < 20, 20, 33 >
rotate < 0.30, 0.20, 0.00 >
}
finish { PolishFinish }
}

#declare StAndGFro =
texture {
pigment {
granite
turbulence 0.7
color_map {
[ 0.000, 0.350 color rgb < 0.10, 0.10, 0.10 >
color rgb < 0.26, 0.26, 0.26 > ]
[ 0.350, 0.540 color rgb < 0.39, 0.33, 0.36 >
color rgb < 0.42, 0.42, 0.38 > ]
[ 0.540, 1.000 color rgb < 0.40, 0.34, 0.31 >
color rgb < 0.67, 0.53, 0.50 > ]
}
}
finish { diffuse 1.0 crand 0.25 ambient 0.5 }
normal { bumps 0.1 scale 0.2 }
}