// This work is licensed under the Creative Commons Attribution-ShareAlike 3.0 Unported License.
// To view a copy of this license, visit http://creativecommons.org/licenses/by-sa/3.0/ or send a
// letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.

/**********************************************************************************
 Persistence of Vision Ray Tracer Scene Description File
 File name   : CanPPol.pov
 Version     : 3.7+
 Description : Predefined granite textures for Persistence of Vision Raytracer version 2.2
               Redefined and made consistent for version 3.7+ by Thomas de Groot (2021)
 Date        : March 2021
 Author      : Daniel Mecklenburg Jr (1996)
 E-mail      : 
 
**********************************************************************************/

// Render settings (right-click on a line below):
// +w640 +h640 +am2 +a0.3 +bm2 +bs8 +wt7
// +w640 +h640 +am3 +a0.01 +ac0.90 +r3 +wt7

#version 3.7;

#include "colors.inc"
#include "functions.inc"
#include "textures.inc"
#declare Rad            = on;		// Radiosity switch

global_settings {
  assumed_gamma 1.0
  max_trace_level 5			//default [5]
  #if (Rad)
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.004          // end pretrace at this size
    count 100, 1000                // higher -> higher quality (1..1600) [35]
    nearest_count 10, 5           // higher -> higher quality (1..10) [5]
    error_bound 1                 // higher -> smoother, less accurate [1.8]
    recursion_limit 2             // how much interreflections are calculated (1..5+) [2]
    low_error_factor .3           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    maximum_reuse 0.1							// new parameter 3.7 [0.2]
    brightness 1                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    normal on                   // take surface normals into account [off]
    media off                    // take media into account [off]
    always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
  #end
  //noise_generator 2
}

//======================================================================
//======================================================================
//Define your textures here

#declare Typ = 2; //1 or 2
#declare SCS = 2;
#if (SCS=2)
  #declare SatBoost = 0.01;
  #declare BrightBoost = -0.01;   //0 = no brightness change; >0 = brighter; <0 = darker
#end
#include "granites21.inc"

//==========================================
//Apply to this object

#declare TexObject =
union {
  ovus {1.00, 0.65 
    scale 0.5
    translate <0, 0.45, 0> 
  }
  superellipsoid { <0.1, 0.1>
    scale 0.5
    translate -0.5*y
  }
  #switch (Typ)
  #case (1)
    texture {CanPPol_1}
  #break
  #case (2)
    texture {CanPPol_2}
  #break
  #else
    #debug "\nAttention! Typ should be 1 or 2!\n"
    texture {pigment {rgb <1, 0, 0>}}
  #end
}

object {TexObject
  scale 40
  rotate 35*y
}

//======================================================================
//======================================================================
//Scene environment

camera {
  location  <0.0, 0.5, -4.0>*40
  direction 1.5*z
  angle     40
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

// a sky sphere
sphere { <0, 0, 0>, 1 
  pigment {
    gradient y
    color_map {
      [0.0 srgb 1.0]
      [0.7 srgb 0.7]
    }
  }
  finish {emission 1 diffuse 0}
  scale 5*10e4
  inverse
}

#include "CGSphere_ground.inc"
object {Ground}

#declare Area           = on;
#declare Sun_alt 			  = 45;
#declare Sun_azm 			  = 55;
#declare Intensity      = 1;

#include "CIE.inc"
#declare SunCol  = Blackbody(6500)*Intensity;
#declare SunPos  = <0, 0, -2>*10e4;
#declare SunDia  = vlength(SunPos)*2/215;  //apparent diameter of the Sun

#if (Area)
  #debug "\nUsing an area_light for the Sun.\n"
  light_source{
    <0, 0, 0>
    color SunCol
    area_light
    SunDia*x, SunDia*z, // lights spread out across this distance (x * z)
    9, 9                // total number of lights in grid (4x*4z = 16 lights)
    adaptive 1          // 0,1,2,3...
    area_illumination on  // full area diffuse and specular
    jitter              // adds random softening of light
    circular            // make the shape of the light circular
    orient              // orient light
    translate SunPos
    rotate Sun_alt*x
    rotate Sun_azm*y
    parallel
    point_at <0, 0, 0>
  }
#else
  light_source {
    <0, 0, 0>           // light's position (translated below)
    color rgb SunCol    // light's color
    translate SunPos
    rotate Sun_alt*x
    rotate Sun_azm*y
    parallel
    point_at <0, 0, 0>
  }
#end
