#version 3.7;
#declare Rad00_adc_bailout = 0.005;
#declare Rad00_always_sample = off;
#declare Rad00_brightness = 1;
#declare Rad00_count = 50;
#declare Rad00_count2 = 500;
#declare Rad00_error_bound = 0.8;
#declare Rad00_gray_threshold = 0.1;
#declare Rad00_low_error_factor = 0.5;
#declare Rad00_max_sample = -99;
#declare Rad00_media = off;
#declare Rad00_maximum_reuse = 0.2;
#declare Rad00_minimum_reuse = 0.015;
#declare Rad00_nearest_count = 10;
#declare Rad00_nearest_count2 = 8;
#declare Rad00_normal = off;
#declare Rad00_pretrace_start = 0.08;
#declare Rad00_pretrace_end = 0.001;
#declare Rad00_recursion_limit = 2;
#declare Rad00_subsurface = off;
global_settings {
    assumed_gamma 1
    ambient_light srgb <1,1,1>
    radiosity {
        adc_bailout       Rad00_adc_bailout
        always_sample     Rad00_always_sample
        brightness        Rad00_brightness
        count             Rad00_count,Rad00_count2
        error_bound       Rad00_error_bound
        gray_threshold    Rad00_gray_threshold
        low_error_factor  Rad00_low_error_factor
        max_sample        Rad00_max_sample
        media             Rad00_media
        maximum_reuse     Rad00_maximum_reuse
        minimum_reuse     Rad00_minimum_reuse
        nearest_count     Rad00_nearest_count,Rad00_nearest_count2
        normal            Rad00_normal
        pretrace_start    Rad00_pretrace_start
        pretrace_end      Rad00_pretrace_end
        recursion_limit   Rad00_recursion_limit
        subsurface        Rad00_subsurface
    }
}
#declare Black = srgbft <0,0,0,0,0>;
#include "functions.inc"
#declare Fn_42 = function {
    pigment{image_map {"F_Displacement.png" gamma 2.2 once map_type 1 interpolate 2 }}
}
#declare F_Displacement = function (x,y,z) {
    Fn_42(x,y,z).grey-0.50
}
#declare Fn_46 = function (x,y,z) {
    ((Fn_42(x,y,z).grey-0.50)*0.04)
}
#declare Fn_47 = function (x,y,z) {
    f_sphere(x,y,z,0.450)-0.01
}
#declare Fn_47_inv = function (x,y,z) {
    -(f_sphere(x,y,z,0.450))-0.01
}
#declare F_DisplaceAsShell = function (x,y,z) {
    max(Fn_47(x,y,z),Fn_47_inv(x,y,z))+Fn_46(x,y,z)
}
#declare F_DisplaceAsSphere = function (x,y,z) {
    f_sphere(x,y,z,0.450)+(F_Displacement(x,y,z)*(0.020*0.5))-(0.020/1.2)
}
#declare F_DisplaceAsSphere_inv = function (x,y,z) {
    -(f_sphere(x,y,z,0.450)+(F_Displacement(x,y,z)*(0.020*0.5))-(0.020/1.2))
}
#declare F_PickOffRind = function (x,y,z) {
    F_DisplaceAsSphere_inv(x,y,z)
}
#declare F_PumpkinRind = function (x,y,z) {
    max(F_DisplaceAsShell(x,y,z),F_PickOffRind(x,y,z))
}
#declare F_HollowInMeat_inv = function (x,y,z) {
    -(f_sphere(x,y,z,0.375)+f_wrinkles(x*11,y*5,z*11)*(0.375*0.05))
}
#declare F_PumpkinMeat = function (x,y,z) {
    max(F_DisplaceAsSphere(x,y,z),F_HollowInMeat_inv(x,y,z))
}
#declare F_blob = function (T,S) {
    1/exp(S*T)
}
#declare F_PumpkinRindMeatMeet = function (x,y,z) {
    2-F_blob(F_PumpkinRind(x,y,z),10.00)-F_blob(F_PumpkinMeat(x,y,z),10.00)
}
#declare Spline_F_StemBaseCone = spline {
    linear_spline
    0.445, <0.2,0.2,0.2>
    0.755, <0.1,0.1,0.1>
}
#declare F_StemBaseCone_Spline = function {
    spline { Spline_F_StemBaseCone }
}
#declare F_StemBaseCone = function (x,y,z) {
    max(sqrt(pow(x,2)+pow(z,2))-0.5*F_StemBaseCone_Spline(y).y,f_rounded_box(x,y-0.6,z,0.125,0.635,0.15,0.635))
}
#declare Pgm_radial5 = pigment {
    radial frequency 5 sine_wave
    color_map { [ 0 color 0 ] [ 1 color 1 ] }
}
#declare F_radial5 = function {
    pigment { Pgm_radial5 }
}
#declare F_StemA = function (x,y,z) {
    F_StemBaseCone(x,y,z)+F_radial5(x,y,z).grey*0.02+(f_wrinkles(x*31.0,y*21.0,z*31.0)*0.0085)
}
#declare F_Stem = function (x,y,z) {
    F_StemA(x+pow(y-0.450,2),y,z)
}
#declare F_Pumpkin = function (x,y,z) {
    2-F_blob(F_PumpkinRind(x,y,z),10.00)-F_blob(F_PumpkinMeat(x,y,z),10.00)-F_blob(F_PumpkinRindMeatMeet(x,y,z),10.00)-F_blob(F_Stem(x,y,z),80.00)
}
#declare F_StemBumpOut = function (x,y,z) {
    F_Stem(x,y,z)-0.02
}
#declare Christine = srgbft <0.9059,0.451,0.03922,0,0>;
#declare Christine_less = srgbft <0.8559,0.401,0,0,0>;
#declare Christine_more = srgbft <0.9559,0.501,0.08922,0,0>;
#declare Amber = srgbft <0.9725,0.651,0.2667,0,0>;
#declare Amber_less = srgbft <0.9225,0.601,0.2167,0,0>;
#declare Amber_more = srgbft <1,0.701,0.3167,0,0>;
#declare CasselEarth416_less = srgbft <0.7696,0.6363,0.4598,0,0>;
#declare CasselEarth416_more = srgbft <0.8696,0.7363,0.5598,0,0>;
#declare F_Rind00 = finish {
    ambient srgb <0,0,0>
    diffuse albedo 0.8
    emission srgb <0,0,0>
    specular albedo 0.2 roughness 0.12
}
#declare N_Rind00 = normal {
    bumps
    bump_size 0.25
    accuracy 0.001
    scale 0.001
}
#declare F_Meat00 = finish {
    ambient srgb <0,0,0>
    diffuse albedo 0.8
    emission srgb <0,0,0>
}
#declare N_Meat00 = normal {
    bumps
    bump_size 0.2
    accuracy 0.001
    scale 0.001
}
#declare F_Stem00 = finish {
    ambient srgb <0,0,0>
    diffuse albedo 0.8
    emission srgb <0,0,0>
}
#declare T_Rind_less = texture {
    pigment { color Christine_less }
    finish { F_Rind00 }
}
#declare T_Rind = texture {
    pigment { color Christine }
    finish { F_Rind00 }
    normal { N_Rind00 }
}
#declare T_Rind_more = texture {
    pigment { color Christine_more }
    finish { F_Rind00 }
}
#declare T_Meat_less = texture {
    pigment { color Amber_less }
    finish { F_Meat00 }
    normal { N_Meat00 }
}
#declare T_Meat = texture {
    pigment { color Amber }
    finish { F_Meat00 }
}
#declare T_Meat_more = texture {
    pigment { color Amber_more }
    finish { F_Meat00 }
    normal { N_Meat00 }
}
#declare T_Stem_less = texture {
    pigment { color CasselEarth416_less }
    finish { F_Stem00 }
}
#declare Clay_Creek = srgbft <0.5412,0.5137,0.3765,0,0>;
#declare T_Stem = texture {
    pigment { color Clay_Creek }
    finish { F_Stem00 }
}
#declare T_Stem_more = texture {
    pigment { color CasselEarth416_more }
    finish { F_Stem00 }
}
#declare T_Default = texture {
    pigment { color Black }
}
#declare F_PumpkinTexture = function (x,y,z) {
    0.0 +
    ( (F_StemBumpOut(x,y,z)>=0) * (F_PickOffRind(x,y,z)<0) * 0.25 ) +
    ( (F_Stem(x,y,z)>=0) * (F_PumpkinMeat(x,y,z)<0) * 0.5 ) +
    ( (F_PumpkinMeat(x,y,z)>=0) * (F_StemBumpOut(x,y,z)<0) * 0.75 ) +
    ( (F_Pumpkin(x,y,z)<0.0001) * f_snoise3d(x*180,y*180,z*180) * 0.00099 )
}
#declare F_PumpkinTexture00 = function (x,y,z) {
    F_PumpkinTexture(x,y,z)
}
#declare F_PumpkinTexture01 = function (x,y,z) {
    F_PumpkinTexture(x/1.2,y/(1+sqrt(pow(x,2)+pow(z,2))),z/1.2)
}
#declare F_PumpkinTexture02 = function (x,y,z) {
    F_PumpkinTexture(x/1.4,y*1.2,z/1.4)
}
#declare F_PumpkinTexture03 = function (x,y,z) {
    F_PumpkinTexture(x,y+(sqrt(pow(x,2)+pow(z,2))),z)
}
#declare F_PumpkinTexture04 = function (x,y,z) {
    F_PumpkinTexture(x,y-(sqrt(pow(x,2)+pow(z,2))),z)
}
#declare F_PumpkinTexture06 = function (x,y,z) {
    F_PumpkinTexture(x*1.5,y,z*1.5)
}
#declare F_PumpkinTexture07 = function (x,y,z) {
    F_PumpkinTexture((x*1.5)-pow(y,2.0),y/1.5,z*1.5)
}
#declare F_Pumpkin00 = function (x,y,z) {
    F_Pumpkin(x,y,z)
}
#declare F_Pumpkin01 = function (x,y,z) {
    F_Pumpkin(x/1.2,y/(1+sqrt(pow(x,2)+pow(z,2))),z/1.2)
}
#declare F_Pumpkin02 = function (x,y,z) {
    F_Pumpkin(x/1.4,y*1.2,z/1.4)
}
#declare F_Pumpkin03 = function (x,y,z) {
    F_Pumpkin(x,y+(sqrt(pow(x,2)+pow(z,2))),z)
}
#declare F_Pumpkin04 = function (x,y,z) {
    F_Pumpkin(x,y-(sqrt(pow(x,2)+pow(z,2))),z)
}
#declare F_Pumpkin06 = function (x,y,z) {
    F_Pumpkin(x*1.5,y,z*1.5)
}
#declare F_Pumpkin07 = function (x,y,z) {
    F_Pumpkin((x*1.5)-pow(y,2.0),y/1.5,z*1.5)
}
#declare TextureMap = texture_map {
    [ 0 T_Default ]
    [ 0.248 T_Default ]
    [ 0.249 T_Rind_less ]
    [ 0.25 T_Rind ]
    [ 0.251 T_Rind_more ]
    [ 0.252 T_Default ]
    [ 0.498 T_Default ]
    [ 0.499 T_Meat_less ]
    [ 0.5 T_Meat ]
    [ 0.501 T_Meat_more ]
    [ 0.502 T_Default ]
    [ 0.748 T_Default ]
    [ 0.749 T_Stem_less ]
    [ 0.75 T_Stem ]
    [ 0.751 T_Stem_more ]
    [ 0.752 T_Default ]
    [ 1 T_Default ]
}
#declare Texture00 = texture {
    function  { F_PumpkinTexture00(x,y,z) }
    texture_map { TextureMap }
}
#declare Texture01 = texture {
    function  { F_PumpkinTexture01(x,y,z) }
    texture_map { TextureMap }
}
#declare Texture02 = texture {
    function  { F_PumpkinTexture02(x,y,z) }
    texture_map { TextureMap }
}
#declare Texture03 = texture {
    function  { F_PumpkinTexture03(x,y,z) }
    texture_map { TextureMap }
}
#declare Texture04 = texture {
    function  { F_PumpkinTexture04(x,y,z) }
    texture_map { TextureMap }
}
#declare Texture06 = texture {
    function  { F_PumpkinTexture06(x,y,z) }
    texture_map { TextureMap }
}
#declare Texture07 = texture {
    function  { F_PumpkinTexture07(x,y,z) }
    texture_map { TextureMap }
}
#declare Grey80 = srgbft <0.8,0.8,0.8,0,0>;
#declare Grey20 = srgbft <0.2,0.2,0.2,0,0>;
#declare ColorMap_CloudyGraySky = color_map {
    [ 0 Grey80 ]
    [ 0.475 Grey20 ]
    [ 0.525 Grey20 ]
    [ 1 Grey80 ]
}
#macro Warp_CloudyGraySky ()
    warp {
        turbulence 0.40
        omega      0.65
    }
#end
#declare Pigment_CloudyGraySky = pigment {
    gradient y
    color_map { ColorMap_CloudyGraySky }
    scale 2.0
    translate <0.0,-1.0,0.0>
    Warp_CloudyGraySky()
}
#declare Sky_Sphere00 = sky_sphere {
    pigment { Pigment_CloudyGraySky }
    emission rgb <1,1,1>
}
#declare Light00 = light_source {
    <250,550,-50>, Grey80
}
#declare Camera01 = camera {
    perspective
    location <0,1.5,-6.501>
    sky <0,1,0>
    angle 35
    right x*(image_width/image_height)
    look_at <0,0,0>
}
#declare IsoPumpkin00 = isosurface {
    function { F_Pumpkin00(x,y,z) }
    contained_by { box { <-0.6,-0.6,-0.6>,<0.6,0.8,0.6> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare IsoPumpkin01 = isosurface {
    function { F_Pumpkin01(x,y,z) }
    contained_by { box { <-0.6,-0.6,-0.6>,<0.6,0.8,0.6> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare IsoPumpkin02 = isosurface {
    function { F_Pumpkin02(x,y,z) }
    contained_by { box { <-0.7,-0.4,-0.7>,<0.7,0.6,0.7> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare IsoPumpkin03 = isosurface {
    function { F_Pumpkin03(x,y,z) }
    contained_by { box { <-0.6,-0.6,-0.6>,<0.6,0.8,0.6> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare IsoPumpkin04 = isosurface {
    function { F_Pumpkin04(x,y,z) }
    contained_by { box { <-0.6,-0.6,-0.6>,<0.6,0.8,0.6> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare IsoPumpkin05 = isosurface {
    function { F_Pumpkin00(x,y,z) }
    contained_by { box { <-0.6,-0.1,-0.6>,<0.6,0.1,0.6> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare IsoPumpkin06 = isosurface {
    function { F_Pumpkin06(x,y,z) }
    contained_by { box { <-0.6,-0.6,-0.6>,<0.6,0.8,0.6> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare IsoPumpkin07 = isosurface {
    function { F_Pumpkin07(x,y,z) }
    contained_by { box { <-0.6,-1.2,-0.6>,<0.8,1.6,0.6> } }
    threshold -0.0001
    accuracy 0.0005
    max_gradient 115
    all_intersections
}
#declare ObjPumpkin00 = object {
    object { IsoPumpkin00 }
    texture { Texture00 }
    scale 0.4
    translate <-1.25,0.60,-0.50>
}
#declare ObjPumpkin01 = object {
    object { IsoPumpkin01 }
    texture { Texture01 }
}
#declare ObjPumpkin02 = object {
    object { IsoPumpkin02 }
    texture { Texture02 }
    scale 0.4
    translate <-1.25,0.00,-0.50>
}
#declare ObjPumpkin03 = object {
    object { IsoPumpkin03 }
    texture { Texture03 }
    scale 0.4
    translate <-1.25,-0.60,-0.50>
}
#declare ObjPumpkin04 = object {
    object { IsoPumpkin04 }
    texture { Texture04 }
    scale 0.4
    translate <1.25,0.60,-0.50>
}
#declare ObjPumpkin05 = object {
    object { IsoPumpkin05 }
    texture { Texture00 }
    scale 0.4
    translate <1.25,0.00,-0.50>
}
#declare ObjPumpkin06 = object {
    object { IsoPumpkin06 }
    texture { Texture06 }
    scale 0.4
    translate <1.25,-0.60,-0.50>
}
#declare ObjPumpkin07 = object {
    object { IsoPumpkin07 }
    texture { Texture07 }
    scale 0.4
    translate <0.75,0.00,-0.70>
}

//---
sky_sphere { Sky_Sphere00 }
camera { Camera01 }
light_source { Light00 }
object { ObjPumpkin00 }
object { ObjPumpkin01 }
object { ObjPumpkin02 }
object { ObjPumpkin03 }
object { ObjPumpkin04 }
object { ObjPumpkin05 }
object { ObjPumpkin06 }
object { ObjPumpkin07 }
