//--- First render false.pov, plaster.pov & true.pov
global_settings {
    assumed_gamma 1.0
    ambient_light srgb <1.0,1.0,1.0>
}
#declare Grey80 = srgbft <0.8,0.8,0.8,0.0,0.0>;
#declare Grey20 = srgbft <0.2,0.2,0.2,0.0,0.0>;
#declare ColorMap_CloudyGraySky = color_map {
    [ 0.0 Grey80 ]
    [ 0.4750 Grey20 ]
    [ 0.5250 Grey20 ]
    [ 1.0 Grey80 ]
}
#macro Warp_CloudyGraySky ()
    warp {
        turbulence 0.40
        omega      0.65
    }
#end
#declare Pigment_CloudyGraySky = pigment {
    gradient y
    color_map { ColorMap_CloudyGraySky }
    scale 2.0
    translate <0.0,-1.0,0.0>
    Warp_CloudyGraySky()
}
#declare Sky_Sphere00 = sky_sphere {
    pigment { Pigment_CloudyGraySky }
    emission rgb <1.1,1.0,1.0>
}
#declare White = srgbft <1.0,1.0,1.0,0.0,0.0>;
#declare Light00 = light_source {
    <250.0,550.0,-350.0>, White
}
#declare Camera00 = camera {
    perspective
    location <0.0,0.0,-1.5001>
    sky <0.0,1.0,0.0>
    angle 35.0
    right x*(image_width/image_height)
    look_at <0.0,0.0,0.0>
}
#include "functions.inc"
#declare Fplaster = function {
    pigment{image_map {"plaster.png" gamma 2.20 once map_type 0 interpolate 3 }}
}
#declare Ftrue = function {
    pigment{image_map {"true.png"    gamma 2.20 once map_type 0 interpolate 3 }}
}
#declare Ffalse = function {
    pigment{image_map {"false.png"   gamma 2.20 once map_type 0 interpolate 3 }}
}
//--- Very thin - paint thin - plaster base
#declare FshapePlaster = function (x,y,z) {
    (Fplaster(x,y,z).grey*0.004)-(0.005-abs(z))
}
//--- Intersect paint image regions with offset thin plaster.
#declare FshapeTrue = function (x,y,z) {
    max(FshapePlaster(x,y,z+0.0010),(Ftrue(x,y,z+0.0010).grey-0.50))
}
//--- Where paint peel displacement happens. Change both 0.0060s.
#declare FshapePaint = function (x,y,z) {
    FshapeTrue(x,y,z+0.0060-(Ffalse(x,y,z).grey*+0.0060))
}
#declare F_Thing00 = function (x,y,z) {
    min(FshapePlaster(x,y,z),FshapePaint(x,y,z))
}
// *_less & *_more colors set extreme to "see" noise
// scaling in Texture01 below. Final image would update.
#declare Ash = srgbft <0.7765,0.7647,0.7098,0.0,0.0>;
#declare Ash_less = srgbft <1.0,0.0,1.0,0.0,0.0>;
#declare Ash_more = srgbft <1.0,1.0,0.0,0.0,0.0>;
#declare Cello = srgbft <0.1176,0.2196,0.3569,0.0,0.0>;
#declare Cello_less = srgbft <1.0,0.0,0.0,0.0,0.0>;
#declare Cello_more = srgbft <0.0,1.0,0.0,0.0,0.0>;
#declare F_Paint00 = finish {
    ambient srgb <0.0,0.0,0.0>
    diffuse albedo 0.8
    emission srgb <0.0,0.0,0.0>
    specular albedo 0.2 roughness 0.12
}
#declare F_Wall00 = finish {
    ambient srgb <0.0,0.0,0.0>
    diffuse albedo 0.8
    emission srgb <0.0,0.0,0.0>
}
#declare T_Paint01_less = texture {
    pigment { color Cello_less }
    finish { F_Paint00 }
}
#declare T_Paint01 = texture {
    pigment { color Cello }
    finish { F_Paint00 }
}
#declare T_Paint01_more = texture {
    pigment { color Cello_more }
    finish { F_Paint00 }
}
#declare T_Wall_less = texture {
    pigment { color Ash_less }
    finish { F_Wall00 }
}
#declare T_Wall = texture {
    pigment { color Ash }
    finish { F_Wall00 }
}
#declare T_Wall_more = texture {
    pigment { color Ash_more }
    finish { F_Wall00 }
}
#declare Grey30 = srgbft <0.3,0.3,0.3,0.0,0.0>;
#declare T_Default = texture {
    pigment { color Grey30 }
}
#declare F_ThingPig = function (x,y,z) {
    0.0 +
    ( (F_Thing00(x,y,z)<0.0) * (FshapePlaster(x,y,z)<0.0) * 0.3333 ) +
    ( (F_Thing00(x,y,z)<0.0) * (FshapePaint(x,y,z)<0.0) * 0.6667 ) +
    ( (F_Thing00(x,y,z)<0.0001) * f_snoise3d(x*40.0,y*40.0,z*40.0) * 0.0010 )
}
#declare TextureMap01 = texture_map {
    [ 0.0 T_Default ]
    [ 0.3313 T_Default ]
    [ 0.3323 T_Wall_less ]
    [ 0.3333 T_Wall ]
    [ 0.3343 T_Wall_more ]
    [ 0.3353 T_Default ]
    [ 0.6647 T_Default ]
    [ 0.6657 T_Paint01_less ]
    [ 0.6667 T_Paint01 ]
    [ 0.6677 T_Paint01_more ]
    [ 0.6687 T_Default ]
    [ 1.0 T_Default ]
}
#declare Texture01 = texture {
    function  { F_ThingPig(x,y,z) }
    texture_map { TextureMap01 }
}
#declare Iso00 = isosurface {
    function { F_Thing00(x,y,z) }
    contained_by { box { <0.0,0.0,-0.0200>,<1.0,1.0,0.0200> } }
    threshold -0.0001
    accuracy 0.0001
    max_gradient 10.0
    max_trace 2
}
#declare OurWall = object {
    object { Iso00 }
    texture { Texture01 }
    translate <-0.5,-0.5,0>
}

//---
sky_sphere { Sky_Sphere00 }
camera { Camera00 }
light_source { Light00 }
object { OurWall }
