//---
// povray +Ifalse.pov +A +AM2 +D -P +H2000 +W2000 +WT8
//
// Gaussian blur in Gimp 30x30 to start. Other edits as needed.
//---
#default { finish {ambient 1.0} }
global_settings {
    assumed_gamma 1.0
    ambient_light srgb <1.0,1.0,1.0>
}
#declare White = srgbft <1.0,1.0,1.0,0.0,0.0>;
#declare Black = srgbft <0.0,0.0,0.0,0.0,0.0>;
background {
    color Black
}
#declare Camera00 = camera {
    orthographic
    location <0.0,0.0,-1.0>
    direction <0.0,0.0,1.0>
    right x*(1.0)
    up <0.0,1.0,0.0>
    look_at z
}
#declare Plane00 = plane { <0.0,0.0,-1.0>, 0.0
}
#macro PaintPeeling (Pattern,P_paint,T_scale,PeelFactor,CrackFactor,CrackWidth)
  #local Crack =
  texture {
    pigment {
      crackle
      turbulence .15
      pigment_map {
          [ 0.00 srgbt <1,1,1,1> ]
          [ 0.04 srgbt <1,1,1,1> ]
          [ 0.04 P_paint ]
      }
    }
    scale CrackWidth
  }
  #local Cracking = PeelFactor + CrackFactor;
  #if (Cracking > 1.00) #local Cracking = 1.0; #end
  texture {
    #switch (Pattern)
    #case (1)
      granite
    #break
    #case (2)
      agate
    #break
    #end
    texture_map {
      [ PeelFactor pigment { srgbt <1,1,1,1>} ]  //no paint
      [ PeelFactor Crack]
      [ Cracking   Crack]
      [ Cracking   pigment { srgb P_paint} ] //full paint
    }
    scale T_scale
  }
#end
#declare ObjPlane01 = object {
    object { Plane00 }
    PaintPeeling(1,White,0.5,0.2,0.2,0.07)
}

//---
camera { Camera00 }
object { ObjPlane01 }
