/**
 * A doodle with an object (at the moment is a dolphin, but could be a bird or a starship...)
 *
 * pg-20130410
 *
 * Credits: the moon texture come from Ken Tyler's Lit tapered candle material
 * 			Blender for the dolphin (following the tutorial http://www.blendernation.com/tutorials/blender-3d-beginner-tutorial-dolphin/)
 *			PoseRay for the export
 *
 * Variations: with a perturbed camera, with a light that looks like the dolphin
 */

//--------------------------------------------------------------------------
#declare with_normal_camera=0;
#declare with_light_object=0;
#declare with_material=0;

global_settings {
	assumed_gamma 1.1
}
background {color srgb<3,38,66>/255}
#default{
	finish{ambient 0.1 diffuse 0.9 }
}

//--------------------------------------------------------------------------
#include "colors.inc"
#include "tut_dolphin_20130410_POV_geom.inc" //Geometry

//--------------------------------------------------------------------------
// camera ------------------------------------------------------------------
camera{
	location <0,1,-3>
	angle 75
	right x*image_width/image_height
	look_at <0, 1, 0>
	#if(with_normal_camera)
		normal {
			bozo 0.12 
			scale 0.00001
		}
	#end
}

// lights ------------------------------------------------------------------
// Visible moon texture
#declare t_moon_light=texture{
	pigment {
		agate
		color_map{
			[ 0 rgb<1,0.98,0.76>*.98]
			[.3 rgb<1,0.98,0.76>*.76]
			[.5 rgb<1,0.98,0.76>*.65]
			[.7 rgb<1,0.98,0.76>*.76]
			[ 1 rgb<1,0.98,0.76>*.98]
		}
		turbulence .61
		scale 2.3
	}
	normal {
		agate
		turbulence .61
		scale 2.3
	}
}

// Hollow moon material
#declare m_moon_light=material {
	texture{
		t_moon_light
	}
	interior {
		media {
			emission 1
			scattering{1,.01}
			intervals 10
			samples 1, 15
			confidence 0.9999
			variance 1/1000
			density {
				radial
				turbulence .35
				color_map{
					[ 0 rgb<1.0,1.0,0.0>]
					[.1 rgb<1.0,.50,0.0>]
					[.5 rgb<1.0,.75,.25>]
					[.7 rgb<0.7,.45,0.0>]
					[ 1 rgb<1.0,.65,0.0>]
				}
			}
		}
	}
}

#declare light_color=rgb <1,0.98,0.76>;
#declare light_pos=<-500, 400, 1400>;
light_source{ light_pos color light_color
	looks_like{
		sphere{ <0,0,0>, 100
			hollow
			material {
				m_moon_light
				scale 5
			}
		}
	}
}

// A sunny spotlight
light_source {
  0
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate light_pos-300*z // <x y z> position of light
  point_at light_pos      // direction of spotlight
  radius 80                // hotspot (inner, in degrees)
  tightness 60            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}

// For the dolphin
light_source {
  0
  #if(with_material)
    color srgb<0.4,0.6,0.9>       // light's color
  #else
    color srgb<0.95,0.95,1>       // light's color
  #end
  spotlight               // this kind of light source
  translate 1*z // <x y z> position of light
  point_at <-1,3,4>      // direction of spotlight
  radius 20                // hotspot (inner, in degrees)
  tightness 60            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 8               // intensity falloff radius (outer, in degrees)
}

//--------------------------------------------------------------------------

// Some random spheres
#declare t_sphere=texture{
	//pigment {color srgb<32,73,110>/255 transmit 0.8}
	pigment {color srgb<57,93,180>/255 transmit 0.8}
	finish {phong 0.5}
	normal {granite 0.1 scale 0.02}  
	
}

#declare r_sphere=0.3;
#declare v_from=<-5,-4,-2>;
#declare v_to=<5,4,6>;
#declare v_step=0.5;
#declare p_hole=0.2;
#declare m_st=r_sphere*1.6;

#declare ix=v_from.x;
#declare iy=v_from.y;
#declare iz=v_from.z;
#declare Rh=seed(123);
#declare Ri=seed(123);

#for(ix,v_from.x,v_to.x,v_step)
	#for(iy,v_from.y,v_to.y,v_step)
		#for(iz,v_from.z,v_to.z,v_step)
			#if(rand(Rh)<p_hole)
				sphere {<ix+rand(Ri)*m_st,iy+rand(Ri)*m_st,iz+rand(Ri)*m_st> r_sphere texture{t_sphere}}
			#end
		#end
	#end
#end

// An object
#if(with_light_object)
	light_source{ 0 color light_color
		looks_like{
			tut_dolphin_20130410_
			scale 0.3
			rotate <-20,-40,30>
			rotate -110*y
			rotate 30*x
			translate <-1,3,4>
		}
	}
#else
	object{
		#if(with_material)
	     	tut_dolphin_20130410_
	    #else
			union {
				object{tut_dolphin_20130410_Material_002_  texture{t_sphere}}
				object{tut_dolphin_20130410_Material_001_  texture{t_sphere}}
			}
			double_illuminate
	    #end
	    scale 0.3
	    rotate <-20,-40,30>
	    rotate -110*y
	    rotate 30*x
	    translate <-1,3,4>
	}
#end
