// +W300 +H100 +FE +KFI1 +KFF9999

#version 3.6;

global_settings {
  assumed_gamma 1.0
  ambient_light 1.0
  max_trace_level 15
}

camera {
  orthographic
  location <0,0,100>   // position & direction of view
  look_at  <0,0,0>
  right   -3*x         // horizontal size of view  \___ to be rendered at square size
  up      1*y          // vertical size of view    /
}



default {
  finish { ambient 1.0 diffuse 0.0 }
}

// ----------------------------------------

#local Delta        = 1/max(image_width/3,image_height);
#local Coupling1    = 1;
#local Coupling2    = 1;
#local Frequency    = 0.1;
#local Amplitude    = 0.5;

#local D            = 1/200;
#local DampingFactor= 1-0.1;

#local DampingFactorD = pow(DampingFactor,D);

//#local PgPlungerShape = pigment { planar rotate z*90 scale 0.01 color_map { [ 0.0 rgb 0 ] [ 0.00001 rgb 1 ] } }
#local PgPlungerShape = pigment { spherical scale Delta translate x*0.25 color_map { [ 0.0 rgb 0 ] [ 0.00001 rgb 1 ] } }

#local FRAME_TYPES  = 1;

#local FirstFrame   = (frame_number <= FRAME_TYPES);
#local FrameDigits  = int(log(final_frame)) + 1;
  
#local PlungerDisp = sin(2*pi*(frame_number/FRAME_TYPES)*D*Frequency) * Amplitude*0.5;

#local NumLayers = 9;

#if (frame_number = 1)
  #local PgPrevious = pigment { color rgb 0.5 }
#else
  #local PgPrevious = pigment { image_pattern { concat("Wavetank", str(frame_number-1,-FrameDigits,0)) once } translate -<0.5,0.5,0> scale <3,1,1> }
#end

#local TxLayout = texture { pigment { checker
  pigment { image_pattern { "WavetankLayout.png" } color_map { [0.7 color rgb 0.5 + PlungerDisp transmit 1] [0.9 color rgb 0.5 + PlungerDisp transmit 0] } }
  pigment { image_pattern { "WavetankLayout.png" } color_map { [0.1 color rgb 0.5               transmit 0] [0.3 color rgb 0.5               transmit 1] } rotate z*90 }
  translate <-0.5,-0.5,0>
}}

#local TxBase = texture { pigment { PgPrevious                                            } finish { ambient    NumLayers } }
#local Tx1    = texture { pigment { PgPrevious rotate -z*90 translate -y -x*Delta         } finish { ambient  D*NumLayers } }
#local Tx2    = texture { pigment { PgPrevious rotate -z*90 translate -y                  } finish { ambient -D*NumLayers } }
#local Tx3    = texture { pigment { PgPrevious rotate -z*90 translate  y -y*Delta         } finish { ambient  D*NumLayers } }
#local Tx4    = texture { pigment { PgPrevious rotate -z*90 translate  y                  } finish { ambient -D*NumLayers } }
#local Tx5    = texture { pigment { PgPrevious                   rotate z*90 translate -x } finish { ambient  D*NumLayers } }
#local Tx6    = texture { pigment { PgPrevious translate x*Delta rotate z*90 translate -x } finish { ambient -D*NumLayers } }
#local Tx7    = texture { pigment { PgPrevious                   rotate z*90 translate  x } finish { ambient  D*NumLayers } }
#local Tx8    = texture { pigment { PgPrevious translate y*Delta rotate z*90 translate  x } finish { ambient -D*NumLayers } }

#local TxOutput = texture {
  average
  texture_map {
    [1 TxBase ]
    [1 Tx1 ]
    [1 Tx2 ]
    [1 Tx3 ]
    [1 Tx4 ]
    [1 Tx5 ]
    [1 Tx6 ]
    [1 Tx7 ]
    [1 Tx8 ]
  }
}

#macro Project(ZOrder,Tex)
  box { <-1.5, -0.5, 0.0>, <1.5, 0.5, 0.0> texture { Tex } translate z*ZOrder }
#end

Project(0, TxOutput)
Project(1, TxLayout)
