#version 3.7;
#default {finish {ambient 0 emission 0 diffuse 0.6}}

#declare Debug = no;
#declare PQ = 3;

#if (PQ > 0)
  #declare UsePhotons = yes;
  #declare PhotonRun = yes; // change to "no" to reuse a map
#end

#switch (PQ)
  #case (0)
    #declare UsePhotons = no;
  #break
  #case (1)
    #declare S_val = 0.1;
    #declare M_val = 75;
    #declare T_val = 5;
		#declare C_val = 150000;
  #break
  #case (2)
    #declare S_val = 0.025;
    #declare M_val = 150;
    #declare T_val = 10;
		#declare C_val = 300000;
  #break
  #case (3)
    #declare S_val = 0.00625;
    #declare M_val = 300;
    #declare T_val = 64;
		#declare C_val = 3000000;
  #break
#end

global_settings {
	max_trace_level 255
	adc_bailout 0.00001
	noise_generator 3
	assumed_gamma 1.0
		#if(UsePhotons)
		photons {
			spacing S_val
			max_trace_level T_val
			#if (PhotonRun)
				save_file "Work.ph"
			#else
				load_file "Work.ph"
			#end
			}
	#end
	}

#declare CamPos = vaxis_rotate (<0,0,-10>, <1,0,0>, 36.5);
#declare LookAt = <0,0.5,0>;
#declare ZF = 1*z;

// -- Camera & Lighting
camera {
	perspective
	location CamPos
	rotate y*15
	angle 54
	look_at LookAt
	right  x*4/3
	direction ZF
	}

#declare Intensity = function (LD,FD,FP) {pow(1+(LD/FD),FP)};

// -- The Key Light
#declare LightPos = <0,0,-20>;
#declare LightDist = vlength(LightPos-<0,0,0>);
#declare FadeDist = 0.056;
#declare FadePower = 2;

#declare AreaLight = no;
#declare SpotLight = no;
#declare ParaLight = no;

#if (Debug)
	#debug concat ("\nKey:\nFade Distance: ", str(FadeDist,2,4))
	#debug concat ("\nLight Distance: ", str(LightDist,5,4)," \n")
	#debug concat ("Light Intensity: ", str(Intensity (LightDist, FadeDist, FadePower),6,4), "\n\n")
#end

#declare Key_Light =
light_source {
	#declare LightColor = srgb 1;
	0, LightColor *  (Intensity (LightDist, FadeDist, FadePower)/2)
	#if (Debug)
		looks_like {sphere {0,0.25 pigment { srgb 1 } } finish {emission srgb 1}}
	#end
	#if (ParaLight)
		parallel
	#end
	#if (SpotLight)
		spotlight
	#end
	#if (AreaLight)
		area_light x*1.5, z*1.5 10,10 adaptive 0 jitter orient circular
		area_illumination on
	#end
	fade_distance FadeDist
	fade_power FadePower
	media_interaction off
	media_attenuation off
	translate LightPos
	#if (ParaLight)
		point_at <0,0,0>
	#end
	#if (SpotLight)
		point_at <0,0,0>
		radius 45
		falloff 90
		tightness 75
	#end
	#if (UsePhotons)
		photons { reflection on refraction on }
	#end
	}

#declare Gem =
difference {
	merge {
		cone { <0,0,0>, 3, <0,-4,0>, 0 }
		cone { <0,0,0>, 3, <0,2,0>, 0  }
		}
	box { <-2,0,-2>, <2,2,2> translate y*1 }
	#local ndx = 0;
	#while ( ndx < 360 )
		box { <-2,-2,-2>, <0,2,2> rotate z*-55 translate x*-2.75 rotate y*ndx }
		box { <-2,-5,-2>, <0,2,2> rotate z*35 translate x*-2.75 rotate y*ndx }
		#local ndx = ndx + 45;
	#end
	hollow on
	material{
		texture{
			pigment{
				srgbf <0.4980, 0.2902, 0.4235,1>
				}
			normal { granite 1e-3 scale 1e-3 }                               
			finish{
				specular 0.7
				roughness 0.001
				diffuse 0
				reflection{
					srgb <0.4980, 0.2902, 0.4235>*0.25, srgb <0.4980, 0.2902, 0.4235>*0.85 fresnel on
					}
				}
			}
		interior {
			ior 1.544
			fade_distance 2
			fade_power 1001
			fade_color <0.4980, 0.2902, 0.4235>
			/*#if (UsePhotons)
				dispersion 1.05
				dispersion_samples 50
			#end*/
			}
		}
	}

object { Key_Light rotate x*30 rotate y*250 }
plane { y,0 pigment { srgb 1 }}

object { Gem 
	scale 0.25 translate y*0.975
	#if (UsePhotons)
		photons { target reflection on refraction on collect on }
	#end
	}
