/*

  Occlusion Baking Demo
  
  + Using baked maps back into a regular scene
  
  --
  Jaime Vives Piqueres, Jul. 2012  <jaime@ignorancia.org>
  
*/
#version 3.7;

// standard includes
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"
#include "woods.inc"

// quick rad settings
#include "rad_def.inc"
global_settings{
  radiosity{Rad_Settings(Radiosity_IndoorLQ, off, off)}
}
#default{texture{finish{ambient 0 diffuse 1}}}

// demo control
#declare use_area=1;
#declare use_fblur=0;

// define first a macro to mix the base texture and the occluding one
#macro m_map_mix(occlusion_map, t_base, t_occlusion, i_base, mix_poly, transition)

material{
  texture{
    uv_mapping
    pigment_pattern{
      image_map{png occlusion_map interpolate 2}
    }
    poly_wave mix_poly
    texture_map{
      [.5-transition*.5 t_occlusion]
      [.5+transition*.5 t_base]
    }
  }  
  interior{i_base}
}

#end // macro

// some generic textures for tests
#include "demo-textures.inc"

// create the material for this test
#declare occlusion_map="dragon_occlusion_map_blur"
#declare m_final=
//m_map_mix(occlusion_map,t_copper,t_copper_corrosion,i_copper,1,1)
//m_map_mix(occlusion_map,t_bronze,t_bronze_patina,i_bronze,1,1)
m_map_mix(occlusion_map,t_iron,t_iron_corrosion,i_iron,.5,1)
//m_map_mix(occlusion_map,t_lead,t_lead_corrosion,i_lead,.33,1)
//m_map_mix(occlusion_map,t_ceramic,t_ceramic_dirt,i_ceramic,1,1)
//m_map_mix(occlusion_map,t_marble,t_marble_dirt,i_marble,.5,1)
//m_map_mix(occlusion_map,t_worn_paint_rust,t_worn_paint,i_worn_paint,3,.33)

// test object textured
#include "dragon_POV_geom.inc"
object{dragon scale .17
  material{m_final} 
  rotate 80*y
  hollow
}

// some scenery
plane{y,0
  pigment{White}
}
box{-.5,.5 scale <100,10,1>
  pigment{White}
  rotate -45*y
  translate <0,0,10>
}
sphere{
  0,250
  pigment{
    image_map{jpeg "sm_jvp_office" interpolate 2 map_type 1}
  }
  finish{emission 1 diffuse 0}
}

// simple test light
light_source{
  <60,100,40>
  White*4000
  #if (use_area)
  area_light 9*x,9*z,4,4 jitter adaptive 1 orient circular
  #end
  fade_distance 1
  fade_power 2
}

// camera
#declare c_location=<6.5,1.5,-1>;   
#declare c_look_at=<0.6,0.9,-.2>; 
#declare c_angle=29;
camera{
  perspective
  location c_location
  up 1*y right (image_width/image_height)*x
  angle c_angle
  look_at c_look_at
  #if (use_fblur)
    aperture 1/8 blur_samples 7*use_fblur focal_point c_look_at
  #end
}


