/*

  Occlusion Baking Demo
  
  + Bake occlusion map for a given mesh using the new mesh_camera feature
  
  Recommended command-line arguments: +FN +UA 

  --
  Jaime Vives Piqueres, Jul. 2012  <jaime@ignorancia.org>
  
*/
#version 3.7;

// standard includes
#include "colors.inc"

// object to be baked (needs to be UV mapped), textured on plain white
#include "dragon_POV_geom.inc"
object{dragon
  material{
    texture{
      pigment{White} 
      finish{
        ambient 0 
        diffuse 1
      }
    }
  }
}

// mesh camera used to bake the AO map
camera{
  mesh_camera{ 1 3 // distribution 3 is what we want here
    mesh{dragon} // use the same mesh as camera (with the same transformations, if any)
  }
  // usually the normals on the mesh point outside, so we reverse the location and direction to look at the faces
  location <0,0,.01>
  direction <0,0,-1>
}

// box-like lighting to simulate the AO (it could have been done more elegantly, but I'm lazy...)
#declare occlusion_distance=1000;
#declare occlusion_area_size=10e5;
#declare occlusion_brightness=4;
#declare occlusion_samples=4;
light_source{
occlusion_distance*x,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
-occlusion_distance*x,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
occlusion_distance*y,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
-occlusion_distance*y,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
occlusion_distance*z,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
-occlusion_distance*z,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<occlusion_distance,0,occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<-occlusion_distance,0,occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<occlusion_distance,0,-occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<-occlusion_distance,0,-occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<occlusion_distance,occlusion_distance,occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<-occlusion_distance,occlusion_distance,occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<occlusion_distance,occlusion_distance,-occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<-occlusion_distance,occlusion_distance,-occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<occlusion_distance,-occlusion_distance,occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<-occlusion_distance,-occlusion_distance,occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<occlusion_distance,-occlusion_distance,-occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
light_source{
<-occlusion_distance,-occlusion_distance,-occlusion_distance>,White/occlusion_brightness
area_light occlusion_area_size*x,occlusion_area_size*z,occlusion_samples,occlusion_samples jitter adaptive 1 orient circular
}
