//------ Tea Cup with Fork ...9/29/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "world7.inc"
#include "cup.inc"
#include "tile.inc"
#include "fork.inc"

camera {
  location <0, 240, -500>
  direction z*4
  up y
  right x*image_width/image_height
  look_at y*30
}

light_source { < 400,  270,  -660 > color White }
light_source { <-400, 1270, -1660 > color Gold }

//---- Players
object { Cup rotate y*-40 translate y*2 }
object { Fork rotate z*7.5 scale 2.8 rotate y*-130 translate <-55, 2, -10> }
object { World7 scale 1 }

//--- Grout
plane { y, 0
  pigment { color White }
  finish { ambient 0.2 }
}

//----Ceiling
plane { y, 3000
  pigment { color White }
  finish { ambient 0.2 }
}

//----Reflection Wall
plane { z, -4000
  pigment { color Copper }
  finish { ambient 0.2 }
}

//----Reflection Wall
plane { x, 4000
  pigment { color Blue }
  finish { ambient 0.2 }
}