//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#include "t1.inc"

#declare Tex1 =
texture {
  pigment { color Wheat }
  finish { ambient 0.2 diffuse 0.6 phong 0.7 reflection { 0.15 } }
}
#declare Tex2 =
texture {
  pigment { color DarkGreen }
  finish { ambient 0.3 diffuse 0.5 phong 0.7 reflection { 0.2 } }
}

#declare Tex3 =
texture { gold2	}

#declare CupBodyTexture =
texture {
  material_map { gif "cupmap.gif" //interpolate 4 
    texture { pigment { color rgb 0 } }
    texture { Tex1 } //Wheat
    texture { Tex3 } //Gold
    texture { Tex2 } //DarkGreen
  }  
  scale <100, 82, 1>
}

//#declare CupBodyTexture =
//texture {
//  pigment { image_map { gif "cupmap.gif" map_type 1 } }
//}

#declare CupHandleTexture =
texture {
  pigment { color Gray }
  finish { phong 1 }
}

#declare TeaTexture =
texture {
  pigment { color IndianRed }
  finish { ambient 0.2 diffuse 0.3 phong 1 reflection { 0.2 } }
  normal { ripples 0.4 frequency 0.2 }
}

#declare Cup1 =
object {
  union {
    difference {
      intersection {
        quadric { <0.001040582726327, -0.000358393269031, 0.001040582726327>, 0, 0, -1 }
        plane { y, 45.721938176603565 }
        plane { y, -19.278061823396435 inverse }
      }
      intersection {
        quadric { <0.001040582726327, -0.000358393269031, 0.001040582726327>, 0, 0, -1 }
        plane { y, 45.721938176603565 }
        plane { y, -19.278061823396435 inverse }
        scale <0.97, 1.1, 0.97>
      }
      translate y*19.278061823396435
    }
    sphere { 0, 1 scale <33, 10, 33> }
    object { T1 translate y*65 }
    difference {
      sphere { 0, 1 scale <25, 11, 25> translate y*-12 }
      plane { y, -15 }
    }
  }
  bounded_by { box { -1, 1 scale <52, 58, 52> translate y*40 } }
  texture { CupBodyTexture translate y*-14 }
}

#declare Handle =
object {
  union {
    difference {
      quartic {
        <1, 0, 0, 0, 2, 0, 0, 2, 0, -428.500000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 412.500000, 0, 0, 0, 0, 1, 0, -428.500000, 0, 42539.062500>
        rotate x*90
      }
      plane { y, 0 rotate z*-120 inverse}
    }    
    difference {
      quartic {
        <1, 0, 0, 0, 2, 0, 0, 2, 0, -428.500000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 412.500000, 0, 0, 0, 0, 1, 0, -428.500000, 0, 42539.062500>
        rotate x*90
      }
      plane { y, 0 }
    }    
    difference { 
      quartic {
        <1, 0, 0, 0, 2, 0, 0, 2, 0, -3880, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 3864, 0, 0, 0, 0, 1, 0, -3880, 0, 3732624.000000>
        rotate x*90
        translate <-29.2500004, -50.662483, 0>
      }
      plane { y, 0 rotate z*-120 }
      plane { y, -47 } 
    }
  }
  texture { Tex1 }
  bounded_by { box { -1, 1 scale <20, 34, 5> translate y*-16 }  }
  scale <1, 1, 2>
  rotate z*3
}

#declare Inner =
object {
  quadric {
    <0.001040582726327, -0.000358393269031, 0.001040582726327>, 0, 0, -1
  }
  clipped_by {  
    plane { y, 45.721938176603565 }
    plane { y, -19.278061823396435 inverse }
  }
  translate y*19.278061823396435
  scale <0.93, 1, 0.93>
  texture { Tex1 }
}

#declare Java =
object {
  intersection {  
    quadric {
      <0.001040582726327, -0.000358393269031, 0.001040582726327>, 0, 0, -1
    }
    plane { y, 38.721938176603565 }
    plane { y, -19.278061823396435 inverse }
  }
  translate y*19.278061823396435
  scale <0.95, 1, 0.95>
  texture { TeaTexture }
}

#declare Cup =
union {
  object { Cup1 translate y*15 }
  object { Inner translate y*15 }
  object { Java translate y*15 }
  object { Handle translate <-50, 62, 0> }
  bounded_by { box { -1, 1 scale <67, 44, 67> translate <-7, 40, 0> } }
}