//
// SECHULL.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 20-Sep-92
// Updated: 22-Jan-93
//
// PoV-Ray object description for the secondary hull of the starship
// U.S.S. Enterprise NCC-1701-A
//
// shapes.inc and bigetext.inc must be included before this file
//
// This file creates following declarations to be externally used:
//
//     Secondary hull of the Enterprise:
//         composite { Secondary_hull }
//
//     Part between secondary hull and saucer section:
//         composite { Inter_connecting_dorsal }
//


//
// Parts of the secondary hull
//


declare Secondary_hull_front_shape = intersection
   {
   quadric
      {
      Ellipsoid

      scale <3 3 6.93109179>
      translate <0 0 -4>
      }

   plane { <0 0  1> 0 }
   plane { <0 0 -1> 4 }
   }


declare Secondary_hull_middle_quadric = quadric
   {
   Ellipsoid

   scale <3 3 12.8>
   translate <0 0 -4>
   }


declare Secondary_hull_middle_shape = intersection
   {
   quadric { Secondary_hull_middle_quadric }

   plane { <0 0  1> -4 }
   plane { <0 0 -1> 10.023529411764 }
   }


declare Secondary_hull_rear_shape = intersection
   {
   quadric
      {
      QCone_Z

      scale <1 1 8>
      translate <0 0 -31.2>
      }

   plane { <0 0 1> -10.023529411764 }
   plane { <0 0 -1> 16.8 }
   }


declare Secondary_hull_swellout_shape = intersection
   {
   quadric
      {
      Ellipsoid

      scale <0.85 0.85 5.5>
      translate <2.15 0 -4>
      }

   plane { <0 0  1> 0.3 }
   plane { <0 0 -1> 4   }
   }


declare Secondary_hull_front = object
   {
   intersection
      {
      union
         {
         intersection { Secondary_hull_front_shape }
         intersection { Secondary_hull_swellout_shape }
         intersection { Secondary_hull_swellout_shape rotate <0 0 -90> }
         intersection { Secondary_hull_swellout_shape rotate <0 0 180> }
         }

      difference
         {
         union
            {
            box { <-3  1   -3  > <3  1.15 -2.6> texture { Window_texture } }
            box { <-3  1   -2.5> <3  1.15 -2.1> texture { Window_texture } }
            box { <-3  1   -2  > <3  1.15 -1.6> texture { Window_texture } }

            box { <-3 -1.1 -2.5> <3 -0.95 -2.1> texture { Window_texture } }
            box { <-3 -1.1 -2  > <3 -0.95 -1.6> texture { Window_texture } }

            box { <-3 -2.2 -3.999><3 -1.8 -3.7> texture { Window_texture } }
            box { <-3 -2.2 -3.6> <3 -1.8  -3.3> texture { Window_texture } }
            box { <-3 -2.2 -3.2> <3 -1.8  -2.9> texture { Window_texture } }
            }

         box { <-1 -2.2 -3.999> <1 1.15 -1.6> texture { Window_texture } }

         inverse
         }

      box { <-0.15 2.66818 -1.1> <0.15 3 0> inverse rotate <0 0  45> }
      box { <-0.15 2.66818 -1.1> <0.15 3 0> inverse rotate <0 0  28> }
      box { <-0.15 2.66818 -1.1> <0.15 3 0> inverse rotate <0 0 -28> }
      box { <-0.15 2.66818 -1.1> <0.15 3 0> inverse rotate <0 0 -45> }
      }

   texture { Secondary_hull_left_texture }

   bounded_by { box { <-3 -3 -4> <3 3 0.3> } }
   }


declare Secondary_hull_middle = object
   {
   intersection
      {
      object { Secondary_hull_middle_shape }

      sphere { <-2.96 0.3 -6> 0.275 inverse }
      sphere { < 2.96 0.3 -6> 0.275 inverse }

      difference
         {
         union
            {
            box { <-3  1   -9.6> <3  1.15 -9.4> texture { Window_texture } }

            box { <-3  0.3 -9.4> <3  0.45 -9.2> texture { Window_texture } }
            box { <-3  0.3 -9  > <3  0.45 -8.6> texture { Window_texture } }
            box { <-3  0.3 -7.5> <3  0.45 -7.3> texture { Window_texture } }
            box { <-3  0.3 -7.2> <3  0.45 -7  > texture { Window_texture } }

            box { <-3 -1.1 -6.6> <3 -0.95 -6.4> texture { Window_texture } }
            box { <-3 -1.1 -6.2> <3 -0.95 -6  > texture { Window_texture } }

            box { <-3 -1.85 -6.8> <3 -1.7 -6.6> texture { Window_texture } }
            box { <-3 -1.85 -6.4> <3 -1.7 -6.2> texture { Window_texture } }

            box { <-3 -2.2 -5.2> <3 -1.8  -4.9> texture { Window_texture } }
            box { <-3 -2.2 -4.8> <3 -1.8  -4.5> texture { Window_texture } }
            box { <-3 -2.2 -4.4> <3 -1.8  -4.1> texture { Window_texture } }
            }

         box { <-1 -2.2 -9.6> <1 1.15 -4.1> texture { Window_texture } }

         inverse
         }

      box { <-0.15 2.9413   -7> <0.15 3 -5.4> inverse rotate <0 0  25> }
      box { <-0.15 2.9413   -7> <0.15 3 -5.4> inverse rotate <0 0 -25> }
      box { <-0.15 2.72627 -10> <0.15 3 -8.2> inverse rotate <0 0  13> }
      box { <-0.15 2.72627 -10> <0.15 3 -8.2> inverse rotate <0 0 -13> }
      }

   texture { Secondary_hull_left_texture }

   bounded_by { box { <-3 -3 -10.023529411764> <3 3 -4> } }
   }


declare Secondary_hull_rear = object
   {
   intersection
      {
      union
         {
         intersection { Secondary_hull_rear_shape }

         intersection
            {
            sphere { <0 0 -16.575> 1.8140079933672 texture { Back_texture } }
            plane { <0 1 0> 0 }
            }

         intersection
            {
            sphere { <0 0 -16.575> 1.8140079933672 }
            plane { <0 -1 0> 0 }
            }
         }

      quadric
         {
         Cylinder_X

         inverse
         scale <1 2.2 8>
         translate <0 -2.5 -20>
         }

      union
         {
         intersection
            {
            plane { <0  1 0> 1.7 }
            plane { <0 -1 0> 0   }

            plane
               {
               <0  0 1> 0

               rotate <-19.44003483 0 0>
               translate <0 0 -16.6>
               }
            }

         intersection
            {
            plane { <0  1 0>  1.54365564 }
            plane { <0 -1 0> -0.44365564 }

            plane
               {
               <0 0 1> 0

               rotate <-28.61045967 0 0>
               translate <0 0.44365564 -16.33663133>
               }
            }

         quadric { Cylinder_X scale <1 0.3 0.3> translate <0 0.3 -16.6> }
         quadric { Cylinder_X scale <1 0.3 0.3> translate <0 1.4 -17.2> }

         inverse
         }

      difference
         {
         union
            {
            box { <-3 1   -10.5> <3  1.15 -10.3> texture { Window_texture } }

            box { <-3 0.3 -11  > <3  0.45 -10.8> texture { Window_texture } }
            box { <-3 0.3 -10.3> <3  0.45 -10.1> texture { Window_texture } }

            box { <-3 -0.4 -12.3> <3 -0.25 -12.1> texture { Window_texture } }
            box { <-3 -0.4 -11.5> <3 -0.25 -11.3> texture { Window_texture } }
            box { <-3 -0.4 -10.7> <3 -0.25 -10.5> texture { Window_texture } }

            box { <-3 -1.8 -10.3> <3 -1.7  -10.1> texture { Window_texture } }
            }

         box { <-1 -1.8 -12.3> <1 1.15 -10.1> texture { Window_texture } }

         inverse
         }
      }

   texture { Secondary_hull_texture }

   bounded_by { box { <-2.7 -2.7 -18.4> <2.7 2.7 -10.023529411764> } }
   }


declare Secondary_hull_top = object
   {
   union
      {
      intersection
         {
         union
            {
            intersection { Secondary_hull_middle_shape }
            intersection { Secondary_hull_rear_shape }

            translate <0 0.05 0>
            }

         union
            {
            box { <-0.25 1.8 -16.575> <0.25 3.1 -7> }

            intersection
               {
               quadric { Cylinder_Y scale <0.25 1 0.25> translate <0 0 -16.575> }
               plane { <0 -1 0> -1.8 }
               }
            }
         }

      sphere { <0 1.85 -16.575> 0.1 texture { Light_texture } }
      }

   bounded_by
      {
      box
         {
         <-0.25 0 0> <0.25 0.45 10.2> 

         rotate <-7 0 0>
         translate <0 1.5 -16.95>
         }
      }
   }


declare Secondary_hull_bottom = object
   {
   intersection
      {
      union
         {
         quadric { QCone_Y }

         intersection
            {
            plane { < 1 0  0> 0 rotate <0 0 -45> }
            plane { <-1 0  0> 0 rotate <0 0  45> }
            plane { < 0 0 -1> 0 }
            }

         translate <0 -0.3 0>
         }

      plane { <0 0 1> 0 rotate <45 0 0> translate <0 0 0.4> }

      box { <-0.3 -0.1 -0.3> <0.3 0 0.4> }
      }

   bounded_by { sphere { <0 0 0.05> 0.6 } }

   translate <0 -0.46 -16.575>
   }


declare Stick = box
   {
   <0 0 -0.025> <0.025 2 0.025>

   texture { colour Detailgray }
   rotate <0 0 32.934>
   translate <1.6 0 0>
   }


declare Shuttle_bay_door = object
   {
   intersection
      {
      union
         {
         quadric
            {
            QCone_Y

            translate <0 1 0>
            scale <1.6 2.47 1.6>
            translate <0 0 -16.575>
            }

         intersection
            {
            plane
               {
               <1 1 0> 0

               translate <0 1 0>
               scale <1.6 2.47 1.6>
               }

            plane
               {
               <-1 1 0> 0

               translate <0 1 0>
               scale <1.6 2.47 1.6>
               }

            plane { <0 0 -1> 16.575 }
            }

         union
            {
            box { Stick }
            box { Stick rotate <0  15 0> }
            box { Stick rotate <0  30 0> }
            box { Stick rotate <0  45 0> }
            box { Stick rotate <0  60 0> }
            box { Stick rotate <0  75 0> }
            box { Stick rotate <0  90 0> }
            box { Stick rotate <0 105 0> }
            box { Stick rotate <0 120 0> }
            box { Stick rotate <0 135 0> }
            box { Stick rotate <0 150 0> }
            box { Stick rotate <0 165 0> }
            box { Stick rotate <0 180 0> }

            translate <0 0 -16.575>
            }
         }

      box { <-1.6 0 -18.3> <1.6 1.7 -16> }
      }

   bounded_by { box { <-1.6 0 -18.3> <1.6 1.7 -16> } }
   }


declare Nav_deflector = object
   {
   intersection
      {
      union
         {
         intersection
            {
            quadric { Ellipsoid scale <2.87 2.87 6.8> translate <0 0 -4> }
            plane { <0 0 1> 0.3 }
            }

         intersection
            {
            quadric { QCone_Z scale <2.1 2.1 11.4> translate <0 0 11.7> }
            plane { <0 0 1> 1.7 }
            }

         intersection
            {
            quadric { QCone_Z scale <2.1 2.1 8.87> translate <0 0 9.17> }
            plane { <0 0 1> 1.9 }
            }

         intersection
            {
            quadric { QCone_Z scale <2.1 2.1 7.25> translate <0 0 7.55> }
            plane { <0 0 1> 2.2 }
            }
         }

      quadric
         {
         Paraboloid_Z

         inverse
         scale <1.45 1.45 0.5>
         translate <0 0 1.7>

         texture { Nav_deflector_texture }
         }

      plane { <0 0 -1> 0 }
      }

   bounded_by { box { <-2.4 -2.4 0> <2.4 2.4 2.2> } }
   }


declare Thing_in_front_of_hull_swellout = object
   {
   union
      {
      intersection { Disk_Z scale <0.35 0.35 0.05> translate <0 -2.2 0.35> }

      intersection
         {
         union
            {
            box { <-0.35 0.02 0> < 0.35 0.1 0.3> }
            box { < 0.25 0    0> < 0.35 0.1 0.3> }
            box { <-0.35 0    0> <-0.25 0.1 0.3> }

            rotate <-45 0 0>
            scale <1 2.1 11.4>
            translate <0 -2.2 0.3>
            }

         plane { <0 0 1> 1.7 }
         }

      sphere { <0 -2.2 0.4> 0.25 texture { colour Detailgray } }
      }

   bounded_by { sphere { <0 -2.175 1> 1 } }
   }


declare Secondary_hull_door = object
   {
   intersection
      {
      union
         {
         quadric
            {
            Secondary_hull_middle_quadric

            translate <-0.05 -0.3 6>
            texture { Door_texture }
            }

         quadric { Cylinder_X inverse scale <1 0.25 0.25> }
         }

      quadric
         {
         Secondary_hull_middle_quadric

         texture { colour Red }
         translate <0.001 -0.3 6>
         }

      quadric { Cylinder_X scale <1 0.3 0.3> }

      plane { <-1 0 0> -2.85 }
      }

   bounded_by { box { <2.85 -0.3 -0.3> <3 0.3 0.3> } }

   translate <0 0.3 -6>
   }


//
// There is a `Starship U.S.S. Enterprise - United Federation of Planets'-
// text on both sides of the secondary hull but there is only one texture
// map file used. That represents left side.
//
// Because we don't want the text to be mirrored on the right side, we have
// to do a little trick:
// 
// This object covers the text on the right side. Object has the same
// texture so transformed that the text will be `unmirrored' correctly on the
// right position. Object does not extend on the stripes and the Starfleet
// logo in the texture.
//

declare Secondary_hull_text_fix = object
   {
   intersection
      {
      union
         {
         intersection { Secondary_hull_front_shape }
         intersection { Secondary_hull_middle_shape }
         intersection { Secondary_hull_swellout_shape }

         translate <0.0001 0 0>
         }

      box { <2.5 -0.1625 -5.9> <3.1 -0.075 -0.8> }
      }

   texture { Secondary_hull_right_texture  }

   bounded_by { box { <2.5 -0.1625 -5.9> <3.1 -0.075 -0.8> } }
   }



//
// Parts of the inter connecting dorsal
//


declare Dorsal_edge_shape = intersection
   {
   union
      {
      quadric
         {
         Cylinder_Y

         scale <0.3 1 1.8>
         translate <0.4 0 -1.8>
         }

      quadric
         {
         Cylinder_Y

         scale <0.3 1 1.8>
         translate <-0.4 0 -1.8>
         }

      intersection
         {
         plane { <-1 0 0> 0.4 }
         plane { < 1 0 0> 0.4 }
         }

      plane { <0 0 1> -1.8 }
      }

   plane { <-1 0 0> 0.7 }
   plane { < 1 0 0> 0.7 }
   plane { < 0 0 1> 0   }
   }


declare Dorsal_top = object
   {
   intersection
      {
      intersection
         {
         Dorsal_edge_shape

         scale <1 1 -1>
         rotate <50.47736873 0 0>
         translate <0 3 -7>
         }

      union
         {
         intersection
            {
            Dorsal_edge_shape

            rotate <60.70863783 0 0>
            translate <0 4 0.9>
            }

         intersection
            {
            Dorsal_edge_shape

            rotate <9.5 0 0>
            translate <0 3.5 0.65>
            }
         }

      plane { <0  1 0>  7    }
      plane { <0 -1 0> -3.45 }

      union
         {
         plane { <0 -1  0> 0 }
         plane { <0  0 -1> 0 }

         rotate <-8 0 0>
         translate <0 4 -5>
         }

      difference
         {
         union
            {
            box { <-1 6.05 -0.5> <1 6.2 -0.3> texture { Window_texture } }
            box { <-1 6.05  2.5> <1 6.2  2.7> texture { Window_texture } }

            box { <-1 5.45 -0.5> <1 5.6 -0.3> texture { Window_texture } }
            box { <-1 5.45  1.8> <1 5.6  2  > texture { Window_texture } }
            box { <-1 5.45  2.5> <1 5.6  2.7> texture { Window_texture } }

            box { <-1 4.85 -2.1> <1 5   -1.9> texture { Window_texture } }
            box { <-1 4.85 -1.2> <1 5   -1  > texture { Window_texture } }
            box { <-1 4.85 -0.5> <1 5   -0.3> texture { Window_texture } }
            box { <-1 4.85  1.1> <1 5    1.3> texture { Window_texture } }

            box { <-1 4.25 -2.8> <1 4.4 -2.6> texture { Window_texture } }
            box { <-1 4.25 -1.2> <1 4.4 -1  > texture { Window_texture } }
            box { <-1 4.25 -0.5> <1 4.4 -0.3> texture { Window_texture } }
            }

         box
            {
            <-0.4 -3 -2.5> <0.4 3.1 0>

            rotate <60.71 0 0>
            translate <0 4 0.5>
            texture { Window_texture }
            }

         inverse
         }
      }

   bounded_by { box { <-0.7 3.3 -6.5> <0.7 7 5.5> } }

   texture { Dorsal_texture }
   }


declare Dorsal_rear_bottom = object
   {
   intersection
      {
      intersection
         {
         Dorsal_edge_shape

         scale <1 1 -1>
         rotate <50.47736873 0 0>
         translate <0 3 -6.95>
         }

      box { <-0.7 3.4 -6.5> <0.7 4 -5> }
      }

   texture
      {
      gradient <0 1 0>

      color_map
         {
         [0   0.5 colour Detailgray colour Detailgray]
         [0.5 1   colour Black      colour Black     ]
         }

      scale <1 0.09 1>
      rotate <-8 0 0>
      }

   bounded_by { box { <-0.7 3.4 -6.5> <0.7 4 -5> } }
   }


declare Dorsal_rear_top = object
   {
   intersection
      {
      quadric
         {
         Cylinder_Y

         scale <0.75 1 1.8>
         translate <0 0 -1.8>
         }
      
      sphere { <0 -5.7 1.7> 12.5 inverse }

      plane { <0 -7 -12> 0 translate <0 5.8 -2.6> }

      plane { <0 0 1> -1.8 }
      plane { <0 1 0>  7   }
      }

   bounded_by { box { <-0.75 5.7 -3.4> <0.75 7 -1.8> } }
   }


declare Dorsal_base_wall = quadric
   {
   Cylinder_Y

   scale <11.1595 1 12.64743559>
   translate <-9.9595 0 0>
   rotate <50.47736873 0 0>
   }


declare Dorsal_base = object
   {
   union
      {
      intersection
         {
         quadric { Dorsal_base_wall }
         quadric { Dorsal_base_wall scale <-1 1 1> }

         union
            {
            intersection
               {
               quadric
                  {
                  Cylinder_X

                  inverse
                  scale <1 2.5 2.5>
                  translate <0 -4.77 -2.5>
                  }

               plane { <0 1  0> -4.77    }
               plane { <0 0 -1>  0.45 }
               }

            plane { <0 0 -1> 0 }

            translate <0 0 -4.45468068>
            rotate <50.47736873 0 0>
            }

         union
            {
            quadric { Cylinder_X scale <1 5 5> }
            plane { <0 0 1> 0 }

            rotate <0 55 0>
            translate <0 -4.3 -1.5>
            }

         union
            {
            quadric { Cylinder_X scale <1 5 5> }
            plane { <0 0 1> 0 }

            rotate <0 -55 0>
            translate <0 -4.3 -1.5>
            }

         union
            {
            quadric { Cylinder_X scale <1 17.5 17.5> }
            plane { <0 0 -1> 0 }

            translate <0 -16.8 -3.25>
            }

         plane { <0 1 0> 0.7 }

         union
            {
            plane { <0 -1 0> 0 }

            intersection
               {
               quadric
                  {
                  Cylinder_X

                  inverse
                  scale <1 0.4 0.4>
                  translate <0 -0.4 -1.3>
                  }

               plane { <0 0 1> -1.3 }
               }
         
            rotate <0 0 10>
            translate <0 -0.29 0>
            }

         union
            {
            plane { <0 -1 0> 0 }

            intersection
               {
               quadric
                  {
                  Cylinder_X

                  inverse
                  scale <1 0.4 0.4>
                  translate <0 -0.4 -1.3>
                  }

               plane { <0 0 1> -1.3 }
               }
         
            rotate <0 0 -10>
            translate <0 -0.29 0>
            }

         plane { <0 -1 0> 0.5 }

         intersection
            {
            plane { <0 0 1> 0 rotate <0  20 0> }
            plane { <0 0 1> 0 rotate <0 -20 0> }

            rotate <9.5 0 0>

            translate <0 0.5 0.9>
            }

         intersection
            {
            quadric
               {
               Cylinder_X

               scale <1 5 5>
               rotate <0 55 0>
               translate <0 -4.35 -1.5>
               }

            quadric
               {
               Cylinder_X

               scale <1 5 5>
               rotate <0 -55 0>
               translate <0 -4.35 -1.5>
               }

            plane { <-1 0 0> 1.14 }
            plane { < 1 0 0> 1.14 }
            plane { <0 -1 0> 0 rotate <0 0  10> translate <0 -0.24 0> }
            plane { <0 -1 0> 0 rotate <0 0 -10> translate <0 -0.24 0> }

            union
               {
               union
                  {
                  plane { <0 0 -1> 0 texture { colour Black } }

                  box
                     {
                     <0.35 -0.5 -0.01> <0.75 -0.3 0.01>

                     texture { Window_texture colour Red }
                     }

                  rotate <0 20 0>
                  }

               union
                  {
                  plane { <0 0 -1> 0 texture { colour Black } }

                  box
                     {
                     <-0.75 -0.5 -0.01> <-0.35 -0.3 0.01>

                     texture { Window_texture colour Red }
                     }

                  rotate <0 -20 0>
                  }

               rotate <9.5 0 0>

               translate <0 0.5 0.8>
               }

            inverse
            }

         sphere { <-1.0965353 0.2 -2.7> 0.28 inverse }
         sphere { < 1.0965353 0.2 -2.7> 0.28 inverse }

         box
            {
            <-1.5 0.15 -4.6> <1.5 0.3 -4.4>

            inverse
            texture { Window_texture }
            }

         box
            {
            <-1.5 0.15 -3.9> <1.5 0.3 -3.7>

            inverse
            texture { Window_texture }
            }

         box
            {
            <-1.5 0.15 -1.7> <1.5 0.3 -1.5>

            inverse
            texture { Window_texture }
            }
         }

      box { <-0.1 0.15 -4.6> <0.1 0.3 -1.5> texture { Window_texture } }
      }

   bounded_by { box { <-1.2 -0.5 -8.5> <1.2 0.7 1> } }

   translate <0 3 0>
   }


declare Dorsal_bottom = object
   {
   box { <-0.3 2 -2.5> <0.3 2.77 0.6> }
   }


declare Dorsal_door = object
   {
   intersection
      {
      union
         {
         quadric
            {
            Dorsal_base_wall

            translate <-0.05 -0.2 2.7>
            texture { Door_texture }
            }

         quadric { Cylinder_X inverse scale <1 0.25 0.25> }
         }

      quadric
         {
         Dorsal_base_wall

         texture { colour Red }
         translate <0.001 -0.2 2.7>
         }

      quadric { Cylinder_X scale <1 0.3 0.3> }

      plane { <-1 0 0> -1 }
      }

   bounded_by { box { <1 -0.3 -0.3> <1.2 0.3 0.3> } }

   translate <0 3.2 -2.7>
   }



//
// And finally - get them together
//


declare Secondary_hull = composite
   {
   object { Secondary_hull_top }

   object { Nav_deflector }

   object { Thing_in_front_of_hull_swellout }
   object { Thing_in_front_of_hull_swellout rotate <0 0  90> }
   object { Thing_in_front_of_hull_swellout rotate <0 0 -90> }

   object { Secondary_hull_front }
   object { Secondary_hull_middle }
   object { Secondary_hull_rear }

   object { Shuttle_bay_door }

   object { Secondary_hull_bottom }

   object { Secondary_hull_text_fix }

   object { Secondary_hull_door }
   object { Secondary_hull_door scale <-1 1 1> }

   bounded_by { box { <-3 -3 -18.4> <3 3 2.2> } }

   translate <0 -3.8 4.45>
   }


declare Inter_connecting_dorsal = composite
   {
   object { Dorsal_rear_top }
   object { Dorsal_top }
   object { Dorsal_rear_bottom }
   object { Dorsal_base }
   object { Dorsal_bottom }

   object { Dorsal_door }
   object { Dorsal_door scale <-1 1 1> }

   bounded_by { box { <-1.2 2 -8.5> <1.2 7 5> } }

   translate <0 -3.8 4.45>
   }
