//
// QUICK_E.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 20-Jan-93
// Updated: 22-Jan-93
//
// Quick replacement object descscription for the starship U.S.S.
// Enterprise NCC-1701-A
//
// This file creates following declaration to be externally used:
//
//     Starship U.S.S. Enterprise:
//         composite { NCC_1701_A }
//
// Enterprise is heading to positive z and it's centered around origin,
// its dimensions are:
//
//     x: +/-  71.24
//     y: +/-  35.36
//     z: +/- 150.02
//
// Scale is so selected that one unit equals to one meter.
//
// This file is meant to be used as replacement for `big_e.inc' when
// very quick rendering for testing purposes is wanted. The object declared
// here is very rough approximation of the one in `big_e.inc'.
//

include "shapes.inc"
include "colors.inc"

default
   {
   texture
      {
      color red 0.95 green 0.95 blue 1
      specular 0.6
      roughness 0.005
      ambient 0.1
      diffuse 0.9
      }
   }


declare Saucer = object
   {
   union
      {
      quadric
         {
         Ellipsoid

         scale <13.7 2 13.7>
         translate <0 -0.5 0>
         }

      sphere { <0 -0.2 0> 3.1 }
      }

   translate <0 3.7 15.15>
   }


declare Secondary_hull = object
   {
   intersection
      {
      quadric
         {
         Ellipsoid

         scale <3 3 13.5>
         translate <0 0 -5>
         }

      plane { <0 0 1> 2 }
      }

   translate <0 -3.8 4.45>
   }


declare Inter_connecting_dorsal = object
   {
   intersection
      {
      box { <-0.7 -2 -8> <0.7 7 6> }
      plane { <0 -1  1> 0 translate <0 2    0> }
      plane { <0  1 -1> 0 translate <0 4.5 -5> }
      }

   translate <0 -3.8 4.45>
   }

declare Nacelle_pylon = object
   {
   intersection
      {
      box { <-0.3 -1 -4.36> <0.3 14.5 0> rotate <-37.69424047 0 0> }
      plane { <0 1 0> 8.8 }
      }
   }

declare Left_nacelle_pylon = composite
   {
   object { Nacelle_pylon }

   translate <0 2 0>
   rotate <0 0 56.30993247>
   translate <0 -2.6 -4.05>
   }


declare Right_nacelle_pylon = composite
   {
   composite { Left_nacelle_pylon }

   scale <-1 1 1>
   }


declare Left_warp_nacelle = object
   {
   box { <-1 -0.1 -28.4> <1 2.6 0> }

   translate <-9 3.4 -0.55>
   }


declare Right_warp_nacelle = object
   {
   box { <-1 -0.1 -28.4> <1 2.6 0> }

   translate <9 3.4 -0.55>
   }

declare NCC_1701_A = composite
   {
   object { Saucer }
   object { Inter_connecting_dorsal }
   object { Secondary_hull }
   object { Left_warp_nacelle }
   object { Right_warp_nacelle }
   composite { Left_nacelle_pylon }
   composite { Right_nacelle_pylon }

   scale <5.2 5.2 5.2>

   bounded_by { box { <-71.24 -35.36 -150.02> <71.24 35.36 150.02> } }
   bounded_by { sphere { <0 0 0> 170 } }
   }

