//
// BIGETEXT.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 15-Sep-92
// Updated: 18-Mar-93
//
// PoV-Ray texture descscriptions for the starship U.S.S. Enterprise
// NCC-1701-A
//
// This file creates following declarations to be externally used:
//
//     Colour for the hull:
//         colour Hullcol
//
//     Colour for the stripes on the hull:
//         colour Stripegray
//
//     Colour for the hull details:
//         colour Detailgray
//
//     Texture for windows:
//         texture { Window_texture }
//
//     Texture for navigation lights:
//         texture { Light_texture }
//
//     Texture for the back of the impulse engine:
//         texture { Impulse_engine_texture }
//
//     Texture for the navigational deflector:
//         texture { Nav_deflector_texture }
//
//     Texture for the top surface of the saucer section:
//         texture { Saucer_top_texture }
//
//     Texture for the bottom surface of the saucer section:
//         texture { Saucer_edge_texture }
//
//     Texture for the edge of the saucer section:
//         texture { Saucer_bottom_texture }
//
//     Texture for docking ports at sides of the secondary hull:
//         texture { Door_texture }
//
//     Texture for secondary hull:
//         texture { Secondary_hull_texture }
//
//     Texture for the back of the secondary hull:
//         texture { Back_texture }
//
//     Texture for the blue things on the sides of the warp nacelles
//         texture { Nacelle_interior_texture }
//
//     Text on the sides of the warp nacelles
//         texture { NCC_1701_A_texture }


include "colors.inc"

// NOTE!
//
// I have written a modification to lighting.c module of the POV-Ray 1.0 to
// speed up the rendering of the heavily layered textures.  This fix speeds
// up the rendering of the Enterprise scene by factor of three (about) but
// it behaves a bit differently:
//
// The original code sums the scalar properties (specular for example) of
// each layer so that 2 transparent layers with specular 1 will result a
// texture with specular 2, so we have to put the specular value only to the
// topmost layer and set zeroes to the specular values of all the other
// layers.
//
// The POV-Ray with my patch installed will use the weighted average of the
// values as the final value so that if I have a layer with 30% transparency
// on non-transparent layer, then 70% of the specular value will be taken
// from the top layer and 30% from the bottom layer.  If I want a constant
// specular value for the texture, I just put the same specular value for
// each layer.
//
// If you are rendering this scene by unmodified POV-Ray 1.0, then you have
// to use this line to get the zero speculars for all but the topmost layer
// in the layered textures. If it's commented out, then uncomment it and
// comment out the other declaration below:

declare layer_specular = 0

// If you are using my patch, then tou have to use this value to get the same
// specular value for all the layers. If it's commented out, then uncomment
// it and comment out the one above:

//declare layer_specular = 0.6


//
// Colours for the hull of the starship
//

declare Hullcol    = color red 0.95 green 0.95 blue 1
declare Stripegray = color Gray80
declare Detailgray = color Gray60


//
// Default texture - will be used in the hull of the starship and as the base
// for all the other textures
//

default
   {
   texture
      {
      color Hullcol
      specular 0.6
      roughness 0.005
      ambient 0.1
      diffuse 0.9
      }
   }



//
// Luminous textures
//


declare Window_texture = texture
   {
   ambient 0.8
   diffuse 0
   color LightBlue
   }


declare Light_texture = texture
   {
   ambient 1
   diffuse 0
   color White
   }


declare Impulse_engine_texture = texture
   {
   wood
   turbulence 0
   color_map { [ 0 1 color Yellow color Red ] }
   ambient 1
   diffuse 0
   scale <1.6 1.6 1.6>
   }


declare Nav_deflector_texture = texture
   {
   wood
   turbulence 0
   color_map { [ 0 1 color White color SlateBlue ] }
   ambient 0.8
   diffuse 0.2
   scale <3 3 1>
   }


//
// If you want to render Enterprise with lights off, you can redefine all the
// luminous textures by uncommenting the next four textures. You also have to
// comment out `object { Saucer_number_lights }'-line from the definition of
// the `composite { Saucer }' in the file `saucer.inc'.
//

/*

declare Window_texture = texture
   {
   ambient 0
   diffuse 0
   reflection 0.3
   color LightBlue
   }


declare Light_texture = texture
   {
   diffuse 0.3
   refraction 0.6
   color White
   }


declare Impulse_engine_texture = texture
   {
   ambient 0
   diffuse 0
   color Black
   }


declare Nav_deflector_texture = texture
   {
   color DarkGreen
   }

*/



//
// Textures for saucer.inc
//


declare Gridgray = color Detailgray


declare Line = texture
   {
   gradient <0 0 1>

   color_map
      {
      [0      0.0005 color Gridgray color Gridgray]
      [0.0005 1      color Clear    color Clear   ]
      }

   scale <1 1 25>
   }


declare Saucer_top_texture = texture
   {
   Line

   color_map
      {
      [0      0.0005 color Gridgray color Gridgray]
      [0.0005 1      color Hullcol  color Hullcol ]
      }

   specular layer_specular
   }

texture { Line specular layer_specular rotate <0 -67.5 0> }
texture { Line specular layer_specular rotate <0 -45   0> }
texture { Line specular layer_specular rotate <0 -22.5 0> }
texture { Line specular layer_specular rotate <0  22.5 0> }
texture { Line specular layer_specular rotate <0  45   0> }
texture { Line specular layer_specular rotate <0  67.5 0> }
texture { Line specular layer_specular rotate <0  90   0> }

texture
   {
   wood

	specular layer_specular

   color_map
      {
      [0     0.167 color Hullcol  color Hullcol ]
      [0.167 0.168 color Gridgray color Gridgray]
      [0.168 0.229 color Clear    color Clear   ]
      [0.229 0.230 color Gridgray color Gridgray]
      [0.230 0.291 color Clear    color Clear   ]
      [0.291 0.292 color Gridgray color Gridgray]
      [0.292 0.353 color Clear    color Clear   ]
      [0.353 0.354 color Gridgray color Gridgray]
      [0.354 0.415 color Clear    color Clear   ]
      [0.415 0.416 color Gridgray color Gridgray]
      [0.416 0.477 color Clear    color Clear   ]
      [0.477 0.478 color Gridgray color Gridgray]
      [0.478 0.539 color Clear    color Clear   ]
      [0.539 0.540 color Gridgray color Gridgray]
      [0.540 1     color Hullcol  color Hullcol ]
      }

   turbulence 0
   rotate <90 0 0>
   scale <50 1 50>
   }

texture
   {
   image_map
      {
      <1 0 -1>
      iff "toprear.iff"
      once
      map_type 0
      interpolate Bi
      alpha 0 1
      }

   // Compensate the half pixel translation caused by interpolation
   translate <0.0015625 0 0.00357142>

	specular layer_specular

   scale <4 1 1.5>
   translate <-2 0 -6.5>
   }

texture
   {
   image_map
      {
      <1 0 -1>
      iff "topfront.iff"
      once
      map_type 0
      interpolate Bi
      alpha 0 1
      }

   // Compensate the half pixel translation caused by interpolation
   translate <0.00044642 0 0.00130208>

   scale <-14 1 -4.8>
   translate <7 0 8.8>
   }


declare Saucer_edge_texture = texture
   {
   gradient <0 1 0>

   colour_map
      {
      [0     0.075 color Hullcol    color Hullcol   ]
      [0.075 0.15  color Stripegray color Stripegray]
      [0.15  0.25  color Hullcol    color Hullcol   ]
      [0.25  0.325 color Stripegray color Stripegray]
      [0.325 0.425 color Hullcol    color Hullcol   ]
      [0.425 0.5   color Stripegray color Stripegray]
      [0.5   1     color Hullcol    color Hullcol   ]
      }

   scale <1 2 1>
   }


declare Saucer_bottom_texture = texture
   {
   Line

   color_map
      {
      [0      0.0005 color Gridgray color Gridgray]
      [0.0005 1      color Hullcol  color Hullcol ]
      }
   specular layer_specular
   }

texture { Line specular layer_specular rotate <0 -67.5 0> }
texture { Line specular layer_specular rotate <0 -45   0> }
texture { Line specular layer_specular rotate <0 -22.5 0> }
texture { Line specular layer_specular rotate <0  22.5 0> }
texture { Line specular layer_specular rotate <0  45   0> }
texture { Line specular layer_specular rotate <0  67.5 0> }
texture { Line specular layer_specular rotate <0  90   0> }

texture
   {
   wood

   color_map
      {
      [0     0.158 color Hullcol  color Hullcol ]
      [0.158 0.159 color Gridgray color Gridgray]
      [0.159 0.215 color Clear    color Clear   ]
      [0.215 0.216 color Gridgray color Gridgray]
      [0.216 0.272 color Clear    color Clear   ]
      [0.272 0.273 color Gridgray color Gridgray]
      [0.273 0.329 color Clear    color Clear   ]
      [0.329 0.330 color Gridgray color Gridgray]
      [0.330 0.386 color Clear    color Clear   ]
      [0.386 0.387 color Gridgray color Gridgray]
      [0.387 0.443 color Clear    color Clear   ]
      [0.443 0.444 color Gridgray color Gridgray]
      [0.444 0.5   color Clear    color Clear   ]
      [0.5   1     color Hullcol  color Hullcol ]
      }

   specular layer_specular

   turbulence 0
   rotate <90 0 0>
   scale <50 1 50>
   }

texture
   {
   image_map
      {
      <1 0 -1>
      iff "botfront.iff"
      once
      map_type 0
      interpolate Bi
      alpha 0 1
      }

   // Compensate the half pixel translation caused by interpolation
   translate <0.00082236 0 0.00367647>

   specular layer_specular

   scale <-7.6 1 1.7>
   translate <3.8 0 6>
   }

texture
   {
   image_map
      {
      <1 0 -1>
      iff "botrear.iff"
      once
      map_type 0
      interpolate Bi
      alpha 0 1
      }

   // Compensate the half pixel translation caused by interpolation
   translate <0.00147058 0 0.00666666>

   scale <3.4 1 -.75>
   translate <-1.7 0 -3.25>
   }



//
// Textures for sechull.inc
//


declare Edge = texture
   {
   gradient <0 1 0>

   color_map
      {
      [0     0.5   color Clear    color Clear    ]
      [0.5   1     color Gridgray color Gridgray ]
      }

   translate <0 -0.5 0>
   scale <1 25 1>
   }


declare Dorsal_texture = texture
   {
   gradient <0 1 0>

   color_map
      {
      [0   0.5 color Hullcol  color Hullcol  ]
      [0.5 1   color Gridgray color Gridgray ]
      }

   specular layer_specular

   translate <0 -0.5 0>
   scale <1 25 1>
   rotate <60.71 0 0>
   translate <0 5.8 3.85>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0   0.5 color Clear    color Clear    ]
      [0.5 1   color Gridgray color Gridgray ]
      }

   specular layer_specular

   translate <0 -0.5 0>
   scale <1 25 1>
   translate <0 5.8 0>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0     0.501 color Clear   color Clear   ]
      [0.501 1     color Hullcol color Hullcol ]
      }

   specular layer_specular

   translate <0 -0.5 0>
   scale <1 25 1>
   rotate <60.71 0 0>
   translate <0 5.8 3.85>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0     0.501 color Clear   color Clear   ]
      [0.501 1     color Hullcol color Hullcol ]
      }

   specular layer_specular

   translate <0 -0.5 0>
   scale <1 25 1>
   translate <0 5.8 0>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0   0.5 color Clear    color Clear    ]
      [0.5 1   color Gridgray color Gridgray ]
      }

   specular layer_specular

   translate <0 -0.5 0>
   scale <1 25 1>
   rotate <60.71 0 0>
   translate <0 5.9 4>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0   0.5 color Clear    color Clear    ]
      [0.5 1   color Gridgray color Gridgray ]
      }

   specular layer_specular

   translate <0 -0.5 0>
   scale <1 25 1>
   translate <0 5.9 0>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0     0.501 color Clear   color Clear   ]
      [0.501 1     color Hullcol color Hullcol ]
      }

   specular layer_specular

   translate <0 -0.5 0>
   scale <1 25 1>
   rotate <60.71 0 0>
   translate <0 5.9 4>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0     0.48  color Hullcol color Hullcol ]
      [0.48  0.501 color Clear   color Clear   ]
      [0.501 1     color Hullcol color Hullcol ]
      }

   translate <0 -0.5 0>
   scale <1 25 1>
   translate <0 5.9 0>
   }


declare Door_texture = texture
   {
   gradient <0 0 1>

   color_map
      {
      [0    0.01 color Black color Black]
      [0.01 1    color Hullcol color Hullcol]
      }
   }


declare Secondary_hull_texture = texture
   {
   gradient <0 0 1>

   color_map
      {
      [0     0.128 color Hullcol  color Hullcol ]
      [0.128 0.129 color Gridgray color Gridgray]
      [0.129 0.215 color Hullcol  color Hullcol ]
      [0.215 0.216 color Gridgray color Gridgray]
      [0.216 0.302 color Hullcol  color Hullcol ]
      [0.302 0.303 color Gridgray color Gridgray]
      [0.303 0.389 color Hullcol  color Hullcol ]
      [0.389 0.390 color Gridgray color Gridgray]
      [0.390 0.476 color Hullcol  color Hullcol ]
      [0.476 0.477 color Gridgray color Gridgray]
      [0.477 0.620 color Hullcol  color Hullcol ]
      [0.620 0.621 color Gridgray color Gridgray]
      [0.621 1     color Hullcol  color Hullcol ]
      }

   specular layer_specular

   scale <1 1 25>
   }

texture
   {
   gradient <0 1 0>

   color_map
      {
      [0      0.0005 color Gridgray color Gridgray]
      [0.0005 1      color Clear    color Clear   ]
      }

   specular layer_specular

   scale <1 25 1>
   translate <0 0.2 0>
   }

texture
   {
   gradient <0 0 1>

   color_map
      {
      [0     0.201 color Gridgray color Gridgray]
      [0.201 1     color Clear    color Clear   ]
      }

   specular layer_specular

   scale <1 1 25>
   translate <0 0 -5>
   rotate <-34 0 0>
   translate <0 1.3 -16.6>
   }

texture
   {
   wood

   color_map
      {
      [0     0.199 color Clear    color Clear   ]
      [0.199 0.2   color Gridgray color Gridgray]
      [0.2   1     color Hullcol  color Hullcol ]
      }

   specular layer_specular

   turbulence 0
   rotate <0 90 0>
   scale <1 50 50>
   translate <0 -203.3 -4>
   }

texture
   {
   wood

   color_map
      {
      [0     0.268 color Hullcol  color Hullcol ]
      [0.268 0.399 color Clear    color Clear   ]
      [0.399 0.4   color Gridgray color Gridgray]
      [0.4   1     color Hullcol  color Hullcol ]
      }

   specular layer_specular

   turbulence 0
   rotate <0 90 0>
   scale <1 50 50>
   translate <0 58.4 -4>
   }

texture
   {
   gradient <0 0 1>

   color_map
      {
      [0   0.2 color Hullcol color Hullcol]
      [0.2 1   color Clear   color Clear  ]
      }

   specular layer_specular

   scale <1 1 25>
   translate <0 0 -5>
   rotate <-34 0 0>
   translate <0 1.3 -16.6>
   }

texture
   {
   gradient <0 0 1>

   color_map
      {
      [0     0.056 color Hullcol color Hullcol]
      [0.056 1     color Clear   color Clear  ]
      }

   specular layer_specular

   scale <1 1 25>
   }


declare Secondary_hull_stripe = texture
   {
   image_map
      {
      <0 -1 1>
      iff "sechull.iff"
      once
      map_type 0
      alpha 0 1
      interpolate Bi
      }

   // Compensate the half pixel translation caused by interpolation
   translate <0 0.01041666 0.00069444>

   scale <1 0.6 -9>
   translate <0 -0.4 0.1625>
   }


declare Secondary_hull_left_texture = texture
   {
   Secondary_hull_texture
   }

texture
   {
   Secondary_hull_stripe
   }


declare Secondary_hull_right_texture = texture
   {
   Secondary_hull_texture
   }

texture
   {
   Secondary_hull_stripe

   scale <1 1 -1>
   translate <0 0 -6.7>
   }


declare Back_texture = texture
   {
   color Hullcol
   specular layer_specular
   }

texture
   {
   image_map
      {
      <1 -1 0>
      iff "back.iff"
      once
      map_type 0
      interpolate Bi
      }

   // Compensate the half pixel translation caused by interpolation
   translate <0.0028409 0.03333333 0>

   scale <2 0.2 1>
   translate <-1 -0.25 0>
   }



//
// Textures for nacelles.inc
//


declare Nacelle_interior_texture = texture
   {
   gradient <0 1 0>

   specular 1
   roughness 0.01

   color_map
      {
      [0   0.5 color NewMidnightBlue color Black]
      [0.5 1   color Black color NewMidnightBlue]
      }

   scale <0.15 0.15 0.15>
   }


declare NCC_1701_A_texture = texture
   {
   color Hullcol
   specular layer_specular
   }

texture
   {
   image_map
      {
      <0 -1 1>
      iff "ncc1701a.iff"
      map_type 0
      once
      interpolate Bi
      alpha 0 1
      }

   scale <1 0.5 2.5>
   }

