//
// SECHULL.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 20-Sep-92
// Updated: 22-Jan-93
//
// PoV-Ray object description for the secondary hull of the starship
// U.S.S. Enterprise NCC-1701-A
//
// shapes.inc and bigetext.inc must be included before this file
//
// This file creates following declarations to be externally used:
//
//     Secondary hull of the Enterprise:
//         union { Secondary_hull }
//
//     Part between secondary hull and saucer section:
//         union { Inter_connecting_dorsal }
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//
// Parts of the secondary hull
//
#declare Secondary_hull_front_shape =
intersection {
  object { Ellipsoid scale <3, 3, 6.93109179> translate z*-4 }
  plane {  z, 0 }
  plane { -z, 4 }
}

#declare Secondary_hull_middle_quadric = quadric { Ellipsoid scale <3, 3, 12.8> translate z*-4 }

#declare Secondary_hull_middle_shape =
intersection {
  object { Secondary_hull_middle_quadric }
  plane {  z, -4 }
  plane { -z, 10.023529411764 }
}

#declare Secondary_hull_rear_shape =
intersection {
  object { QCone_Z scale <1, 1, 8> translate z*-31.2 }
  plane {  z, -10.023529411764 }
  plane { -z,  16.8 }
}

#declare Secondary_hull_swellout_shape =
intersection {
  object { Ellipsoid scale <0.85, 0.85, 5.5> translate <2.15, 0, -4> }
  plane {  z, 0.3 }
  plane { -z, 4 }
}

#declare Secondary_hull_front =
object {
  intersection {
    union {
      intersection { Secondary_hull_front_shape }
      intersection { Secondary_hull_swellout_shape }
      intersection { Secondary_hull_swellout_shape rotate z*-90 }
      intersection { Secondary_hull_swellout_shape rotate z*180 }
    }
    difference {
      union {
        box { <-3,  1,   -3>,     <3,  1.15, -2.6> texture { Window_texture } }
        box { <-3,  1,   -2.5>,   <3,  1.15, -2.1> texture { Window_texture } }
        box { <-3,  1,   -2>,     <3,  1.15, -1.6> texture { Window_texture } }
        box { <-3, -1.1, -2.5>,   <3, -0.95, -2.1> texture { Window_texture } }
        box { <-3, -1.1, -2>,     <3, -0.95, -1.6> texture { Window_texture } }
        box { <-3, -2.2, -3.999>, <3, -1.8,  -3.7> texture { Window_texture } }
        box { <-3, -2.2, -3.6>,   <3, -1.8,  -3.3> texture { Window_texture } }
        box { <-3, -2.2, -3.2>,   <3, -1.8,  -2.9> texture { Window_texture } }
      }
      box { <-1, -2.2, -3.999>, <1, 1.15, -1.6> texture { Window_texture } }
      inverse
    }
    box { <-0.15, 2.66818, -1.1>, <0.15, 3, 0> inverse rotate z*45 }
    box { <-0.15, 2.66818, -1.1>, <0.15, 3, 0> inverse rotate z*28 }
    box { <-0.15, 2.66818, -1.1>, <0.15, 3, 0> inverse rotate z*-28 }
    box { <-0.15, 2.66818, -1.1>, <0.15, 3, 0> inverse rotate z*-45 }
  }
  texture { Secondary_hull_left_texture }
  bounded_by { box { <-3, -3, -4>, <3, 3, 0.3> } }
}

#declare Secondary_hull_middle =
object {
  intersection {
    object { Secondary_hull_middle_shape }
    sphere { <-2.96, 0.3, -6>, 0.275 inverse }
    sphere { < 2.96, 0.3, -6>, 0.275 inverse }
    difference {
      union {
        box { <-3,  1,    -9.6>, <3,  1.15, -9.4> texture { Window_texture } }
        box { <-3,  0.3,  -9.4>, <3,  0.45, -9.2> texture { Window_texture } }
        box { <-3,  0.3,  -9  >, <3,  0.45, -8.6> texture { Window_texture } }
        box { <-3,  0.3,  -7.5>, <3,  0.45, -7.3> texture { Window_texture } }
        box { <-3,  0.3,  -7.2>, <3,  0.45, -7>   texture { Window_texture } }
        box { <-3, -1.1,  -6.6>, <3, -0.95, -6.4> texture { Window_texture } }
        box { <-3, -1.1,  -6.2>, <3, -0.95, -6>   texture { Window_texture } }
        box { <-3, -1.85, -6.8>, <3, -1.7,  -6.6> texture { Window_texture } }
        box { <-3, -1.85, -6.4>, <3, -1.7,  -6.2> texture { Window_texture } }
        box { <-3, -2.2,  -5.2>, <3, -1.8,  -4.9> texture { Window_texture } }
        box { <-3, -2.2, - 4.8>, <3, -1.8,  -4.5> texture { Window_texture } }
        box { <-3, -2.2,  -4.4>, <3, -1.8,  -4.1> texture { Window_texture } }
      }
      box { <-1, -2.2, -9.6>, <1, 1.15, -4.1> texture { Window_texture } }
      inverse
    }
    box { <-0.15, 2.9413,  -7>,  <0.15, 3, -5.4> inverse rotate z*25 }
    box { <-0.15, 2.9413,  -7>,  <0.15, 3, -5.4> inverse rotate z*-25 }
    box { <-0.15, 2.72627, -10>, <0.15, 3, -8.2> inverse rotate z*13 }
    box { <-0.15, 2.72627, -10>, <0.15, 3, -8.2> inverse rotate z*-13 }
  }
  texture { Secondary_hull_left_texture }
  bounded_by { box { <-3, -3, -10.023529411764>, <3, 3, -4> } }
}

#declare Secondary_hull_rear =
object {
  intersection {
    union {
      intersection { Secondary_hull_rear_shape }
      intersection {
        sphere { z*-16.575, 1.8140079933672 texture { Back_texture } }
        plane { y, 0 }
      }
      intersection {
        sphere { z*-16.575, 1.8140079933672 }
        plane { -y 0 }
      }
    }
    object { Cylinder_X inverse scale <1, 2.2, 8> translate <0, -2.5, -20> }
    union {
      intersection {
        plane { y, 1.7 }
        plane { -y, 0  }
        plane { z, 0 rotate x*-19.44003483 translate z*-16.6 }
      }
      intersection {
        plane {  y,  1.54365564 }
        plane { -y, -0.44365564 }
        plane {  z,  0 rotate x*-28.61045967 translate <0, 0.44365564, -16.33663133> }
      }
      object { Cylinder_X scale <1, 0.3, 0.3> translate <0, 0.3, -16.6> }
      object { Cylinder_X scale <1, 0.3, 0.3> translate <0, 1.4, -17.2> }
      inverse
    }
    difference {
      union {
        box { <-3,  1,   -10.5>, <3,  1.15, -10.3> texture { Window_texture } }
        box { <-3,  0.3, -11>,   <3,  0.45, -10.8> texture { Window_texture } }
        box { <-3,  0.3, -10.3>, <3,  0.45, -10.1> texture { Window_texture } }
        box { <-3, -0.4, -12.3>, <3, -0.25, -12.1> texture { Window_texture } }
        box { <-3, -0.4, -11.5>, <3, -0.25, -11.3> texture { Window_texture } }
        box { <-3, -0.4, -10.7>, <3, -0.25, -10.5> texture { Window_texture } }
        box { <-3, -1.8, -10.3>, <3, -1.7,  -10.1> texture { Window_texture } }
      }
      box { <-1, -1.8, -12.3>, <1, 1.15, -10.1> texture { Window_texture } }
      inverse
    }
  }
  texture { Secondary_hull_texture }
  bounded_by { box { <-2.7, -2.7, -18.4>, <2.7, 2.7, -10.023529411764> } }
}


#declare Secondary_hull_top =
object {
  union {
    intersection {
      union {
        object { Secondary_hull_middle_shape }
        object { Secondary_hull_rear_shape }
        translate y*0.05
      }
      union {
        box { <-0.25, 1.8, -16.575>, <0.25, 3.1, -7> }
        intersection {
          object { Cylinder_Y scale <0.25, 1, 0.25> translate z*-16.575 }
          plane { -y, -1.8 }
        }
      }
    }
    sphere { <0, 1.85, -16.575>, 0.1 texture { Light_texture } }
  }
  bounded_by { box { <-0.25, 0, 0>, <0.25, 0.45, 10.2> rotate x*-7 translate <0, 1.5, -16.95> } }
}

#declare Secondary_hull_bottom =
object {
  intersection {
    union {
      object { QCone_Y }
      intersection {
        plane { x, 0 rotate z*-45 }
        plane { -x, 0 rotate z*45 }
        plane { -z 0 }
      }
      translate y*-0.3
    }
    plane { z, 0 rotate x*45 translate z*0.4 }
    box { <-0.3, -0.1, -0.3>, <0.3, 0, 0.4> }
  }
  bounded_by { sphere { z*0.05, 0.6 } }
  translate <0, -0.46, -16.575>
}

#declare Stick = box { <0, 0, -0.025>, <0.025, 2, 0.025> pigment { colour Detailgray } rotate z*32.934 translate x*1.6 }

#declare Shuttle_bay_door =
object {
  intersection {
    union {
      object { QCone_Y translate y scale <1.6, 2.47, 1.6> translate z*-16.575 }
      intersection {
        plane { < 1, 1, 0>, 0 translate y scale <1.6, 2.47, 1.6> }
        plane { <-1, 1, 0>, 0 translate y scale <1.6, 2.47, 1.6> }
        plane { -z, 16.575 }
      }
      union {
        box { Stick }
        box { Stick rotate y*15 }
        box { Stick rotate y*30 }
        box { Stick rotate y*45 }
        box { Stick rotate y*60 }
        box { Stick rotate y*75 }
        box { Stick rotate y*90 }
        box { Stick rotate y*105 }
        box { Stick rotate y*120 }
        box { Stick rotate y*135 }
        box { Stick rotate y*150 }
        box { Stick rotate y*165 }
        box { Stick rotate y*180 }
        translate z*-16.575
      }
    }
    box { <-1.6, 0, -18.3>, <1.6, 1.7, -16> }
  }
  bounded_by { box { <-1.6, 0, -18.3>, <1.6, 1.7, -16> } }
}

#declare Nav_deflector =
object {
  intersection {
    union {
      intersection {
        object { Ellipsoid scale <2.87, 2.87, 6.8> translate z*-4 }
        plane { z, 0.3 }
      }
      intersection {
        object { QCone_Z scale <2.1, 2.1, 11.4> translate z*11.7 }
        plane { z, 1.7 }
      }
      intersection {
        object { QCone_Z scale <2.1, 2.1, 8.87> translate z*9.17 }
        plane { z, 1.9 }
      }
      intersection {
        object { QCone_Z scale <2.1, 2.1, 7.25> translate z*7.55 }
        plane { z, 2.2 }
      }
    }
    object { Paraboloid_Z inverse scale <1.45, 1.45, 0.5> translate z*1.7 texture { Nav_deflector_texture } }
    plane { -z 0 }
  }
  bounded_by { box { <-2.4, -2.4, 0>, <2.4, 2.4, 2.2> } }
}

#declare Thing_in_front_of_hull_swellout =
object {
  union {
    object { Disk_Z scale <0.35, 0.35, 0.05> translate <0, -2.2, 0.35> }
    intersection {
      union {
        box { <-0.35, 0.02, 0>, < 0.35, 0.1, 0.3> }
        box { < 0.25, 0,    0>, < 0.35, 0.1, 0.3> }
        box { <-0.35, 0,    0>, <-0.25, 0.1, 0.3> }
        rotate x*-45
        scale <1, 2.1, 11.4>
        translate <0, -2.2, 0.3>
      }
      plane { z, 1.7 }
    }
    sphere { <0, -2.2, 0.4>, 0.25 pigment { colour Detailgray } }
  }
  bounded_by { sphere { <0, -2.175, 1> 1 } }
}

#declare Secondary_hull_door =
object {
  intersection {
    union {
      object { Secondary_hull_middle_quadric translate <-0.05, -0.3, 6> texture { Door_texture } }
      object { Cylinder_X inverse scale <1, 0.25, 0.25> }
    }
    object { Secondary_hull_middle_quadric pigment { colour Red } translate <0.001, -0.3, 6> }
    object { Cylinder_X scale <1, 0.3, 0.3> }
    plane { -x, -2.85 }
  }
  bounded_by { box { <2.85, -0.3, -0.3>, <3, 0.3, 0.3> } }
  translate <0, 0.3, -6>
}

//
// There is a `Starship U.S.S. Enterprise - United Federation of Planets'-
// text on both sides of the secondary hull but there is only one texture
// map file used. That represents left side.
//
// Because we don't want the text to be mirrored on the right side, we have
// to do a little trick:
// 
// This object covers the text on the right side. Object has the same
// texture so transformed that the text will be `unmirrored' correctly on the
// right position. Object does not extend on the stripes and the Starfleet
// logo in the texture.
//

#declare Secondary_hull_text_fix =
object {
  intersection {
    union {
      object { Secondary_hull_front_shape }
      object { Secondary_hull_middle_shape }
      object { Secondary_hull_swellout_shape }
      translate x*0.0001
    }
    box { <2.5, -0.1625, -5.9>, <3.1, -0.075, -0.8> }
  }
  texture { Secondary_hull_right_texture  }
  bounded_by { box { <2.5, -0.1625, -5.9>, <3.1, -0.075, -0.8> } }
}

//
// Parts of the inter connecting dorsal
//
#declare Dorsal_edge_shape =
intersection {
  union {
    object { Cylinder_Y scale <0.3, 1, 1.8> translate < 0.4, 0, -1.8> }
    object { Cylinder_Y scale <0.3, 1, 1.8> translate <-0.4, 0, -1.8> }
    intersection {
      plane { -x, 0.4 }
      plane { x 0.4 }
    }
    plane { z, -1.8 }
  }
  plane { -x, 0.7 }
  plane { x, 0.7 }
  plane { z, 0 }
}

#declare Dorsal_top =
object {
  intersection {
    object { Dorsal_edge_shape scale <1, 1, -1> rotate x*50.47736873 translate <0, 3, -7> }
    union {
      object { Dorsal_edge_shape rotate x*60.70863783 translate <0, 4, 0.9> }
      object { Dorsal_edge_shape rotate x*9.5 translate <0, 3.5, 0.65> }
    }
    plane {  y, 7 }
    plane { -y, -3.45 }
    union {
      plane { -y 0 }
      plane { -z 0 }
      rotate x*-8
      translate <0, 4, -5>
    }
    difference {
      union {
        box { <-1, 6.05, -0.5>, <1, 6.2, -0.3> texture { Window_texture } }
        box { <-1, 6.05,  2.5>, <1, 6.2,  2.7> texture { Window_texture } }
        box { <-1, 5.45, -0.5>, <1, 5.6, -0.3> texture { Window_texture } }
        box { <-1, 5.45,  1.8>, <1, 5.6,  2>   texture { Window_texture } }
        box { <-1, 5.45,  2.5>, <1, 5.6,  2.7> texture { Window_texture } }
        box { <-1, 4.85, -2.1>, <1, 5,  -1.9>  texture { Window_texture } }
        box { <-1, 4.85, -1.2>, <1, 5,  -1>    texture { Window_texture } }
        box { <-1, 4.85, -0.5>, <1, 5,  -0.3>  texture { Window_texture } }
        box { <-1, 4.85,  1.1>, <1, 5,   1.3>  texture { Window_texture } }
        box { <-1, 4.25, -2.8>, <1, 4.4, -2.6> texture { Window_texture } }
        box { <-1, 4.25, -1.2>, <1, 4.4, -1>   texture { Window_texture } }
        box { <-1, 4.25, -0.5>, <1, 4.4, -0.3> texture { Window_texture } }
      }
      box { <-0.4, -3, -2.5>, <0.4, 3.1, 0> rotate x*60.71 translate <0, 4, 0.5> texture { Window_texture } }
      inverse
    }
  }
  bounded_by { box { <-0.7, 3.3, -6.5>, <0.7, 7, 5.5> } }
  texture { Dorsal_texture }
}

#declare Dorsal_rear_bottom =
object {
  intersection {
    object { Dorsal_edge_shape scale <1, 1, -1> rotate x*50.47736873 translate <0, 3, -6.95> }
    box { <-0.7, 3.4, -6.5>, <0.7, 4, -5> }
  }
  texture {
    pigment {
      gradient y
      color_map {
        [0  0.5 colour Detailgray colour Detailgray]
        [0.5 1  colour Black    colour Black    ]
      }
    }
    scale <1, 0.09, 1>
    rotate x*-8
  }
  bounded_by { box { <-0.7, 3.4, -6.5>, <0.7, 4, -5> } }
}

#declare Dorsal_rear_top =
object {
  intersection {
    object { Cylinder_Y scale <0.75, 1, 1.8> translate z*-1.8 }
    sphere { <0, -5.7, 1.7>, 12.5 inverse }
    plane { <0, -7, -12>, 0 translate <0, 5.8, -2.6> }
    plane { z, -1.8 }
    plane { y, 7}
  }
  bounded_by { box { <-0.75, 5.7, -3.4>, <0.75, 7, -1.8> } }
}

#declare Dorsal_base_wall = quadric { Cylinder_Y scale <11.1595, 1, 12.64743559> translate x*-9.9595 rotate x*50.47736873 }

#declare Dorsal_base =
object {
  union {
    intersection {
      object { Dorsal_base_wall }
      object { Dorsal_base_wall scale <-1, 1, 1> }
      union {
        intersection {
          object { Cylinder_X inverse scale <1, 2.5, 2.5> translate <0, -4.77, -2.5> }
          plane { y, -4.77 }
          plane { -z, 0.45 }
        }
        plane { -z, 0 }
        translate z*-4.45468068
        rotate x*50.47736873
      }
      union {
        object { Cylinder_X scale <1, 5, 5> }
        plane { z, 0 } rotate y*55 translate <0, -4.3, -1.5>
      }
      union {
        object { Cylinder_X scale <1, 5, 5> }
        plane { z, 0 } rotate y*-55 translate <0, -4.3, -1.5> 
      }
      union {
        object { Cylinder_X scale <1, 17.5, 17.5> }
        plane { -z, 0 } translate <0, -16.8, -3.25>
      }
      plane { y, 0.7 }
      union {
        plane { -y, 0 }
        intersection {
          object { Cylinder_X inverse scale <1, 0.4, 0.4> translate <0, -0.4, -1.3> }
          plane { z, -1.3 }
        }
        rotate z*10
        translate y*-0.29
      }
      union {
        plane { -y, 0 }
        intersection {
          object { Cylinder_X inverse scale <1, 0.4, 0.4> translate <0, -0.4, -1.3> }
          plane { z, -1.3 }
        }
        rotate z*-10
        translate y*-0.29
      }
      plane { -y, 0.5 }
      intersection {
        plane { z, 0 rotate y*20 }
        plane { z, 0 rotate y*-20 }
        rotate x*9.5
        translate <0, 0.5, 0.9>
      }
      intersection {
        object { Cylinder_X scale <1, 5, 5> rotate  y*55 translate <0, -4.35, -1.5> }
        object { Cylinder_X scale <1, 5, 5> rotate y*-55 translate <0, -4.35, -1.5> }
        plane { -x, 1.14 }
        plane { x 1.14 }
        plane { -y, 0 rotate z*10 translate y*-0.24 }
        plane { -y, 0 rotate z*-10 translate y*-0.24 }
        union {
          union {
            plane { -z, 0 pigment { colour Black } }
            box { <0.35, -0.5, -0.01>, <0.75, -0.3, 0.01> texture { Window_texture pigment { colour Red } } }
            rotate y*20
          }
          union {
            plane { -z, 0 pigment { colour Black } }
            box { <-0.75, -0.5, -0.01>, <-0.35, -0.3, 0.01> texture { Window_texture pigment { colour Red } } }
            rotate y*-20
          }
          rotate x*9.5
          translate <0, 0.5, 0.8>
        }
        inverse
      }
      sphere { <-1.0965353, 0.2, -2.7>, 0.28 inverse }
      sphere { < 1.0965353, 0.2, -2.7>, 0.28 inverse }
      box { <-1.5, 0.15, -4.6>, <1.5, 0.3, -4.4> inverse texture { Window_texture } }
      box { <-1.5, 0.15, -3.9>, <1.5, 0.3, -3.7> inverse texture { Window_texture } }
      box { <-1.5, 0.15, -1.7>, <1.5, 0.3, -1.5> inverse texture { Window_texture } }
    }
    box { <-0.1, 0.15, -4.6>, <0.1, 0.3, -1.5> texture { Window_texture } }
  }
  bounded_by { box { <-1.2, -0.5, -8.5>, <1.2, 0.7, 1> } }
  translate y*3
}

#declare Dorsal_bottom = box { <-0.3, 2, -2.5>, <0.3, 2.77, 0.6> }

#declare Dorsal_door =
object {
  intersection {
    union {
      object { Dorsal_base_wall translate <-0.05, -0.2, 2.7> texture { Door_texture } }
      object { Cylinder_X inverse scale <1, 0.25, 0.25> }
    }
    object { Dorsal_base_wall pigment { colour Red } translate <0.001, -0.2, 2.7> }
    object { Cylinder_X scale <1 0.3 0.3> }
    plane { -x, -1 }
  }
  bounded_by { box { <1, -0.3, -0.3>, <1.2, 0.3, 0.3> } }
  translate <0, 3.2, -2.7>
}

//
// And finally - get them together
//
#declare Secondary_hull =
union {
  object { Secondary_hull_top }
  object { Nav_deflector }
  object { Thing_in_front_of_hull_swellout }
  object { Thing_in_front_of_hull_swellout rotate z*90 }
  object { Thing_in_front_of_hull_swellout rotate z*-90 }
  object { Secondary_hull_front }
  object { Secondary_hull_middle }
  object { Secondary_hull_rear }
  object { Shuttle_bay_door }
  object { Secondary_hull_bottom }
  object { Secondary_hull_text_fix }
  object { Secondary_hull_door }
  object { Secondary_hull_door scale <-1, 1, 1> }
  bounded_by { box { <-3, -3, -18.4>, <3, 3, 2.2> } }
  translate <0, -3.8, 4.45>
}

#declare Inter_connecting_dorsal =
union {
  object { Dorsal_rear_top }
  object { Dorsal_top }
  object { Dorsal_rear_bottom }
  object { Dorsal_base }
  object { Dorsal_bottom }
  object { Dorsal_door }
  object { Dorsal_door scale <-1, 1, 1> }
  bounded_by { box { <-1.2, 2, -8.5>, <1.2, 7, 5> } }
  translate <0, -3.8, 4.45>
}