//
// SAUCER.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 14-Sep-92
// Updated: 18-Mar-93
//
// PoV-Ray object description for the saucer section of the starship
// U.S.S. Enterprise NCC-1701-A
//
// shapes.inc and bigetext.inc must be included before this file
//
// This file creates following declaration to be externally used:
//
//     Saucer section of the Enterprise:
//         composite { Saucer }
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

/*

Here are some coordinates which may be useful if someone wants
to modify the shape of the saucer

  y
  ^               
  |         
  |                
  |                                     R             y
  ----->R          A
                  /|                a   3             1.2
                 / |                b   3.75          1.1
                /  |                c  12             0
                                    d  12.5          -1.2

---------a-_
            b
         |/  \_
         B     ---_c_______
           _______        /
        _--       --_    /
       /             d--'
     _e                           Torii:
__---                                    R             y             r

                                  A  12            31.4875       31.4875
            \   /                 B   3            -1.6625        2.8625
             \ /                  C   9           -13.2          12.5
              C                   D  13.65         -0.05          0.05
                                  E  13.3          -1.1           0.1
                   A
                   ^
___                |
   --------_________ 
                  / \ 
                 ( D )
                  \_/
                   /
              _   / <- angle = 15.845708139373
             / \ /
            ( E )
_____________\_/

*/

//
// The parts of the saucer
//
#declare Saucer_hat_top = 
object {
  union {
    difference {
      union {
        intersection {
          union {
            intersection {
              intersection {
                plane { x, 0 rotate z*33.69006753 }
                plane { z, 0 rotate x*-52 translate z*0.15 }
                plane { z, 0 }
                rotate y*26
                translate x*1.7
             }
              intersection {
                plane { -x, 0 rotate z*-33.69006753 }
                plane { z, 0 rotate x*-52 translate z*0.15 }
                plane { z, 0 }
                rotate y*-26
                translate x*-1.7
             }
              plane {y, 0.6 }
           }
            sphere { y*-0.75, 1.65 }
         }
          box { <-1.6, 0, -1.9>, <1.6, 0.65, 1.6> }
       }
        box { <-0.3, 0.6, -1.9>, <0.3, 0.65, 0> }
        intersection {
          object { Cylinder_Y scale <1.6, 1, 1.6> }
          box { <-1.6, 0, 0>, <1.6, 0.15, 1.6> }
       }
        intersection {
          object { Cylinder_Y scale <0.75, 1, 0.75> }
          sphere { y*-0.6, 1.5 }
          plane { y, -0.15 }
        }
      }
      box { <-0.6, 0.02,  1>,   < 0.6, 0.12, 2> texture { Light_texture } }
      box { <-2,   0.02, -0.2>, <-1,   0.12, 1> texture { Light_texture } }
      box { < 1,   0.02, -0.2>, < 2,   0.12, 1> texture { Light_texture } }
      intersection {
        box { <-1, 0.1, -3>, <1, 0.525, -1.8> }
        plane { -x, 0 rotate z*-38 translate x*-0.65 }
        plane { x, 0 rotate z*38 translate x*0.65 }
      }
    }
    intersection {
      object { Cylinder_Z scale <0.275, 0.275, 1> }
      object { Cylinder_Z inverse scale <0.2, 0.2, 1> }
      plane { z, -1 }
      plane { -z, 1.91 pigment { color Red } }
      translate y*0.325
    }
    sphere { < 0,    0.65, -1.55>, 0.1  texture { Light_texture } }
    sphere { <-0.36, 0.25, -1.8 >, 0.06 texture { Light_texture } }
    sphere { < 0.36, 0.25, -1.8 >, 0.06 texture { Light_texture } }
    }
  bounded_by { box { <-1.6, 0, -1.91>, <1.6, 0.9, 1.6> } }
  translate y*2
}


#declare Saucer_hat_shape =
union {
  object { QCone_Y translate y*3 }
  object { QCone_Y translate < 0.7, 1, -2.752380788> }
  object { QCone_Y translate <-0.7, 1, -2.752380788> }
  intersection {
    object { QCone_Y translate y*3.84 }
    plane {  x, 0 rotate y*-14.2692474 }
    plane { -x, 0 rotate  y*14.2692474 }
  }
  intersection {
    intersection {
      plane { <-1, 1, 0>, 0 translate x*-3 }
      plane { z, 0 }
      plane { -z, 2.016333306 }
      rotate y*-30.49774796
    }
    plane { x, 0 }
  }
  intersection  {
    intersection {
      plane { <1, 1, 0>, 0 translate x*3 }
      plane { z, 0 }
      plane { -z, 2.016333306 }
      rotate y*30.49774796
    }
    plane { -x, 0 }
  }
}

#declare Saucer_hat = 
union {
  object {
    intersection {
      plane { y, 1 }
      plane { -y, 0.4 }
      object { Saucer_hat_shape }
      union {
        //quartic { // A torus with r0=2.44 and r1=0.96568542
        //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -13.7722967, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 10.0421033, 0, 0, 0, 0, 1, 0, -13.7722967, 0, 25.2109599>
        //  sturm
        //  translate y*80.03431458
        //}
        torus { 2.44, 0.96568542 translate y*80.03431458 }
        object { Cylinder_Y scale <2.44, 1, 2.44> }
        plane { y, 0.71715729 }
      }
      union {
        intersection {
          plane { x, 0 }
          intersection {
            plane { z, 0 }
            union {
              plane { -x, 1.7 }
              object { Cylinder_Z scale <0.72426407, 0.72426407, 1> translate <-1.7, 0.27573593, 0> }
            }
            rotate y*-30.49774796
          }
        }
        intersection{
          plane { -x, 0 }
          intersection {
            plane { z, 0 }
            union {
              plane { x, 1.7 }
              object { Cylinder_Z scale <0.72426407, 0.72426407, 1> translate <1.7, 0.27573593, 0> }
            }
            rotate y*30.49774796
          }
        }
        //quartic { // a torus with r0=1.7 and r1=0.72426407
        //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -6.8291169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 4.7308831, 0, 0, 0, 0, 1, 0, -6.8291169, 0, 5.5953138>
        //  sturm
        //  translate y*0.27573593
        //}
        torus { 1.7, 0.72426407 translate y*0.27573593 }
        object { Cylinder_Y scale <1.7, 1, 1.7> }
        plane { y, 0.78786797 }
      }
      union {
        plane { -y, -0.6 }
        intersection {
          plane { y, 0 rotate x*-12 translate <0, 0.25, -2.5> }
          plane { y, 0.25 }
          box { <-0.91, 0.09, -5>, <0.91, 0.61, -3.1> inverse }
        }
      }
    }
  }
  object {
    intersection {
      plane { y, 0.7 }
      plane { -y, 0.4 }
      union { Saucer_hat_shape translate y*-0.08 }
      union {
        object { QCone_Y translate <0, 3.76, 0.05> texture { Window_texture } }
        intersection {
          box { <-0.85, 0, -5>, <-0.5,  0.55, -3> inverse }
          box { <-0.4,  0, -5>, <-0.05, 0.55, -3> inverse }
          box { < 0.05, 0, -5>, < 0.4,  0.55, -3> inverse }
          box { < 0.5,  0, -5>, < 0.85, 0.55, -3> inverse }
        }
      }
      intersection {
        box { <-3, 0.3,  0.3>, <-2, 0.525,  0.5> inverse texture { Window_texture } }
        box { <-3, 0.3, -0.1>, < 3, 0.525,  0.1> inverse texture { Window_texture } }
        box { < 2, 0.3, -0.5>, < 3, 0.525, -0.3> inverse texture { Window_texture } }
        box { < 2, 0.3, -1.6>, < 3, 0.525, -1.2> inverse texture { Window_texture } }
        rotate y*22
      }
      intersection {
        box { < 3, 0.3,  0.3>, < 3, 0.525,  0.5> inverse texture { Window_texture } }
        box { <-3, 0.3, -0.1>, < 3, 0.525,  0.1> inverse texture { Window_texture } }
        box { <-3, 0.3, -0.5>, <-2, 0.525, -0.3> inverse texture { Window_texture } }
        box { <-3, 0.3, -1.6>, <-2, 0.525, -1.2> inverse texture { Window_texture } }
        rotate y*-22
      }
    }
    pigment { color Stripegray }
  }
  bounded_by { box { <-3, -0.4, -4.2>, <3, 1, 3> } }
  scale <1, 0.8, 1>
  translate y*1.2
}

#declare Saucer_top_center =
object {
  intersection {
    //quartic { // A torus with r0=3 and r1=2.8625
    //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -34.3878126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 1.61218750, 0, 0, 0, 0, 1, 0, -34.3878126, 0, 0.649787134>
    //  sturm
    //  translate y*-1.6625
    //}
    torus { 3, 2.8625 translate y*-1.6625 }
    plane { y, -1.1 }
  }
  bounded_by {
    intersection {
      plane { y, 1.2 }
      plane { -y, -1.1 }
      sphere { y*1.2 3.75 }
    }
  }
}

#declare Saucer_top =
object{
  intersection {
    //quartic { // A torus with r0=12 and r1=31.4875
    //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -2270.92532, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, -1694.92531, 0, 0, 0, 0, 1, 0, -2270.92532, 0, 718192.953>
    //  sturm
    //  inverse
    //  translate y*31.4875
    //}
    torus { 12, 31.4875 inverse translate y*31.4875 }
    sphere { 0, 12 }
    plane {  y, 1.1 }
    plane { -y, 0 }
  }
  texture { Saucer_top_texture }
  bounded_by {
    intersection {
      plane {  y, 1.1 }
      plane { -y, 0 }
      sphere { 0, 12 }
    }
  }
}

#declare Saucer_top_edge =
object {
  intersection {
    union {
      //quartic { // A torus with r0=13.65 and r1=0.05
      //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -372.65, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 372.64, 0, 0, 0, 0, 1, 0, -372.65, 0, 34715.1424>
      //  sturm
      //  translate y*-0.05
      //}
      torus { 13.65, 0.05 translate y*-0.05 }
      sphere { 0, 13.65 }
    }
    plane { y, 0 }
    plane { -y, 0.07}
  }
  texture { Saucer_top_texture }
  bounded_by {
    intersection {
      plane { y, 0 }
      plane { -y, 0.07 }
      sphere { y*-0.05, 13.7 }
      sphere { 0,12 inverse }
    }
  }
}

#declare Saucer_top_sphere_pair =
object {
  union {
    box { <-0.4, -0.1, -0.2>, <0.4, 0.01, 0.2> }
    sphere { x*-0.2, 0.1 }
    sphere { x*0.2, 0.1 }
  }
  pigment { color Detailgray }
  bounded_by { sphere { 0, 0.45 } }
  translate y*-31.4875
  rotate x*11.768494
  translate <0, 31.4875, 12>
}

#declare Saucer_top_edge_thing =
object {
  intersection {
    union {
      //quartic { // A torus with r0=13.65 and r1=0.051
      //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -372.650202, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 372.639798, 0, 0, 0, 0, 1, 0, -372.650202, 0, 34715.1048>
      //  sturm
      //  translate y*-0.05
      //}
      torus { 13.65, 0.051 translate y*-0.05 }
      sphere { 0, 13.65 }
      intersection {
        object { QCone_Y translate -y scale <13.6991, 48.261073, 13.6991> }
        plane { y, 0 }
        translate y*-0.06365239
      }
    }
    box { <-0.5, -0.15, 13.2>, <0.5, 0.001, 13.701> }
    plane { < 2, 3, -3>, 0 translate < 0.5, 0, 13.65> }
    plane { <-2, 3, -3>, 0 translate <-0.5, 0, 13.65> }
  }
  pigment { color Detailgray }
  bounded_by { box { <-0.5, -0.2, 13.2>, <0.5, 0.001, 13.701> } }
}

#declare Saucer_edge =
object {
  intersection {
    plane { y, -0.06365239 }
    object { QCone_Y translate -y scale <13.6981, 48.261073, 13.6981> translate y*-0.06365239 }
    sphere { 0, 13 inverse }
    plane { -y 1.12730478 }
  }
  texture { Saucer_edge_texture }
  bounded_by { box { <-13.7, -1.1, -13.7>, <13.7, -0.05, 13.7> } }
}

#declare Saucer_edge_windows =
object {
  intersection {
    union {
      box { <-2.4, -0.46, 13>, <-2.1, -0.34, 14> }
      box { <-1.8, -0.46, 13>, <-1.7, -0.34, 14> }
      box { <-1.4, -0.46, 13>, <-1.1, -0.34, 14> }
      box { <-0.8, -0.46, 13>, <-0.7, -0.34, 14> }
      box { <-0.6, -0.81, 13>, <-0.5, -0.69, 14> }
      box { <-0.4, -0.46, 13>, <-0.3, -0.34, 14> }
      box { < 0.3, -0.46, 13>, < 0.4, -0.34, 14> }
      box { < 0.5, -0.81, 13>, < 0.6, -0.69, 14> }
      box { < 0.7, -0.46, 13>, < 0.8, -0.34, 14> }
      box { < 1.1, -0.46, 13>, < 1.4, -0.34, 14> }
      box { < 1.7, -0.46, 13>, < 1.8, -0.34, 14> }
      box { < 2.1, -0.46, 13>, < 2.4, -0.34, 14> }
    }
    object { QCone_Y translate -y scale <13.6981, 48.261073, 13.6981> translate <0, -0.06365239, 0.005> }
  }
  texture { Window_texture }
  bounded_by { box { <-2.4, -0.81, 13>, <2.4, -0.34, 13.7> } }
}

#declare Saucer_rear_windows =
object {
  intersection {
    union {
      box { <-1.05, -0.46, 13>, <-0.95, -0.34, 14> }
      box { <-0.65, -0.46, 13>, <-0.55, -0.34, 14> }
      box { <-0.25, -0.46, 13>, <-0.15, -0.34, 14> }
      box { < 0.15, -0.46, 13>, < 0.25, -0.34, 14> }
      box { < 0.55, -0.46, 13>, < 0.65, -0.34, 14> }
      box { < 0.95, -0.46, 13>, < 1.05, -0.34, 14> }

      box { <-1.05, -0.81, 13>, <-0.95, -0.69, 14> }
      box { <-0.65, -0.81, 13>, <-0.55, -0.69, 14> }
      box { <-0.25, -0.81, 13>, <-0.15, -0.69, 14> }
      box { < 0.15, -0.81, 13>, < 0.25, -0.69, 14> }
      box { < 0.55, -0.81, 13>, < 0.65, -0.69, 14> }
      box { < 0.95, -0.81, 13>, < 1.05, -0.69, 14> }
    }
    object { QCone_Y translate -y scale <13.6981, 48.261073, 13.6981> translate <0, -0.06365239, 0.005> }
  }
  texture { Window_texture }
  bounded_by { box { <-1.05, -0.81, 13>, <1.05, -0.34, 13.7> } }
}

#declare Impulse_engine =
object {
  intersection {
    union {
      intersection {
        object { Cylinder_Y scale <1.6, 1, 1.6> }
        plane { y, 0.4 }
        sphere { y*2.25, 2.1 inverse }
      }
      sphere { y*-0.1, 0.7 texture { Window_texture } }
      intersection {
        object { Cylinder_Z scale <9, 9, 1> translate y*-8.75 }
        union {
          box { <-1.7, -2, -3.2>, <1.7, 1, 0> }
          object { Cylinder_Y scale <1.7, 1, 1.7> }
          intersection {
            object { Cylinder_Y scale <0.6, 1, 0.6> translate z*2.5}
            plane { -z, -2.5 }
          }
          box { <-0.2, -2, 0>, <0.2, 1, 2.6> }
        }
        plane {  x, 0 rotate z*-12 translate x*1.7 }
        plane { -x, 0 rotate z*12 translate x*-1.7 }
        intersection {
          plane { -z, 0 rotate  y*14 }
          plane { -z, 0 rotate y*-14 }
          rotate x*-10
          translate z*-3.2
        }
        intersection {
          plane { -y, 0 rotate  z*10 }
          plane { -y, 0 rotate z*-10 }
          rotate x*10
          translate <0, -0.7, -3.2>
        }
        union {
          object { Cylinder_Z inverse scale <8.93, 8.93, 1> translate y*-8.75 }
          plane { -x, 0 rotate z*-12 translate x*1.63 }
          plane { x, 0 rotate z*12 translate x*-1.63 }
          intersection {
            plane { -z, 0 rotate  y*14 texture { Impulse_engine_texture translate <-0.9, -0.2,  0> } }
            plane { -z, 0 rotate y*-14 texture { Impulse_engine_texture translate < 0.9, -0.25, 0> } }
            rotate x*-10
            translate z*-3.05
          }
          union {
            plane { y, 0 rotate z*10 }
            plane { y, 0 rotate z*-10 }
            rotate x*10
            translate <0, -0.63, -3.2>
          }
        }
      }
      intersection {
        object { Cylinder_Z scale <8.95, 8.95, 1> translate y*-8.75 }
        box { <-0.6, -2, 0>, <0.6, 1, 2.5> }
      }
      intersection {
        plane {  z, -1.4 }
        plane {  y,  0.28 }
        plane {  x,  0 rotate z*-10 translate  x*0.4 }
        plane { -x,  0 rotate  z*10 translate x*-0.4 }
        plane { -y,  0 rotate  x*10 translate <0, -0.75,-3.2> }
      }
    }
    plane { -z, 0 rotate x*-9 translate z*-3.15 }
    union {
      plane { z, -2 }
      plane { -y, 0 }
    }
  }
  bounded_by { box { <-1.7, -1.2, -3.2>, <1.7, 0.6, 3.1>} }
  translate z*-11.2
}

#declare Saucer_bottom_edge = 
object {
  //quartic { // A torus with r0=13.3 and r1=0.1
  //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -353.80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 353.76, 0, 0, 0, 0, 1, 0, -353.80, 0, 31286.5344>
  //  sturm
  //  translate y*-1.1
  //}
  torus { 13.3, 0.1 translate y*-1.1 }
  bounded_by {
    intersection {
      plane  { y, -1 }
      plane  { -y, 1.2 }
      sphere { y*-1.2, 13.4 }
      sphere { y*-1.2, 12.2 inverse }
    }
  }
}

#declare Saucer_bottom =
object {
  intersection {
    //quartic { // A torus with r0=9 and r1=12.5
    //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -474.50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, -150.50, 0, 0, 0, 0, 1, 0, -474.50, 0, 5662.5625>
    //  sturm
    //  inverse
    //  translate y*-13.2
    //}
    torus { 9, 12.5 inverse translate y*-13.2 }
    intersection {
      union {
        intersection {
          plane  { -y, 1.2 }
          sphere { y*-1.2, 13.3 }
        }
        sphere { y*4, 10 }
      }
      plane { y, -0.6 }
    }
    sphere { y*-1.35728072, 5 inverse }
  }
  texture { Saucer_bottom_texture }
  bounded_by {
    intersection {
      plane  { y, -0.6 }
      plane  { -y,  1.561 }
      sphere { y*-1.2, 13.3 }
      sphere { y*-1.35728072, 5 inverse }
    }
  }
}

#declare Saucer_bottom_shape = quadric { <1, -1, 1>, 0, 0, 1 translate y*-2.236068 scale <2.5, 0.94406864, 2.5> }

#declare Saucer_bottom_windows =
union {
  sphere { <0, -0.5173422248, 3.4>, 0.1 texture { Window_texture } rotate y*-18 }
  sphere { <0, -0.5173422248, 3.4>, 0.1 texture { Window_texture } rotate y*-6 }
  sphere { <0, -0.5173422248, 3.4>, 0.1 texture { Window_texture } rotate y*6 }
  sphere { <0, -0.5173422248, 3.4>, 0.1 texture { Window_texture } rotate y*18 }
  sphere { <0, -0.1006895797, 4.7>, 0.1 texture { Window_texture } rotate y*-15 }
  sphere { <0, -0.1006895797, 4.7>, 0.1 texture { Window_texture } rotate y*15 }
  inverse
}

#declare Saucer_bottom_center =
object {
  intersection {
    object { Saucer_bottom_shape texture { Saucer_bottom_texture } }
    plane { y, 0 }
    plane { -y, 2 }
    object { Saucer_bottom_windows }
    object { Saucer_bottom_windows rotate y*90 }
    object { Saucer_bottom_windows rotate y*-90 }
    translate y*-1.35728072
  }
  bounded_by { sphere { y*-1.35728072, 5 } }
}

#declare Saucer_censor_dome =
object {
  union {
    intersection {
      object { Saucer_bottom_shape translate y*-0.3 }
      plane { y, -0.6 }
      plane { -y, 1.33 }
      plane { <-4, -1,  0>, 0 translate <-2, -1,  0  > }
      plane { < 4, -1,  0>, 0 translate < 2, -1,  0  > }
      plane { < 0, -1, -4>, 0 translate < 0, -1, -2  > }
      plane { < 0, -1,  4>, 0 translate < 0, -1,  2.7> }
      union {
        intersection {
          union {
            plane { <-4,   -2, -1.7>, 0 translate <-0.9, -1.33, -0.9> }
            plane { <-1.7, -2, -4  >, 0 translate <-0.9, -1.33, -0.9> }
          }
          union {
            plane { <4,   -2, -1.7>, 0 translate <0.9, -1.33, -0.9> }
            plane { <1.7, -2, -4  >, 0 translate <0.9, -1.33, -0.9> }
          }
          union {
            plane { <-4,   -2, 1.2>, 0 translate <-0.9, -1.33, 0.9> }
            plane { <-1.7, -2, 4  >, 0 translate <-0.9, -1.33, 0.9> }
          }
          union {
            plane { <4,   -2, 1.2>, 0 translate <0.9, -1.33, 0.9> }
            plane { <1.7, -2, 4  >, 0 translate <0.9, -1.33, 0.9> }
          }
        }
        intersection {
          object { QCone_Y translate y*-2.9 }
          object { QCone_Y translate y*-1.272792206 scale <1, 0.43, 1> translate y*-1.33 }
        }
      }
      union {
        object { Saucer_bottom_shape inverse translate y*-0.27 }
        intersection {
          union {
            plane { < 4, 2, 1.7>, 0 translate <-0.87, -1.33, -0.87> }
            plane { <-4, 2, 1.7>, 0 translate < 0.87, -1.33, -0.87> }
            plane { -z, 1.9
              texture { Light_texture pigment { color red 1 green 0.9 blue 0.6 } }
              texture {
                pigment {
                  gradient x
                  color_map {
                    [0    0.27 color Black color Black]
                    [0.27 0.52 color Clear color Clear]
                    [0.52 1    color Black color Black]
                  }
                }
              }
            }
            box { <-0.1, -1.17, -1.901>, <0.1, -0.97, -1.8> texture { Light_texture } }
          }
          union {
            plane { <1.7, 2,  4>, 0 translate <-0.87, -1.33, -0.87> }
            plane { <1.7, 2, -4>, 0 translate <-0.87, -1.33,  0.87> }
            plane { -x, 1.9
              texture { Light_texture pigment { color red 1 green 0.9 blue 0.6 } }
              texture {
                pigment {
                  gradient z
                  color_map {
                    [0   0.3 color Clear color Clear]
                    [0.3 1   color Black color Black]
                  }
                }
              }
            }
          }
          union {
            plane { <-1.7, 2,  4>, 0 translate <0.87, -1.33, -0.87> }
            plane { <-1.7, 2, -4>, 0 translate <0.87, -1.33,  0.87> }
            plane { x, 1.9
              texture { Light_texture pigment { color red 1 green 0.9 blue 0.6 } }
              texture {
                pigment {
                  gradient z
                  color_map  {
                    [0  0.3 color Clear color Clear]
                    [0.3 1  color Black color Black]
                  }
                }
              }
            }
          }
          union {
            plane { < 4, 2, -1.2>, 0 translate <-0.87, -1.33, 0.87> }
            plane { <-4, 2, -1.2>, 0 translate < 0.87, -1.33, 0.87> }
            plane { z, 2.65
              texture { Light_texture }
              texture {
                pigment {
                  gradient x
                  color_map {
                    [0  0.3 color Clear color Clear]
                    [0.3 1  color Black color Black]
                  }
                }
              }
            }
          }
        }
      }
      union {
        box { <-0.1, -0.1, -0.3>, <0.1, 0, -0.1> pigment { color Stripegray } }
        box { <-0.1, -0.1,  0.1>, <0.1, 0,  0.3> pigment { color Stripegray } }
        inverse
        rotate z*-11.98397699
        translate <-1.7, -1.239342002, 0>
      }
      union {
        box { <-0.1, -0.1, -0.3>, <0.1, 0, -0.1> pigment { color Stripegray } }
        box { <-0.1, -0.1,  0.1>, <0.1, 0,  0.3> pigment { color Stripegray } }
        inverse
        rotate z*11.98397699
        translate <1.7, -1.239342002, 0>
      }
      union {
        box { <-0.3, -0.1, -0.1>, <-0.1, 0, 0.1> pigment { color Stripegray } }
        box { < 0.1, -0.1, -0.1>, < 0.3, 0, 0.1> pigment { color Stripegray } }
        inverse
        rotate x*11.98397699
        translate <0, -1.239342002, -1.7>
      }
      union {
        box { <-0.3, -0.1, -0.1>, <-0.1, 0, 0.1> pigment { color Stripegray } }
        box { < 0.1, -0.1, -0.1>, < 0.3, 0, 0.1> pigment { color Stripegray } }
        inverse
        rotate x*-14.80245439
        translate <0, -1.059170719, 2.45>
      }
    }
    intersection {
      quadric { <1, -1, 1>, 0, 0, 1 scale <0.577350269, 1, 0.577350269> translate -y }
      plane { y, 1 }
      union {
        plane { -y, -0.85 }
        box { <-0.1, 0.7, -2>,   <0.1, 0.9, 2> }
        box { <-2,   0.7, -0.1>, <2,   0.9, 0.1> }
      }
      scale <1.2, 0.7, 1.2>
      translate y*-2
    }
    intersection {
      quadric { <1, -1, 1>, 0, 0, 1 scale <0.577350269, 1, 0.577350269> translate -y }
      plane { y, 1 }
      plane { -y, 1 }
      scale <1.2, 0.7, 1.2>
      translate y*-1.95
    }
  }
  bounded_by { box { <-2.1, -2, -2.1>, <2.1, -0.6, 2.9> } }
  translate y*-1.35728072
}

#declare Saucer_bottom_sphere_pair =
object {
  union {
    box { <-0.4, -0.01, -0.2>, <0.4, 0.1, 0.2> }
    sphere { x*-0.2, 0.1 }
    sphere { x*0.2, 0.1 }
  }
  pigment { color Detailgray }
  bounded_by { sphere { 0, 0.45 } }
  translate y*12.5
  rotate x*-15.90242956
  translate <0, -13.2, 9>
}

#declare Saucer_bottom_edge_thing = 
object {
  intersection {
    union {
      //quartic { // A torus with r0=13.3 and r1=0.101
      //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -353.800402, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 353.759598, 0, 0, 0, 0, 1, 0, -353.800402, 0, 31286.4633>
      //  sturm
      //  translate y*-1.1
      //}
      torus { 13.3, 0.101 translate y*-1.1 }
      sphere { y*-1.2, 13.3 }
      intersection {
        object { QCone_Y translate -y scale <13.6991, 48.261073, 13.6991> translate y*-0.06365239 }
        plane { -y, 1.12730478 }
      }
    }
    box { <-0.5, -1.201, 12.85>, <0.5, -1, 13.45> }
    plane { < 2, -3, -3>, 0 translate < 0.5, -1.2, 13.3> }
    plane { <-2, -3, -3>, 0 translate <-0.5, -1.2, 13.3> }
  }
  pigment { color Detailgray }
  bounded_by { box { <-0.5, -1.201, 12.85>, <0.5, -1, 13.45> } }
}

#declare Saucer_navigation_lights =
object {
  union {
    sphere { z*13.45, 0.1 texture { Light_texture } }
    sphere { <0, -1.2, 13.1>, 0.1 texture { Light_texture } }
    sphere { x*13.45, 0.1 texture { Light_texture } }
    sphere { <13.1, -1.2, 0>, 0.1 texture { Light_texture } }
    sphere { x*-13.45, 0.1 texture { Light_texture } }
    sphere { <-13.1, -1.2, 0>, 0.1 texture { Light_texture } }
  }
}

#declare Saucer_number_lights =
object {
  union {
    light_source { <0, -7, 3.5> color White spotlight point_at <0, -2, 6.5> radius 100 falloff 110 }
    light_source { <0,  6, 4>   color White spotlight point_at <0,  1, 7>   radius 100 falloff 110 }
  }
}

//
// And then we have to put them all together
//

/*

 Saucer_hat_top /
           ____/
          /
 --__    / Saucer_hat  /
 ____\_       ________/
 -------.    / Saucer_top_center / Saucer_top /
         \  /   ________________/            /
 _________\_   /                            /    Saucer_top_edge
            \                              /
             "-__                         /
                 ----______
 ..........................------------_______________
                                                      O --------
                                 _____________        / Saucer_edge
 ..........................___---.............---____O -------
                      __---
                  __--                               | Saucer_bottom_edge
              __--     \        Saucer_bottom        |
        ___---          \________
 ____---/                        \
 __/__--  \  Saucer_bottom_center
    _/     \__________
 --"                  \
    Saucer_censor_dome
*/

#declare Saucer = 
union {
  object { Saucer_hat_top }

  object { Saucer_hat }

  object { Saucer_top_center }

  object { Saucer_top_sphere_pair rotate y*-90 }
  object { Saucer_top_sphere_pair }
  object { Saucer_top_sphere_pair rotate y*90 }

  object { Saucer_top }

  object { Saucer_top_edge_thing rotate y*-135 }
  object { Saucer_top_edge_thing rotate y*-45 }
  object { Saucer_top_edge_thing rotate y*45 }
  object { Saucer_top_edge_thing rotate y*135 }

  object { Saucer_top_edge }

  object { Saucer_edge }

  object { Impulse_engine }

  object { Saucer_navigation_lights }

  object { Saucer_edge_windows rotate y*-157.5 }
  object { Saucer_edge_windows rotate y*-112.5 }
  object { Saucer_edge_windows rotate y*-67.5 }
  object { Saucer_edge_windows rotate y*-22.5 }
  object { Saucer_edge_windows rotate y*22.5 }
  object { Saucer_edge_windows rotate y*67.5 }
  object { Saucer_edge_windows rotate y*112.5 }
  object { Saucer_rear_windows rotate y*157.5 }

  object { Saucer_bottom_edge_thing rotate y*-135 }
  object { Saucer_bottom_edge_thing rotate y*-45 }
  object { Saucer_bottom_edge_thing rotate y*45 }
  object { Saucer_bottom_edge_thing rotate y*135 }

  object { Saucer_bottom_edge }

  object { Saucer_bottom }

  object { Saucer_bottom_sphere_pair rotate y*-90 }
  object { Saucer_bottom_sphere_pair }
  object { Saucer_bottom_sphere_pair rotate y*90 }

  object { Saucer_bottom_center }

  object { Saucer_censor_dome }

  object { Saucer_number_lights }

  bounded_by {
    intersection {
      sphere { z*-0.35, 14.1 }
      plane  { y, 2.9 }
      plane  { -y, 3.36 }
    }
  }
  translate <0, 3.7, 15.15>
}