//
// NACELLES.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 22-Sep-92
// Updated: 22-Jan-93
//
// PoV-Ray object description for the warp drive nacelles of the starship
// U.S.S. Enterprise NCC-1701-A
//
// shapes.inc and bigetext.inc must be included before this file
//
// This file creates following declarations to be externally used:
//
//     Left warp nacelle:
//         union { Left_warp_nacelle }
//
//     Right warp nacelle:
//         union { Right_warp_nacelle }
//
//     Pylon connecting the left nacelle to secondary hull:
//         union { Left_nacelle_pylon }
//
//     Pylon connecting the right nacelle to secondary hull:
//         union { Right_nacelle_pylon }
//
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//
// Parts of the warp drive nacelles
//
#declare Nacelle_bottom_shape =
union {
  object { Cylinder_Z scale <0.6, 0.6, 1> translate y*0.6 }
  intersection {
    plane { -y, -0.555 }
    plane { x, 0 rotate z*-4.3012223 translate <0.59831012, 0.555, 0> }
    plane { -x, 0 rotate z*4.3012223 translate <-0.59831012, 0.555, 0> }
  }
  scale <1, 0.5, 1>
}

#declare Nacelle_front_shape =
intersection {
  union {
    object { Cylinder_Z scale <0.9, 0.9, 1> translate y*4.6 }
    intersection {
      object { Nacelle_bottom_shape scale <1, 2, 1> }
      plane { y, 4.5325 }
    }
  }
  union {
    object { Ellipsoid scale 0.9 translate y*4.94626276 }
    object { Ellipsoid scale 0.6 translate y*0.6 }
    intersection {
      plane { y, 4.88414043 }
      plane { -y, -0.55858511 }
      object { QCone_Y translate -y scale <0.89785345, 12.97666595, 0.89785345> translate y*4.88414043 }
    }
    intersection {
      plane { z, 0 }
      plane { z, 0 rotate x*-23.02549201 translate y*4.94626276 }
    }
    plane { z, 0 rotate x*-23.02549201 translate y*0.6 }
    translate y*-0.6
    rotate x*23.02549201
    translate <0, 0.6, -2.6>
  }
  scale <1, 0.5, 0.5>
}

#declare Nacelle_front_cover =
object {
  union {
    intersection {
      object { Nacelle_front_shape }
      union {
        intersection {
          plane { x, 0 rotate y*-1.85 rotate z*-4.3012223 translate <0.59831012, 0.555, -3> scale <1, 0.5, 1> }
          plane { -x, 0 rotate y*1.85 rotate z*4.3012223 translate <-0.59831012, 0.555, -3> scale <1, 0.5, 1> }
        }
        plane { y, 0.3 }
        plane { -y, -2.2 }
      }
      union {
        union {
          object { Nacelle_bottom_shape scale <0.75, 1, 1> translate y*0.2 inverse }
          plane { z, -5 }
        }
        intersection {
          plane { x, 0.1 }
          plane { -x, 0.1 }
        }
        intersection {
          plane { y, 2.3  }
          plane { -y, -2.15 }
        }
      }
      plane { -z, 6 }
    }
    intersection {
      union {
        box { <-0.55, 2.45, -6>, <0.55, 2.75, 0> }
        object { Cylinder_Z scale <0.15, 0.15, 1> translate <0.55, 2.6, 0> }
        object { Cylinder_Z scale <0.15, 0.15, 1> translate <-0.55, 2.6, 0> }
      }
      box { <-0.4, 2.4, -5>, <0.4, 2.8, 0> inverse }
      union {
        object { Cylinder_Y scale <4, 1, 4> translate <-4.4, 0, -2> }
        object { Cylinder_Y scale <4, 1, 4> translate < 4.4, 0, -2> }
        plane { z, -2 }
      }
      plane { -z, 6 }
    }
    sphere { <-0.55, 2.6, -6>, 0.15 }
    sphere { < 0.55, 2.6, -6>, 0.15 }
    intersection { Disk_Y scale <0.4, 0.05, 0.4> translate <0, 2.7, -5> }
    intersection {
      sphere { <0, 2.65, -5>, 0.3 }
      plane { y, 2.86 }
    }
  }
}

#declare Nacelle_front_side =
union {
  intersection {
    union {
      box { <-1.1, 0.8, -7>, <-0.5, 2, -3> }
      intersection {
        object { Cylinder_Z scale <0.5, 0.3, 1> translate <-0.6, 0.8, 0> }
        plane { z, -3.4 }
      }
      object { Ellipsoid scale <0.5, 0.3, 0.6> translate <-0.6, 0.8, -3.4> }
      intersection {
        object { Cylinder_Z scale <0.3, 0.3, 1> translate <-0.8, 2, 0> }
        plane { z, -2.6 }
      }
      object { Ellipsoid scale <0.3, 0.3, 0.4> translate <-0.8, 2, -2.6> }
    }
    plane { <0, 1, -1>, 0 translate <0, 0.3, -7> }
    union {
      plane { -y, -2 }
      plane { <0, -1, 1>, 0 translate <0, 2, -3.5> }
      plane { y, 0.8 }
      plane { z, 0 rotate x*-22.5 translate <0, 0.8, -4.2171572875254> }
    }
    object { Cylinder_X scale <1, 0.2, 0.2> translate <0, 1, -4.2171572875254> inverse }
  }
  intersection {
    box { <-0.15, 0, -0.08>, <0.1, 1.4534442, 0> }
    object { Cylinder_Y scale <0.2, 1, 0.3> translate z*-0.3 }
    rotate x*26
    scale <1, 1.0111854, 1>
    rotate z*8.53
    translate <-0.64, 0.7, -2.842>
  }
}

#declare Nacelle_front_sides =
object {
  union {
    object { Nacelle_front_side }
    object { Nacelle_front_side scale <-1, 1, 1> }
    object { Ellipsoid scale <1.08, 0.9, 1.6> translate <0, 1.55, -3.8> texture { Nacelle_interior_texture } }
    intersection {
      object { Cylinder_Z scale <1.08, 0.9, 1> translate <0, 1.55, 0> texture { Nacelle_interior_texture } }
      plane { z, -3.8 }
      plane { -z, 5 }
    }
  }
  bounded_by { box { <-1.1, 0.5, -7>, <1.1, 2.3, -2.2> } }
}


#declare Nacelle_front_interior =
object {
  intersection {
    object { Nacelle_front_shape scale <0.9, 0.9, 1> translate <0, 0.17, -0.1> }
    plane { -z, 5 }
  }
  texture { pigment { colour Gray05 } finish { specular 0 } }
}

#declare Nacelle_front =
union {
  object { Nacelle_front_cover }
  object { Nacelle_front_interior }
  object { Nacelle_front_sides }
  bounded_by { box { <-1.1, 0, -7>, <1.1, 2.9, 0> } }
}

#declare Nacelle_top_shape =
intersection {
  union {
    //quartic { // a torus with r0=2.88333333 and r1=0.15
    //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -16.6722222, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 16.5822222, 0, 0, 0, 0, 1, 0, -16.6722222, 0, 68.7425234>
    //  sturm
    //}
    torus { 2.88333333, 0.15 }
    object { Cylinder_Y scale <2.88333333, 1, 2.88333333> }
  }
  plane { x, -2.43333333 }
  scale <1, 1, 1.5>
}

#declare Nacelle_top =
object {
  intersection {
    union {
      object { Nacelle_top_shape translate <2.43333333, 2.6, -16> }
      object { Nacelle_top_shape translate <2.43333333, 2.6, -16> scale <-1, 1, 1> }
    }
    box { <-0.6, 2.45, -18.2>, <0.6, 2.75, -16> }
  }
  bounded_by { box { <-0.6, 2.45, -18.2>, <0.6, 2.75, -16> } }
}

#declare Nacelle_middle =
union {
  object { Nacelle_top }
  object {
    intersection {
      //quartic { // A torus with r0=18 and r1=0.45
      //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -648.4050, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 647.5950, 0, 0, 0, 0, 1, 0, -648.4050, 0, 104844.821>
      //  sturm
      //  rotate z*90
      //  translate <0, -15.7, -19>
      //  scale <2, 1, 1>
      //}
      torus { 18, 0.45 rotate z*90 translate <0, -15.7, -19> scale <2, 1, 1> }
      box { <-0.9, 2.2, -23>, <0.9, 2.75, -19> }
    }
    bounded_by { box { <-0.9, 2.2, -23>, <0.9, 2.75, -19> } }
  }
  object {
    intersection {
      union {
        //quartic { // A torus with r0=10 and r1=0.3
        //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -200.18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 199.82, 0, 0, 0, 0, 1, 0, -200.18, 0, 9982.0081>
        //  sturm
        //  rotate z*90
        //  translate <0, 10.3, -16>
        //  scale <2, 1, 1>
        //}
        torus { 10, 0.3 rotate z*90 translate <0, 10.3, -16> scale <2, 1, 1> }
        intersection {
          object { QCone_X translate x*-2.5225 scale <0.14985989, 1, 1> translate <-1.7222593, 10.3, -16> }
          object { QCone_X translate x*2.5225 scale <0.14985989, 1, 1> translate <1.7222593, 10.3, -16> }
          object { Cylinder_X scale <1, 10.0225, 10.0225> translate <0, 10.3, -16> }
        }
      }
      box { <-0.7, 0, -20>, <0.7, 0.6, -16> }
    }
    bounded_by { box { <-0.7, 0, -20>, <0.7, 0.6, -16> } }
  }
  object {
    intersection {
      union {
        union {
          intersection {
            object { Cylinder_Z scale <0.9, 0.45, 1> translate y*2.3 }
            plane { -z, 19 }
          }
          intersection {
            object { Nacelle_bottom_shape }
            plane { y, 2.26625 }
            plane { -z, 16 }
          }
        }
        difference {
          union {
            object { Cylinder_Z scale <0.6, 0.35, 1> translate <0.48, 2, 0> }
            object { Cylinder_Z scale <0.6, 0.35, 1> translate <-0.48, 2, 0> }
            object { Cylinder_Z scale <1.08, 0.35, 1> translate y*0.8 }
            box { <-1.08, 0.8, -20>, <1.08, 2, -5> }
          }
          union {
            intersection {
              object { Cylinder_Z translate <-1.9, 1.4, 0> texture { Nacelle_interior_texture } }
              plane { -z, 18 }
            }
            object { Ellipsoid scale <1, 1, 2> translate <-1.9, 1.4, -18> texture { Nacelle_interior_texture } }
          }
          union {
            intersection {
              object { Cylinder_Z translate <1.9, 1.4, 0> texture { Nacelle_interior_texture } }
              plane { -z, 18 }
            }
            object { Ellipsoid scale <1, 1, 2> translate <1.9, 1.4, -18> texture { Nacelle_interior_texture } }
          }
        }
        intersection {
          union {
            box { <-0.45, 2.45, -16>, <0.45, 2.75, -6> }
            object { Cylinder_Z scale <0.15, 0.15, 1> translate <0.45, 2.6, 0> }
            object { Cylinder_Z scale <0.15, 0.15, 1> translate <-0.45, 2.6, 0> }
          }
          plane { -z, 16 }
        }
      }
      plane { z, -5 }
      plane { -z, 20 }
    }
    bounded_by { box { <-1.08, 0, -20>, <1.08, 2.75, -5> } }
  }
}

#declare Nacelle_back =
union {
  object {
    intersection {
      union {
        intersection {
          //quartic { // A torus with r0=36.4 and r1=0.6
          //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -2650.64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2649.20, 0, 0, 0, 0, 1, 0, -2650.64, 0, 1754565.16>
          //  sturm
          //  scale <1, 0.58333333, 1>
          //  translate <35.92, 2, -20>
          //}
          torus { 36.4, 0.6 scale <1, 0.58333333, 1> translate <35.92, 2, -20> }
          plane { x, 0 }
        }
        intersection {
          //quartic { // A torus with r0=36.4 and r1=0.6
          //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -2650.64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2649.20, 0, 0, 0, 0, 1, 0, -2650.64, 0, 1754565.16>
          //  sturm
          //  scale <1, 0.58333333, 1>
          //  translate <-35.92, 2, -20>
          //}
          torus { 36.4, 0.6 scale <1, 0.58333333, 1> translate <-35.92, 2, -20> }
          plane { -x, 0 }
        }
        intersection {
          object { Cylinder_Y scale <36.4, 1, 36.4> translate <35.92, 0, -20> }
          object { Cylinder_Y scale <36.4, 1, 36.4> translate <-35.92, 0, -20> }
        }
      }
      box { <-1.08, 2, -28.6>, <1.08, 2.35, -20> }
      plane { <0, -1, -1>, 0 translate <0, 2, -28.3> }
    }
    bounded_by { box { <-1.08, 2, -28.6>, <1.08, 2.35, -20> } }
  }
  object {
    intersection {
      object { Cylinder_Y scale <37, 1, 37> translate <35.92, 0, -20> texture { NCC_1701_A_texture scale <1, 1, -1> translate <0, 1.3, -24.5> } }
      object { Cylinder_Y scale <37 1 37> translate <-35.92 0, -20> texture { NCC_1701_A_texture translate <0, 1.3, -27> } }
      box { <-1.08, 0.8, -28.3>, <1.08, 2, -20> }
      plane { <0, -1, -1>, 0 translate <0, 2, -28.3> }
    }
    bounded_by { box { <-1.08, 0.8, -28.3>, <1.08, 2, -20> } }
  }
  object {
    intersection {
      union {
        intersection {
          //quartic { // A torus with r0=35.92 and r1=1.08
          //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -2582.8256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2578.1600, 0, 0, 0, 0, 1, 0, -2582.8256, 0, 1661727.25>
          //  sturm
          //  scale <1, 0.324074074, 1>
          //  translate <35.92, 0.8, -20>
          //}
          torus { 35.92, 1.08 scale <1, 0.324074074, 1> translate <35.92, 0.8, -20> }
          plane { x, 0 }
        }
        intersection {
          //quartic { // A torus with r0=35.92 and r1=1.08
          //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -2582.8256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2578.1600, 0, 0, 0, 0, 1, 0, -2582.8256, 0, 1661727.25>
          //  sturm
          //  scale <1, 0.324074074, 1>
          //  translate <-35.92, 0.8, -20>
          //}
          torus { 35.92, 1.08 scale <1, 0.324074074, 1> translate <-35.92, 0.8, -20> }
          plane { -x 0 }
        }
      }
      box { <-1.08, 0.45, -27.1>, <1.08, 0.8, -20> }
      plane { <0, -1, -1>, 0 translate <0, 2, -28.3> }
    }
    bounded_by { box { <-1.08, 0.45, -27.1>, <1.08, 0.8, -20> } }
  }
  object {
    intersection {
      plane { -x, 0.1 }
      plane { x, 0.1 }
      plane { < 0, -1, -1>, 0 translate <0, 2,  -28.4> }
      plane { < 0,  1, -1>, 0 translate <0, 1.7, -28.1> }
      plane { < 0, -5,  1>, 0 translate <0, 0,  -26.5> }
      plane { < 0,  8,  3>, 0 translate <0, 2,  -28> }
    }
  }
  bounded_by { box { <-1.08, 0, -28.6>, <1.08, 2.35, -20> } }
}

#declare Nacelle_light = sphere { <0, 2.3, -27.6>, 0.1 texture { Light_texture } }

#declare Nacelle_bottom =
object {
  union {
    object { Ellipsoid   scale <0.3, 0.5, 0.5> translate <0, 0.1, -8> }
    object { Ellipsoid   scale <0.3, 0.5, 0.5> translate <0, 0.1, -15.8> }
    intersection { Disk_Z scale <0.3, 0.5, 3.9> translate <0, 0.1, -11.85> }
  }
  bounded_by { box { <-0.3, -0.4, -16.3>, <0.3, 0.2, -7.5> } }
}

#declare Nacelle_wing =
object {
  intersection {
    plane { y, 0.9 }
    plane { -x, 1.1 }
    plane { x, 0  }
    plane { < 0, 1, 1>, 0 translate <0, 0.8, -22  > }
    plane { < 0, -60, 1>, 0 translate <0, 0.8, -22  > }
    plane { <-6, -6, -11>, 0 translate <0, 0.9, -27.8> }
  }
  bounded_by { box { <-1.1, 0.7, -27.8>, <0, 0.9, -22> } }
  translate y*0.1
}

//
// Parts of the pylons
//
#declare Nacelle_pylon_cover =
object {
  intersection {
    union {
      intersection {
        object { Cylinder_Y scale <2.60039888, 1, 2.60039888> translate x*2.30039888 }
        object { Cylinder_Y scale <2.60039888, 1, 2.60039888> translate x*-2.30039888 }
      }
      plane { z, 0 }
      rotate x*-37.69424047
      translate z*-1.1
    }
    union {
      intersection {
        object { Cylinder_Y scale <1.81554797, 1, 1.81554797> translate x*1.51554797 }
        object { Cylinder_Y scale <1.81554797, 1, 1.81554797> translate x*-1.51554797 }
      }
      plane { -z, 0 }
      rotate x*-48.93478206
      translate z*-1.1
    }
    plane { -x, 0.3 }
    plane { x, 0.3 }
    plane { -y, 0  }
    plane { y, 8.8 }
    plane { -z, 0 rotate x*-48.93478206 translate z*-2.2 }
    plane { z, 0 rotate x*-37.69424047 }
    box { <-0.1, 0.5, -0.05>, <0.1, 13, 0.05> rotate x*-48.93478206 translate z*-2.2 inverse pigment { colour Black } }
    box { <-0.1, 0.3, -0.05>, <0.1, 1, 0.05> rotate x*-37.69424047 inverse pigment { colour Black } }
    box { <-0.1, 1.3, -0.05>, <0.1, 2.6, 0.05> rotate x*-37.69424047 inverse pigment { colour Black } }
    box { <-0.1, 2.9, -0.05>, <0.1, 10.6, 0.05> rotate x*-37.69424047 inverse pigment { colour Black } }
    intersection {
      plane { y, 8.3 }
      plane { z, -9.7 }
      plane { -z, 0 rotate x*-48.93478206 translate z*-2.05 }
      inverse
    }
    intersection {
      plane { y, 5.8 }
      plane { -y, -2 }
      plane { x, 0 }
      plane { z, 0 rotate x*-37.69424047 translate z*-2.2 }
      plane { -z, 0 rotate x*-48.93478206 translate z*-2.05 }
      inverse
    }
  }
}

#declare Nacelle_pylon_interior =
object {
  intersection {
    union {
      intersection {
        object { Cylinder_Y scale <1.76554797, 1, 1.76554797> translate x*1.51554797 }
        object { Cylinder_Y scale <1.76554797, 1, 1.76554797> translate x*-1.51554797 }
      }
      plane { -z, -0 }
      rotate x*-48.93478206
      translate z*-1.1
    }
    plane { -x, 0.25 }
    plane { x, 0.25 }
    plane { -y, 0 }
    plane { y, 8.8 }
    plane { -z, 0 rotate x*-48.93478206 translate z*-2.1 }
    plane { z, 0 rotate x*-37.69424047 translate z*-1.1 }
  }
  pigment { colour Gray70 }
}

#declare Nacelle_pylon_base =
object {
  intersection {
    //quartic { // A torus with r0=5.10833333 and r1=1
    //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -54.1901388, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 50.1901388, 0, 0, 0, 0, 1, 0, -54.1901388, 0, 629.762508>
    //  sturm
    //  inverse
    //  translate <3.80833333, 0, -1.1>
    //  scale <1, 0.5, 1>
    //}
    torus { 5.10833333, 1 inverse translate <3.80833333, 0, -1.1> scale <1, 0.5, 1> }
    //quartic { // A torus with r0=5.10833333 and r1=1
    //  <1, 0, 0, 0, 2, 0, 0, 2, 0, -54.1901388, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 50.1901388, 0, 0, 0, 0, 1, 0, -54.1901388, 0, 629.762508>
    //  sturm
    //  inverse
    //  translate <-3.80833333, 0, -1.1>
    //  scale <1, 1.3, 1>
    //}
    torus { 5.10833333, 1 inverse translate <-3.80833333, 0, -1.1> scale <1, 1.3, 1> }
    object { Cylinder_X inverse translate z*-3.2 }
    object { Cylinder_X inverse translate <0, 0.6114475, 0.791285002> }
    box { <-0.7, -1.2, -3.2>, <1, 0, 0.77> }
  }
  bounded_by { box { <-0.7, -1.2, -3.2>, <1, 0, 0.77> } }
}

#declare Nacelle_pylon =
union {
  object { Nacelle_pylon_cover }
  object { Nacelle_pylon_interior }
  bounded_by { box { <-0.3, 0, -4.36>, <0.3, 14.5, 0> rotate x*-37.69424047 } }
  scale <1, 0.967032967, 1>
}

//
// And then we collect them together
//
#declare Left_nacelle_pylon =
union {
  object { Nacelle_pylon }
  object { Nacelle_pylon_base }
  translate y*2.3
  rotate z*56.30993247
  translate <0, -2.6, -4.05>
}

#declare Right_nacelle_pylon = object { Left_nacelle_pylon scale <-1, 1, 1> }

#declare Left_warp_nacelle =
union {
  object { Nacelle_front }
  object { Nacelle_middle }
  object { Nacelle_back }
  object { Nacelle_bottom }
  object { Nacelle_light }
  object { Nacelle_wing }
  bounded_by { box { <-1.1, -0.4, -28.4>, <1.1, 2.86, 0> } }
  translate <-9, 3.4, -0.55>
}

#declare Right_warp_nacelle =
union {
  object { Nacelle_front }
  object { Nacelle_middle }
  object { Nacelle_back }
  object { Nacelle_bottom }
  object { Nacelle_light }
  object { Nacelle_wing scale <-1, 1, 1> }
  bounded_by { box { <-1.1, -0.4, -28.4>, <1.1, 2.86, 0> } }
  translate <9, 3.4, -0.55>
}