//
// BIGETEXT.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 15-Sep-92
// Updated: 18-Mar-93
//
// PoV-Ray texture descscriptions for the starship U.S.S. Enterprise
// NCC-1701-A
//
// This file creates following declarations to be externally used:
//
//     Colour for the hull:
//         colour Hullcol
//
//     Colour for the stripes on the hull:
//         colour Stripegray
//
//     Colour for the hull details:
//         colour Detailgray
//
//     Texture for windows:
//         texture { Window_texture }
//
//     Texture for navigation lights:
//         texture { Light_texture }
//
//     Texture for the back of the impulse engine:
//         texture { Impulse_engine_texture }
//
//     Texture for the navigational deflector:
//         texture { Nav_deflector_texture }
//
//     Texture for the top surface of the saucer section:
//         texture { Saucer_top_texture }
//
//     Texture for the bottom surface of the saucer section:
//         texture { Saucer_edge_texture }
//
//     Texture for the edge of the saucer section:
//         texture { Saucer_bottom_texture }
//
//     Texture for docking ports at sides of the secondary hull:
//         texture { Door_texture }
//
//     Texture for secondary hull:
//         texture { Secondary_hull_texture }
//
//     Texture for the back of the secondary hull:
//         texture { Back_texture }
//
//     Texture for the blue things on the sides of the warp nacelles
//         texture { Nacelle_interior_texture }
//
//     Text on the sides of the warp nacelles
//         texture { NCC_1701_A_texture }

// NOTE!
//
// I have written a modification to lighting.c module of the POV-Ray 1.0 to
// speed up the rendering of the heavily layered textures.  This fix speeds
// up the rendering of the Enterprise scene by factor of three (about) but
// it behaves a bit dgiferently:
//
// The original code sums the scalar properties (specular for example) of
// each layer so that 2 transparent layers with specular 1 will result a
// texture with specular 2, so we have to put the specular value only to the
// topmost layer and set zeroes to the specular values of all the other
// layers.
//
// The POV-Ray with my patch installed will use the weighted average of the
// values as the final value so that if I have a layer with 30% transparency
// on non-transparent layer, then 70% of the specular value will be taken
// from the top layer and 30% from the bottom layer.  If I want a constant
// specular value for the texture, I just put the same specular value for
// each layer.
//
// If you are rendering this scene by unmodified POV-Ray 1.0, then you have
// to use this line to get the zero speculars for all but the topmost layer
// in the layered textures. If it's commented out, then uncomment it and
// comment out the other declaration below:

//#declare layer_specular = 0;

// If you are using my patch, then tou have to use this value to get the same
// specular value for all the layers. If it's commented out, then uncomment
// it and comment out the one above:

//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare layer_specular = 0.6;

//
// Colours for the hull of the starship
//
#declare Hullcol    = colour rgb <0.95, 0.95, 1>;
#declare Stripegray = colour rgb 0.8;
#declare Detailgray = colour rgb 0.6;

//
// Default texture - will be used in the hull of the starship and as the base
// for all the other textures
//
#default {
  texture {
    pigment { colour Hullcol }
    finish { specular 0.6 roughness 0.005 ambient 0.1 diffuse 0.9 }
  }
}

//
// Luminous textures
//
#declare Window_texture =
texture {
  finish { ambient 0.8 diffuse 0 }
  pigment { colour LightBlue }
}

#declare Light_texture =
texture {
  finish { ambient 1 diffuse 0 }
  pigment { colour White }
}

#declare Impulse_engine_texture =
texture {
  pigment { wood turbulence 0 colour_map { [ 0 1 colour Yellow colour Red ] } }
  finish { ambient 1 diffuse 0 }
  scale 1.6
}

#declare Nav_deflector_texture =
texture {
  pigment { wood turbulence 0 colour_map { [ 0 1 colour White colour SlateBlue ] } }
  finish { ambient 0.8 diffuse 0.2 }
  scale <3, 3, 1>
}

//
// If you want to render Enterprise with lights off, you can redefine all the
// luminous textures by uncommenting the next four textures. You also have to
// comment out `object { Saucer_number_lights }'-line from the definition of
// the `composite { Saucer }' in the file `saucer.inc'.
//

/*

#declare Window_texture =
texture {
  finish { ambient 0 diffuse 0 reflection { 0.3 } }
  pigment { colour LightBlue }
}

#declare Light_texture =
texture {
  finish { diffuse 0.3 } //refraction 0.6
  pigment { colour White }
}

#declare Impulse_engine_texture =
texture {
  finish { ambient 0 diffuse 0 }
  pigment { colour Black }
}

#declare Nav_deflector_texture =
texture {
  pigment { colour DarkGreen }
}
*/

//
// Textures for saucer.inc
//
#declare Gridgray = colour Detailgray;

#declare Line =
texture {
  pigment {
    gradient z
    colour_map {
      [0 0.0005 colour Gridgray colour Gridgray]
      [0.0005 1 colour Clear    colour Clear   ]
    }
  }
  scale <1, 1, 25>
}

#declare Saucer_top_texture =
texture {
  Line
  pigment {
    colour_map {
      [0 0.0005 colour Gridgray colour Gridgray]
      [0.0005 1 colour Hullcol  colour Hullcol ]
    }
  }
  finish { specular layer_specular }
}
texture { Line finish { specular layer_specular } rotate y*-67.5 }
texture { Line finish { specular layer_specular } rotate y*-45 }
texture { Line finish { specular layer_specular } rotate y*-22.5 }
texture { Line finish { specular layer_specular } rotate y*22.5 }
texture { Line finish { specular layer_specular } rotate y*45 }
texture { Line finish { specular layer_specular } rotate y*67.5 }
texture { Line finish { specular layer_specular } rotate y*90 }
texture {
  pigment {
    wood
    turbulence 0
    colour_map {
      [0     0.167 colour Hullcol  colour Hullcol ]
      [0.167 0.168 colour Gridgray colour Gridgray]
      [0.168 0.229 colour Clear    colour Clear   ]
      [0.229 0.230 colour Gridgray colour Gridgray]
      [0.230 0.291 colour Clear    colour Clear   ]
      [0.291 0.292 colour Gridgray colour Gridgray]
      [0.292 0.353 colour Clear    colour Clear   ]
      [0.353 0.354 colour Gridgray colour Gridgray]
      [0.354 0.415 colour Clear    colour Clear   ]
      [0.415 0.416 colour Gridgray colour Gridgray]
      [0.416 0.477 colour Clear    colour Clear   ]
      [0.477 0.478 colour Gridgray colour Gridgray]
      [0.478 0.539 colour Clear    colour Clear   ]
      [0.539 0.540 colour Gridgray colour Gridgray]
      [0.540 1     colour Hullcol  colour Hullcol ]
    }
  }
  finish { specular layer_specular }
  rotate x*90
  scale <50, 1, 50>
}
texture {
  pigment { image_map { gif "toprear.gif" once map_type 0 } }
  // Compensate the half pixel translation caused by interpolation
  translate <0.0015625, 0, 0.00357142>
  finish { specular layer_specular }
  scale <4, 1, 1.5>
  translate <-2, 0, -6.5>
}
texture {
  pigment { image_map { gif "topfront.gif" once map_type 0 interpolate 2 } }
  // Compensate the half pixel translation caused by interpolation
  translate <0.00044642, 0, 0.00130208>
  scale <-14, 1, -4.8>
  translate <7, 0, 8.8>
}

#declare Saucer_edge_texture =
texture {
  pigment {
    gradient y
    colour_map {
      [0     0.075 colour Hullcol    colour Hullcol   ]
      [0.075 0.15  colour Stripegray colour Stripegray]
      [0.15  0.25  colour Hullcol    colour Hullcol   ]
      [0.25  0.325 colour Stripegray colour Stripegray]
      [0.325 0.425 colour Hullcol    colour Hullcol   ]
      [0.425 0.5   colour Stripegray colour Stripegray]
      [0.5   1     colour Hullcol    colour Hullcol   ]
    }
  }
  scale <1, 2, 1>
}

#declare Saucer_bottom_texture =
texture {
  Line
  pigment {
    colour_map {
      [0      0.0005 colour Gridgray colour Gridgray]
      [0.0005 1      colour Hullcol  colour Hullcol ]
    }
  }
  finish { specular layer_specular }
}
texture { Line finish { specular layer_specular } rotate y*-67.5 }
texture { Line finish { specular layer_specular } rotate y*-45 }
texture { Line finish { specular layer_specular } rotate y*-22.5 }
texture { Line finish { specular layer_specular } rotate y*22.5 }
texture { Line finish { specular layer_specular } rotate y*45 }
texture { Line finish { specular layer_specular } rotate y*67.5 }
texture { Line finish { specular layer_specular } rotate y*90 }
texture {
  pigment {
    wood
    turbulence 0
    colour_map {
      [0     0.167 colour Hullcol  colour Hullcol ]
      [0.167 0.168 colour Gridgray colour Gridgray]
      [0.168 0.229 colour Clear    colour Clear   ]
      [0.229 0.230 colour Gridgray colour Gridgray]
      [0.230 0.291 colour Clear    colour Clear   ]
      [0.291 0.292 colour Gridgray colour Gridgray]
      [0.292 0.353 colour Clear    colour Clear   ]
      [0.353 0.354 colour Gridgray colour Gridgray]
      [0.354 0.415 colour Clear    colour Clear   ]
      [0.415 0.416 colour Gridgray colour Gridgray]
      [0.416 0.477 colour Clear    colour Clear   ]
      [0.477 0.478 colour Gridgray colour Gridgray]
      [0.478 0.539 colour Clear    colour Clear   ]
      [0.539 0.540 colour Gridgray colour Gridgray]
      [0.540 1     colour Hullcol  colour Hullcol ]
    }
  }
  finish {
    specular layer_specular
  }
  rotate x*90
  scale <50, 1, 50>
}
texture {
  pigment { image_map { gif "botfront.gif" once map_type 0 interpolate 2 } }
  // Compensate the half pixel translation caused by interpolation
  translate <0.00082236, 0, 0.00367647>
  finish { specular layer_specular }
  scale <-7.6, 1, 1.7>
  translate <3.8, 0, 6>
}
texture {
  pigment { image_map { gif "botrear.gif" once map_type 0 interpolate 2 } }
  // Compensate the half pixel translation caused by interpolation
  translate <0.00147058, 0, 0.00666666>
  scale <3.4, 1, -0.75>
  translate <-1.7, 0, -3.25>
}

//
// Textures for sechull.inc
//
#declare Edge =
texture {
  pigment {
    gradient y
    colour_map {
      [0   0.5 colour Clear    colour Clear    ]
      [0.5 1   colour Gridgray colour Gridgray ]
    }
  }
  translate y*-0.5
  scale <1, 25, 1>
}

#declare Dorsal_texture =
texture {
  pigment {
    gradient y
    colour_map {
      [0   0.5 colour Hullcol  colour Hullcol  ]
      [0.5 1   colour Gridgray colour Gridgray ]
    }
  }
  finish { specular layer_specular }
  translate y*-0.5
  scale <1, 25, 1>
  rotate x*60.71
  translate <0, 5.8, 3.85>
}
texture {
  pigment {
    gradient y
    colour_map {
      [0   0.5 colour Clear    colour Clear    ]
      [0.5 1   colour Gridgray colour Gridgray ]
    }
  }
  finish { specular layer_specular }
  translate y*-0.5
  scale <1, 25, 1>
  translate y*5.8
}
texture {
  pigment {
    gradient y
    colour_map {
      [0     0.501 colour Clear   colour Clear   ]
      [0.501 1     colour Hullcol colour Hullcol ]
    }
  }
  finish { specular layer_specular }
  translate y*-0.5
  scale <1, 25, 1>
  rotate x*60.71
  translate <0, 5.8, 3.85>
}
texture {
  pigment {
    gradient y
    colour_map {
      [0     0.501 colour Clear   colour Clear   ]
      [0.501 1     colour Hullcol colour Hullcol ]
    }
  }
  finish { specular layer_specular }
  translate y*-0.5
  scale <1, 25, 1>
  translate y*5.8
}
texture {
  pigment {
    gradient y
    colour_map {
      [0   0.5 colour Clear    colour Clear    ]
      [0.5 1   colour Gridgray colour Gridgray ]
    }
  }
  finish { specular layer_specular }
  translate y*-0.5
  scale <1, 25, 1>
  rotate x*60.71
  translate <0, 5.9, 4>
}
texture {
  pigment {
    gradient y
    colour_map {
      [0   0.5 colour Clear    colour Clear    ]
      [0.5 1   colour Gridgray colour Gridgray ]
    }
  }
  finish { specular layer_specular }
  translate y*-0.5
  scale <1, 25, 1>
  translate y*5.9
}
texture {
  pigment {
    gradient y
    colour_map {
      [0     0.501 colour Clear   colour Clear   ]
      [0.501 1     colour Hullcol colour Hullcol ]
      }
  }
  finish { specular layer_specular }
  translate y*-0.5
  scale <1, 25, 1>
  rotate x*60.71
  translate <0, 5.9, 4>
}
texture {
  pigment {
    gradient y
    colour_map {
      [0     0.48  colour Hullcol colour Hullcol ]
      [0.48  0.501 colour Clear   colour Clear   ]
      [0.501 1     colour Hullcol colour Hullcol ]
    }
  }
  translate y*-0.5
  scale <1, 25, 1>
  translate y*5.9
}

#declare Door_texture =
texture {
  pigment {
    gradient z
    colour_map {
      [0    0.01 colour Black colour Black]
      [0.01 1    colour Hullcol colour Hullcol]
    }
  }
}

#declare Secondary_hull_texture =
texture {
  pigment {
    gradient z
    colour_map {
      [0     0.128 colour Hullcol  colour Hullcol ]
      [0.128 0.129 colour Gridgray colour Gridgray]
      [0.129 0.215 colour Hullcol  colour Hullcol ]
      [0.215 0.216 colour Gridgray colour Gridgray]
      [0.216 0.302 colour Hullcol  colour Hullcol ]
      [0.302 0.303 colour Gridgray colour Gridgray]
      [0.303 0.389 colour Hullcol  colour Hullcol ]
      [0.389 0.390 colour Gridgray colour Gridgray]
      [0.390 0.476 colour Hullcol  colour Hullcol ]
      [0.476 0.477 colour Gridgray colour Gridgray]
      [0.477 0.620 colour Hullcol  colour Hullcol ]
      [0.620 0.621 colour Gridgray colour Gridgray]
      [0.621 1     colour Hullcol  colour Hullcol ]
    }
  }
  finish { specular layer_specular }
  scale <1, 1, 25>
}
texture {
  pigment {
    gradient y
    colour_map {
      [0      0.0005 colour Gridgray colour Gridgray]
      [0.0005 1      colour Clear    colour Clear   ]
    }
  }
  finish { specular layer_specular }
  scale <1, 25, 1>
  translate y*0.2
}
texture {
  pigment {
    gradient z
    colour_map {
      [0     0.201 colour Gridgray colour Gridgray]
      [0.201 1     colour Clear    colour Clear   ]
     }
  }
  finish { specular layer_specular }
  scale <1, 1, 25>
  translate z*-5
  rotate x*-34
  translate <0, 1.3, -16.6>
}
texture {
  pigment {
    wood
    turbulence 0
    colour_map {
      [0     0.199 colour Clear    colour Clear   ]
      [0.199 0.2   colour Gridgray colour Gridgray]
      [0.2   1     colour Hullcol  colour Hullcol ]
    }
  }
  finish { specular layer_specular }
  rotate y*90
  scale <1, 50, 50>
  translate <0, -203.3, -4>
}
texture {
  pigment {
    wood
    turbulence 0
    colour_map {
      [0     0.268 colour Hullcol  colour Hullcol ]
      [0.268 0.399 colour Clear    colour Clear   ]
      [0.399 0.4   colour Gridgray colour Gridgray]
      [0.4   1     colour Hullcol  colour Hullcol ]
    }
  }
  finish { specular layer_specular }
  rotate y*90
  scale <1, 50, 50>
  translate <0, 58.4, -4>
}
texture {
  pigment {
    gradient z
    colour_map {
      [0   0.2 colour Hullcol colour Hullcol]
      [0.2 1   colour Clear   colour Clear  ]
    }
  }
  finish { specular layer_specular }
  scale <1, 1, 25>
  translate z*-5
  rotate x*-34
  translate <0, 1.3, -16.6>
}
texture {
  pigment {
    gradient z
    colour_map {
      [0     0.056 colour Hullcol colour Hullcol]
      [0.056 1     colour Clear   colour Clear  ]
    }
  }
  finish { specular layer_specular }
  scale <1, 1, 25>
}


#declare Secondary_hull_stripe =
texture {
  pigment { image_map { gif "sechull.gif" once map_type 0 interpolate 2 } }
  // Compensate the half pixel translation caused by interpolation
  translate <0, 0.01041666, 0.00069444>
  scale <1, 0.6, -9>
  translate <0, -0.4, 0.1625>
}

#declare Secondary_hull_left_texture =
texture { Secondary_hull_texture }
texture { Secondary_hull_stripe }

#declare Secondary_hull_right_texture =
texture { Secondary_hull_texture }
texture {
  Secondary_hull_stripe
  scale <1, 1, -1>
  translate z*-6.7
}

#declare Back_texture =
texture {
  pigment { colour Hullcol }
  finish { specular layer_specular }
}
texture {
  pigment { image_map { gif "back.gif" once map_type 0 interpolate 2 } }
  // Compensate the half pixel translation caused by interpolation
  translate <0.0028409, 0.03333333, 0>
  scale <2, 0.2, 1>
  translate <-1, -0.25, 0>
}

//
// Textures for nacelles.inc
//

#declare Nacelle_interior_texture =
texture {
  pigment {
    gradient y
    colour_map {
      [0   0.5 colour NewMidnightBlue colour Black]
      [0.5 1   colour Black colour NewMidnightBlue]
    }
  }
  finish { specular 1 roughness 0.01 }
  scale 0.15
}

#declare NCC_1701_A_texture =
texture {
  pigment { colour Hullcol }
  finish { specular layer_specular }
}
texture {
  pigment { image_map { gif "ncc1701a.gif" map_type 0 once interpolate 2 } }
  scale <1, 0.5, 2.5>
}