
global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;
//
// BIG_E.POV
//
// Written by Ville Saari
//
// Created: 25-Sep-92
// Updated: 22-Jan-93
//
// PoV-Ray scene description for the starship U.S.S Enterprise
// NCC-1701-A
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
// Get the definition for the starship
//
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "big_e.inc"

//
// Very distant light source
//
light_source { <-10000000, -100000, -5000000> colour White }

//
// A planet from planet.pov
//
union {
   sphere { 0, 3000000
    texture {
      pigment {
        bozo
        turbulence 0.5
        color_map {
          [0   0.7  color MediumBlue  color MediumBlue ]
          [0.7 1    color ForestGreen color Bronze2    ]
          [1.0 1.01 color Bronze2     color Brown      ]
        }
      }
      finish { crand 0.08 }
      scale 700000
      translate y*5000000
    }
   }
   sphere { 0, 3005000
     texture {
       pigment {
         bozo
         turbulence 1
         color_map {
           [0   0.4 color Clear color Clear ]
           [0.4 0.9 color Clear color White ]
           [0.9 1   color White color White ]
         }
       }
       scale <240000, 60000, 240000>
     }
   }
   translate z*-5700000
   rotate <0, -40, -30>
}

//
// The observer
//
camera {
   location <-400, -160, 1600>
   direction z*12.1
   right x*4/3
   sky <-7, 90, 0>
   look_at <12, -15, 0>
   }

//
// And the starship
//
object { NCC_1701_A }