//
// BIG_E.INC (BIG_E.POV)
//
// Written by Ville Saari
//
// Created: 21-Sep-92
// Updated: 22-Jan-93
//
// PoV-Ray object descscription for the starship U.S.S. Enterprise
// NCC-1701-A
//
// This file creates following declaration to be externally used:
//
//     Starship U.S.S. Enterprise:
//         composite { NCC_1701_A }
//
// Enterprise is heading to positive z and it's centered around origin,
// its dimensions are:
//
//     x: +/-  71.24
//     y: +/-  35.36
//     z: +/- 150.02
//
// Scale is so selected that one unit equals to one meter.
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "bigetext.inc"
#include "saucer.inc"
#include "sechull.inc"
#include "nacelles.inc"

#declare NCC_1701_A =
union {
  object { Saucer }
  object { Inter_connecting_dorsal }
  object { Secondary_hull }
  object { Left_warp_nacelle }
  object { Right_warp_nacelle }
  object { Left_nacelle_pylon }
  object { Right_nacelle_pylon }
  scale 5.2
  bounded_by { box { <-71.24, -35.36, -150.02>, <71.24, 35.36, 150.02> } }
  bounded_by { sphere { 0, 170 } }
}