//------ Surrounding World for the Nest
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "sky.inc"
#include "cloud.map"

#declare sky_color = color rgb <0.292, 0.316, 0.39>;
#declare fog_color = color rgb <0.765, 0.675, 0.616>;

fog { color fog_color distance 600000 }

#include "sky1.map"
#include "cloud2.map"

#declare sky_blend_1 =
pigment { gradient y turbulence 0.1 color_map { sky1 } }

#declare gray_clouds =
pigment {
//  bozo
    gradient y
    turbulence 0.4
    color_map { cloud2 }
}

//---- Sky Dome
object {
  SkyDome
  no_shadow
  texture {
    pigment { sky_blend_1 }
    finish {
      ambient 1
      diffuse 0
      phong 0
    }
    scale <50000, 25000, 50000>
  }
  texture {
    pigment { gray_clouds }
    finish {
      ambient 1
      diffuse 0
      phong 0
    }
    scale <20000, 29500, 20000>
  }
}