//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
global_settings {
  //assumed_gamma 1
  //ambient_light -0.1
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "textures.inc"
#include "Stat.inc"  // Added by CJF
#include "Hallway.inc"
#include "ToyTrain.inc"

camera {
  location <0, 200, -750>
  direction z*1.6
  up y
  right x*image_width/image_height
  look_at y*120
}

light_source { < 100, 700, -800> color rgb 1 }
light_source { <-400, 200, -400> color rgb 1 }

//fog { color Black distance 3500 }

// ---------------- BUILD STAGE --------------------------------------------
object {
  THE_FLOOR
  scale <0.6, 0.8, 0.6>
  rotate x*90
  translate <50, -14, 2020>
}
object {
  TRAIN
  //scale 1
  rotate y*30
  translate <130, -12, -100>
}

// -----------------TEST FLOOR -----------------------
//object {
//  plane { y, -14 }
//  pigment { color Gray }
//}

// ---------------CREATE WORLD SPHERES-----------
//sphere { 0, 1
//  hollow on
//  scale <3000, 3000, 6000>
//  texture {
//    pigment { color Black }
//    finish { ambient 1 }
//  }
//}

#declare Zenith = rgb <0, 0, 0.93>;
#declare MidSky = rgb <0.55, 0.55, 1>;
#declare HighHorizon = rgb <0.73, 0.73, 0.98>;
#declare GroundColor = ForestGreen;
#declare Rose = rgb <0.96, 0.59, 0.66>;
#declare LowHorizon = CadetBlue;

#declare Clouds1 =
texture {
  pigment {
    bozo
    turbulence 0.6
    color_map {
      [0.0 0.5   color White filter 1.0 color White filter 1.0]
      [0.5 0.8   color White filter 0.5 color Rose]
      [0.8 1.001 color Rose color DimGray ]
    }
    scale <1, 0.7, 1>
  }
}

// -----------------Sky sphere-------------------------------------
sphere { 0, 1
  hollow on
  scale <3000, 3000, 6000>
  texture {
    pigment {
      gradient y
      color_map {
        [0.0  0.1  color LowHorizon color HighHorizon]
        [0.1  0.15 color HighHorizon color HighHorizon]
        [0.15 0.7  color HighHorizon color MidSky]
        [0.7  0.9  color MidSky color Zenith]
        [0.9  1.01 color Zenith color LowHorizon]
      }
    }
    finish { ambient 0}
    scale <6000, 6000, 1600>
  }
  texture { Clouds1 scale <1000, 550, 2050> }
  translate z*400
}
// ---THANKS DAN--


// -----------------------------BACK DROP----------------------------
plane { z, 4000
  texture {
    pigment { color Black }
    finish { ambient 1}
  }
}

// -----------------------------Front DROP----------------------------
box { -1, 1
  scale <2000, 2000, 5>
  texture {
    pigment {
      image_map { 
        //<1, -1, 0>
        //gif "f1.gif"
        png "fract003.png"
      }
      scale <4000, 4000, 5>
      translate <-2000, -2000, -5>
    }
    finish { ambient 0.4 diffuse 0 }
  }
  translate <0, 1500, -1220>
  rotate y*30
}

// --------TEST OBJECTS---------------
//union {
//  sphere { 0, 100 translate y*100 }
//  box { -70, 70 rotate y*70 translate <-170, 20, 80> }
//  object { Y_Disk scale <70, 200, 70> translate <130, 0, -70> }
//  texture { GOLD }
//  translate z*-100
//}