//------ Toy Train 1993
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#include "Texture.INC"

//-----  Gold Stack
#declare stack1 =
union {
  object { Y_Disk scale <5, 20, 5> }
  object { Y_Disk scale <8, 10, 8> translate y*20 }
}

//----- Side Panels
#declare side_panel =
object {
  union {
    box { -1, 1 scale <65, 35,   2.5> }
    box { -1, 1 scale <55, 25,   7.5> }
    box { -1, 1 scale <85, 10,   2.5> translate <150, - 5,   0> }
    box { -1, 1 scale <25,  6,   7>   translate <130, -50,   1> }
    box { -1, 1 scale <10, 17,   7>   translate <115, -38,   1> }
    box { -1, 1 scale <60,  2.5, 2.5> translate <120, -22.5, 0> }
  }
  texture { bod_color5 }
  bounded_by { box { -1, 1 scale <160, 60, 8> translate <85, -10, 0> } }
}

//---- Spoke
#declare spoke = object { X_Disk scale <84, 5, 4> translate x*-42 }

//---- Large Wheel
#declare wheel =
union {
  object {
    union {
      object { spoke }
      object { spoke rotate z*45 }
      object { spoke rotate z*90 }
      object { spoke rotate z*-45 }
      object { Z_Disk scale <20, 20, 10> translate z*-5 }
      object { Z_Disk scale 10 translate z*-8 }
    }
    texture { bod_color2 }
    bounded_by { Z_Disk scale <48, 48, 18> translate z*-9 }
  }
  object {
    difference {
      object { Z_Disk scale <45, 45, 12> translate z*-6 }
      object { Cylinder_Z  scale <40, 40, 1> }
    }
    texture { silver }
    bounded_by { Z_Disk scale <48, 48, 13> translate z*-6.5 }
  }
  bounded_by { Z_Disk scale <48, 48, 12> translate z*-6 }
}

//--- Small Wheel
#declare s_wheel = object { wheel scale <0.6, 0.6, 1> }

#declare cow =
object {
  intersection {
    plane {  z, 1 }
    plane { -z, 1.1 }
    plane { -y, 1 }
    plane {  x, 0.5 rotate  z*45 translate y*-0.5 rotate x*-45 }
    plane { -x, 0.5 rotate z*-45 translate y*-0.5 rotate x*-45 }
  }
}

//--- Thick Gold Railing
#declare thick_rail =
object {
  union {
    sphere { 0, 5 }
    sphere { 0, 5 translate x*130 }
    sphere { 0, 5 translate <130, -30, 0> }
    sphere { 0, 5 translate <300, -30, 0> }
    sphere { 0, 5 translate <350, -80, 0> }
    sphere { 0, 5 translate <370, -80, 0> }
    object { X_Disk scale <130, 5, 5> }
    object { X_Disk scale <170,  5, 5> translate <130, -30, 0> }
    object { Y_Disk scale <  5, 30, 5> translate <130, -30, 0> }
    object { X_Disk scale < 20,  5, 5> translate <350, -80, 0> }
    object { X_Disk scale < 70,  5, 5> rotate z*-45 translate <300, -30, 0> }
  }
  texture { bod_color4 }
  bounded_by { box { -1, 1 scale <200, 70, 10> translate <190, -35, 0> } }
}

#declare post = sphere { 0, 1 scale <4, 4, 8> }

#declare thin_rail =
object {
  union {
    object { post }
    object { post translate x*120 }
    object { post translate x*240 }
    object { X_Disk scale <240, 2, 2> translate z*-2 }
  }
  texture { bod_color4 }
  bounded_by { X_Disk scale <250, 9, 9> translate x*-5 }
}

//---- Wheel Mechanics
#declare wheel_drive =
object {
  union {
    object { Z_Disk scale <7, 7, 12> translate z*-4 }
    object { Z_Disk scale <7, 7, 12> translate <130, 0, -4> }
    object { Z_Disk scale <7, 7, 12> translate <150, 25, -4> }
    box { -1, 1 scale <65, 3, 2> translate <65, 0, 0> }
    box { -1, 1 scale <15, 3, 2> rotate z*40 translate <140, 10, 0> }
    box { -1, 1 scale <55, 3, 2> translate <140, 39, 4> }
  }
  texture { silver }
  bounded_by { box { -1, 1 scale <130, 40, 12> translate <120, 20, 0> } }
}

//----- Complete Train
#declare TRAIN = 
object {
  union {
    union {
      union {
      //---- trunk
        object {
          union {
            object { X_Disk scale <240, 50, 50> }
            object { X_Disk scale < 20, 30, 20> translate <160, 50, 0> }
            sphere { 0, 1 scale <30, 30, 20> translate <160, 50, 0> }
            sphere { 0, 1 scale <30, 30, 20> translate <180, 50, 0> }
            box { -1, 1 scale <120, 3, 55> translate x*120 }
          }
          texture { bod_color1 }
          bounded_by { X_Disk scale <250, 70, 56> translate <-5, 10, 0> }
        }
        //--- Brass ring
        object {
          union {
            sphere { 0, 1 scale <5, 55, 55> translate  x*95 }
            sphere { 0, 1 scale <5, 55, 55> translate x*175 }
            sphere { 0, 1 scale <5, 55, 55> translate x*240 }
            box { -1, 1 scale <120, 3, 55> translate x*120 }
          }
          texture { bod_color4 }
          bounded_by { X_Disk scale <250, 70, 56> translate <-5, 10, 0> }
        }
        translate <-330 130 0>
      }
      //--- Top Cabin
      union {
        object {
          difference {
            union {
              box { -1, 1 scale <35, 10, 20> translate <75, 90, 0> }
              object { X_Disk scale <150, 93, 93> }
            }
            plane { y, 60 }
          }
          texture { bod_color2 }
          translate <-85, 0, 0>
        }
        //---- Cabin
        object {
          difference {
            box { -1, 1 scale <55, 60, 70> }
            box { -1, 1 scale <10, 20, 80> translate <-35,  30, 0> }
            box { -1, 1 scale <30, 20, 80> translate < 15,  30, 0> }
            box { -1, 1 scale <50, 50, 65> translate y*5 }
            box { -1, 1 scale <40, 20, 80> translate < 25, -60, 0> }
          }
          texture {
            material_map {
              // <1 -1 0>
              gif "tcabin.gif"
              // png "tcabin.png"
              texture { bod_color1 finish { phong 0.5 phong_size 50 diffuse 0.9 } } // Black
              texture { bod_color2 finish { phong 0.5 phong_size 50 diffuse 0.9 } } // Brown
              texture { bod_color3 finish { phong 0.5 phong_size 50 diffuse 0.9 } } // Red
              texture { bod_color4 finish { phong 0.5 phong_size 50 diffuse 0.9 } } // Gold
            }
            scale <110, 120, 1>
            translate <-55, -60, -1>
          }
          bounded_by { box { -80, 80 translate <-10, 20, 0> } }
        }
        translate <-385, 130, 0>
      }
      object {
        union {
          sphere { 0, 1 scale < 5, 55, 55> translate x*80 }
          sphere { 0, 1 scale <10, 45, 45> translate x*80 }
          sphere { 0, 1 scale 10 translate <70, 60, 0> }
          object { X_Disk scale <80, 50, 50> }
          object { X_Disk scale <10, 15, 15> translate x*87 }
          object { X_Disk scale <20, 10, 10> translate <70, 60, 0> }
          object { Y_Disk scale <15, 20, 15> translate <25, 50, 0> }
          object { Y_Disk scale <25,  5, 25> translate <25, 70, 0> }
          object { DCone scale  <30, 65, 30> translate <25, 40, 0> }
        }
        texture { bod_color6 }
        bounded_by { box { -1, 1 scale <60, 95, 60 > translate <50, 30, 0> } }
        translate <-90, 130, 0>
      }
      //--- Train Frame
      object {
        union {
          box { -1, 1 scale <235, 30, 40> }
          box { -1, 1 scale < 25, 40, 80> translate x*130 }
          box { -1, 1 scale < 40, 15, 20> translate <-225, -25, 0> }
          box { -1, 1 scale < 15, 30, 85> translate x*130 }
          box { -1, 1 scale < 40,  3, 70> translate x*195 }
        }
        texture { bod_color5 }
        bounded_by { box { -1, 1 scale <270, 60, 90 > } }
        translate <-200, 60, 0>
      }
      //---- Stacks
      object {
        union {
          object { stack1 translate <-285, 210, 0> }
          object { stack1 translate <-245, 190, 0> }
          object { stack1 translate <-225, 190, 0> }
          object { stack1 scale < 2,  1,  2> translate <-160, 200, 0> }
          object { Y_Disk scale <15, 40, 15> translate <-285, 170, 0> }
          sphere { 0, 1 scale <15, 10, 15> translate <-285, 210, 0> }
          object { Y_Disk scale <20, 20, 20> translate <-235, 170, 0> }
          object { Y_Disk scale <35, 10, 35> translate < -65, 230, 0> }
          object { Y_Disk scale <25, 10, 25> translate < -65, 240, 0> }
          object { X_Disk scale 10 translate y*190 }
        }
        texture { bod_color4 }
//        bounded_by { bo { -1, 1 scale <180, 50, 45> translate <-130, 210, 0> } }
      }
      object { side_panel translate <-265, 105, -67.5> }
      object { side_panel translate <-265, 105,  67.5> }
      object { wheel translate <-280, 45, -50> }
      object { wheel translate <-280, 45,  50> }
      object { wheel translate <-150, 45, -50> }
      object { wheel translate <-150, 45,  50> }
      object { s_wheel translate <0, 28, -50> }
      object { s_wheel translate <0, 28,  50> }
      object { thick_rail translate <-330, 140,  67.5> }
      object { thick_rail translate <-330, 140, -67.5> }
      object { thin_rail translate <-300, 160,  45> }
      object { thin_rail translate <-300, 160, -45> }
      object { wheel_drive translate <-270, 30,  67.5> }
      object { wheel_drive translate <-270, 30, -71.5> }
      union {
        //--- Cow Catcher
        object {
          difference {
            object { cow scale <10, 5, 10> }
            box { -1, 1 scale <1, 5, 20> translate <  1.5, 1, 0> }
            box { -1, 1 scale <1, 5, 20> translate <  4.5, 1, 0> }
            box { -1, 1 scale <1, 5, 20> translate <  7.5, 1, 0> }
            box { -1, 1 scale <1, 5, 20> translate < -1.5, 1, 0> }
            box { -1, 1 scale <1, 5, 20> translate < -4.5, 1, 0> }
            box { -1, 1 scale <1, 5, 20> translate < -7.5, 1, 0> }
            box { -1, 1 scale <1, 5, 20> translate <-10.5, 1, 0> }
            box { -1, 1 scale <1, 5, 20> translate < 10.5, 1, 0> }
            object { cow scale <10, 5, 10> translate <0, -0.5, 2> }
          }
          texture { silver }
          bounded_by { box { -1, 1 scale <10, 5, 10> } }
          scale <4.8, 5, 4> translate <0, -10, -45>
        }
        box { -1, 1 scale <70, 30, 5> texture { bod_color5 } }
        rotate y*-90
        scale <0.7, 1, 1.1>
        translate <43, 45, 0>
      }
      sphere { 0, 1 scale <5, 10.3, 10.3> translate <10, 130, 0> texture { bod_color4 } }
      bounded_by { box { -1, 1 scale <330, 140, 120> translate <-160, 130, 0> } }
    }
    //--- Smoke
    object {
      merge {
        sphere { 0, 1 scale < 15, 40, 15> }
        sphere { 0, 1 scale 20 translate y*30 }
        sphere { 0, 1 scale < 25, 20, 25> translate < -10,  50, 0> }
        sphere { 0, 1 scale < 30, 25, 30> translate < -40,  60, 0> }
        sphere { 0, 1 scale < 50, 25, 35> translate < -60,  70, 0> }
        sphere { 0, 1 scale <170, 25, 40> translate < -90,  80, 0> }
        sphere { 0, 1 scale <170, 25, 40> translate <-100, 100, 0> }
        sphere { 0, 1 scale < 50, 10, 30> translate <-120, 110, 0> }
      }
      texture { Smokey } // Changed this to a "declared" texture - see TextureCJF.INC
      bounded_by { box { -1, 1 scale <400, 120, 50> translate <-160, 30, 0> } }
      scale <1, 1.2, 1>
      translate <-65, 265, 0>
    }
//    scale 2
//    translate <-1170, 20, 800>
  }
}