/*------------ SHAPES DATA ---------------------------------*/
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Cylinder_X = quadric { <0, 1, 1>, 0, 0, -1 }
#declare Cylinder_Y = quadric { <1, 0, 1>, 0, 0, -1 }
#declare Cylinder_Z = quadric { <1, 1, 0>, 0, 0, -1 }
#declare Cone_X = quadric { <-1,  1,  1>, 0, 0, 0 }
#declare Cone_Y = quadric { < 1, -1,  1>, 0, 0, 0 }
#declare Cone_Z = quadric { < 1,  1, -1>, 0, 0, 0 }

#declare DCone = /*---------CONE POINT DOWN /POINT at 000--------*/
intersection {
  object { Cone_Y scale 1 }
  plane { -y, 0 }
  plane {  y, 1 }
}

#declare UCone = /*---------CONE POINT UP /POINT at 000--------*/
intersection {
  object { Cone_Y scale 1 }
  plane { y,  0 }
  plane { y, -1 inverse }
}

/*
#declare Cube =
intersection {
  plane {  z, 1 }
  plane { -z, 1 }
  plane {  y, 1 }
  plane { -y, 1 }
  plane {  x, 1 }
  plane { -x, 1 }
}
*/

#declare X_Disk = intersection {       /* Capped cylinder, Length in x axis */
  object { Cylinder_X }
  plane { x, 0 inverse }
  plane { x, 1 }
}

#declare Y_Disk = intersection {       /* Capped cylinder, Length in y axis */
  object { Cylinder_Y }
  plane { y, 0 inverse }
  plane { y, 1 }
}

#declare Z_Disk = intersection {       /* Capped cylinder, Length in z axis */
  object { Cylinder_Z }
  plane { z, 0 inverse }
  plane { z, 1 }
}

// #declare Sphere = sphere { 0, 1 }
// #declare UnitBox = box { -1, 1 }
// #declare Cube = object { UnitBox }
// #declare QSphere = sphere { 0, 1 }