// This data declares Hardwood, A Floor & walls w/base moulding
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

// Light TAN to D.BROWN

// #declare BR01 = color rgb <1.00, 0.94, 0.71>;
// #declare BR02 = color rgb <1.00, 0.88, 0.65>;
// #declare br03 = color rgb <0.94, 0.80, 0.59>;
// #declare BR03 = color rgb <0.94, 0.80, 0.59>;
// #declare BR04 = color rgb <0.80, 0.69, 0.52>;
// #declare BR05 = color rgb <0.72, 0.63, 0.46>;
// #declare BR06 = color rgb <0.78, 0.63, 0.46>;
// #declare BR07 = color rgb <0.74, 0.59, 0.49>;
// #declare BR08 = color rgb <0.66, 0.51, 0.41>;
// #declare BR09 = color rgb <0.61, 0.50, 0.42>;
// #declare BR10 = color rgb <0.58, 0.45, 0.32>;
// #declare BR11 = color rgb <0.65, 0.45, 0.32>;
// #declare BR12 = color rgb <0.65, 0.41, 0.28>;
// #declare BR13 = color rgb <0.58, 0.41, 0.28>;
#declare BR14 = color rgb <0.57, 0.37, 0.24>;
#declare BR15 = color rgb <0.60, 0.37, 0.24>;
#declare BR16 = color rgb <0.54, 0.35, 0.25>;
#declare BR17 = color rgb <0.56, 0.31, 0.21>;
#declare BR18 = color rgb <0.45, 0.31, 0.16>;
#declare BR19 = color rgb <0.45, 0.31, 0.21>;
#declare BR20 = color rgb <0.41, 0.27, 0.17>;
#declare BR21 = color rgb <0.40, 0.24, 0.14>;
#declare BR22 = color rgb <0.37, 0.24, 0.11>;
#declare BR23 = color rgb <0.37, 0.24, 0.18>;
#declare BR24 = color rgb <0.34, 0.21, 0.15>;
#declare BR25 = color rgb <0.40, 0.21, 0.15>;
#declare BR26 = color rgb <0.32, 0.19, 0.07>;
#declare BR27 = color rgb <0.30, 0.14, 0.02>;
#declare BR28 = color rgb <0.30, 0.14, 0.10>;
#declare BR29 = color rgb <0.24, 0.16, 0.12>;
#declare BR30 = color rgb <0.25, 0.13, 0.09>;
#declare BR31 = color rgb <0.21, 0.09, 0.05>;

#declare POP_WOOD =
texture { 
  pigment {
    marble
    color_map {
      [0.0 0.2  color BR16 color BR16]	
      [0.2 0.4  color BR16 color BR14]
      [0.4 0.6  color BR14 color BR17]
      [0.6 0.8  color BR17 color BR17]
      [0.8 0.9  color BR17 color BR14]
      [0.9 1.01 color BR14 color BR16]
    }
    turbulence 0.4
    scale <13, 13, 1>
  }
  finish { ambient 0.8 phong 0.5 }
}
texture {
  pigment {
    wood
    color_map {
      [0.0 0.05 color BR25            color BR25 filter 0.5]
      [0.05 0.2 color BR25 filter 0.5 color BR21 filter 1]
      [0.2 0.7  color BR21 filter 1   color BR21 filter 0.8]
      [0.7 0.8  color BR27 filter 0.7 color BR27 filter 1]
      [0.8 0.9  color BR27 filter 1   color BR27 filter 0.7]
      [0.9 1.01 color BR27 filter 1   color BR30 filter 0.5]
    }
    turbulence 0.5
    scale <5, 15, 1>
  }
  finish { ambient 0.9 phong 1 }
}

#declare ZEB_WOOD =
texture {
  pigment {
    marble
    color_map {
      [0.0 0.2  color BR16 color BR16]	
      [0.2 0.4  color BR16 color BR14]
      [0.4 0.6  color BR14 color BR17]
      [0.6 0.8  color BR17 color BR17]
      [0.8 0.9  color BR17 color BR14]
      [0.9 1.01 color BR14 color BR16]
    }
    turbulence 0.25
    scale <13, 13, 1>
  }
  finish { ambient 0.3 diffuse 1.2 }
}
texture {
  pigment {
    wood
    color_map {
      [0.0 0.05 color BR25            color BR25 filter 0.7]
      [0.05 0.2 color BR25 filter 0.7 color BR21 filter 1]
      [0.2 0.7  color BR21 filter 1   color BR21 filter 0.8]
      [0.7 0.8  color BR27 filter 0.7 color BR27 filter 1]
      [0.8 0.9  color BR27 filter 1   color BR27 filter 0.7]
      [0.9 1.01 color BR27 filter 1   color BR30 filter 0.7]
    }
    turbulence 0.3
  }
  finish { ambient 0.6 diffuse 0.9 }
}
texture {
  pigment {
    wood
    color_map {
      [0.0 0.05 color BR25            color BR25 filter 0.4]
      [0.05 0.2 color BR25 filter 0.4 color BR21 filter 0.8]
      [0.2 0.7  color BR21 filter 0.8 color BR21 filter 0.9]
      [0.7 0.8  color BR27 filter 0.8 color BR27 filter 0.6]
      [0.8 0.9  color BR27 filter 0.6 color BR27 filter 0.4]
      [0.9 1.01 color BR27 filter 0.5 color BR30 filter 0.8]
    }
    turbulence 0.2
    scale <4, 20, 4>
  }
  finish { ambient 0.3 diffuse 0.9 }
}

// ------------------ MAKE HARDWOOD FLOOR ----------------------------------
#declare WT = 
texture {
  ZEB_WOOD
  scale <15, 30, 20>
  finish { phong 0.5 phong_size 20 reflection { 0.35 } crand 0.01 }
}

#declare PLANK = box { -1, 1 scale <100, 3000, 0.5> texture { WT } }

#declare THE_FLOOR =
union {
  object { PLANK texture { WT translate <-5, 17, 0> } }
  object { PLANK texture { WT translate y*60 } translate x*204 }
  object { PLANK texture { WT translate <10, 50, 0> rotate z*-10 } translate x*408 }
  object { PLANK texture { WT translate y*-70 } translate x*612 }
  object { PLANK texture { WT translate <2, -30, 0> } translate x*-204 }
  object { PLANK texture { WT translate y*-17 } translate x*-408 }
  object { PLANK texture { WT translate <5, -50, 0> rotate z*10 } translate x*-612 }
  object { PLANK texture { WT translate <7, -50, 0> } translate x*816 }
  object { PLANK texture { WT translate y*-50 rotate z*10 } translate x*1020 }
  object { PLANK texture { WT translate y*-100 } translate x*1224 }
  object { PLANK texture { WT translate y*-70 } translate x*1428 }
  object { PLANK texture { WT translate y*50 } translate x*1632 }
  object { PLANK texture { WT translate y*-50 } translate x*1836 }
  object { PLANK texture { WT translate y*-100 } translate x*2040 }
  object { PLANK texture { WT translate y*-70 } translate x*2244 }
  object { PLANK texture { WT translate y*50 } translate x*2448 }
  object { PLANK texture { WT translate <7, -50, 0> } translate x*-816 }
  object { PLANK texture { WT translate y*-50 rotate z*10 } translate x*-1020 }
  object { PLANK texture { WT translate y*-100 } translate x*-1224 }
  object { PLANK texture { WT translate y*-70 } translate x*-1428 }
  object { PLANK texture { WT translate y*50 } translate x*-1632 }
  object { PLANK texture { WT translate y*-50 } translate x*-1836 }
  object { PLANK texture { WT translate y*-100 } translate x*-2040 }
  object { PLANK texture { WT translate y*-70 } translate x*-2244 }
  object { PLANK texture { WT translate y*50 } translate x*-2448 }
  object { box { -1, 1 scale <1800, 3000, 1.2>  pigment { color Black } translate <0, -1, 20> } }
  bounded_by { box { -1, 1 scale <2720, 3000, 5> } }
}

// --------------------START THE WALLS-------------------------
#declare CWALL =
texture {
  pigment { color DarkSlateGray }
  finish { diffuse 0.7}
}

// ----------------  Build BaseBoards  ------------------------
#declare BASEBOARD =
object {
  difference {
    union {
      box { -1, 1 scale <300, 50, 120> translate y*50 }
      box { -1, 1 scale <290, 25, 110> translate y*125 }
      sphere { 0, 10 translate <290, 110, -110> }
      sphere { 0, 10 translate <290, 110,  110> }
      object { X_Disk scale <580, 10,  10> translate <-290, 110, -110> }
      object { Z_Disk scale < 10, 10, 220> translate < 290, 110, -110> }
      //Quarter Round
      sphere { 0, 20 translate < 300, -10, -120> }
      sphere { 0, 20 translate < 300, -10,  120> }
      sphere { 0, 20 translate <-300, -10, -120> }
      object { X_Disk scale <600, 20,  20> translate <-300, -10, -120> }
      object { Z_Disk scale < 20, 20, 240> translate < 300, -10, -120> }
      object { Z_Disk scale < 20, 20, 240> translate <-300, -10, -120> }
    }
    object { Cylinder_X scale < 1, 20, 20> translate <   0, 150, -110> }
    object { Cylinder_Z scale <20, 20,  1> translate < 290, 150,    0> }
    object { Cylinder_Z scale <20, 20,  1> translate <-290, 150,    0> }
  }
  texture {  pigment { color Gray } finish { ambient 0.2 diffuse 0.7 phong 1 } }
  bounded_by { box { -1, 1 scale <325, 80, 155> translate y*77 } }
}

// --------------- THE PLASTER WALL ------------------------------------
#declare PLASTER = box { -1, 1 scale <260, 750, 80> texture { CWALL } }

// -------------- WALL WITH BASE ATTACHED ------------------------------
#declare WALL =
union {
  object { PLASTER translate y*900 }
  object { BASEBOARD }
}