// Textures
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//  Copied all defined textures here, makes it nice and neat
//

#declare FinTex =
texture {
   pigment { image_map { gif "fin.gif" } }
   scale <250, 1, 125>
   translate z*-90
   finish { ambient 0.5 phong 1 }
}

#declare Glass =
texture {
  pigment { colour rgbf <1, 1, 1, 0.8> }
  finish { ambient 0 diffuse 0 phong 1 phong_size 100 }
}

//--- Bright Metallic Gold
#declare Gold2 =
texture {
   pigment { colour rgb <0.64, 0.51, 0.05> }
   finish { ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8 specular 0.5 crand 0.02 }
}

#declare stone4 =
texture {
   pigment { colour rgb <0.82, 0.57, 0.46> }
   finish { ambient 0.2 diffuse 0.8 phong 1 crand 0.09 }
}

#declare GrayStone1 =
texture {
   pigment {
      granite
      colour_map {
         [0 0.5 colour rgb 0.6 colour rgb 0.8]
         [0.5 1 colour rgb 0.7 colour rgb 0.4]
      }
   }
   finish { ambient 0.2 diffuse 0.6 phong 0.4 phong_size 80 crand 0.08 }
}

#declare GrayStone2 =
texture {
   pigment {
      granite
      colour_map {
         [0 0.5 colour rgb 0.5 colour rgb 0.7]
         [0.5 1 colour rgb 0.6 colour rgb 0.3]
      }
   }
   finish { ambient 0.2 diffuse 0.6 phong 0.4 phong_size 80 crand 0.08 }
}

#declare GrayStone3 =
texture {
   pigment {
      granite
      colour_map {
         [0 0.5 colour rgb 0.4 colour rgb 0.7]
         [0.5 1 colour rgb 0.6 colour rgb 0.3]
      }
   }
   finish { ambient 0.2 diffuse 0.6 phong 0.4 phong_size 80 reflection { 0.2 } crand 0.08 }
}

#declare GrayStone4 =
texture {
   pigment {
      granite
      colour_map {
         [0 0.5 colour rgb 0.6 colour rgb 0.8]
         [0.5 1 colour rgb 0.7 colour rgb 0.5]
      }
   }
   finish { ambient 0.2 diffuse 0.6 phong 0.4 phong_size 80 reflection { 0.3 } crand 0.08 }
}

#declare GrayStone5 =
texture {
   pigment {
      granite
      colour_map {
         [0 0.5 colour rgb 0.6 colour rgb <0.847059, 0.847059, 0.74902>]
         [0.5 1 colour rgb 0.7 colour rgb 0.5]
      }
   }
   finish { ambient 0.2 diffuse 0.6 phong 0.4 phong_size 80 reflection { 0.3 } crand 0.08 }
}

//---- Brass
#declare brass = texture {
   pigment {
      colour rgb <0.80, 0.58, 0.0> 
   }
   finish { ambient 0.4 diffuse 0.3 reflection { 0.5 } brilliance 6 phong 1.0 }
}

//--- Metalic Silver
#declare silver =
texture {
   pigment { colour rgb 0.7 }
   finish { ambient 0.4 diffuse 0.7 reflection { 0.9 } brilliance 7.0 specular 0.5 crand 0.02 }
}

#declare bod_color1 =
texture {
   pigment { colour rgb <0.7, 0, 0.1> }
   finish { diffuse 0.6 ambient 0.15 phong 1 phong_size 80 }
}

#declare bod_color2 =
texture {
   pigment { colour rgb <0.55, 0.09, 0.09> }
   finish { diffuse 0.4 ambient 0.15 phong 1 phong_size 80 }
}

#declare bod_color3 =
texture {
   pigment { colour rgb <0.7, 0, 0.1> }
   finish { diffuse 0.6 ambient 0.15 phong 1 phong_size 80 }
}

#declare bod_color4 = texture { Gold2 }

#declare bod_color5 =
texture {
   pigment { colour rgb 0.2 }
   finish { ambient 0.2 diffuse 0.6 phong 1 crand 0.03 }
}

#declare bod_color6 =
texture {
   pigment { colour rgb 0.15 }
   finish { diffuse 0.7 ambient 0.15 phong 1.0 phong_size 80 crand 0.03 }
}

#declare st1 =
texture {
   pigment {
      leopard
      turbulence 0.3
      colour_map {
         [0.000 0.175 colour rgb <1.000, 0.718, 0.541> colour rgb <0.890, 0.651, 0.612>]
         [0.175 0.316 colour rgb <0.890, 0.651, 0.612> colour rgb <1.000, 0.820, 0.675>]
         [0.316 0.386 colour rgb <1.000, 0.820, 0.675> colour rgb <0.816, 0.400, 0.345>]
         [0.386 0.447 colour rgb <0.816, 0.400, 0.345> colour rgb <0.937, 0.729, 0.561>]
         [0.447 0.632 colour rgb <0.937, 0.729, 0.561> colour rgb <0.878, 0.604, 0.565>]
         [0.632 0.754 colour rgb <0.878, 0.604, 0.565> colour rgb <0.984, 0.780, 0.655>]
         [0.754 0.842 colour rgb <0.984, 0.780, 0.655> colour rgb <1.000, 0.812, 0.608>]
         [0.842 0.982 colour rgb <1.000, 0.812, 0.608> colour rgb <1.000, 0.678, 0.478>]
         [0.982 1.001 colour rgb <1.000, 0.678, 0.478> colour rgb <1.000, 0.718, 0.541>]
      }
   }
   finish { crand 0.08 }
}

//-------------- creams & rose With high filter's for top layer
#declare st2 =
texture {
   pigment {
      marble
      turbulence 0.4
      colour_map {
         [0.000 0.175 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <0.843, 0.678, 0.655, 0.753>]
         [0.175 0.228 colour rgbf <0.843, 0.678, 0.655, 0.753> colour rgbf <0.906, 0.831, 0.773, 0.298>]
         [0.228 0.386 colour rgbf <0.906, 0.831, 0.773, 0.298> colour rgbf <0.992, 0.718, 0.545, 0.494>]
         [0.386 0.412 colour rgbf <0.992, 0.718, 0.545, 0.494> colour rgbf <0.333, 0.188, 0.067, 0.384>]
         [0.412 0.439 colour rgbf <0.333, 0.188, 0.067, 0.384> colour rgbf <0.925, 0.557, 0.514, 0.478>]
         [0.439 0.684 colour rgbf <0.925, 0.557, 0.514, 0.478> colour rgbf <0.984, 0.780, 0.655, 0.596>]
         [0.684 0.781 colour rgbf <0.984, 0.780, 0.655, 0.596> colour rgbf <0.965, 0.847, 0.675, 0.780>]
         [0.781 0.982 colour rgbf <0.965, 0.847, 0.675, 0.780> colour rgbf <1.000, 0.718, 0.541, 0.890>]
         [0.982 1.001 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <1.000, 0.718, 0.541, 0.890>]
      }
   }
}
 
#declare st3 =
texture {
   pigment {
      spotted
      turbulence 0.4
      colour_map {
         [0.000 0.202 colour rgb <1.000, 0.718, 0.541> colour rgb <0.890, 0.651, 0.612>]
         [0.202 0.298 colour rgb <0.890, 0.651, 0.612> colour rgb <1.000, 0.820, 0.675>]
         [0.298 0.377 colour rgb <1.000, 0.820, 0.675> colour rgb <0.890, 0.643, 0.612>]
         [0.377 0.465 colour rgb <0.890, 0.643, 0.612> colour rgb <0.937, 0.729, 0.561>]
         [0.465 0.544 colour rgb <0.937, 0.729, 0.561> colour rgb <0.878, 0.604, 0.565>]
         [0.544 0.640 colour rgb <0.878, 0.604, 0.565> colour rgb <0.984, 0.780, 0.655>]
         [0.640 0.860 colour rgb <0.984, 0.780, 0.655> colour rgb <1.000, 0.863, 0.635>]
         [0.860 0.982 colour rgb <1.000, 0.863, 0.635> colour rgb <1.000, 0.765, 0.620>]
         [0.982 1.001 colour rgb <1.000, 0.765, 0.620> colour rgb <1.000, 0.718, 0.541>]
      }
   }
   finish { crand 0.05 }
}

#declare st4 =
texture {
   pigment {
      spotted
      turbulence 0.4
      colour_map {
         [0.000 0.202 colour rgbf <0.788, 0.659, 0.573, 0.000> colour rgbf <0.749, 0.612, 0.592, 0.000>]
         [0.202 0.298 colour rgbf <0.749, 0.612, 0.592, 0.000> colour rgbf <0.733, 0.643, 0.565, 0.000>]
         [0.298 0.377 colour rgbf <0.733, 0.643, 0.565, 0.000> colour rgbf <0.663, 0.627, 0.608, 0.000>]
         [0.377 0.465 colour rgbf <0.663, 0.627, 0.608, 0.000> colour rgbf <0.706, 0.569, 0.478, 0.000>]
         [0.465 0.544 colour rgbf <0.706, 0.569, 0.478, 0.000> colour rgbf <0.686, 0.541, 0.525, 0.000>]
         [0.544 0.640 colour rgbf <0.686, 0.541, 0.525, 0.000> colour rgbf <0.835, 0.698, 0.624, 0.000>]
         [0.640 0.860 colour rgbf <0.835, 0.698, 0.624, 0.000> colour rgbf <0.765, 0.706, 0.596, 0.000>]
         [0.860 0.982 colour rgbf <0.765, 0.706, 0.596, 0.000> colour rgbf <0.600, 0.514, 0.459, 0.020>]
         [0.982 1.001 colour rgbf <0.600, 0.514, 0.459, 0.020> colour rgbf <0.788, 0.659, 0.573, 0.000>]
      }
   }
   finish { crand 0.05 }
}

//--------------  high filter's for top layer
#declare st5 =
texture {
   pigment {
      marble
      turbulence 0.5
      colour_map {
         [0.000 0.175 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <0.843, 0.678, 0.655, 0.753>]
         [0.175 0.228 colour rgbf <0.843, 0.678, 0.655, 0.753> colour rgbf <0.906, 0.831, 0.773, 0.980>]
         [0.228 0.386 colour rgbf <0.906, 0.831, 0.773, 0.698> colour rgbf <0.992, 0.718, 0.545, 0.794>]
         [0.386 0.412 colour rgbf <0.992, 0.718, 0.545, 0.794> colour rgbf <0.333, 0.188, 0.067, 0.784>]
         [0.412 0.439 colour rgbf <0.333, 0.188, 0.067, 0.784> colour rgbf <0.925, 0.557, 0.514, 0.778>]
         [0.439 0.684 colour rgbf <0.925, 0.557, 0.514, 0.678> colour rgbf <0.984, 0.780, 0.655, 0.696>]
         [0.684 0.781 colour rgbf <0.984, 0.780, 0.655, 0.696> colour rgbf <0.965, 0.847, 0.675, 0.880>]
         [0.781 0.982 colour rgbf <0.965, 0.847, 0.675, 0.880> colour rgbf <1.000, 0.718, 0.541, 0.990>]
         [0.982 1.001 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <1.000, 0.718, 0.541, 0.890>]
      }
   }
}

#declare st6 =
texture {
   pigment {
      marble
      turbulence 0.5
      colour_map {
         [0.000 0.193 colour rgbf <0.847, 0.753, 0.690, 0.000> colour rgbf <0.878, 0.812, 0.800, 0.000>]
         [0.193 0.281 colour rgbf <0.878, 0.812, 0.800, 0.000> colour rgbf <0.847, 0.796, 0.753, 0.000>]
         [0.281 0.368 colour rgbf <0.847, 0.796, 0.753, 0.000> colour rgbf <0.663, 0.627, 0.608, 0.000>]
         [0.368 0.447 colour rgbf <0.663, 0.627, 0.608, 0.000> colour rgbf <0.812, 0.725, 0.667, 0.000>]
         [0.447 0.526 colour rgbf <0.812, 0.725, 0.667, 0.000> colour rgbf <0.816, 0.733, 0.725, 0.000>]
         [0.526 0.623 colour rgbf <0.816, 0.733, 0.725, 0.000> colour rgbf <0.890, 0.800, 0.749, 0.000>]
         [0.623 0.833 colour rgbf <0.890, 0.800, 0.749, 0.000> colour rgbf <0.835, 0.796, 0.722, 0.000>]
         [0.833 0.982 colour rgbf <0.835, 0.796, 0.722, 0.000> colour rgbf <0.796, 0.753, 0.725, 0.020>]
         [0.982 1.001 colour rgbf <0.796, 0.753, 0.725, 0.020> colour rgbf <0.847, 0.753, 0.690, 0.000>]
      }
   }
}

/*-------------------DEEP THAN MARBLE1 With, For SECOND LAYERS--------*/
#declare st7 =
texture {
   pigment {
      marble
      turbulence 0.6
      colour_map {
         [0.000 0.291 colour rgbf <0.690, 0.612, 0.569, 1.000> colour rgbf <0.737, 0.596, 0.522, 0.500>]
         [0.291 0.316 colour rgbf <0.737, 0.596, 0.522, 0.500> colour rgbf <0.667, 0.561, 0.514, 0.300>]
         [0.316 0.436 colour rgbf <0.667, 0.561, 0.514, 0.300> colour rgbf <0.788, 0.667, 0.631, 0.500>]
         [0.436 0.641 colour rgbf <0.788, 0.667, 0.631, 0.500> colour rgbf <0.604, 0.506, 0.455, 0.700>]
         [0.641 0.692 colour rgbf <0.604, 0.506, 0.455, 0.700> colour rgbf <0.773, 0.612, 0.569, 0.400>]
         [0.692 1.001 colour rgbf <0.773, 0.612, 0.569, 0.400> colour rgbf <0.690, 0.612, 0.569, 1.000>]
      }
   }
   finish { crand 0.03 }
}

/*-------------------Yellows & Whites tints with high filter--------*/
#declare st8 = 
texture {
   pigment {
      marble
      turbulence 0.6
      colour_map {
         [0.000 0.103 colour rgbf <1.000, 1.000, 0.580, 0.576> colour rgbf <1.000, 0.835, 0.420, 0.737>]
         [0.103 0.328 colour rgbf <1.000, 0.835, 0.420, 0.737> colour rgbf <0.980, 0.980, 0.780, 0.718>]
         [0.328 0.474 colour rgbf <0.980, 0.980, 0.780, 0.718> colour rgbf <1.000, 1.000, 0.867, 0.761>]
         [0.474 0.603 colour rgbf <1.000, 1.000, 0.867, 0.761> colour rgbf <0.929, 0.753, 0.639, 0.741>]
         [0.603 0.690 colour rgbf <0.929, 0.753, 0.639, 0.741> colour rgbf <0.706, 0.580, 0.294, 0.839>]
         [0.690 0.836 colour rgbf <0.706, 0.580, 0.294, 0.839> colour rgbf <0.973, 0.788, 0.580, 0.831>]
         [0.836 1.001 colour rgbf <0.973, 0.788, 0.580, 0.831> colour rgbf <1.000, 1.000, 0.580, 0.576>]
      }
   }
   finish { crand 0.03 }
}

/*-------------------Grays & muted Greens--------*/
#declare st9 =
texture {
   pigment {
      marble
      turbulence 0.7
      colour_map {
         [0.000 0.155 colour rgb <0.259, 0.259, 0.259> colour rgb <0.341, 0.365, 0.341>]
         [0.155 0.328 colour rgb <0.341, 0.365, 0.341> colour rgb <0.310, 0.267, 0.310>]
         [0.328 0.474 colour rgb <0.310, 0.267, 0.310> colour rgb <0.318, 0.318, 0.235>]
         [0.474 0.750 colour rgb <0.318, 0.318, 0.235> colour rgb <0.427, 0.424, 0.420>]
         [0.750 0.871 colour rgb <0.427, 0.424, 0.420> colour rgb <0.306, 0.306, 0.247>]
         [0.871 0.983 colour rgb <0.306, 0.306, 0.247> colour rgb <0.337, 0.337, 0.333>]
         [0.983 1.001 colour rgb <0.337, 0.337, 0.333> colour rgb <0.259, 0.259, 0.259>]
      }
   }
   finish { crand 0.03 }
}


//-------------- creams & rose With high filter's for top layer
#declare st13 =
texture {
   pigment {
      marble
      turbulence 0.7
      colour_map {
         [0.000 0.175 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <0.843, 0.678, 0.655, 0.753>]
         [0.175 0.228 colour rgbf <0.843, 0.678, 0.655, 0.753> colour rgbf <0.906, 0.831, 0.773, 0.598>]
         [0.228 0.386 colour rgbf <0.906, 0.831, 0.773, 0.598> colour rgbf <0.992, 0.718, 0.545, 0.594>]
         [0.386 0.412 colour rgbf <0.992, 0.718, 0.545, 0.594> colour rgbf <0.333, 0.188, 0.067, 0.584>]
         [0.412 0.439 colour rgbf <0.333, 0.188, 0.067, 0.584> colour rgbf <0.925, 0.557, 0.514, 0.578>]
         [0.439 0.684 colour rgbf <0.925, 0.557, 0.514, 0.678> colour rgbf <0.984, 0.780, 0.655, 0.796>]
         [0.684 0.781 colour rgbf <0.984, 0.780, 0.655, 0.696> colour rgbf <0.965, 0.847, 0.675, 0.880>]
         [0.781 0.982 colour rgbf <0.965, 0.847, 0.675, 0.980> colour rgbf <1.000, 0.718, 0.541, 0.890>]
         [0.982 1.001 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <1.000, 0.718, 0.541, 0.890>]
      }
   }
}
 
//-------------- a More Tubulated st2
#declare st10 =
texture {
   pigment {
      marble
      turbulence 0.7
      colour_map {
         [0.000 0.175 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <0.843, 0.678, 0.655, 0.753>]
         [0.175 0.228 colour rgbf <0.843, 0.678, 0.655, 0.753> colour rgbf <0.906, 0.831, 0.773, 0.498>]
         [0.228 0.386 colour rgbf <0.906, 0.831, 0.773, 0.498> colour rgbf <0.992, 0.718, 0.545, 0.494>]
         [0.386 0.412 colour rgbf <0.992, 0.718, 0.545, 0.494> colour rgbf <0.333, 0.188, 0.067, 0.484>]
         [0.412 0.439 colour rgbf <0.333, 0.188, 0.067, 0.484> colour rgbf <0.925, 0.557, 0.514, 0.578>]
         [0.439 0.684 colour rgbf <0.925, 0.557, 0.514, 0.578> colour rgbf <0.984, 0.780, 0.655, 0.596>]
         [0.684 0.781 colour rgbf <0.984, 0.780, 0.655, 0.596> colour rgbf <0.965, 0.847, 0.675, 0.780>]
         [0.781 0.982 colour rgbf <0.965, 0.847, 0.675, 0.780> colour rgbf <1.000, 0.718, 0.541, 0.890>]
         [0.982 1.001 colour rgbf <1.000, 0.718, 0.541, 0.890> colour rgbf <1.000, 0.718, 0.541, 0.890>]
      }
   }
}

/*--------------------Crack & OverTint /Green---------------------*/
#declare st11 =
texture {
   pigment {
      marble
      turbulence 0.7
      colour_map {
         [0    0.05  colour rgbf 0 filter 0.6 colour rgb 0 filter 1.0]
         [0.05 0.95  colour rgbf <0.184314, 0.309804, 0.184314, 0.85> colour rgb 0.329412 filter 0.90]
         [0.95 1.001 colour rgb 0 filter 0.9 colour rgb 0 filter 1.0]
      }
   }
}


/*------------- THIN black CRACK ---------------*/
#declare butt_crack =
texture {
   pigment {
      marble
      turbulence 0.7
      colour_map {
         [0.000 0.026 colour rgbf <0.000, 0.000, 0.000, 0.922> colour rgbf <0.333, 0.333, 0.000, 1.000>]
         [0.026 0.383 colour rgbf <0.333, 0.333, 0.000, 1.000> colour rgbf <0.333, 0.333, 0.000, 1.000>]
         [0.383 0.426 colour rgbf <0.333, 0.333, 0.000, 1.000> colour rgbf <0.000, 0.000, 0.000, 0.257>]
         [0.426 0.461 colour rgbf <0.000, 0.000, 0.000, 0.257> colour rgbf <0.455, 0.333, 0.000, 0.714>]
         [0.461 0.522 colour rgbf <0.455, 0.333, 0.000, 0.714> colour rgbf <0.333, 0.333, 0.000, 0.996>]
         [0.522 0.965 colour rgbf <0.333, 0.333, 0.000, 0.996> colour rgbf <0.333, 0.333, 0.000, 1.000>]
         [0.965 0.983 colour rgbf <0.333, 0.333, 0.000, 1.000> colour rgbf <0.000, 0.000, 0.000, 0.731>]
         [0.983 1.001 colour rgbf <0.000, 0.000, 0.000, 0.731> colour rgbf <0.000, 0.000, 0.000, 0.422>]
      }
   }
   finish { crand 0.1 }
}

//--------- Clear with white feather Viens ----- This one does contain Filter
#declare Grnt22 =
texture {
   pigment {
      granite
      turbulence 0
      colour_map {
         [0    0.07 colour rgb 1 colour rgb 1]
         [0.07 0.2  colour rgb 1 colour rgb 0.329412 ]
         [0.2  0.3  colour 0.329412 colour rgbf 1]
         [0.3  0.7  colour rgbf 1 colour rgbf 1]
         [0.7  1    colour rgbf 1 colour 0.329412 ]
      }
   }
   finish { crand 0.08 }
}

//--------- White Feature Viens
#declare Grnt20a =
texture {
   pigment {
      granite
      turbulence 0
      colour_map {
         [0   0.2 colour rgb 1 filter 0   colour rgb 1 filter 0.7]
         [0.2 0.3 colour rgb 1 filter 0.7 colour rgbf 1 ]
         [0.3 1   colour rgbf 1           colour rgbf 1]
      }
   }
   finish { crand 0.02 }
}

//---------- Overtint, with Black Cracks
#declare Crack3 =
texture {
   pigment {
      marble
      turbulence 0.85
      colour_map {
         [0    0.04  colour rgb 0 filter 0.6 colour rgb 0 filter 1.0]
         [0.04 0.97  colour rgbf <0.184314, 0.309804, 0.184314, 0.80> colour rgbf <0.184314, 0.309804, 0.184314, 0.90>]
         [0.97 1.001 colour rgb 0 filter 0.9 colour rgb 0 filter 1.0]
      }
   }
   finish { crand 0.02 }
}

//--------- Overtint with White Crack
#declare Crack4 =
texture {
   pigment {
      marble
      turbulence 0.85
      colour_map {
         [0    0.03  colour rgb 1 filter 0.5 colour rgbf 1]
         [0.03 0.97  colour rgb 0 filter 0.7 colour rgb 0.329412 filter 0.9]
         [0.97 1.001 colour rgb 1 filter 0.7 colour rgbf 1]
      }
   }
}

//------- Red Swirl
#declare Grnt28 = 
texture {
   pigment { 
   marble
      turbulence 0.7
      colour_map {
         [0.000 0.155 colour rgb <0.686, 0.235, 0.282> colour rgb <0.686, 0.235, 0.282>]
         [0.155 0.328 colour rgb <0.686, 0.235, 0.282> colour rgb <0.494, 0.243, 0.294>]
         [0.328 0.474 colour rgb <0.494, 0.243, 0.294> colour rgb <0.769, 0.329, 0.373>]
         [0.474 0.647 colour rgb <0.769, 0.329, 0.373> colour rgb <0.769, 0.329, 0.373>]
         [0.647 0.810 colour rgb <0.769, 0.329, 0.373> colour rgb <0.686, 0.235, 0.282>]
         [0.810 0.922 colour rgb <0.686, 0.235, 0.282> colour rgb <0.792, 0.388, 0.427>]
         [0.922 1.001 colour rgb <0.792, 0.388, 0.427> colour rgb <0.686, 0.235, 0.282>]
      }
   }
   finish { crand 0.08 }
}

//--- Stair colours
#declare swall_col =
texture {
  st6
  finish { ambient 0.4 diffuse 0.7 }
  scale <40, 50, 2>
  rotate z*-25
}
texture {
  pigment { colour rgbf <0.40, 0.33, 0.33, 0.3> } 
  finish { diffuse 0.5 }
}
texture {
  butt_crack
  scale <90, 140, 50>
  finish { phong 1.0 }
}

#declare step_col =
texture {
  st6
  finish { ambient 0.3 diffuse 0.8 }
  scale <40, 50, 2>
  rotate z*-25
}
texture {
   pigment { colour rgbf <0.46, 0.33, 0.33, 0.5> }
   finish { diffuse 0.5 }
}
texture {
  butt_crack
  scale <52, 80, 90>
  finish { phong 1 reflection 0.2 }
}

//---- Checker Texture
#declare t1 =
texture {
  st6
  finish { ambient 0.2 diffuse 0.4 }
  scale <2.5, 2.3, 0.3>
  rotate z*40
}

#declare t2 =
texture {
  st6
  finish { /*ambient 0.4*/ diffuse 0.7 }
  scale <2.3, 3.5, 0.3>
  rotate z*-25
}

//------------- Red Marble with gray & white veining
#declare Stone21 =
texture { Grnt28 scale <1.3, 2.5, 1.7> rotate z*40 }
texture { Grnt22 scale <1, 2, 2> rotate z*40 }
texture { Crack4 scale <1, 0.6, 1> rotate <10, 0, -20> finish { phong 1 phong_size 90 } }

//-------------, Jade with white veining
#declare Stone18 =
texture { pigment { colour rgb <0.137255, 0.556863, 0.419608> } finish { ambient 0.3 diffuse 0.6 } }
texture { Grnt22 scale <1.5, 0.7, 0.5> rotate z*40 }
texture { Grnt20a scale <2.5, 2, 0.5> rotate z*-50 }
texture { Crack4 scale <0.7, 1, 1> rotate <10, 0, -20> finish { phong 1 phong_size 90 } }

//------------- Med Gray, with white veining
#declare GreenStone1 =
texture { pigment { colour rgb <0.4, 0.5, 0.45> } }
texture { Grnt22 scale <1.5, 0.7, 0.5> rotate z*40 }
texture { Crack4 scale <0.7, 1, 1> rotate <10, 0, -20> }
texture { pigment { colour rgbf <0.3, 0.3, 0.3, 0.8> } finish { phong 1 phong_size 90 ambient 0.1 crand 0.03 } }

//------------- Light Gray, with white veining
#declare GreenStone2 =
texture { pigment { colour rgb <0.4, 0.5, 0.45> } }
texture { Grnt22 scale <1.5, 0.7, 0.5> rotate z*40 }
texture { Crack4 scale <0.7, 1, 1> rotate <10, 0, -20> }
texture { pigment { colour rgbf <0.3, 0.3, 0.3, 0.8> } finish { phong 1 phong_size 90 ambient 0.1 crand 0.03 } }

#declare Smokey =  // Changed this to a "declared" texture - Colin Fleming - cj_fleming@btinternet.com
texture {
  pigment {
    bozo
    turbulence 0.4
    colour_map {
      [0.0 0.1   colour rgbf <1, 1, 1, 0.8> colour rgbf <1, 1, 1, 0.9> ]
      [0.1 0.5   colour rgbf <1, 1, 1, 0.9> colour rgbf <1, 1, 1, 0.8> ]
      [0.5 1.001 colour rgbf <1, 1, 1, 0.8> colour rgbf <1, 1, 1, 1> ]
    }
  }
  finish { crand 0.05 }
  rotate z*90
  scale <40, 30, 20>
}
texture {
  pigment {
    gradient y
    colour_map {
      [0.0 0.2  colour rgbf <1, 1, 1, 0.7> colour rgbf <1, 1, 1, 0.8>]
      [0.2 0.4  colour rgbf <1, 1, 1, 0.8> colour rgbf <1, 1, 1, 1>]
      [0.4 1.01 colour rgbf <1, 1, 1, 1>   colour rgbf <1, 1, 1, 1>]
    }
  }
  scale <300, 140, 40>
  translate y*-160
}

#declare BaseTexture =
texture { st6 scale <11, 5, 5> finish { ambient 0.2 diffuse 0.8 } }
texture { st7 scale <10, 11, 6> rotate z*-40 finish { phong 1.0 } }

#declare T1a =
texture { t1 finish { phong 1 ambient 0.1 reflection { 0.3 } } }
texture {
   pigment {
      checker
         colour rgb 0.329412 filter 0.2
         colour rgb 0.329412 filter 0.5
   }
   finish { phong 1 ambient 0.1 reflection { 0.3 } }
   scale <105, 107.8, 2>
}

#declare T2a =
texture { t2 finish { phong 1 ambient 0.1 reflection { 0.3 } } }
texture {
   pigment {
      checker
         colour rgb 0.329412 filter 0.2
         colour rgb 0.329412 filter 0.5
   }
   finish { phong 1 ambient 0.1 reflection { 0.3 } }
   scale <105, 107.8, 2>
}