/* ---------------------------------------------------------------

      Train Station 1993, Mike Miller

   ---------------------------------------------------------------
   
      Original file by Mike Miller

      Modified for POV-Ray version 3.x by
      Colin Fleming, cj_fleming@btinternet.com

   --------------------------------------------------------------- */

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;
                         
#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
                         
#include "Stat.INC"
#include "Texture.INC"    //This is all defined textures
                         
#include "ToyTrain.INC"
#include "Turn16-x.INC"
#include "Platform.INC"
#include "Fish.INC"
#include "World.INC"
#include "Vase.INC"
#include "Plant.INC"
#include "Scene.INC"      //This is everything combined
   
//---- Final Camera
#declare Cam1 = // Final scene
camera {
   location <1200, 450, -1770>
   direction z*2
   up y
   right x*image_width/image_height
   //right x*4/3
   look_at <-50, 160, 0>
}

#declare Cam2 = // Close-up of bannister
camera {
   location <50, 50, -700>
   direction z*1.5
   up y
   right x*image_width/image_height
   //right x*4/3
   look_at <50, -50, 0>
}

#declare Cam3 = // Deep angle towards stairs
camera {
   location <1200, 450, -1770>
   direction z*2
   up y
   right x*image_width/image_height
   //right x*4/3
   look_at <-50, -160, 0>
}

#declare Cam4 = // Close-up of stairs
camera {
   location <1200, 450, -1770>
   direction z*2
   up y
   right x*image_width/image_height
   //right x*4/3
   look_at x*-50
}

camera { Cam1 }

//--- Lights
light_source { < 4000,  300, -2000> color rgb 1 }
light_source { <-1000, 2000, -3000> color rgb 1 }
light_source { <-4000, 5000, -1500> color rgb 1 }
light_source { < 5000, 1000, 15000> color rgb 1 }
light_source { < 3000,  800,  -200> color rgb 1 }

//-------------------------------- Scene
object { Scene }
