// Station Platform
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//----- Lower Wall
#declare lower_wall =
union {

  //---- Wall Base
  object {
    union {
      box { -1, 1 scale <24, 3,  6> translate y*3 }
      box { -1, 1 scale <10, 3, 16> translate y*3 }
      box { -1, 1 scale <23, 5,  5> translate y*11 }
      box { -1, 1 scale < 9, 5, 15> translate y*11 }
      object { Y_Disk scale <8.5, 4, 8.5> translate <0, 16, -6> }
    }
    texture { st6 scale <15, 4, 3> finish { ambient 0.2 diffuse 0.8 } }
    texture { st7 scale <20, 12, 5> rotate z*-40 finish { phong 1 } }
    bounded_by { box { -1, 1 scale <25, 11, 17> translate y*12 } }
  }

  //---- Wall Base
  object {
    union {
      box { -1, 1 scale <24, 3,  6> translate y*3 }
      box { -1, 1 scale <10, 3, 16> translate y*3 }
      box { -1, 1 scale <23, 5,  5> translate y*11 }
      box { -1, 1 scale < 9, 5, 15> translate y*11 }
      object { Y_Disk scale <8.5, 4, 8.5> translate <0, 16, -6> }
    }
    texture { st6 scale <7, 4, 3> finish { ambient 0.2 diffuse 0.8 } }
    texture { st7 scale <10, 6, 5> rotate z*-40 finish { phong 1 } }
    bounded_by { box { -1, 1 scale <25, 11, 17> translate y*12 } }
    scale <1, 0.5, 1>
    rotate z*180
    translate y*100
  }

  //---- Ionic Capital
  union {
    object {
      union { //----------capital belly
        object { Y_Disk scale <8.5, 2, 8.5> }
        object { Y_Disk scale <9, 12, 9> translate y*2 }
        object { Z_Disk scale <4.5, 4.8, 12> translate <-8.5, 9.3, -10> }
        object { Z_Disk scale <4.5, 4.8, 12> translate <8.5, 9.3, -10> }
        sphere { 0, 1 scale <11, 1, 11> translate y*8 }
      }
      texture { stone4 }
      bounded_by { object { Y_Disk scale <17, 15, 17> translate <0, -0.5, -2> } }
    }
    object { turn16 rotate x*90 rotate z*90 translate <-8, 9, -9> }
    object { turn16 rotate x*90 rotate z*90 rotate y*180 translate <8, 9, -9> }
    object { X_Disk scale <16, 0.5, 3> translate <-8, 13.5, -9> } texture { stone4 }
    bounded_by { object { Y_Disk scale <22, 16, 22> translate <0, -1, -2> } }
    translate <0, 78, -6>
  }

  //--- Column
  object { Y_Disk scale <8, 58, 8>
    texture { st3 scale <6, 10, 1> finish { diffuse 0.5 } }
    texture { st2 scale <15, 20, 3> rotate z*35 finish { ambient 0.2 phong 1 phong_size 50 } }
    translate <0, 20, -6>
  }

  //--- Wall
  box { -1, 1 scale <22, 39, 4>
    texture { GreenStone2 scale <3, 2, 3> }
    translate y*54
  }
  bounded_by { box { -1, 1 scale <25, 55, 18> translate y*54 } }
}

//--- Large Arch Molding
#declare l_arch =
object {
  difference {
    object { Cylinder_Z scale <40, 40, 1> }
    object { Cylinder_Z scale <33, 33, 1> }
    plane { -z,  5 inverse }
    plane { -z, -5 }
    plane { -x,  0 }
  }
  texture { st6 scale <10, 4, 5> finish { ambient 0.2 diffuse 0.7 } }
  texture { st7 scale <10, 7, 5> rotate z*-40 finish { phong 1 } }
  bounded_by { box { -1, 1 scale <24, 24, 12> translate <-19, 22, 0> } }
}

//--- Apex molding
#declare apex =
object {
  difference {
    union {
      object { Cylinder_Z scale <9.375, 9.375, 1> translate x*-5 }
      object { Cylinder_Z scale <9.375, 9.375, 1> translate x*5 }
    }
    object { Cylinder_Z scale <5, 5, 1> translate x*-5 }
    object { Cylinder_Z scale <5, 5, 1> translate x*5 }
    plane { -z,  5 inverse }
    plane { -z, -5 }
    plane { -x, -5 }
    plane {  x, -5 }
  }
  texture { stone4 }
  bounded_by { box { -12, 12 translate 0 } }
}

//---- Small Arch molding
#declare s_arch = object { l_arch scale <0.625, 0.625, 0.9> }

#declare wedge_key =
object {
  union {
    intersection { 
      plane {  z, 1 }
      plane { -z, 1 }
      plane {  y, 1 }
      plane { -y, 1 }
      plane {  x, 1 rotate z*-20 }
      plane { -x, 1 rotate  z*20 }
      scale <10, 11, 14> translate z*2
    }
    intersection { 
      plane {  z, 1 }
      plane { -z, 1 }
      plane {  y, 1 }
      plane { -y, 1 }
      plane {  x, 1 rotate z*-20 }
      plane { -x, 1 rotate  z*20 }
      scale <20, 7.5, 12> translate <0, -2, 2>
    }
  }
  texture { st6 scale <5, 4, 3> finish { ambient 0.2 diffuse 0.8 } }
  texture { st7 scale <7, 3, 5> rotate z*-40 finish { phong 1 } }
  scale <0.4, 0.75, 0.5>
}

//---- Station Wall
#declare st_w =
union {

  //--- Station Roof
  object {
    union {
      box { -1, 1 scale <72, 3, 200> translate <0, 168, 185> }
      box { -1, 1 scale <68, 5, 200> translate <0, 175, 185> }
    }
    texture { GrayStone2 }
  }
  object { lower_wall translate x*-47 }
  object { lower_wall translate x*47 }
  object { l_arch translate <-5, 102, -10> }
  object { s_arch translate <-5, 100, 2> }
  object { l_arch rotate y*180 translate <5, 102, -10> }
  object { s_arch rotate y*180 translate <5, 100, 2> }

  //---- Upper wall
  object {
    union {
      difference {
        box { -1, 1 scale <55, 55, 4.5> translate <0, 55, -4.5> }
        object { Cylinder_Z scale <42, 40, 1> }
      }
      difference {
        box { -1, 1 scale <68, 35, 4.5> translate <0, 35, 4.5> }
        object { Cylinder_Z scale <28, 25, 1> }
      }
    }
    texture { GreenStone1 scale <3, 2, 3> }
    bounded_by { box { -1, 1 scale <70, 55, 10> translate y*50 } }
    translate y*100
  }
  object { wedge_key translate <0, 140, -11> }
  object { wedge_key scale 0.8 translate <0, 125, -4> }
  bounded_by { box { -1, 1 scale <95, 93, 18> translate y*90 } }
}

//--- Combine Two Walls
#declare station_wall =
union {
  object { st_w }
  object { st_w translate x*136 }
  object { st_w translate x*272 } //Added for extra wide shot!
}

//---- Corner Post
#declare fat_post =
object {
  union {
    box { -1, 1 scale <30, 60, 30> translate 0 }
    box { -1, 1 scale <35, 10, 35> translate y*-50 }
    box { -1, 1 scale <35, 10, 35> translate y*42 }
  }
  texture { st6 scale <15, 9, 9> finish { ambient 0.2 diffuse 0.8 } }
  texture { st7 scale <10, 14, 7> rotate z*-40 finish { phong 1 } }
  bounded_by { box { -1, 1 scale <40, 70, 40> translate 0 } }
}

//--- Vase
#declare vase =
object {
  union {
    object { 
      difference {
        union {
          sphere { 0, 1 scale <12, 20, 22> }
          sphere { 0, 1 scale <12, 20, 22> rotate y*45 }
          sphere { 0, 1 scale <12, 20, 22> rotate y*90 }
          sphere { 0, 1 scale <12, 20, 22> rotate y*135 }
        }
        plane { -y, 0.2 }
      }
    }
    union {
      sphere { 0, 1 scale <13, 5, 13> translate 0 }
      sphere { 0, 1 scale <6, 10, 6> translate y*6 }
    }
    texture { st3 scale <13, 8, 6> finish { diffuse 0.5 } }
    texture { st2 scale <10, 10, 6> rotate z*35 finish { ambient 0.2 phong 1 phong_size 50 } }
    bounded_by { box { -30, 30 } }
  }
  scale 1.5
}

#declare tred = box { -1, 1 scale <35, 5, 210> }
#declare riser = box { -1, 1 scale <5, 15, 210> }

//--- Steps, Step Walls & Corner Posts
union {

  //---- Stair Wall
  object {
    union {
      difference {
        box { -1, 1 scale <120, 75, 35> }
        plane { y, 0 rotate z*32.5 translate y*22.5 inverse }
      }
      difference {
        box { -1, 1 scale <120, 105, 20> translate y*50 }
        plane { y, 0 rotate z*32.5 translate y*80 inverse }
      }
    }
    texture { GrayStone3 scale 0.5 }
    bounded_by { box { -1, 1 scale <130, 120, 40> translate y*45 } }
    translate z*-240
  }

  //---- Stair Wall
  object {
    union {
      difference {
        box { -1, 1 scale <120, 75, 35> }
        plane { y, 0 rotate z*32.5 translate y*22.5 inverse }
      }
      difference {
        box { -1, 1 scale <120, 105, 20> translate y*50 }
        plane { y, 0 rotate z*32.5 translate y*80 inverse }
      }
    }
    texture { GrayStone3 scale 0.5 }
    bounded_by { box { -1, 1 scale <130, 120, 40> translate y*45 } }
    translate z*240
  }

  //---Top Face
  object {
    box { -1, 1 scale <135, 6, 35> rotate z*32.5 translate y*77 }
    texture { st6 scale <15, 10, 18> rotate y*30 }
    texture { st7 scale <10, 16, 16> rotate z*40 finish { ambient 0.1 diffuse 0.5 phong 0.2 phong_size 200 } }
    translate z*240
  }

  //---Top Face
  object {
    box { -1, 1 scale <135, 6, 35> rotate z*32.5 translate y*77 }
    texture { st6 scale <15, 12, 16> rotate x*20}
    texture { st7 scale <13, 17, 18> rotate z*-10 finish { ambient 0.1 diffuse 0.5 phong 0.2 phong_size 200 } }
    translate z*-240
  }

  //---- Steps
  object {
    union {
      object { riser translate <-65, -60, 0> }
      object { tred translate <-45, -40, 0> }
      object { riser translate <-5, -30, 0> }
      object { tred translate <15, -10, 0> }
      object { riser translate x*55}
      object { tred translate <75, 20, 0> }
    }
    texture { st3 scale <18, 14, 15> rotate z*40 finish { diffuse 0.5 } }
    texture { st2 scale <15, 9, 23>  rotate z*15 finish { ambient 0.2 phong 0.7 phong_size 60 reflection { 0.3 } } }
    bounded_by { box { -1, 1 scale <110, 60, 240> translate <15, -25, 0> } }
  }

  object { fat_post translate <140, 115, 240> }
  object { fat_post translate <140, 115, -240> }

  bounded_by { box { -1, 1 scale <160, 140, 290> translate <30, 55, 0> } }
  rotate y*-90
  translate <300, -50, -610>
}
  
//---- Marble Floor
box { -1, 1 scale <1470, 1510, 5>
  texture {
    checker
    texture { T1a }
    texture { T2a }
    scale <100, 100, 4>
  }
  rotate x*90
  translate <1000, 0, 1000>
}


//---- Floor Base
box { -1, 1 scale <1450, 200, 1490> translate <1000, -200, 1000>
  texture { st3 scale <30, 20, 20> finish { diffuse 0.5 } }
  texture { st2 scale <50, 30, 30> rotate z*35 finish { ambient 0.2 } }
  texture { pigment { color rgb 0.329412 filter 0.4 } finish { phong 1 phong_size 50 } }
}

//---- Floor Trim
box { -1, 1 scale <1460, 20, 20> translate <1000, -25, -488>
  texture { st3 scale <19, 20, 20> finish { diffuse 0.5 } }
  texture { st2 scale <30, 25, 20> rotate z*35 finish { ambient 0.2 phong 1 phong_size 50 } }
}

//--- Cross section of railing
#declare cross =
object {
  union {
    object { Cylinder_Y scale <2.5, 80, 2.5> translate y*-40 rotate z*45 }
    object { Cylinder_Y scale <2.5, 80, 2.5> translate y*-40 rotate z*-45 }
    object { Cylinder_Y scale <2.5, 50, 2.5> translate <25, -25, 0> }
    object { Cylinder_Y scale <2.5, 50, 2.5> translate <-25, -25, 0> }
  }
  texture { Gold2 }
  clipped_by { box { -1, 1 scale <30, 25, 3> } }
  bounded_by { clipped_by }
}

#declare hor_rail = object { Cylinder_X scale <480, 3, 4> translate x*-240 texture { Gold2 } }

#declare cross_rail =
union {
  object { cross translate x*-175 }
  object { cross translate x*-105 }
  object { cross translate x*-35 }
  object { cross translate x*35 }
  object { cross translate x*105 }
  object { cross translate x*175 }
  object { hor_rail translate y*25 }
  object { hor_rail translate y*-25 }
  bounded_by { box { -1, 1 scale <245, 60, 5> } }
  scale <1, 1.22, 1>
}

//--- Bridge Section
#declare bridge =
object {
  difference {
    union {
      box { -1, 1 scale <200, 160, 100> }
      box { -1, 1 scale <200, 10, 110> translate y*135 }
    }
    object { Cylinder_Z scale <60, 60, 1> translate <-100, 50, 0> }
    object { Cylinder_Z scale <60, 60, 1> translate <100, 50, 0> }
    box { -1, 1 scale <60, 120, 160> translate <-100, -70, 0> }
    box { -1, 1 scale <60, 120, 160> translate <100, -70, 0> }
  }
  texture { st3 scale <100, 60, 20> finish { diffuse 0.5 } }
  texture { st2 scale <200, 90, 60> finish { ambient 0.2 } rotate z*35 }
  texture { pigment { color rgb 0.329412 filter 0.6 } finish { ambient 0.2 phong 1 phong_size 30 } }
  bounded_by { box { -1, 1 scale <201, 161, 121> } }
  scale <2, 2, 2.2>
}

union {

  //--- Bridge Base
  box { -1, 1 scale <3000, 10, 130> texture { pigment { color rgb 0.329412 } finish { ambient 0.2 diffuse 0.5 } } }

  //---Silver Track
  box { -1, 1 scale <3000, 10, 10> translate <0, 10, -100> texture { silver } }
  box { -1, 1 scale <3000, 10, 10> translate <0, 10, 100> texture { silver } }
  texture { silver }
  bounded_by { box { -1, 1 scale <3000, 20, 135> } }
  translate <-1000, 0, 800>
}

//---- Lower Marble Floor
box { -1, 1 scale <1800, 1800, 5>
  texture {
    checker
    texture { T1a finish { phong 1 ambient 0.1 reflection { 0.3 } } }
    texture { T2a finish { phong 1 ambient 0.1 reflection { 0.3 } } }
    scale <100, 100, 4>
  }
  rotate x*90
  translate <1000, -124, 500>
}