//------ Toy Train 1993

//-----  Gold Stack
#declare stack1 = union {
	intersection { Y_Disk scale <5 20 5> }
	intersection { Y_Disk scale <8 10 8> translate <0 20 0>  }
}

//----- Side Panels
#declare side_panel =
object {
   union {
     intersection { Cube scale <65 35 2.5> translate <0 0 0> }
     intersection { Cube scale <55 25 7.5> translate <0 0 0> }
     intersection { Cube scale <85 10 2.5> translate <150 -5 0> }
     intersection { Cube scale <25 6 7> translate <130 -50 1> }
     intersection { Cube scale <10 17 7> translate <115 -38 1> }
     intersection { Cube scale <60 2.5 2.5> translate <120 -22.5 0> }
   }
	texture { bod_color5 }
		bounded_by {
		intersection { Cube scale <160 60 8> translate <85 -10 0> }
		}
}

//---- Spoke
#declare spoke = intersection { X_Disk scale <84 5 4> translate <-42 0 0> }

//---- Large Wheel
#declare wheel =
composite {
 object {
   union {
     intersection { spoke rotate <0 0 0> }
     intersection { spoke rotate <0 0 45> }
     intersection { spoke rotate <0 0 90> }
     intersection { spoke rotate <0 0 -45> }
     intersection { Z_Disk scale <20 20 10> translate <0 0 -5> }
     intersection { Z_Disk scale <10 10 10> translate <0 0 -8> }
   }
	texture { bod_color2 }
	   bounded_by {
	   intersection { Z_Disk scale <48 48 18> translate <0 0 -9> }
	   }
 }

 object {
   difference {
     intersection { Z_Disk scale <45 45 12> translate <0 0 -6> }
     quadric { Cylinder_Z  scale <40 40 1> }
   }
       texture { silver }
	bounded_by {
	intersection { Z_Disk scale <48 48 13> translate <0 0 -6.5> }
	}
 }
	  bounded_by {
	  intersection { Z_Disk scale <48 48 12> translate <0 0 -6> }
	  }
}

//--- Small Wheel
#declare s_wheel = composite { wheel scale <0.60 0.60 1> }

#declare cow =
intersection {
	plane { <0.0 0.0 1.0> 1.0 }
	plane { <0.0 0.0 -1.0> 1.1 }
	plane { <0.0 -1.0 0.0> 1.0 }
	plane { <1.0 0.0 0.0> 0.5 rotate <0 0 45> translate < 0 -0.5 0> rotate <-45 0 0>  }
	plane { <-1.0 0.0 0.0> 0.5 rotate <0 0 -45> translate <0 -0.5 0> rotate <-45 0 0> }
}

#declare cutter = intersection { Cube scale <1 5 20> }
#declare dot_r = quadric { Sphere scale <5 5 5> }


//--- Thick Gold Railing
#declare thick_rail =
object {
   union {
     quadric { dot_r translate <0 0 0> }
     quadric { dot_r translate <130 0 0> }
     quadric { dot_r translate <130 -30 0> }
     quadric { dot_r translate <300 -30 0> }
     quadric { dot_r translate <350 -80 0> }
     quadric { dot_r translate <370 -80 0> }
     intersection { X_Disk scale <130 5 5> translate <0 0 0> }
     intersection { X_Disk scale <170 5 5> translate <130 -30 0> }
     intersection { Y_Disk scale <5 30 5> translate <130 -30 0> }
     intersection { X_Disk scale <20 5 5> translate <350 -80 0> }
     intersection { X_Disk scale <70 5 5> rotate <0 0 -45> translate <300 -30 0> }
   }
	texture { bod_color4 }
	  bounded_by {
	  intersection { Cube scale <200 70 10> translate <190 -35 0> }
	  }
}


#declare post = quadric { Sphere scale <4 4 8> }

#declare thin_rail =
object {
   union {
     quadric { post }
     quadric { post translate <120 0 0> }
     quadric { post translate <240 0 0> }
     intersection { X_Disk scale <240 2 2> translate <0 0 -2> }
   }
	texture { bod_color4 }
	   bounded_by {
	   intersection { X_Disk scale <250 9 9> translate <-5 0 0> }
	   }
}

//---- Wheel Mechanics
#declare wheel_drive =
object {
   union {
     intersection { Z_Disk scale <7 7 12> translate <0 0 -4> }
     intersection { Z_Disk scale <7 7 12> translate <130 0 -4> }
     intersection { Z_Disk scale <7 7 12> translate <150 25 -4> }
     intersection { Cube scale <65 3 2> translate <65 0 0> }
     intersection { Cube scale <15 3 2> rotate <0 0 40> translate <140 10 0> }
     intersection { Cube scale <55 3 2> translate <140 39 4> }
   }
	texture { silver }
	   bounded_by {
	   intersection { Cube scale <130 40 12> translate <120 20 0> }
	   }
}


//----- Complete Train
composite {
  composite {
	composite {
	//---- trunk
     	object {
	  union {
	    intersection { X_Disk scale <240 50 50> translate <0 0 0> }
	    quadric { Sphere scale <30 30 20> translate <160 50 0> }
	    quadric { Sphere scale <30 30 20> translate <180 50 0> }
	    intersection { X_Disk scale <20 30 20> translate <160 50 0> }
	    intersection { Cube scale <120 3 55> translate <120 0 0> }
	  }
	       texture { bod_color1 }
		bounded_by {
		intersection { X_Disk scale <250 70 56> translate <-5 10 0> }
		}
	}

	//--- Brass ring
	object {
	  union {
	     quadric { Sphere scale <5 55 55> translate <95 0 0> }
	     quadric { Sphere scale <5 55 55> translate <175 0 0> }
	     quadric { Sphere scale <5 55 55> translate <240 0 0> }
	     intersection { Cube scale <120 3 55> translate <120 0 0> }
	  }
	       texture { bod_color4 }
		bounded_by {
		intersection { X_Disk scale <250 70 56> translate <-5 10 0> }
		}
	}

 	translate <-330 130 0>
	}

	//--- Top Cabin
	composite {
	  object {
	     difference {
		union {
		  intersection { Cube scale < 35 10 20> translate <75 90 0> }
		  intersection { X_Disk scale <150 93 93> translate <0 0 0> }
		}
	          plane { <0 1 0> 60 }
	      }
			texture { bod_color2 }
	  translate <-85 0 0>
	   }

	  //---- Cabin
	  object {
		difference {
		  intersection { Cube scale <55 60 70> translate <0 0 0> }
		  intersection { Cube scale <10 20 80> translate <-35 30 0> }
		  intersection { Cube scale <30 20 80> translate <15 30 0> }
		  intersection { Cube scale <50 50 65> translate <0 5 0> }
		  intersection { Cube scale <40 20 80> translate <25 -60 0> }
		}
		  texture {
		     material_map { <1 -1 0> gif "tcabin.gif" 
		     texture { bod_color1 finish { phong 0.5 phong_size 50 diffuse 0.9 }}
		     texture { bod_color2 finish { phong 0.5 phong_size 50 diffuse 0.9 }}
		     texture { bod_color3 finish { phong 0.5 phong_size 50 diffuse 0.9 }}
		     texture { bod_color4 finish { phong 0.5 phong_size 50 diffuse 0.9 }}
		
		  }
		scale <110 120 1>
		translate <-55 -60 -1>
       	}
			bounded_by {
			intersection { Cube scale <80 80 80 > translate <-10 20 0> }
			}
	}
	translate <-385 130 0>
        }

	object {
	  union {
	   intersection { X_Disk scale <80 50 50> translate <0 0 0> }
	   quadric { Sphere scale <5 55 55> translate <80 0 0> }
	   quadric { Sphere scale <10 45 45> translate <80 0 0> }
	   intersection { X_Disk scale <10 15 15> translate <87 0 0> }
	   quadric { Sphere scale <10 10 10> translate <70 60 0> }
	   intersection { X_Disk scale <20 10 10> translate <70 60 0> }
	   intersection { Y_Disk scale <15 20 15> translate <25 50 0> }
	   intersection { DCone scale <30 65 30> translate <25 40 0> }
	   intersection { Y_Disk scale <25 5 25> translate <25 70 0> }
	  }
	      texture { bod_color6 }
	         bounded_by {
	         intersection { Cube scale <60 95 60 > translate <50 30 0> }
	         }
	translate <-90 130 0>
	}

	//--- Train Frame
	object {
	   union {
	     intersection { Cube scale <235 30 40> translate <0 0 0> }
	     intersection { Cube scale <25 40 80> translate <130 0 0> }
	     intersection { Cube scale <40 15 20> translate <-225 -25 0> }
	     intersection { Cube scale <15 30 85> translate <130 0 0> }
	     intersection { Cube scale <40 3 70> translate <195 0 0> }
	   }
	      texture { bod_color5 }
		bounded_by {
		intersection { Cube scale <270 60 90 > translate <0 0 0> }
		}
	translate <-200 60 0>
	}

	//---- Stacks
	object {
	  union {
	    union { stack1 translate <-285 210 0> }
	    union { stack1 translate <-245 190 0> }
	    union { stack1 translate <-225 190 0> }
	    union { stack1 scale <2 1 2> translate <-160 200 0> }
            intersection { Y_Disk scale <15 40 15> translate <-285 170 0> }
	    quadric { Sphere scale <15 10 15> translate <-285 210 0> }
	    intersection { Y_Disk scale <20 20 20> translate <-235 170 0> }
	    intersection { Y_Disk scale <35 10 35> translate <-65 230 0> }
	    intersection { Y_Disk scale <25 10 25> translate <-65 240 0> }
	    intersection { X_Disk scale <10 10 10> translate <0 190 0> }
	  }
	       texture { bod_color4 }
		bounded_by {
		intersection { Cube scale <180 50 45> translate <-130 210 0> }
		}
	}



	object { side_panel translate <-265 105 -67.5> }
//	object { side_panel translate <-265 105 67.5> }
	composite { wheel translate <-280 45 -50> }
//	composite { wheel translate <-280 45 50> }
	composite { wheel translate <-150 45 -50> }
//	composite { wheel translate <-150 45 50> }
	composite { s_wheel translate <0 28 -50> }
//	composite { s_wheel translate <0 28 50> }
	object { thick_rail translate <-330 140 67.5> }
	object { thick_rail translate <-330 140 -67.5> }
//	object { thin_rail translate <-300 160 45> }
	object { thin_rail translate <-300 160 -45> }
//	object { wheel_drive translate <-270 30 67.5> }
	object { wheel_drive translate <-270 30 -71.5> }

	composite {
	//--- Cow Catcher
	object {
	  difference {
	    intersection { cow scale <10 5 10> }
	    intersection { cutter translate <1.5 1 0> }
	    intersection { cutter translate <4.5 1 0> }
	    intersection { cutter translate <7.5 1 0> }
	    intersection { cutter translate <-1.5 1 0> }
	    intersection { cutter translate <-4.5 1 0> }
	    intersection { cutter translate <-7.5 1 0> }
	    intersection { cutter translate <-10.5 1 0> }
	    intersection { cutter translate <10.5 1 0> }
	    intersection { cow scale <10 5 10> translate <0 -0.5 2> }
	  }
	     texture { silver }
		bounded_by {
		intersection { Cube scale <10 5 10> }
		}
	scale <4.8 5 4> translate <0 -10 -45>
	}

	object {
	   intersection { Cube scale <70 30 5> }
	   texture { bod_color5 }
	}
	rotate <0 -90 0>
	scale <0.7 1 1.1>  translate <43 45 0>
	}

	object {
	  quadric { Sphere scale <5 10.3 10.3> translate <10 130 0> }
	     texture { bod_color4 }
	}
		bounded_by {
		intersection { Cube scale <330 140 120> translate <-160 130 0> }
		}
 }
	//--- Smoke
	object {
	 union {
 	    quadric { Sphere scale <15 40 15> translate <0 0 0> }
	    quadric { Sphere scale <20 20 20> translate <0 30 0> }
	    quadric { Sphere scale <25 20 25> translate <-10 50 0> }
	    quadric { Sphere scale <30 25 30> translate <-40 60 0> }
	    quadric { Sphere scale <50 25 35> translate <-60 70 0> }
	    quadric { Sphere scale <170 25 40> translate <-90 80 0> }
	    quadric { Sphere scale <170 25 40> translate <-100 100 0> }
	    quadric { Sphere scale <50 10 30> translate <-120 110 0> }
	 }
	     texture {
         bozo
         turbulence 0.4
         0.05
         colour_map {
		  [0.0 0.1   colour red 1.0 green 1.0 blue 1.0 alpha 0.8
	          colour red 1.0 green 1.0 blue 1.0 alpha 0.9]
		  [0.1 0.5   colour red 1.0 green 1.0 blue 1.0 alpha 0.9
           	  colour red 1.0 green 1.0 blue 1.0 alpha 0.8 ]
		  [0.5 1.001 colour red 1.0 green 1.0 blue 1.0 alpha 0.8
      		  colour red 1.0 green 1.0 blue 1.0 alpha 1.0]
       		}
	rotate <0 0 90> scale <40 30 20>
	}

    texture {
		gradient <0 1 0>
		color_map {
		[0.0 0.2 color White alpha 0.7 color White alpha 0.8]
		[0.2 0.4 color White alpha 0.8 color White alpha 1.0]
		[0.4 1.01 color White alpha 1.0 color White alpha 1.0]
		}
		scale <300 140 40> translate <0 -160 0>
	     }
		bounded_by {
		intersection { Cube scale <400 120 50> translate <-160 30 0> }
		}
	scale <1 1.2 1> translate <-65 265 0>
 	}
scale <2 2 2>
translate <-1170 20 800>
}

