// #include "color1.inc"  // Colin Fleming, cj_fleming@csi.com 1998
#include "colors.inc"

#declare FinTex =
texture {
	image_map { <1 0 -1> gif "fin.gif" }
	scale <250 1 125>
	translate <0 0 -90>
	ambient .5
	phong 1
}



#declare Glass = texture {
	color red 1.0 green 1.0 blue 1.0
	alpha 0.8
	ambient 0.0
	diffuse 0.0
	refraction 1.0
	ior 1.5
	phong 1
	phong_size 100
}


//--- Bright Metallic Gold
#declare Gold2 =
texture {
	0.02
	ambient 0.3
	diffuse 0.5
	colour red 0.64 green 0.51 blue 0.05
	reflection 0.6
	brilliance 8
	specular 0.5
}


#declare stone4 =
texture {
	color Feldspar
	ambient 0.2
	diffuse 0.8
	phong 1.0
	.09
}

#declare GrayStone1 =
texture {
	granite
	color_map {
	[0 .5 color Gray60 color Gray80]
	[.5 1 color Gray70 color Gray40]
	}
	ambient .2
	diffuse .6
	phong .4
	phong_size 80
	.08
}

#declare GrayStone2 =
texture {
	granite
	color_map {
	[0 .5 color Gray50 color Gray70]
	[.5 1 color Gray60 color Gray30]
	}
	ambient .2
	diffuse .6
	phong .4
	phong_size 80
	.08
}

#declare GrayStone3 =
texture {
	granite
	color_map {
	[0 .5 color Gray40 color Gray70]
	[.5 1 color Gray60 color Gray30]
	}
	ambient .2
	diffuse .6
	phong .4
	phong_size 80
	reflection .2
	.08
}

#declare GrayStone4 =
texture {
	granite
	color_map {
	[0 .5 color Gray60 color Gray80]
	[.5 1 color Gray70 color Gray50]
	}
	ambient .2
	diffuse .6
	phong .4
	phong_size 80
	reflection .3
	.08
}

#declare GrayStone5 =
texture {
	granite
	color_map {
	[0 .5 color Gray60 color Wheat]
	[.5 1 color Gray70 color Gray50]
	}
	ambient .2
	diffuse .6
	phong .4
	phong_size 80
	reflection .3
	.08
}




//---- Brass
#declare brass = texture {
	metallic
	color red 0.80 green 0.58 blue 0.0
	ambient 0.4
	diffuse 0.3
	reflection 0.5
	brilliance 6
	phong 1.0
}



//--- Metalic Silver
#declare silver = texture {
        0.02
	ambient 0.4
	diffuse 0.7
        colour red 0.7 green 0.7 blue 0.7
	reflection 0.9
	brilliance 7.0
        specular 0.5
    }



#declare bod_color1 =
texture {
	color red .7 green 0 blue .1
	diffuse .6
	ambient .15
	phong 1
	phong_size 80

}

#declare bod_color2 =
texture {
	color Scarlet
	diffuse .4
	ambient .15
	phong 1.0
	phong_size 80
}

#declare bod_color3 =
texture {
	color red .7 green 0 blue .1
	diffuse .6
	ambient .15
	phong 1
	phong_size 80

}

#declare bod_color4 = texture { Gold2  }

#declare bod_color5 =
texture {
	color red 0.2 green 0.2 blue 0.2
	ambient .2
	diffuse .6
	phong 1
	.03
}

#declare bod_color6 =
texture {
	color red 0.15 green 0.15 blue 0.15
	diffuse .7
	ambient .15
	phong 1.0
	phong_size 80
	.03
}


#declare st1 = texture {
leopard
turbulence 0.3
colour_map {
   [0.000 0.175   colour red  1.000  green  0.718  blue  0.541  alpha  0.000
                  colour red  0.890  green  0.651  blue  0.612  alpha  0.000]
   [0.175 0.316   colour red  0.890  green  0.651  blue  0.612  alpha  0.000
                  colour red  1.000  green  0.820  blue  0.675  alpha  0.000]
   [0.316 0.386   colour red  1.000  green  0.820  blue  0.675  alpha  0.000
                  colour red  0.816  green  0.400  blue  0.345  alpha  0.000]
   [0.386 0.447   colour red  0.816  green  0.400  blue  0.345  alpha  0.000
                  colour red  0.937  green  0.729  blue  0.561  alpha  0.000]
   [0.447 0.632   colour red  0.937  green  0.729  blue  0.561  alpha  0.000
                  colour red  0.878  green  0.604  blue  0.565  alpha  0.000]
   [0.632 0.754   colour red  0.878  green  0.604  blue  0.565  alpha  0.000
                  colour red  0.984  green  0.780  blue  0.655  alpha  0.000]
   [0.754 0.842   colour red  0.984  green  0.780  blue  0.655  alpha  0.000
                  colour red  1.000  green  0.812  blue  0.608  alpha  0.000]
   [0.842 0.982   colour red  1.000  green  0.812  blue  0.608  alpha  0.000
                  colour red  1.000  green  0.678  blue  0.478  alpha  0.000]
   [0.982 1.001   colour red  1.000  green  0.678  blue  0.478  alpha  0.000
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.000]
}
0.08
}

//-------------- creams & rose With high alpha's for top layer
#declare st2 = texture {
marble
turbulence 0.4
colour_map {
   [0.000 0.175   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  0.843  green  0.678  blue  0.655  alpha  0.753]
   [0.175 0.228   colour red  0.843  green  0.678  blue  0.655  alpha  0.753
                  colour red  0.906  green  0.831  blue  0.773  alpha  0.298]
   [0.228 0.386   colour red  0.906  green  0.831  blue  0.773  alpha  0.298
                  colour red  0.992  green  0.718  blue  0.545  alpha  0.494]
   [0.386 0.412   colour red  0.992  green  0.718  blue  0.545  alpha  0.494
                  colour red  0.333  green  0.188  blue  0.067  alpha  0.384]
   [0.412 0.439   colour red  0.333  green  0.188  blue  0.067  alpha  0.384
                  colour red  0.925  green  0.557  blue  0.514  alpha  0.478]
   [0.439 0.684   colour red  0.925  green  0.557  blue  0.514  alpha  0.478
                  colour red  0.984  green  0.780  blue  0.655  alpha  0.596]
   [0.684 0.781   colour red  0.984  green  0.780  blue  0.655  alpha  0.596
                  colour red  0.965  green  0.847  blue  0.675  alpha  0.780]
   [0.781 0.982   colour red  0.965  green  0.847  blue  0.675  alpha  0.780
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.890]
   [0.982 1.001   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.890]
}

}

#declare st3 = texture {
spotted
turbulence 0.4
colour_map {
   [0.000 0.202   colour red  1.000  green  0.718  blue  0.541  alpha  0.000
                  colour red  0.890  green  0.651  blue  0.612  alpha  0.000]
   [0.202 0.298   colour red  0.890  green  0.651  blue  0.612  alpha  0.000
                  colour red  1.000  green  0.820  blue  0.675  alpha  0.000]
   [0.298 0.377   colour red  1.000  green  0.820  blue  0.675  alpha  0.000
                  colour red  0.890  green  0.643  blue  0.612  alpha  0.000]
   [0.377 0.465   colour red  0.890  green  0.643  blue  0.612  alpha  0.000
                  colour red  0.937  green  0.729  blue  0.561  alpha  0.000]
   [0.465 0.544   colour red  0.937  green  0.729  blue  0.561  alpha  0.000
                  colour red  0.878  green  0.604  blue  0.565  alpha  0.000]
   [0.544 0.640   colour red  0.878  green  0.604  blue  0.565  alpha  0.000
                  colour red  0.984  green  0.780  blue  0.655  alpha  0.000]
   [0.640 0.860   colour red  0.984  green  0.780  blue  0.655  alpha  0.000
                  colour red  1.000  green  0.863  blue  0.635  alpha  0.000]
   [0.860 0.982   colour red  1.000  green  0.863  blue  0.635  alpha  0.000
                  colour red  1.000  green  0.765  blue  0.620  alpha  0.000]
   [0.982 1.001   colour red  1.000  green  0.765  blue  0.620  alpha  0.000
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.000]
}
0.05
}


#declare st4 = texture {
spotted
turbulence 0.4
colour_map {
   [0.000 0.202   colour red  0.788  green  0.659  blue  0.573  alpha  0.000
                  colour red  0.749  green  0.612  blue  0.592  alpha  0.000]
   [0.202 0.298   colour red  0.749  green  0.612  blue  0.592  alpha  0.000
                  colour red  0.733  green  0.643  blue  0.565  alpha  0.000]
   [0.298 0.377   colour red  0.733  green  0.643  blue  0.565  alpha  0.000
                  colour red  0.663  green  0.627  blue  0.608  alpha  0.000]
   [0.377 0.465   colour red  0.663  green  0.627  blue  0.608  alpha  0.000
                  colour red  0.706  green  0.569  blue  0.478  alpha  0.000]
   [0.465 0.544   colour red  0.706  green  0.569  blue  0.478  alpha  0.000
                  colour red  0.686  green  0.541  blue  0.525  alpha  0.000]
   [0.544 0.640   colour red  0.686  green  0.541  blue  0.525  alpha  0.000
                  colour red  0.835  green  0.698  blue  0.624  alpha  0.000]
   [0.640 0.860   colour red  0.835  green  0.698  blue  0.624  alpha  0.000
                  colour red  0.765  green  0.706  blue  0.596  alpha  0.000]
   [0.860 0.982   colour red  0.765  green  0.706  blue  0.596  alpha  0.000
                  colour red  0.600  green  0.514  blue  0.459  alpha  0.020]
   [0.982 1.001   colour red  0.600  green  0.514  blue  0.459  alpha  0.020
                  colour red  0.788  green  0.659  blue  0.573  alpha  0.000]
}
0.05
}


//--------------  high alpha's for top layer
#declare st5 = texture {
marble
turbulence 0.5
colour_map {
   [0.000 0.175   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  0.843  green  0.678  blue  0.655  alpha  0.753]
   [0.175 0.228   colour red  0.843  green  0.678  blue  0.655  alpha  0.753
                  colour red  0.906  green  0.831  blue  0.773  alpha  0.98]
   [0.228 0.386   colour red  0.906  green  0.831  blue  0.773  alpha  0.698
                  colour red  0.992  green  0.718  blue  0.545  alpha  0.794]
   [0.386 0.412   colour red  0.992  green  0.718  blue  0.545  alpha  0.794
                  colour red  0.333  green  0.188  blue  0.067  alpha  0.784]
   [0.412 0.439   colour red  0.333  green  0.188  blue  0.067  alpha  0.784
                  colour red  0.925  green  0.557  blue  0.514  alpha  0.778]
   [0.439 0.684   colour red  0.925  green  0.557  blue  0.514  alpha  0.678
                  colour red  0.984  green  0.780  blue  0.655  alpha  0.696]
   [0.684 0.781   colour red  0.984  green  0.780  blue  0.655  alpha  0.696
                  colour red  0.965  green  0.847  blue  0.675  alpha  0.880]
   [0.781 0.982   colour red  0.965  green  0.847  blue  0.675  alpha  0.880
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.990]
   [0.982 1.001   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.890]
}
}


#declare st6 = texture {
marble
turbulence 0.5
colour_map {
   [0.000 0.193   colour red  0.847  green  0.753  blue  0.690  alpha  0.000
                  colour red  0.878  green  0.812  blue  0.800  alpha  0.000]
   [0.193 0.281   colour red  0.878  green  0.812  blue  0.800  alpha  0.000
                  colour red  0.847  green  0.796  blue  0.753  alpha  0.000]
   [0.281 0.368   colour red  0.847  green  0.796  blue  0.753  alpha  0.000
                  colour red  0.663  green  0.627  blue  0.608  alpha  0.000]
   [0.368 0.447   colour red  0.663  green  0.627  blue  0.608  alpha  0.000
                  colour red  0.812  green  0.725  blue  0.667  alpha  0.000]
   [0.447 0.526   colour red  0.812  green  0.725  blue  0.667  alpha  0.000
                  colour red  0.816  green  0.733  blue  0.725  alpha  0.000]
   [0.526 0.623   colour red  0.816  green  0.733  blue  0.725  alpha  0.000
                  colour red  0.890  green  0.800  blue  0.749  alpha  0.000]
   [0.623 0.833   colour red  0.890  green  0.800  blue  0.749  alpha  0.000
                  colour red  0.835  green  0.796  blue  0.722  alpha  0.000]
   [0.833 0.982   colour red  0.835  green  0.796  blue  0.722  alpha  0.000
                  colour red  0.796  green  0.753  blue  0.725  alpha  0.020]
   [0.982 1.001   colour red  0.796  green  0.753  blue  0.725  alpha  0.020
                  colour red  0.847  green  0.753  blue  0.690  alpha  0.000]
}
}

/*-------------------DEEP THAN MARBLE1 With ALPHA For SECOND LAYERS--------*/
#declare st7 = texture {
marble
turbulence 0.6
colour_map {
   [0.000 0.291   colour red  0.690  green  0.612  blue  0.569  alpha  1.00
                  colour red  0.737  green  0.596  blue  0.522  alpha  0.500]
   [0.291 0.316   colour red  0.737  green  0.596  blue  0.522  alpha  0.500
                  colour red  0.667  green  0.561  blue  0.514  alpha  0.300]
   [0.316 0.436   colour red  0.667  green  0.561  blue  0.514  alpha  0.300
                  colour red  0.788  green  0.667  blue  0.631  alpha  0.500]
   [0.436 0.641   colour red  0.788  green  0.667  blue  0.631  alpha  0.500
                  colour red  0.604  green  0.506  blue  0.455  alpha  0.700]
   [0.641 0.692   colour red  0.604  green  0.506  blue  0.455  alpha  0.700
                  colour red  0.773  green  0.612  blue  0.569  alpha  0.400]
   [0.692 1.001   colour red  0.773  green  0.612  blue  0.569  alpha  0.400
                  colour red  0.690  green  0.612  blue  0.569  alpha  1.000]
}

0.03
}

/*-------------------Yellows & whites tints with high alpha--------*/
#declare st8 = texture {
marble
turbulence 0.6
colour_map {
   [0.000 0.103   colour red  1.000  green  1.000  blue  0.580  alpha  0.576
                  colour red  1.000  green  0.835  blue  0.420  alpha  0.737]
   [0.103 0.328   colour red  1.000  green  0.835  blue  0.420  alpha  0.737
                  colour red  0.980  green  0.980  blue  0.780  alpha  0.718]
   [0.328 0.474   colour red  0.980  green  0.980  blue  0.780  alpha  0.718
                  colour red  1.000  green  1.000  blue  0.867  alpha  0.761]
   [0.474 0.603   colour red  1.000  green  1.000  blue  0.867  alpha  0.761
                  colour red  0.929  green  0.753  blue  0.639  alpha  0.741]
   [0.603 0.690   colour red  0.929  green  0.753  blue  0.639  alpha  0.741
                  colour red  0.706  green  0.580  blue  0.294  alpha  0.839]
   [0.690 0.836   colour red  0.706  green  0.580  blue  0.294  alpha  0.839
                  colour red  0.973  green  0.788  blue  0.580  alpha  0.831]
   [0.836 1.001   colour red  0.973  green  0.788  blue  0.580  alpha  0.831
                  colour red  1.000  green  1.000  blue  0.580  alpha  0.576]
}
0.03
}


/*-------------------Grays & muted Greens--------*/
#declare st9 = texture {
marble
turbulence 0.7
colour_map {
   [0.000 0.155   colour red  0.259  green  0.259  blue  0.259  alpha  0.000
                  colour red  0.341  green  0.365  blue  0.341  alpha  0.000]
   [0.155 0.328   colour red  0.341  green  0.365  blue  0.341  alpha  0.000
                  colour red  0.310  green  0.267  blue  0.310  alpha  0.000]
   [0.328 0.474   colour red  0.310  green  0.267  blue  0.310  alpha  0.000
                  colour red  0.318  green  0.318  blue  0.235  alpha  0.000]
   [0.474 0.750   colour red  0.318  green  0.318  blue  0.235  alpha  0.000
                  colour red  0.427  green  0.424  blue  0.420  alpha  0.000]
   [0.750 0.871   colour red  0.427  green  0.424  blue  0.420  alpha  0.000
                  colour red  0.306  green  0.306  blue  0.247  alpha  0.000]
   [0.871 0.983   colour red  0.306  green  0.306  blue  0.247  alpha  0.000
                  colour red  0.337  green  0.337  blue  0.333  alpha  0.000]
   [0.983 1.001   colour red  0.337  green  0.337  blue  0.333  alpha  0.000
                  colour red  0.259  green  0.259  blue  0.259  alpha  0.000]
}
0.03
}


//-------------- creams & rose With high alpha's for top layer
#declare st13 = texture {
marble
turbulence 0.7
colour_map {
   [0.000 0.175   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  0.843  green  0.678  blue  0.655  alpha  0.753]
   [0.175 0.228   colour red  0.843  green  0.678  blue  0.655  alpha  0.753
                  colour red  0.906  green  0.831  blue  0.773  alpha  0.598]
   [0.228 0.386   colour red  0.906  green  0.831  blue  0.773  alpha  0.598
                  colour red  0.992  green  0.718  blue  0.545  alpha  0.594]
   [0.386 0.412   colour red  0.992  green  0.718  blue  0.545  alpha  0.594
                  colour red  0.333  green  0.188  blue  0.067  alpha  0.584]
   [0.412 0.439   colour red  0.333  green  0.188  blue  0.067  alpha  0.584
                  colour red  0.925  green  0.557  blue  0.514  alpha  0.578]
   [0.439 0.684   colour red  0.925  green  0.557  blue  0.514  alpha  0.678
                  colour red  0.984  green  0.780  blue  0.655  alpha  0.796]
   [0.684 0.781   colour red  0.984  green  0.780  blue  0.655  alpha  0.696
                  colour red  0.965  green  0.847  blue  0.675  alpha  0.880]
   [0.781 0.982   colour red  0.965  green  0.847  blue  0.675  alpha  0.980
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.890]
   [0.982 1.001   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.890]
}

}


//-------------- a More Tubulated st2
#declare st10 = texture {
marble
turbulence 0.7
colour_map {
   [0.000 0.175   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  0.843  green  0.678  blue  0.655  alpha  0.753]
   [0.175 0.228   colour red  0.843  green  0.678  blue  0.655  alpha  0.753
                  colour red  0.906  green  0.831  blue  0.773  alpha  0.498]
   [0.228 0.386   colour red  0.906  green  0.831  blue  0.773  alpha  0.498
                  colour red  0.992  green  0.718  blue  0.545  alpha  0.494]
   [0.386 0.412   colour red  0.992  green  0.718  blue  0.545  alpha  0.494
                  colour red  0.333  green  0.188  blue  0.067  alpha  0.484]
   [0.412 0.439   colour red  0.333  green  0.188  blue  0.067  alpha  0.484
                  colour red  0.925  green  0.557  blue  0.514  alpha  0.578]
   [0.439 0.684   colour red  0.925  green  0.557  blue  0.514  alpha  0.578
                  colour red  0.984  green  0.780  blue  0.655  alpha  0.596]
   [0.684 0.781   colour red  0.984  green  0.780  blue  0.655  alpha  0.596
                  colour red  0.965  green  0.847  blue  0.675  alpha  0.780]
   [0.781 0.982   colour red  0.965  green  0.847  blue  0.675  alpha  0.780
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.890]
   [0.982 1.001   colour red  1.000  green  0.718  blue  0.541  alpha  0.890
                  colour red  1.000  green  0.718  blue  0.541  alpha  0.890]
}

}


/*--------------------Crack & OverTint /Green---------------------*/
#declare st11 = texture {
marble
turbulence 0.7
color_map {
	[0.0 0.05 color Black alpha 0.6 color Black alpha 1.0]
	[0.05 0.95 color DarkGreen alpha 0.85 color DimGray alpha 0.90]
	[0.95 1.001 color Black alpha 0.9 color Black alpha 1.0]
}
}



/*------------- THIN BLACK CRACK ---------------*/

#declare butt_crack = texture {
marble
turbulence 0.7
0.1
colour_map {
   [0.000 0.026   colour red  0.000  green  0.000  blue  0.000  alpha  0.922
                  colour red  0.333  green  0.333  blue  0.000  alpha  1.000]
   [0.026 0.383   colour red  0.333  green  0.333  blue  0.000  alpha  1.000
                  colour red  0.333  green  0.333  blue  0.000  alpha  1.000]
   [0.383 0.426   colour red  0.333  green  0.333  blue  0.000  alpha  1.000
                  colour red  0.000  green  0.000  blue  0.000  alpha  0.257]
   [0.426 0.461   colour red  0.000  green  0.000  blue  0.000  alpha  0.257
                  colour red  0.455  green  0.333  blue  0.000  alpha  0.714]
   [0.461 0.522   colour red  0.455  green  0.333  blue  0.000  alpha  0.714
                  colour red  0.333  green  0.333  blue  0.000  alpha  0.996]
   [0.522 0.965   colour red  0.333  green  0.333  blue  0.000  alpha  0.996
                  colour red  0.333  green  0.333  blue  0.000  alpha  1.000]
   [0.965 0.983   colour red  0.333  green  0.333  blue  0.000  alpha  1.000
                  colour red  0.000  green  0.000  blue  0.000  alpha  0.731]
   [0.983 1.001   colour red  0.000  green  0.000  blue  0.000  alpha  0.731
                  colour red  0.000  green  0.000  blue  0.000  alpha  0.422]
}
}











//--------- Clear with White feather Viens ----- This one does contain Alpha
#declare Grnt22 = texture {
   granite
   turbulence 0.0
   color_map {
      [0.0 0.07 color White color White]
      [0.07 0.2 color White color DimGray ]
      [0.2 0.3 color DimGray color Clear]
      [0.3 0.7 color Clear color Clear]
      [0.7 1.0 color Clear color DimGray ]
   }
   0.02
}


//--------- White Feature Viens
#declare Grnt20a = texture {
   granite
   turbulence 0.0
   color_map {
      [0.0 0.2 color White alpha 0.0 color White alpha 0.7]
      [0.2 0.3 color White alpha 0.7 color Clear ]
      [0.3 1.0 color Clear color Clear]
   }
   0.02
}



//---------- Overtint Green with Black Cracks
#declare Crack3 = texture {
   marble
   turbulence 0.85
   color_map {
      [0.0 0.04 color Black alpha 0.6 color Black alpha 1.0]
      [0.04 0.97 color DarkGreen alpha 0.80 color DarkGreen alpha 0.90]
      [0.97 1.001 color Black alpha 0.9 color Black alpha 1.0]
   }
}

//--------- Overtint with White Crack
#declare Crack4 = texture {
   marble
   turbulence 0.85
   color_map {
      [0.0 0.03 color White alpha 0.5 color White alpha 1.0]
      [0.03 0.97 color Black alpha 0.70 color DimGray alpha 0.90]
      [0.97 1.001 color White alpha 0.7 color White alpha 1.0]
   }
}



//------- Red Swirl
#declare Grnt28 = texture {
   marble
   turbulence 0.7
   colour_map {
      [0.000 0.155   colour red  0.686  green  0.235  blue  0.282  alpha  0.000
      colour red  0.686  green  0.235  blue  0.282  alpha  0.000]
      [0.155 0.328   colour red  0.686  green  0.235  blue  0.282  alpha  0.000
      colour red  0.494  green  0.243  blue  0.294  alpha  0.000]
      [0.328 0.474   colour red  0.494  green  0.243  blue  0.294  alpha  0.000
      colour red  0.769  green  0.329  blue  0.373  alpha  0.000]
      [0.474 0.647   colour red  0.769  green  0.329  blue  0.373  alpha  0.000
      colour red  0.769  green  0.329  blue  0.373  alpha  0.000]
      [0.647 0.810   colour red  0.769  green  0.329  blue  0.373  alpha  0.000
      colour red  0.686  green  0.235  blue  0.282  alpha  0.000]
      [0.810 0.922   colour red  0.686  green  0.235  blue  0.282  alpha  0.000
      colour red  0.792  green  0.388  blue  0.427  alpha  0.000]
      [0.922 1.001   colour red  0.792  green  0.388  blue  0.427  alpha  0.000
      colour red  0.686  green  0.235  blue  0.282  alpha  0.000]
   }
   0.03
}









//--- Stair Colors
#declare swall_col =
texture {
	st6
	ambient 0.4
	diffuse 0.7
	scale <40 50 2>
	rotate <0 0 -25> }
texture {
	color red 0.40 green 0.33 blue 0.33
	alpha 0.3
	diffuse 0.5
}
texture {
	butt_crack
	scale <90 140 50>
	phong 1.0
}


#declare step_col =
texture {
	st6
	ambient 0.3
	diffuse 0.8
	scale <40 50 2>
	rotate <0 0 -25>
}
texture {
	color red 0.46 green 0.33 blue 0.33
	alpha 0.5
	diffuse 0.5
}
texture {
	butt_crack
	scale <52 80 90>
	phong 1.0
	reflection 0.2
}

//---- Checker Texture
#declare t1 =
texture {
	st6
	ambient 0.2
	diffuse 0.4
	scale <2.5 2.3 0.3>
	rotate <0 0 40>
}

#declare t2 =
texture {
	st6
	ambient 0.4
	diffuse 0.7
	scale <2.3 3.5 0.3>
	rotate <0 0 -25>
}


//------------- Red Marble with gray & white veining
#declare Stone21 =
texture { Grnt28 scale <1.3 2.5 1.7> rotate <0 0 40>  }
texture { Grnt22 scale <1 2 2> rotate <0 0 40>  }
texture { Crack4 scale <1 0.6 1> rotate <10 0 -20> phong 1.0 phong_size 90 }



//------------- Green Jade with white veining
#declare Stone18 =
texture { color SeaGreen ambient 0.3 diffuse 0.6 0.03 }
texture { Grnt22 scale <1.5 0.7 0.5> rotate <0 0 40>  }
texture { Grnt20a scale <2.5 2 0.5> rotate <0 0 -50>  }
texture { Crack4 scale <0.7 1 1> rotate <10 0 -20> phong 1.0 phong_size 90 }


//------------- Med Gray Green with white veining
#declare GreenStone1 =
texture { color red .4 green .5 blue .45 }
texture { Grnt22 scale <1.5 0.7 0.5> rotate <0 0 40>  }
texture { Crack4 scale <0.7 1 1> rotate <10 0 -20> }
texture { color Gray30 alpha .8 phong 1.0 phong_size 90 .07 ambient .1 .03 }

//------------- Light Gray Green with white veining
#declare GreenStone2 =
texture { color red .4 green .5 blue .45 }
texture { Grnt22 scale <1.5 0.7 0.5> rotate <0 0 40>  }
texture { Crack4 scale <0.7 1 1> rotate <10 0 -20> }
texture { color Gray30 alpha .8 phong 1.0 phong_size 90 .07 ambient .1 .03 }
