//-------------- Train Station 1993
#version 1.0 // Colin Fleming, cj_fleming@compuserve.com 1998

	#include "stat.inc"
 	#include "texture.inc"
	#include "toytrain.inc"
	#include "turn16-x.inc"
	#include "platform.inc"
	#include "fish.inc"
	#include "world.inc"


//---- Final Camera
#declare Cam1 =
camera {
	location <1200 450 -1770>
	direction <0 0 2>
	up <0 1 0>
	right <1.333 0 0>
	look_at <-50 160 0>
}

#declare Cam2 =
camera {
	location <50 50 -700>
	direction <0 0 1.5>
	up <0 1 0>
	right <1.333 0 0>
	look_at <50 -50 0>
}

#declare Cam3 =
camera {
	location <1200 450 -1770>
	direction <0 0 2>
	up <0 1 0>
	right <1.333 0 0>
	look_at <-50 -160 0>
}

//---- Close-up of stairs
#declare Cam4 =
camera {
	location <1200 450 -1770>
	direction <0 0 2>
	up <0 1 0>
	right <1.333 0 0>
	look_at <-50 0 0>
}

camera { Cam1 }


//--- Lights
object { light_source { <4000 300 -2000> color White }}
object { light_source { <-1000 2000 -3000> color White }}
object { light_source { <-4000 5000 -1500> color White }}
object { light_source { <5000 1000 15000> color White }}
object { light_source { <3000 800 -200> color White }}



//-------------------------------- Scene


	composite { station_wall scale <4 4 4> translate <0 3.5 0> }
	composite { station_wall scale <4 4 4> translate <30 3.5 1600 > }

	//--- Station Roof
	object {
	   box { UnitBox scale <3000 1 1000> translate <3000 525 1000> }
	       texture {
		color Gray60
	       }
	}

	composite { cross_rail translate <-162 60 -470> }
	composite { cross_rail translate <-132 60 2470> }
	composite { cross_rail rotate <0 90 0> translate <-430 60 -220 > }
	composite { cross_rail rotate <0 90 0> translate <-430 60 270 > }
	composite { cross_rail translate <810 60 -470> }

	object { fat_post translate <-430 60 -470> }
	object { fat_post translate <-430 60 25> }
	object { fat_post translate <-430 60 515> }
	object { fat_post translate <-410 60 2470> }
	object { fat_post translate <60 60 2470> }
	object { fat_post translate <60 -65 -760> }
	object { fat_post translate <520 -65 -760> }

	object { vase translate <-430 150 -470> }
	object { vase translate <-430 150 25> }
	object { vase translate <-430 150 515> }
	object { vase translate <-410 150 2470> }
	object { vase translate <60 150 2470> }
	object { vase translate <60 25 -760> }
	object { vase translate <520 25 -760> }
	object { vase translate <60 150 -470> }
	object { vase translate <540 150 -470> }

	object { bridge translate <-870 -320 800> }
	object { bridge translate <-1670 -320 800> }
	object { bridge translate <-2470 -320 800> }
	object { bridge translate <-3270 -320 800> }



//--- Fish come through left entrance
composite {
	Fish
	scale <5 5 5>
	rotate <0 -90 0>
	translate <0 250 -20>
}

//--- Fish High
composite {
	Fish
	scale <2.5 2.5 2.5>
	rotate <0 -90 0>
	translate <500 500 -500>
}

//--- Front Fish
composite {
	Fish
	scale <4.9 4.9 4.9>
	rotate <0 -80 0>
	translate <300 200 -850>
}


