/*------------ SHAPES DATA ---------------------------------*/

#declare Cylinder_X = quadric {
<0.0 1.0 1.0> <0.0 0.0 0.0> <0.0 0.0 0.0> -1.0 }

#declare Cylinder_Y = quadric {
<1.0 0.0 1.0> <0.0 0.0 0.0> <0.0 0.0 0.0> -1.0 }

#declare Cylinder_Z = quadric {
<1.0 1.0 0.0> <0.0 0.0 0.0> <0.0 0.0 0.0> -1.0 }

#declare Cone_X = quadric { 
<-1.0 1.0 1.0> <0.0 0.0 0.0> <0.0 0.0 0.0> 0.0 }

#declare Cone_Y = quadric {
<1.0 -1.0 1.0> <0.0 0.0 0.0> <0.0 0.0 0.0> 0.0 }

#declare Cone_Z = quadric {
<1.0 1.0 -1.0> <0.0 0.0 0.0> <0.0 0.0 0.0> 0.0 }

#declare DCone = /*---------CONE POINT DOWN /POINT at 000--------*/
intersection {
quadric { Cone_Y scale <1 1 1> } plane { <0 -1 0> 0 }
plane { <0 1 0> 1  } }

#declare UCone = /*---------CONE POINT UP /POINT at 000--------*/
intersection {
quadric { Cone_Y scale <1 1 1> } plane { <0 1 0> 0   }
plane { <0 1 0> -1 inverse } }


/*
#declare Cube = intersection {
	plane { <0.0 0.0 1.0> 1.0 }
	plane { <0.0 0.0 -1.0> 1.0 }
	plane { <0.0 1.0 0.0> 1.0 }
	plane { <0.0 -1.0 0.0> 1.0 }
	plane { <1.0 0.0 0.0> 1.0 }
	plane { <-1.0 0.0 0.0> 1.0 }
}
*/




#declare X_Disk = intersection {       /* Capped cylinder, Length in x axis */
  quadric { Cylinder_X }
  plane { <1.0 0.0 0.0> 0.0 inverse }
  plane { <1.0 0.0 0.0> 1.0 }
}


#declare Y_Disk = intersection {       /* Capped cylinder, Length in y axis */
  quadric { Cylinder_Y }
  plane { <0.0 1.0 0.0> 0.0 inverse }
  plane { <0.0 1.0 0.0> 1.0 }
}


#declare Z_Disk = intersection {       /* Capped cylinder, Length in z axis */
  quadric { Cylinder_Z }
  plane { <0.0 0.0 1.0> 0.0 inverse }
  plane { <0.0 0.0 1.0> 1.0 }
}

#declare Sphere = quadric {
<1.0 1.0 1.0> <0.0 0.0 0.0> <0.0 0.0 0.0> -1.0 }


#declare UnitBox = box { <-1.0 -1.0 -1.0> <1.0 1.0 1.0> }

#declare Cube = intersection {
	box { UnitBox }
}













