//----- Station Platform




#declare BaseTexture =
   texture { st6 scale <11 5 5> ambient 0.2 diffuse 0.8 }
   texture { st7 scale <10 11 6> rotate <0 0 -40> phong 1.0 }



//----- Lower Wall
#declare lower_wall =
composite {
 //---- Wall Base
 object {
   union {
     intersection { Cube scale <24 3 6> translate <0 3 0> }
     intersection { Cube scale <10 3 16> translate <0 3 0> }
     intersection { Cube scale <23 5 5> translate <0 11 0> }
     intersection { Cube scale <9 5 15> translate <0 11 0> }
     intersection { Y_Disk scale <8.5 4 8.5> translate <0 16 -6> }
   }
	texture { st6 scale <15 4 3> ambient 0.2 diffuse 0.8 }
	texture { st7 scale <20 12 5> rotate <0 0 -40> phong 1.0 }
		bounded_by {
		intersection { Cube scale <25 11 17> translate <0 12 0> }
		}
 }
 //---- Wall Base
 object {
   union {
     intersection { Cube scale <24 3 6> translate <0 3 0> }
     intersection { Cube scale <10 3 16> translate <0 3 0> }
     intersection { Cube scale <23 5 5> translate <0 11 0> }
     intersection { Cube scale <9 5 15> translate <0 11 0> }
     intersection { Y_Disk scale <8.5 4 8.5> translate <0 16 -6> }
   }
	texture { st6 scale <7 4 3> ambient 0.2 diffuse 0.8 }
	texture { st7 scale <10 6 5> rotate <0 0 -40> phong 1.0 }
		bounded_by {
		intersection { Cube scale <25 11 17> translate <0 12 0> }
		}
 scale <1 0.5 1> rotate <0 0 180> translate <0 100 0>
 }

 //---- Ionic Capital
 composite {
    object {
      union { //----------capital belly
        intersection { Y_Disk scale <8.5 2 8.5> translate <0 0 0> }
        intersection { Y_Disk scale <9 12 9> translate <0 2 0> }
        intersection { Z_Disk scale <4.5 4.8 12> translate <-8.5 9.3 -10> }
        intersection { Z_Disk scale <4.5 4.8 12> translate <8.5 9.3 -10> }
        quadric { Sphere scale <11 1 11> translate <0 8 0> }
      }
	  texture { stone4 }
		bounded_by {
		intersection { Y_Disk scale <17 15 17> translate <0 -0.5 -2> }
		}
    }

    composite { turn16 rotate <90 0 0> rotate <0 0 90> translate <-8 9 -9> }
    composite { turn16 rotate <90 0 0> rotate <0 0 90> rotate <0 180 0> translate <8 9 -9> }

    object {
      intersection { X_Disk scale <16 0.5 3> translate <-8 13.5 -9> }
        texture { stone4 }
    }
		bounded_by {
		intersection { Y_Disk scale <22 16 22> translate <0 -1 -2> }
		}
 translate <0 78 -6>
 }

 //--- Column
 object {
   intersection { Y_Disk scale <8 58 8> }
      texture { st3 scale <6 10 1> diffuse 0.5 }
      texture { st2 scale <15 20 3> ambient 0.2 rotate <0 0 35> phong 1.0 phong_size 50 }
   translate <0 20 -6>
 }

 //--- Wall
 object {
   intersection { Cube scale <22 39 4> }
	texture { GreenStone2 scale <3 2 3> }
 translate <0 54 0>
 }

		bounded_by {
		intersection { Cube scale <25 55 18> translate <0 54 0> }
		}
}



//--- Large Arch Molding
#declare l_arch =
object {
   difference {
     quadric { Cylinder_Z scale <40 40 1> }
     quadric { Cylinder_Z scale <33 33 1> }
     plane { <0 0 -1> 5 inverse }
     plane { <0 0 -1> -5 }
     plane { <-1 0 0> 0 }
   }
       texture { st6 scale <10 4 5> ambient 0.2 diffuse 0.7 }
       texture { st7 scale <10 7 5> rotate <0 0 -40> phong 1.0 }
	  bounded_by {
	  intersection { Cube scale <24 24 12> translate <-19 22 0> }
	  }
}


//--- Apex molding
#declare apex =
object {
   difference {
     union {
       quadric { Cylinder_Z scale <9.375 9.375 1> translate <-5 0 0> }
       quadric { Cylinder_Z scale <9.375 9.375 1> translate <5 0 0> }
     }
     quadric { Cylinder_Z scale <5 5  1> translate <-5 0 0> }
     quadric { Cylinder_Z scale <5 5 1> translate <5 0 0> }
     plane { <0 0 -1> 5 inverse }
     plane { <0 0 -1> -5 }
     plane { <-1 0 0> -5 }
     plane { <1 0 0> -5 }
  }
       texture { stone4 }
	bounded_by {
	intersection { Cube scale <12 12 12> translate <0 0 0> }
	}
}


//---- Small Arch molding
#declare s_arch = object { l_arch scale <0.625 0.625 0.9> }

#declare wedge_key =
object {
   union {
     intersection {
       plane { <0 0 1> 1.0 }
       plane { <0 0 -1> 1.0 }
       plane { <0 1 0> 1.0 }
       plane { <0 -1 0> 1.0 }
       plane { <1 0 0> 1.0   rotate <0 0 -20> }
       plane { <-1 0 0> 1.0  rotate <0 0 20> }
     scale <10 11 14> translate <0 0 2>
     }

     intersection {
       plane { <0 0 1> 1.0 }
       plane { <0 0 -1> 1.0 }
       plane { <0 1 0> 1.0 }
       plane { <0 -1 0> 1.0 }
       plane { <1 0 0> 1.0   rotate <0 0 -20> }
       plane { <-1 0 0> 1.0  rotate <0 0 20> }
     scale <20 7.5 12> translate <0 -2 2>
     }
   }
	texture { st6 scale <5 4 3> ambient 0.2 diffuse 0.8 }
	texture { st7 scale <7 3 5> rotate <0 0 -40> phong 1.0 }
scale <0.4 0.75 0.5>
}


//---- Station Wall
#declare st_w =
composite {

	//--- Station Roof
	object {
	 union {
	  intersection { Cube scale <72 3 200> translate <0 168 185> }
	  intersection { Cube scale <68 5 200> translate <0 175 185> }
 	 }
	    texture { GrayStone2 }
	}

	composite { lower_wall translate <-47 0 0> }
	composite { lower_wall translate <47 0 0> }
	object { l_arch translate <-5 102 -10> }
	object { s_arch translate <-5 100 2> }
	object { l_arch rotate <0 180 0> translate <5 102 -10> }
	object { s_arch rotate <0 180 0> translate <5 100 2> }

	//---- Upper wall
	object {
	  union {
	    difference {
	      intersection { Cube scale <55 55 4.5> translate <0 55 -4.5> }
	      quadric { Cylinder_Z scale <42 40 1> }
	    }
	    difference {
	      intersection { Cube scale <68 35 4.5> translate <0 35 4.5> }
	      quadric { Cylinder_Z scale <28 25 1> }
	    }
	  }
		texture { GreenStone1 scale <3 2 3> }


		   bounded_by {
		   intersection { Cube scale <70 55 10> translate <0 50 0> }
		   }
	translate <0 100 0>
	}

	object { wedge_key translate <0 140 -11> }
	object { wedge_key scale <0.8 0.8 0.8> translate <0 125 -4> }

		bounded_by {
		intersection { Cube scale <95 93 18> translate <0 90 0> }
		}
}




//--- Combine Two Walls
#declare station_wall =
composite {
  composite { st_w }
  composite { st_w translate <136 0 0> }
}



//---- Corner Post
#declare fat_post =
object {
   union {
     intersection { Cube scale <30 60 30> translate <0 0 0> }
     intersection { Cube scale <35 10 35> translate <0 -50 0> }
     intersection { Cube scale <35 10 35> translate <0 42 0> }
   }
	texture { st6 scale <15 9 9> ambient 0.2 diffuse 0.8 }
	texture { st7 scale <10 14 7> rotate <0 0 -40> phong 1.0 }
	  bounded_by {
	  intersection { Cube scale <40 70 40 > translate <0 0 0> }
	  }
}

//--- Vase
#declare vase =
object {
union {
  intersection {
    difference {
	union {
	  quadric { Sphere scale <12 20 22> }
	  quadric { Sphere scale <12 20 22> rotate <0 45 0> }
	  quadric { Sphere scale <12 20 22> rotate <0 90 0> }
	  quadric { Sphere scale <12 20 22> rotate <0 135 0> }
        }
	plane { <0 -1 0> 0.2 }
     }
   }

   union {
     quadric { Sphere scale <13 5 13> translate <0 0 0> }
     quadric { Sphere scale <6 10 6>  translate <0 6 0> }
   }
  }
	texture { st3 scale <13 8 6> diffuse 0.5 }
	texture { st2 scale <10 10 6> ambient 0.2 rotate <0 0 35> phong 1.0 phong_size 50 }
	  bounded_by {
	  intersection { Cube scale <30 30 30 >}
	  }

  scale <1.5 1.5 1.5>
}

#declare tred = intersection { Cube scale <35 5 210> }
#declare riser = intersection { Cube scale <5 15 210> }

//--- Steps, Step Walls & Corner Posts
composite {
 //---- Stair Wall
 object {
  union {
    difference {
      intersection { Cube scale <120 75 35> }
      plane { <0 1 0> 0 rotate <0 0 32.5> translate <0 22.5 0> inverse }
    }
    difference {
      intersection { Cube scale <120 105 20> translate <0 50 0> }
      plane { <0 1 0> 0 rotate <0 0 32.5> translate <0 80 0> inverse }
    }
  }
	texture { GrayStone3 scale <.5 .5 .5> }
	   bounded_by {
	   intersection { Cube scale <130 120 40> translate <0 45 0> }
	   }
 translate <0 0 -240>
 }

 //---- Stair Wall
 object {
  union {
    difference {
      intersection { Cube scale <120 75 35> }
      plane { <0 1 0> 0 rotate <0 0 32.5> translate <0 22.5 0> inverse }
    }
    difference {
      intersection { Cube scale <120 105 20> translate <0 50 0> }
      plane { <0 1 0> 0 rotate <0 0 32.5> translate <0 80 0> inverse }
    }
  }
	texture { GrayStone3 scale <.5 .5 .5> }
	   bounded_by {
	   intersection { Cube scale <130 120 40> translate <0 45 0> }
	   }
 translate <0 0 240>
 }

 //---Top Face
 object {
     intersection { Cube scale <135 6 35> rotate <0 0 32.5> translate <0 77 0> }
	texture { st6 scale <15 10 18>  rotate <0 30 0> }
	texture { st7 scale <10 16 16> rotate <0 0 40> ambient .1 diffuse .5 phong .2 phong_size 200 }
 translate <0 0 240>
 }

 //---Top Face
 object {
     intersection { Cube scale <135 6 35> rotate <0 0 32.5> translate <0 77 0> }
	texture { st6 scale <15 12 16> rotate <20 0 0>}
	texture { st7 scale <13 17 18> rotate <0 0 -10> ambient .1 diffuse .5 phong .2 phong_size 200 }
 translate <0 0 -240>
 }

 //---- Steps
 object {
   union {
     intersection { riser translate <-65 -60 0> }
     intersection { tred translate <-45 -40 0> }
     intersection { riser translate <-5 -30 0> }
     intersection { tred translate <15 -10 0> }
     intersection { riser translate <55 0 0> }
     intersection { tred translate <75 20 0> }
   }
      texture { st3 scale <18 14 15> diffuse 0.5 rotate <0 0 40>}
      texture { st2 scale <15 9 23>
	ambient 0.2
	rotate <0 0 15>
	phong .7
	phong_size 60
	reflection .3
      }
	  bounded_by {
	  intersection { Cube scale <110 60 240> translate <15 -25 0> }
	  }
 }

 object { fat_post translate <140 115 240> }
 object { fat_post translate <140 115 -240> }
	bounded_by {
	intersection { Cube scale <160 140 290> translate <30 55 0> }
	}

rotate <0 -90 0> translate <300 -50 -610>
}



//---- Marble Floor
object {
   intersection { Cube scale <1470 1510 5> }
     texture {
	tiles {
	  texture { t1 }
	  tile2
	  texture { t2  }
        }
      scale <50 50 2>
     }

/* ------------------------------------------------------
     REMed out - Colin Fleming, cj_fleming@csi.com 1998     

   texture {
   checker
   color DimGray
   alpha 0.2
   color DimGray
   alpha 0.5
   scale <105 107.8 2>
   phong 1.0
   ambient .1
   reflection 0.3
   }
   ------------------------------------------------------ */

  rotate <90 0 0> translate <1000 0 1000>
}



//---- Floor Base
object {
  intersection { Cube scale <1450 200 1490> translate <1000 -200 1000> }
     texture { st3 scale <30 20 20> diffuse 0.5 }
     texture { st2 scale <50 30 30> ambient 0.2 rotate <0 0 35> }
     texture { color DimGray alpha 0.4 phong 1.0 phong_size 50 }
}

//---- Floor Trim
object {
  intersection { Cube scale <1460 20 20> translate <1000 -25 -488> }
     texture { st3 scale <19 20 20> diffuse 0.5 }
     texture { st2 scale <30 25 20> ambient 0.2 rotate <0 0 35> phong 1.0 phong_size 50 }
}



//--- Cross section of railing
#declare cross =
object {
   union {
     quadric { Cylinder_Y scale <2.5 80 2.5> translate <0 -40 0> rotate <0 0 45> }
     quadric { Cylinder_Y scale <2.5 80 2.5> translate <0 -40 0> rotate <0 0 -45> }
     quadric { Cylinder_Y scale <2.5 50 2.5> translate <25 -25 0> rotate <0 0 0> }
     quadric { Cylinder_Y scale <2.5 50 2.5> translate <-25 -25 0> rotate <0 0 0> }
   }
	texture { Gold2 }
	  clipped_by { intersection { Cube scale <30 25 3> } }
	  bounded_by { intersection { Cube scale <30 25 3> } }
}


#declare hor_rail =
object {
  quadric { Cylinder_X scale <480 3 4> translate <-240 0 0> }
  texture { Gold2 }
}


#declare cross_rail =
composite {
	object { cross translate <-175 0 0> }
	object { cross translate <-105 0 0> }
	object { cross translate <-35 0 0> }
	object { cross translate <35 0 0> }
	object { cross translate <105 0 0> }
	object { cross translate <175 0 0> }
	object { hor_rail translate <0 25 0> }
	object { hor_rail translate <0 -25 0> }
	   bounded_by {
	   intersection { Cube scale <245 60 5> }
	   }
scale <1 1.22 1>
}


//--- Bridge Section
#declare bridge =
object {
  difference {
    union {
     intersection { Cube scale <200 160 100> }
     intersection { Cube scale <200 10 110> translate <0 135 0> }
    }
    quadric { Cylinder_Z scale <60 60 1> translate <-100 50 0> }
    quadric { Cylinder_Z scale <60 60 1> translate <100 50 0> }
    intersection { Cube scale <60 120 160> translate <-100 -70 0> }
    intersection { Cube scale <60 120 160> translate <100 -70 0> }
  }
       texture { st3 scale <100 60 20> diffuse 0.5 }
       texture { st2 scale <200 90 60> ambient 0.2 rotate <0 0 35> }
       texture { color DimGray alpha 0.6 ambient 0.2 phong 1.0 phong_size 30 }
	bounded_by {
	intersection { Cube scale <201 161 121> }
	}
scale <2 2 2.2>
}

composite {
  //--- Bridge Base
  object {
    intersection { Cube scale <3000 10 130> }
       texture {
	color DimGray
	0.05
	ambient 0.2
	diffuse 0.5
	}
   }

   //---Silver Track
   object {
     union {
       intersection { Cube scale <3000 10 10> translate <0 10 -100> }
       intersection { Cube scale <3000 10 10> translate <0 10 100> }
     }
         texture { silver }
   }
		bounded_by {
		intersection { Cube scale <3000 20 135> }
		}
   translate <-1000 0 800>
}



//---- Lower Marble Floor
object {
   intersection { Cube scale <1800 1800 5> }
     texture {
	tiles {
	  texture { t1 }
	  tile2
	  texture { t2  }
        }
      scale <50 50 2>
     }

/* ------------------------------------------------------
     REMed out - Colin Fleming, cj_fleming@csi.com 1998     

   texture {
   checker
   color DimGray
   alpha 0.3
   color DimGray
   alpha 0.5
   scale <105 107.8 2>
   phong 1.0
   ambient .1
   reflection 0.3
   }
   
   ------------------------------------------------------ */
   
  rotate <90 0 0> translate <1000 -124 500>
}


