// Persistence of Vision Raytracer Version 1.0
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
// Standard shapes #include file
// 

#declare Sphere = quadric { 1, 0, 0, -1 }

#declare USphere =
intersection {
  sphere { 0, 1 }
  plane { y, 0 inverse }
}

#declare DSphere =
intersection {
  sphere { 0, 1 }
  plane { -y, 0 inverse }
}

#declare Cylinder_X = quadric { <0, 1, 1>, 0, 0, -1 }

#declare Cylinder_Y = quadric { <1, 0, 1>, 0, 0, -1 }

#declare Cylinder_Z = quadric { <1, 1, 0>, 0, 0, -1 }

#declare Cone_X = quadric { <-1, 1, 1,> 0, 0, 0 }

#declare Cone_Y = quadric { <1, -1, 1>, 0, 0, 0 }

#declare Cone_Z = quadric {<1, 1, -1>, 0, 0, 0 }

#declare DCone = /*---------CONE POINT DOWN /POINT at 000--------*/
intersection {
  quadric { Cone_Y scale 1 }
  plane { -y, 0 }
  plane {  y, 1 }
}

#declare UCone = /*---------CONE POINT UP /POINT at 000--------*/
intersection {
  quadric { Cone_Y scale 1 }
  plane { y, 0   }
  plane { y, -1 inverse }
}

#declare BiCone = /*----2 CONES POINTS TOGETHER /POINT at 000---*/
intersection {
  quadric { Cone_Y scale 1 }
  plane { y, 1   }
  plane { y, -1 inverse }
}

#declare Plane_YZ = quadric { 0, 0, x, 0 }

#declare Plane_XZ = quadric { 0, 0, y, 0 }

#declare Plane_XY = quadric { 0, 0, z, 0 }

/* y^2 + z^2 - x = 0 */
#declare Paraboloid_X = quadric { <0, 1, 1>, 0, -x, 0 }

/* x^2 + z^2 - y = 0 */
#declare Paraboloid_Y = quadric { <1, 0, 1>, 0, -y, 0 }

/* x^2 + y^2 - z = 0 */
#declare Paraboloid_Z = quadric { <1, 1, 0>, 0, -z, 0 }

/* y - x^2 + z^2 = 0 */
#declare Hyperboloid = quadric { <-1, 0, 1>, 0, y, 0 }

#declare Hyperboloid_Y = quadric { <1, -1, 1>, 0, 0, -1 }
  /* Vertical hyperboloid */
  /*                      */
  /*            \   /     */
  /* Like this:  ) (      */
  /*            /   \     */

#declare Cube = intersection {
  plane {  z, 1 }
  plane { -z, 1 }
  plane {  y, 1 }
  plane { -y, 1 }
  plane {  x, 1 }
  plane { -x, 1 }
}

#declare Tetrahedron = intersection {
  plane { -y, 1 }
  plane {  z, 1 rotate x*-30 }
  plane {  x, 1 rotate <0, 30, 30> }
  plane { -x, 1 rotate <0, -30, -30> }
}

#declare X_Disk = intersection {       /* Capped cylinder, Length in x axis */
  quadric { Cylinder_X }
  plane { x, 0 inverse }
  plane { x, 1 }
}

#declare Y_Disk = intersection {       /* Capped cylinder, Length in y axis */
  quadric { Cylinder_Y }
  plane { y, 0 inverse }
  plane { y, 1 }
}

#declare Z_Disk = intersection {       /* Capped cylinder, Length in z axis */
  quadric { Cylinder_Z }
  plane { z, 0 inverse }
  plane { z, 1 }
}

#declare Hexagon = intersection {          /* Hexagonal Solid, axis along x */
  plane { z,  1 }   /* Rotate 90 in z axis to stand up */
  plane { z,  1 rotate x*60 }
  plane { z,  1 rotate x*120 }
  plane { z,  1 rotate x*180 }
  plane { z,  1 rotate x*240 }
  plane { z,  1 rotate x*300 }
  plane { x,  1 }
  plane { x, -1 inverse }
}

#declare Rhomboid =      /* Three Dimensional 4-Sided Diamond */
intersection {
  plane { -x, 1 rotate z*-30 }
  plane {  x, 1 rotate z*-30 }
  plane {  z, 1 }
  plane { -z, 1 }
  plane {  y, 1 }
  plane { -y, 1 }
}