//------------- Plant Leaf ..........6/14/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Leaf_Texture = 
texture {
  pigment { 
    color ForestGreen
    //bozo
    //turbulence 0.7
    //color_map {
      //[0.0 0.3 color DarkGreen color ForestGreen ]
      //[0.3 0.7 color ForestGreen color HuntersGreen ]
      //[0.7 1.0 color HuntersGreen color DarkGreen]
      //}
  }
  finish { ambient 0.3 diffuse 0.7 phong 1 phong_size 40 }
  normal { bumps 1 }
  scale 3
}

#declare LEAF_BODY =
object {
  intersection {
    sphere { 0, 20 }
    plane { z, 0 rotate y*26 translate z*-10 inverse }
    plane { z, 0 rotate y*-26 translate z*10 }  
  }
  texture { Leaf_Texture }
  clipped_by {
    plane { y, 0 rotate z*22.5 translate y*8 inverse }
    sphere { 0, 19.9 inverse }
  }
  bounded_by { sphere { 0, 21 } }
}

#declare STEM = 
object {
  Disk_Z
  scale <77, 77, 0.7>
  translate <-40, -40, 0>
  texture { Leaf_Texture }
  clipped_by {
    plane { x, 0 rotate z*22.5 translate x*20 inverse }
    object { Cylinder_Z scale <76.5, 76.5, 1> translate <-40, -40, 0> inverse }
  }
}

//------- One Leaf & Stem
#declare LEAF =
union {
  object { LEAF_BODY }
  object { STEM }
  translate <-37, 40, 0 >   
}

//------- 4 Leafs in a bunch
#declare BUNCH4=
union {
  object { LEAF }
  object { LEAF rotate y*90 }
  object { LEAF rotate y*180 }
  object { LEAF rotate y*270 }
  bounded_by { sphere { 0, 90 translate y*20 } }
}

//------- 3 Leafs in a bunch
#declare BUNCH3=
union {
  object { LEAF rotate y*120 }
  object { LEAF rotate y*240 }
  object { LEAF }
  bounded_by { sphere { 0, 90 translate y*20 } }
}