// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//--------------- jake the snake

#declare DCone = /*---------CONE POINT DOWN /POINT at 000--------*/
intersection {
  object { Cone_Y scale 1 }
  plane { -y, 0 }
  plane {  y, 1 } }

//--------------- truman's ctds default colour
#declare Truman = colour rgb <0.556, 0.419, 0.137>;

//--------------- deep red for gums
#declare YourTexture =
texture {
  pigment { colour Red }
  finish { ambient 0.1 diffuse 0.4 phong 1.0 phong_size 60  }
}

//-------------- jakes neck colour
#declare devil_2 =
texture {
  pigment {
    marble
    turbulence 0.4
    colour_map {
      [0     0.139 colour rgbf <0.569, 0.486, 0.333, 0> colour rgbf <0.839, 0.576, 0.384, 0>]
      [0.139 0.296 colour rgbf <0.839, 0.576, 0.384, 0> colour rgbf <0.898, 0.733, 0.525, 0>]
      [0.296 0.426 colour rgbf <0.898, 0.733, 0.525, 0> colour rgbf <0.945, 0.851, 0.737, 0>]
      [0.426 0.670 colour rgbf <0.945, 0.851, 0.737, 0> colour rgbf <0.918, 0.761, 0.843, 0>]
      [0.670 0.783 colour rgbf <0.918, 0.761, 0.843, 0> colour rgbf <0.898, 0.604, 0.525, 0>]
      [0.783 0.878 colour rgbf <0.898, 0.604, 0.525, 0> colour rgbf <0.757, 0.518, 0.518, 0>]
      [0.878 0.983 colour rgbf <0.757, 0.518, 0.518, 0> colour rgbf <0.569, 0.486, 0.333, 0>]
      [0.983 1.001 colour rgbf <0.569, 0.486, 0.333, 0> colour rgbf <0.569, 0.486, 0.333, 0>]
    }
    scale <20, 20, 5>
  }
}
texture {
  pigment {
    gradient y
    colour_map {
      [0.0 0.3 colour Truman colour Truman]
      [0.3 0.5 colour Truman colour Truman filter 0.7]
      [0.5 1.0 colour Truman filter 0.7 colour Truman ]
    }
  }
  finish { phong 1.0 ambient 0.2 phong_size 80 }
  scale <100, 60, 100>
  translate <-50, -30, 0>
}

//--------------- main head texture {
#declare devil_1 =
texture {
  pigment { image_map { gif "coat-t2.gif" } }
  finish { ambient 0.2 diffuse 0.8 }
  scale <100, 60, 1>
  translate <-50, -30, -1>
}
texture {
  pigment {
    gradient x
    colour_map {
      [0.0 0.4 colour Clear colour Clear]
      [0.4 0.7 colour Clear colour Truman]
      [0.7 1.0 colour Truman colour Truman]
    }
  }
  finish { phong 1.0 ambient 0.2 phong_size 80 }
  scale <100, 60, 100>
  translate <-50, -30, -1>
}

#declare Dot = sphere { 0, 1 }
//quadric { 1, 0, 0, -1.0 }

#declare Connector_1 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane { x, 0 inverse }
  plane { x, 1}
}

#declare Connector_2 = 
quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

//---------------- positive <z> of neck
#declare neck_a =
object {
  union {
    sphere { 0, 8.8 translate y*-3 }
    sphere { 0, 8.6 translate <7.031240, -1.604050, 0> }
    sphere { 0, 8.4 translate <14.199350, -1.532300, 0> }
    sphere { 0, 8.2 translate <21.257130, -2.787220, 0> }
    sphere { 0, 8 translate <27.961150, -5.325530, 0> }
    sphere { 0, 7.8 translate <34.080230, -9.059690, 0> }
    sphere { 0, 7.6 translate <39.403310, -13.860920, 0> }
    sphere { 0, 7.4 translate <43.746830, -19.563630, 0> }
    sphere { 0, 7.2 translate <46.960970, -25.971150, 0> }
    sphere { 0, 7 translate <48.934890, -32.862490, 0> }
    sphere { 0, 6.8 translate <49.600520, -40, 0> }
    sphere { 0, 6.73846 translate <49.095940, -45.442170, 0> }
    sphere { 0, 6.67692 translate <47.599380, -50.698810, 0> }
    sphere { 0, 6.61538 translate <45.161890, -55.590690, 0> }
    sphere { 0, 6.55385 translate <41.866560, -59.951050, 0> }
    sphere { 0, 6.49231 translate <37.825730, -63.631210, 0> }
    sphere { 0, 6.43077 translate <33.177170, -66.505710, 0> }
    sphere { 0, 6.36923 translate <28.079360, -68.476560, 0> }
    sphere { 0, 6.30769 translate <22.706100, -69.476560, 0> }
    sphere { 0, 6.24615 translate <17.240590, -69.471620, 0> }
    sphere { 0, 6.18461 translate <11.869150, -68.461900, 0> }
    sphere { 0, 6.12307 translate <6.774910, -66.481830, 0> }
    sphere { 0, 6.06154 translate <2.131560, -63.598930, 0> }
    sphere { 0, 6 translate <-1.902610, -59.911460, 0> }
    sphere { 0, 6 translate <-6.473790, -57.077620, 0> }
    sphere { 0, 6 translate <-11.475990, -55.101660, 0> }
    sphere { 0, 6 translate <-16.749800, -54.046550, 0> }
    sphere { 0, 6 translate <-22.127190, -53.945910, 0> }
    sphere { 0, 6 translate <-27.436790, -54.802960, 0> }
    sphere { 0, 6 translate <-32.509410, -56.590370, 0> }
    sphere { 0, 6 translate <-37.183430, -59.251210, 0> }
    sphere { 0, 6 translate <-41.309880, -62.700660, 0> }
    sphere { 0, 6 translate <-44.757300, -66.828820, 0> }
    sphere { 0, 6 translate <-47.415810, -71.504150, 0> }
    sphere { 0, 6 translate <-49.200720, -76.577660, 0> }
    sphere { 0, 6 translate <-50.055130, -81.887690, 0> }
    sphere { 0, 6 translate <-49.951840, -87.265020, 0> }
    sphere { 0, 6 translate <-48.894120, -92.538310, 0> }
    sphere { 0, 6 translate <-46.915690, -97.539530, 0> }
    sphere { 0, 6 translate <-44.079570, -102.109310, 0> }
    sphere { 0, 6 translate <-40.476170, -106.102030, 0> }
    sphere { 0, 6 translate <-36.220280, -109.390460, 0> }
    sphere { 0, 6 translate <-31.447530, -111.869830, 0> }
    sphere { 0, 6 translate <-26.310000, -113.461110, 0> }
    sphere { 0, 6 translate <-20.971400, -114.113610, 0> }
  }
  texture { devil_2  }
  bounded_by { sphere { 0, 93.843722 translate <0.172695, -56.55883, 0> } }
  translate z*3
}

//--------------- negative <z> of neck
#declare neck_b =
object {
  union {       
    sphere { 0, 8.8 translate y*-3 }
    sphere { 0, 8.6 translate <7.031240, -1.604050, 0> }
    sphere { 0, 8.4 translate <14.199350, -1.532300, 0> }
    sphere { 0, 8.2 translate <21.257130, -2.787220, 0> }
    sphere { 0, 8 translate <27.961150, -5.325530, 0> }
    sphere { 0, 7.8 translate <34.080230, -9.059690, 0> }
    sphere { 0, 7.6 translate <39.403310, -13.860920, 0> }
    sphere { 0, 7.4 translate <43.746830, -19.563630, 0> }
    sphere { 0, 7.2 translate <46.960970, -25.971150, 0> }
    sphere { 0, 7 translate <48.934890, -32.862490, 0> }
    sphere { 0, 6.8 translate <49.600520, -40, 0> }
    sphere { 0, 6.73846 translate <49.095940, -45.442170, 0> }
    sphere { 0, 6.67692 translate <47.599380, -50.698810, 0> }
    sphere { 0, 6.61538 translate <45.161890, -55.590690, 0> }
    sphere { 0, 6.55385 translate <41.866560, -59.951050, 0> }
    sphere { 0, 6.49231 translate <37.825730, -63.631210, 0> }
    sphere { 0, 6.43077 translate <33.177170, -66.505710, 0> }
    sphere { 0, 6.36923 translate <28.079360, -68.476560, 0> }
    sphere { 0, 6.30769 translate <22.706100, -69.476560, 0> }
    sphere { 0, 6.24615 translate <17.240590, -69.471620, 0> }
    sphere { 0, 6.18461 translate <11.869150, -68.461900, 0> }
    sphere { 0, 6.12307 translate <6.774910, -66.481830, 0> }
    sphere { 0, 6.06154 translate <2.131560, -63.598930, 0> }
    sphere { 0, 6 translate <-1.902610, -59.911460, 0> }
    sphere { 0, 6 translate <-6.473790, -57.077620, 0> }
    sphere { 0, 6 translate <-11.475990, -55.101660, 0> }
    sphere { 0, 6 translate <-16.749800, -54.046550, 0> }
    sphere { 0, 6 translate <-22.127190, -53.945910, 0> }
    sphere { 0, 6 translate <-27.436790, -54.802960, 0> }
    sphere { 0, 6 translate <-32.509410, -56.590370, 0> }
    sphere { 0, 6 translate <-37.183430, -59.251210, 0> }
    sphere { 0, 6 translate <-41.309880, -62.700660, 0> }
    sphere { 0, 6 translate <-44.757300, -66.828820, 0> }
    sphere { 0, 6 translate <-47.415810, -71.504150, 0> }
    sphere { 0, 6 translate <-49.200720, -76.577660, 0> }
    sphere { 0, 6 translate <-50.055130, -81.887690, 0> }
    sphere { 0, 6 translate <-49.951840, -87.265020, 0> }
    sphere { 0, 6 translate <-48.894120, -92.538310, 0> }
    sphere { 0, 6 translate <-46.915690, -97.539530, 0> }
    sphere { 0, 6 translate <-44.079570, -102.109310, 0> }
    sphere { 0, 6 translate <-40.476170, -106.102030, 0> }
    sphere { 0, 6 translate <-36.220280, -109.390460, 0> }
    sphere { 0, 6 translate <-31.447530, -111.869830, 0> }
    sphere { 0, 6 translate <-26.310000, -113.461110, 0> }
    sphere { 0, 6 translate <-20.971400, -114.113610, 0> }
  }
  texture { devil_2  }  
  bounded_by { sphere { 0, 93.843722 translate <0.172695, -56.55883, 0> } }
  translate z*-3
}

//--------------- starts head
//----------------positive <z> of head
#declare head_a = 
object {
  difference {
    union {
      union {
        sphere { 0, 4.5 translate <29.102780, -5.325960, 0> }
        sphere { 0, 5 translate <26.073090, -3.905650, 0> }
        sphere { 0, 5.5translate <22.933100, -2.749480, 0> }
        sphere { 0, 6 translate <19.705780, -1.865900, 0> }
        sphere { 0, 6.5 translate <16.414750, -1.261380, 0> }
        sphere { 0, 7 translate <13.084100, -0.940350, 0> }
        sphere { 0, 7.5 translate <9.738200, -0.905140, 0> }
        sphere { 0, 8 translate <6.401540, -1.156030, 0> }
        sphere { 0, 8.5 translate <3.098520, -1.691170, 0> }
        sphere { 0, 9 translate <-0.146680, -2.506650, 0> }
        sphere { 0, 9.4 translate <-1.736590, -3.492240, 0> }
        sphere { 0, 9.8 translate <-3.434760, -4.276750, 0> }
        sphere { 0, 10.2 translate <-5.215870, -4.848500, 0> }
        sphere { 0, 10.6 translate <-7.053370, -5.198950, 0> }
        sphere { 0, 11 translate <-8.919880, -5.322890, 0> }
        sphere { 0, 11.4 translate <-10.787590, -5.218480, 0> }
        sphere { 0, 11.8 translate <-12.628660, -4.887250, 0> }
        sphere { 0, 12.2 translate <-14.415650, -4.334170, 0> }
        sphere { 0, 12.6 translate <-16.121930, -3.567450, 0> }
        sphere { 0, 13 translate <-17.722060, -2.598540, 0> }
        sphere { 0, 5 translate <32, -7, 0> }
        sphere { 0, 5.61538 translate <28.857440, -4.176180, 0> }
        sphere { 0, 6.23077 translate <25.431910, -1.703250, 0> }
        sphere { 0, 6.84615 translate <21.762410, 0.390630, 0> }
        sphere { 0, 7.46154 translate <17.890700, 2.081650, 0> }
        sphere { 0, 8.07692 translate <13.860870, 3.350530, 0> }
        sphere { 0, 8.69231 translate <9.718780, 4.182850, 0> }
        sphere { 0, 9.30769 translate <5.511590, 4.569120, 0> }
        sphere { 0, 9.92308 translate <1.287200, 4.504950, 0> }
        sphere { 0, 10.53846 translate <-2.906310, 3.991060, 0> }
        sphere { 0, 11.15385 translate <-7.021210, 3.033320, 0> }
        sphere { 0, 11.76923 translate <-11.010640, 1.642610, 0> }
        sphere { 0, 12.38462 translate <-14.829190, -0.165220, 0> }
        sphere { 0, 13 translate <-18.433400, -2.369610, 0> }
        sphere { 0, 12.25 translate <-20.509540, -3.658460, 0> }
        sphere { 0, 11.5 translate <-22.685340, -4.770860, 0> }
        sphere { 0, 10.75 translate <-24.945820, -5.699160, 0> }
        sphere { 0, 10 translate <-27.275440, -6.436970, 0> }
        sphere { 0, 9.25 translate <-29.658190, -6.979220, 0> }
        sphere { 0, 8.5 translate <-32.077670, -7.322170, 0> }
        sphere { 0, 7.75 translate <-34.517250, -7.463480, 0> }
        sphere { 0, 7 translate <-36.960150, -7.402170, 0> }
        sphere { 0, 6 translate <-34, -17, 0> }
        sphere { 0, 6.5 translate <-31.104770, -16.844320, 0> }
        sphere { 0, 7 translate <-28.242920, -16.379080, 0> }
        sphere { 0, 7.5 translate <-25.447470, -15.609650, 0> }
        sphere { 0, 8 translate <-22.750640, -14.544890, 0> }
        sphere { 0, 8.5 translate <-20.183530, -13.197090, 0> }
        sphere { 0, 9 translate <-17.775750, -11.581790, 0> }
        sphere { 0, 9.5 translate <-15.555070, -9.717620, 0> }
        sphere { 0, 10 translate <-13.547080, -7.626060, 0> }
        sphere { 0, 10.5 translate <-11.774950, -5.331250, 0> }
        sphere { 0, 11 translate <-10.259120, -2.859640, 0> }
        translate z*3
      }
      union {
        sphere { 0, 4.5 translate <29.102780, -5.325960, 0> }
        sphere { 0, 5 translate <26.073090, -3.905650, 0> }
        sphere { 0, 5.5translate <22.933100, -2.749480, 0> }
        sphere { 0, 6 translate <19.705780, -1.865900, 0> }
        sphere { 0, 6.5 translate <16.414750, -1.261380, 0> }
        sphere { 0, 7 translate <13.084100, -0.940350, 0> }
        sphere { 0, 7.5 translate <9.738200, -0.905140, 0> }
        sphere { 0, 8 translate <6.401540, -1.156030, 0> }
        sphere { 0, 8.5 translate <3.098520, -1.691170, 0> }
        sphere { 0, 9 translate <-0.146680, -2.506650, 0> }
        sphere { 0, 9.4 translate <-1.736590, -3.492240, 0> }
        sphere { 0, 9.8 translate <-3.434760, -4.276750, 0> }
        sphere { 0, 10.2 translate <-5.215870, -4.848500, 0> }
        sphere { 0, 10.6 translate <-7.053370, -5.198950, 0> }
        sphere { 0, 11 translate <-8.919880, -5.322890, 0> }
        sphere { 0, 11.4 translate <-10.787590, -5.218480, 0> }
        sphere { 0, 11.8 translate <-12.628660, -4.887250, 0> }
        sphere { 0, 12.2 translate <-14.415650, -4.334170, 0> }
        sphere { 0, 12.6 translate <-16.121930, -3.567450, 0> }
        sphere { 0, 13 translate <-17.722060, -2.598540, 0> }
        sphere { 0, 5 translate <32, -7, 0> }
        sphere { 0, 5.61538 translate <28.857440, -4.176180, 0> }
        sphere { 0, 6.23077 translate <25.431910, -1.703250, 0> }
        sphere { 0, 6.84615 translate <21.762410, 0.390630, 0> }
        sphere { 0, 7.46154 translate <17.890700, 2.081650, 0> }
        sphere { 0, 8.07692 translate <13.860870, 3.350530, 0> }
        sphere { 0, 8.69231 translate <9.718780, 4.182850, 0> }
        sphere { 0, 9.30769 translate <5.511590, 4.569120, 0> }
        sphere { 0, 9.92308 translate <1.287200, 4.504950, 0> }
        sphere { 0, 10.53846 translate <-2.906310, 3.991060, 0> }
        sphere { 0, 11.15385 translate <-7.021210, 3.033320, 0> }
        sphere { 0, 11.76923 translate <-11.010640, 1.642610, 0> }
        sphere { 0, 12.38462 translate <-14.829190, -0.165220, 0> }
        sphere { 0, 13 translate <-18.433400, -2.369610, 0> }
        sphere { 0, 12.25 translate <-20.509540, -3.658460, 0> }
        sphere { 0, 11.5 translate <-22.685340, -4.770860, 0> }
        sphere { 0, 10.75 translate <-24.945820, -5.699160, 0> }
        sphere { 0, 10 translate <-27.275440, -6.436970, 0> }
        sphere { 0, 9.25 translate <-29.658190, -6.979220, 0> }
        sphere { 0, 8.5 translate <-32.077670, -7.322170, 0> }
        sphere { 0, 7.75 translate <-34.517250, -7.463480, 0> }
        sphere { 0, 7 translate <-36.960150, -7.402170, 0> }
        sphere { 0, 6 translate <-34, -17, 0> }
        sphere { 0, 6.5 translate <-31.104770, -16.844320, 0> }
        sphere { 0, 7 translate <-28.242920, -16.379080, 0> }
        sphere { 0, 7.5 translate <-25.447470, -15.609650, 0> }
        sphere { 0, 8 translate <-22.750640, -14.544890, 0> }
        sphere { 0, 8.5 translate <-20.183530, -13.197090, 0> }
        sphere { 0, 9 translate <-17.775750, -11.581790, 0> }
        sphere { 0, 9.5 translate <-15.555070, -9.717620, 0> }
        sphere { 0, 10 translate <-13.547080, -7.626060, 0> }
        sphere { 0, 10.5 translate <-11.774950, -5.331250, 0> }
        sphere { 0, 11 translate <-10.259120, -2.859640, 0> }
        //--------------- add brow
        sphere { 0, 1 scale <8, 4, 4> rotate z*12 translate <-17, 3, -10> }
        sphere { 0, 1 scale <8, 4, 4> rotate z*12 translate <-17, 3, 10> }
        translate z*-3
      }
    }
    //----------- remove for mouth opening
    object { Cylinder_Z scale <14, 7, 1> rotate z*-7 translate <-38, -13.5, 0> }
    //---------- eye socket
    sphere { 0, 1 scale <8, 4, 4> rotate z*12 translate <-20, 0, -15> }
    sphere { 0, 1 scale <8, 4, 4> rotate z*12 translate <-20, 0, 15> }
  }
  texture { devil_1  }
  bounded_by { sphere { 0, 51.204994 translate <-3.480075, -4.424780, 0> } }
}

//------------ eyeballs
#declare eyes =
union {
  sphere { 0, 5 translate <-20.5, -1,  11.5> }
  sphere { 0, 5 translate <-20.5, -1, -11.5> }
  texture { pigment { colour Red } finish { phong 1.0 ambient 0.2 diffuse 0.6 } }
}

//------------ mouth gums
#declare gums =
object {
  difference {
    union {
      union {
        sphere { 0, 10   translate <-27.27544, -6.43697, 0> }
        sphere { 0, 9.25 translate <-29.65819, -6.97922, 0> }
        sphere { 0, 8.5  translate <-32.07767, -7.32217, 0> }
        sphere { 0, 7.75 translate <-34.51725, -7.46348, 0> }
        sphere { 0, 7    translate <-36.96015, -7.40217, 0> }
        translate z*-3
      }
      union {
/*
        sphere { 0, 12.25 translate <-20.50954, -3.65846, 0> }
        sphere { 0, 11.5  translate <-22.68534, -4.77086, 0> }
        sphere { 0, 10.75 translate <-24.94582, -5.69916, 0> }
*/         
        sphere { 0, 10   translate <-27.27544, -6.43697, 0> }
        sphere { 0, 9.25 translate <-29.65819, -6.97922, 0> }
        sphere { 0, 8.5  translate <-32.07767, -7.32217, 0> }
        sphere { 0, 7.75 translate <-34.51725, -7.46348, 0> }
        sphere { 0, 7    translate <-36.96015, -7.40217, 0> }
        translate z*3
      }
    }
    //----------- remove for gums
    object { Cylinder_Z scale <12.5, 6, 1> rotate z*-7 translate <-39, -13.5, 0> }
  }
  texture { pigment { colour Red } finish { ambient 0.2 diffuse 0.6 phong 1.0 } }
  scale 0.97
}

//---------- tongue
#declare tongue =
union {
  sphere { 0, 1.83333 translate <-28, -14, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 1.831084 }
      plane { x, 1.664628 inverse }
    }
    translate x*-1.831084
    scale <20.185134, 1, 1>
    translate x*-0.090715
    rotate y*180
    rotate z*29.532621
    rotate y*-180
    translate <-28, -14, 0>
    texture { YourTexture }
  }
  sphere { 0, 1.66667 translate <-30.93057, -12.33976, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 1.664628 }
      plane { x, 1.498162 inverse }
    }
    translate x*-1.664628
    scale <20.183921, 1, 1>
    translate x*-0.082473
    rotate y*180
    rotate z*19.581197
    rotate y*-180
    translate <-30.930570, -12.339760, 0>
    texture { YourTexture }
  }
  sphere { 0, 1.5 translate <-34.103960, -11.210940, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 1.498162 }
      plane { x, 1.331697 inverse }
    }
    translate x*-1.498162
    scale <20.183907, 1, 1>
    translate x*-0.074226
    rotate y*180
    rotate z*9.629558
    rotate y*-180
    translate <-34.103960, -11.210940, 0>
    texture { YourTexture }
  }
  sphere { 0, 1.333330 translate <-37.424680, -10.647520, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 1.331697 }
      plane { x, 1.165241 inverse }
    }
    translate x*-1.331697
    scale <20.185092, 1, 1>
    translate x*-0.065974
    rotate y*180
    rotate z*-0.322189
    rotate y*-180
    translate <-37.424680, -10.647520, 0>
    texture { YourTexture }
  }
  sphere { 0, 1.16667 translate <-40.792800, -10.666460, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 1.165241 }
      plane { x, 0.998775 inverse }
    }
    translate x*-1.165241
    scale <20.183923, 1, 1>
    translate x*-0.057731
    rotate y*180
    rotate z*-10.273580
    rotate y*-180
    translate <-40.792800, -10.666460, 0>
    texture { YourTexture }
  }
  sphere { 0, 1 translate <-44.106980, -11.267170, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 0.998775 }
      plane { x, 0.832309 inverse }
    }
    translate x*-0.998775
    scale <20.183938, 1, 1>
    translate x*-0.049484
    rotate y*180
    rotate z*-20.225422
    rotate y*-180
    translate <-44.106980, -11.267170, 0>
    texture { YourTexture }
  }
  sphere { 0, 0.83333 translate <-47.267480, -12.431600, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 0.833191 }
      plane { x, 0.763872 inverse }
    }
    translate x*-0.833191
    scale <54.665755, 1, 1>
    translate x*-0.015242
    rotate y*180
    rotate z*-35.439702
    rotate y*-180
    translate <-47.267480, -12.431600, 0>
    texture { YourTexture }
  }
  sphere { 0, 0.764 translate <-50.355790, -14.629570, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 0.763884 }
      plane { x, 0.697894 inverse }
    }
    translate x*-0.763884
    scale <57.424898, 1, 1>
    translate x*-0.013302
    rotate y*180
    rotate z*-25.912793
    rotate y*-180
    translate <-50.355790, -14.629570, 0>
    texture { YourTexture }
  }
  sphere { 0, 0.698 translate <-53.765300, -16.286080, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 0.697894 }
      plane { x, 0.631904 inverse }
    }
    translate x*-0.697894
    scale <57.424838, 1, 1>
    translate x*-0.012153
    rotate y*180
    rotate z*-16.386017
    rotate y*-180
    translate <-53.765300, -16.286080, 0>
    texture { YourTexture }
  }
  sphere { 0, 0.632 translate <-57.401950, -17.355440, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 0.631904 }
      plane { x, 0.565914 inverse }
    }
    translate x*-0.631904
    scale <57.424919, 1, 1>
    translate x*-0.011004
    rotate y*180
    rotate z*-6.859
    rotate y*-180
    translate <-57.401950, -17.355440, 0>
    texture { YourTexture }
  }
  sphere { 0, 0.566 translate <-61.165440, -17.808140, 0> texture { YourTexture } }
  object { Connector_2
    clipped_by {
      plane { x, 0.565914 }
      plane { x, 0.499924 inverse }
    }
    translate x*-0.565914
    scale <57.424908, 1, 1>
    translate x*-0.009855
    rotate y*180
    rotate z*2.667882
    rotate y*-180
    translate <-61.165440, -17.808140, 0>
    texture { YourTexture }
  }
  sphere { 0, 0.5 translate <-64.951950, -17.631700, 0> texture { YourTexture } }
  bounded_by { sphere { 0, 22.265562 translate <-45.809310, -13.844165, 0> } }
}

//---------- upper choppers
#declare tooth =
object {
  DCone
  scale <0.7, 6, 0.7>
  texture {
    pigment { colour White }
    finish { phong 1.0 ambient 0.4 diffuse 0.9 }
  }
}

//----------- lower choppers
#declare tooth2 =
object {
  DCone
  scale <0.7, 3, 0.7>
  rotate z*180
  texture { 
    pigment { colour White }
    finish { phong 1.0 ambient 0.4 diffuse 0.9 }
  }
}

//------------ jake the snake
#declare fish07 = 
union {
  object { neck_a }
  object { neck_b }
  object { head_a }
  object { eyes }	
  object { gums }
  object { tooth translate <-40, -12, -5.5> }
  object { tooth translate <-40, -12, 5.5> }
  object { tooth translate <-36, -12, -6.5> }
  object { tooth translate <-36, -12, 6.5> }
  object { tooth translate <-32, -12, -7.5> }
  object { tooth translate <-32, -12, 7.5> }
  object { tooth translate <-30, -12, -8.5> }
  object { tooth translate <-30, -12, 8.5> }
  object { tooth2 translate <-36, -17.5, -4.5> }
  object { tooth2 translate <-36, -17.5, 4.5> }
  object { tooth2 translate <-33, -16.5, -6> }
  object { tooth2 translate <-33, -16.5, 6> }
  object { tooth2 translate <-30, -15.5, -7> }
  object { tooth2 translate <-30, -15.5, 7> }
  object { tongue translate <5, -2, 0> }
  scale <1, 1, 0.8>
  bounded_by { sphere { 0, 97.539435 translate <0.172695, -52.792045, 0> } }
}