//------ Jake the Dormer Snake finds a gap chasm
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.5
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapes_old.inc"
#include "Plant.inc"
#include "Jake.inc"

//#default  { 
//texture {
//  pigment { color Red }
//  finish { ambient 0.35 diffuse 0.7 phong 1 phong_size 60 }
//}

#declare T1 = 
texture {
  pigment { color Gold }
  finish { ambient 0.4 diffuse 0.8 phong 1 phong_size 60 }
}

camera {
  location <100, 10700, -1600>
  direction z*1.5
  up y
  right x*image_width/image_height
  look_at <100, 10000, 0>
}

light_source { < -8100, 19050, -1000> color White }
light_source { < 80000, 19750,  1000> color Gold }
light_source { <-80000, 21750,  1000> color DkGreenCopper }

//------ World
union {
  plane { y, 50000 }
  plane { y, -50000 }
  texture {
    pigment { color Black }
    finish { ambient 1 diffuse 0 }
  }
}

//----------- Hight Field Mountains
#declare HILL1 =
height_field { pot "Pot1.pot" smooth
  texture {
    pigment { image_map { gif "frac5.gif" } rotate x*90 }
    finish { ambient 0.15 phong 1 diffuse 0.8 }
  }
  scale <2000, 10000, 2000>
  translate <-1000, 0, -1000>
  rotate y*-110 
}

//----------- Hight Field Mountains
#declare HILL2 =
height_field { pot "Pot1.pot" smooth
  texture {
    pigment { image_map { gif "frac5.gif" } rotate x*90 }
    finish { ambient 0.15 phong 1 diffuse 0.4 }
  }
  scale <50000, 25000, 50000> 
  translate <-30000, -16500, -3000> 
  rotate y*70
  translate <-6000, 0, -2000> 
}

#declare Ball = 
sphere { 0, 60
  texture {
    pigment { color Red }
    finish { phong 1 }
  }
}	

fog { color Black distance 50000 }

object { HILL1 }
object { HILL2 }
object { fish07 scale 6 rotate z*30 rotate y*-140 translate <-450, 10400, 360> }

#declare Plant =
union {
  object { BUNCH4 }
  object { BUNCH4 rotate y*45 }
  object { BUNCH3 translate y*15 }
}

object { Plant scale 3 translate < 120, 9910,   0> } 
object { Plant scale 3 translate <  -5, 9910, 450> } 
object { Plant scale 3 translate <-140, 9910,   0> } 
object { Plant scale 3 translate < -70, 9910, 140> } 