//--- Ancient Towers
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Torus For Dome Base
#declare T20 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -50.32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 49.68, 0, 0, 0, 0, 1, 0, -50.32, 0, 617.0256> sturm }

//--- Hersey Kiss Shape
#declare Piriform =
quartic { <4, 0, 0, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0, 0, 0, 0, 0, 1, 0, 0, 0, 0,  0, 0, 1, 0, 0> }

//--- Bright Metallic Gold
#declare Gold2 = 
texture {  
  pigment { colour red 0.64 green 0.51 blue 0.05 }
  finish { crand 0.02 ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8  specular 0.5  }
}

#declare DomeTexture =
texture {
  pigment {
    gradient y
    turbulence 0.3
    colour_map { [0 1  colour Gold colour Gray60] }
  }
  scale 2
  finish { ambient 0.1 phong 1 crand 0.1 }
}

#declare FrameTexture =
texture {
  pigment { colour Feldspar }
  finish { ambient 0.1 phong 1 crand 0.15 }
}

#declare Muck = colour red 0.76 green 0.74 blue 0.67;

#declare Body2Texture =
texture {
  pigment { colour Muck }
  finish { ambient 0.1 phong 1 crand 0.15 }
}

#declare BodyTexture =
texture {
  pigment { colour Gray50 }
  finish { ambient 0.1 phong 1 crand 0.15 }
}

//--- Kiss shaped Object
#declare Kiss =
object {
  Piriform rotate z*-90
  texture { DomeTexture }
  bounded_by { box { -1, 1 scale <0.66, 0.6, 0.66> translate y*-0.55 } }
}

//--- Kiss shape for Rib
#declare RKiss = object { Piriform rotate z*-90 }

//--- Dome Ribs
#declare DRib =
object {
  intersection { 
    object { RKiss scale 11 } 
    plane { z, 0.3 }
    plane { z, -0.3 inverse }
  }
  texture { Gold2 }
  bounded_by { box { -1, 1 scale <7, 6, 3> translate y*-5.5 } }
}

//---- Tower Type1
#declare Tower1 =
union {
  //--- Dome
  union {
    object { Kiss scale 10 translate y*10 }
    object { Kiss scale 2.9 translate y*10.7 texture { Gold2 } }
    object { Kiss scale <1.07, 6, 1.07> translate y*14.3 texture { Gold2 } }
    object { DRib rotate 0 translate y*10.5 }
    object { DRib rotate y*60 translate y*10.5 }
    object { DRib rotate y*120 translate y*10.5 }
    bounded_by { box { -1, 1 scale <7, 7.5, 7> translate y*7.3 } }
    translate y*42
  }
  //--- Torus Base
  object {
    quartic { T20 }
    texture { Gold2 }
    bounded_by { box { -1, 1 scale <5.5, 0.5, 5.5> } }
    translate y*42
  }
  //--- Tower Body
  object {
    difference {
      object { Disk_Y scale <5, 21, 5> translate y*21 }
      object { Cylinder_Y scale <4, 1, 4> }
      object { Cylinder_Z scale <3, 3, 1> translate y*35.2 }
      box { -1, 1 scale <1.8, 3.4, 6> translate y*33.2 }
    }
    texture { BodyTexture }
    bounded_by { box { -1, 1 scale <5.5, 22, 5.5> translate y*21 } }
  } 
  //--- Tower Window
  object {
    difference {
      union {
        object { Cylinder_Z scale <3.8, 3.8, 1> translate y*35.2 }
        box { -1, 1 scale <2.6, 4.2, 6> translate y*33.2 }
      }
      object { Cylinder_Z scale <3, 3, 1> translate y*35.2 }
      box { -1, 1 scale <1.8, 3.4, 6> translate y*33.2 }
      object { Cylinder_Y scale <5.5, 1, 5.5> inverse }
    }
    texture { FrameTexture }
    bounded_by { box { -1, 1 scale <4.2, 6, 6> translate y*33.9 } }
  }
  object { 
    union {
      object { Disk_Y scale <5.5, 1, 5.5> translate y*40.6 }
      object { Disk_Y scale <5.5, 13, 5.5> translate y*13 }
    }
    texture { FrameTexture }
  }
  bounded_by { box { -1, 1 scale <7, 30, 7> translate y*29 } }
}

//---- Tower Type2
#declare Tower2 =
union {
  //--- Dome
  union {
    object { Kiss scale 10 translate y*10 texture { BodyTexture } }
    object { Kiss scale 2.9 translate y*10.7 texture { Gold2 }}
    object { Kiss scale <1.07 6 1.07> translate y*14.3 texture { Gold2 }}
    object { DRib rotate 0 translate y*10.5 }
    object { DRib rotate y*60 translate y*10.5 }
    object { DRib rotate y*120 translate y*10.5 }
    bounded_by { box { -1, 1 scale <7, 7.5, 7> translate y*7.3 } }
    translate y*42
  }
  //--- Torus Base
  object {
    quartic { T20 }
    texture { Gold2 }
    bounded_by { box { -1, 1 scale <5.5, 0.5, 5.5> } }
    translate y*42 
  }
  //--- Tower Body
  object {
    difference {
      object { Disk_Y scale <5, 21, 5> translate y*21 }
      object { Cylinder_Y scale <4, 1, 4> }
      object { Cylinder_Z scale <3, 3, 1> translate y*35.2 }
      box { -1, 1 scale <1.8, 3.4, 6> translate y*33.2 }
    }
    texture { BodyTexture }
    bounded_by { box { -1, 1 scale <5.5, 22, 5.5> translate y*21 } }
  } 
  //--- Tower Window
  object {
    difference {
      union {
        object { Cylinder_Z scale <3.8, 3.8, 1> translate y*35.2 }
        box { -1, 1 scale <2.6, 4.2, 6> translate y*33.2 }
      }
      object { Cylinder_Z scale <3, 3, 1> translate y*35.2 }
      box { -1, 1 scale <1.8, 3.4, 6> translate y*33.2 }
      object { Cylinder_Y scale <5.5, 1, 5.5> inverse }
    }
    texture { Body2Texture }
    bounded_by { box { -1, 1 scale <4.2, 6, 6> translate y*33.9 } }
  }
  object { 
    union {
      object { Disk_Y scale <5.5, 1, 5.5> translate y*40.6 }
      object { Disk_Y scale <5.5, 13, 5.5> translate y*13 }
    }
    texture { Body2Texture }
  }
  bounded_by { box { -1, 1 scale <7, 30, 7> translate y*29 } }
}

//--- Post for Bridge
#declare Post1 = object { Disk_Y scale <0.2, 1.8, 0.2> }

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  

//--- Complete Tower 
union {
  union {
    object { Tower1 translate x*-22 }
    object { Tower1 translate x*22 }
    object { Tower1 scale <3, 2, 3> translate y*-61 }
    object { Tower2 scale 1.6 translate <14.3, 0, 23> }
    bounded_by { box { -1, 1 scale <33, 50, 30> translate <0, 49, 7.7> } }
  }
  union {
    object { Tower1 scale 1 translate x*64.6 }
    object { Tower2 scale 1.6 translate <75, 0, 23.1> }
    object { Tower2 scale 1.6 translate <75, -49.5, -9.1> }
    bounded_by { box { -1, 1 scale <19, 50, 30> translate <72.5, 49, 7.7> } }
  }
  //--- Bridge Span
  union {
    union {
      //--- Bridge Trim
      object {
        union {
          difference {
            object { Disk_Z scale <12, 12, 2> translate y*-14 }
            object { Cylinder_Z scale <11, 11, 1> translate y*-14 }
            plane { y, -14 }
          }
          box { -1, 1 scale <16.5, 0.6, 2> translate y*-0.6 }
          box { -1, 1 scale < 1.9, 1.1, 2> translate <-14.7, -15, 0> }
          box { -1, 1 scale < 1.9, 1.1, 2> translate < 14.7, -15, 0> }
        }
        texture { FrameTexture }
        bounded_by { box { -1, 1 scale <17.5, 9, 3> translate y*-8 } }
      }
      //--- Bridge Wall
      object {
        difference {
          box { -1, 1 scale <16.5, 6.45, 1.6> translate y*-7.6 }
          object { Cylinder_Z scale <12, 12, 1> translate y*-14 }
        }
        texture { BodyTexture }
        bounded_by { box { -1, 1 scale <17.5, 9, 3> translate y*-8 } }
      }
      bounded_by { box { -1, 1 scale <17.5 9 3> translate y*-8 } }
    }
    object {
      union {
        object { Post1 translate <-15,   1.8, 0> }
        object { Post1 translate <-13.5, 1.8, 0> }
        object { Post1 translate <-12,   1.8, 0> }
        object { Post1 translate <-10.5, 1.8, 0> }
        object { Post1 translate < -9,   1.8, 0> }
        object { Post1 translate < -7.5, 1.8, 0> }
        object { Post1 translate < -6,   1.8, 0> }
        object { Post1 translate < -4.5, 1.8, 0> }
        object { Post1 translate < -3,   1.8, 0> }
        object { Post1 translate < -1.5, 1.8, 0> }
        object { Post1 translate <  0,   1.8, 0> }
        object { Post1 translate < 15,   1.8, 0> }
        object { Post1 translate < 13.5, 1.8, 0> }
        object { Post1 translate < 12,   1.8, 0> }
        object { Post1 translate < 10.5, 1.8, 0> }
        object { Post1 translate <  9,   1.8, 0> }
        object { Post1 translate <  7.5, 1.8, 0> }
        object { Post1 translate <  6,   1.8, 0> }
        object { Post1 translate <  4.5, 1.8, 0> }
        object { Post1 translate <  3,   1.8, 0> }
        object { Post1 translate <  1.5, 1.8, 0> }
      }
      texture { Gold2 }
      bounded_by { box { -1, 1 scale <16, 2.3, 0.5> translate y*1.7 } }
    }
    translate <43.6, 30.6, 0>  
  }
  bounded_by { box { -1, 1 scale <65, 50, 30> translate <28.8, 49, 7.7> } }
  scale 16.6666
  translate <290, 1040, 1100>
}