//---- Slug Like Creature
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//--- Slug Textures
#declare Cream = colour rgb <0.9, 0.85, 0.8>;
#declare BruisedFlesh = colour rgb <0.69, 0.33, 0.33>;

//---- Main Body Texture
#declare BodyTexture =
texture {
  pigment {
    wood 
    turbulence 0.01
      colour_map {
        [0 0.1 colour Red colour Red]
        [0.1 0.14 colour Black colour Black]
        [0.14 0.4 colour Cream colour Cream]
        [0.4 1 colour Cream colour Gold]
      }
  }
  finish { ambient 0.1 diffuse 0.5 }
  scale 8
  translate y*1.5
}  
texture {
  pigment {
    gradient y
    colour_map {
      [0 0.15 colour DarkGreen colour BruisedFlesh]
      [0.15 0.24 colour BruisedFlesh colour Gold]
      [0.24 1 colour Gold colour Clear]
   }
  }
  finish { ambient 0.1 diffuse 0.5 }
  scale <9, 10, 9>
  translate y*-3.5
}  
texture {
  pigment { colour Clear }
  normal { bumps 1 frequency 0.01 }
  scale 0.1
  finish { ambient 0.1 diffuse 0.5 phong 0.7 phong_size 80 }
}  

//--- Leg Texture
#declare LegTexture =
texture {
  pigment {
    gradient y
    turbulence 0
    colour_map {
      [0 0.2 colour Black colour Red]
      [0.2 0.5 colour Red colour Gold]
      [0.5 1 colour Gold colour Gold]
    }
  }
  finish { ambient 0.1 diffuse 0.5 phong 1 phong_size 70 }
  scale <1, 7, 1>
}  

//---- Horn Texture
#declare YourTexture =
texture {
  pigment {
    gradient z
    colour_map {
      [0 0.4 colour Cream colour Gold]
      [0.4 0.7 colour Gold colour Scarlet]
      [0.7 1 colour Scarlet colour Black]
    }
  }
  finish { ambient 0.1 diffuse 0.5 phong 1 }
  scale <1, 1, 11.5>
}

//---- Head Texture
#declare HeadCheese =
texture {
  pigment {
    wood
    colour_map {
      [0 0.3 colour Black colour Violet]
      [0.3 0.6 colour Violet colour Scarlet]
      [0.6 0.8 colour Scarlet colour Gold]
      [0.8 1 colour Gold colour Cream]
    }
  }
  finish { ambient 0.2 phong 1 }
  scale <8, 8, 1>
}
texture {
  pigment { colour Clear }
  normal { bumps 1 frequency 0.01 }
  scale 0.1
  finish { ambient 0.1 diffuse 0.5 phong 0.7 phong_size 80 }
}  

//---- Alternative Head Pulpt
#declare HeadTexture =
texture {
  pigment {
    gradient z
    colour_map {
      [0 0.5 colour Cream colour Clear]
      [0.5 1 colour Clear colour Clear]
    }
  }
  finish { ambient 0.1 diffuse 0.4 phong 1 }
  scale <1, 1, 2>
  translate z*-2
}
texture {
  pigment { colour Clear }
  normal { bumps 1 frequency 0.01 }
  scale 0.1
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//--- Slug Leg
#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

//---- Make one Slug Leg
#declare Leg =
   union {
      sphere { 0, 0.1 translate <-6.5, 0.1, 0> texture { LegTexture } }
      object { Connector_2 
         clipped_by {
            plane { x, 0.297156 }
            plane { x, 0.099052 inverse }
         }
         translate x*-0.099052
         scale <7.211103, 1, 1>
         translate x*0.013736
         rotate z*74.054604
         rotate y*-180
         translate <-6.5, 0.1, 0>
         texture { LegTexture }
      }
      sphere { 0, 0.3 translate <-6.9, 1.5, 0> texture { LegTexture } }
      object { Connector_2 
         clipped_by {
            plane { x, 0.397553 }
            plane { x, 0.298165 inverse }
         }
         translate x*-0.298165
         scale <9, 1, 1>
         translate x*0.033129
         rotate z*83.659808
         rotate y*-180
         translate <-6.9, 1.5, 0>
         texture { LegTexture }
      }
      sphere { 0, 0.4 translate <-7, 2.4, 0> texture { LegTexture } }
      object { Connector_2 
         clipped_by {
            plane { x, 0.497947 }
            plane { x, 0.398357 inverse }
         }
         translate x*-0.398357
         scale <11, 1, 1>
         translate x*0.036214
         rotate z*84.805571
         translate <-7, 2.4, 0>
         texture { LegTexture }
      }
      sphere { 0, 0.5 translate <-6.9, 3.5, 0> texture { LegTexture } }
      object { Connector_2 
         clipped_by {
            plane { x, 0.596460 }
            plane { x, 0.497050 inverse }
         }
         translate x*-0.49705
         scale <9.165151, 1, 1>
         translate x*0.054233
         rotate z*77.471192
         translate <-6.9, 3.5, 0>
         texture { LegTexture }
      }
      sphere { 0, 0.6 translate <-6.7, 4.4, 0> texture { LegTexture } }
      object { Connector_2 
         clipped_by {
            plane { x, 0.692179 }
            plane { x, 0.593296 inverse }
         }
         translate x*-0.593296
         scale <6.633250, 1, 1>
         translate x*0.089443
         rotate z*63.434949
         translate <-6.7, 4.4, 0>
         texture { LegTexture }
      }
      sphere { 0, 0.7 translate <-6.4, 5, 0> texture { LegTexture } }
      object { Connector_2 
         clipped_by {
            plane { x, 0.834176 }
            plane { x, 0.686969 inverse }
         }
         translate x*-0.686969
         scale <5.109903, 1, 1>
         translate x*0.134439
         rotate z*39.805571
         translate <-6.4, 5, 0>
         texture { LegTexture }
      }
      sphere { 0, 0.85 translate <-5.8, 5.5, 0> texture { LegTexture } }
      object { Connector_2 
         clipped_by {
            plane { x, 0.982540 }
            plane { x, 0.835159 inverse }
         }
         translate x*-0.835159
         scale <5.280993, 1, 1>
         translate x*0.158144
         rotate z*29.744881
         translate <-5.8, 5.5, 0>
         texture { LegTexture }
      }
      object { Dot translate <-5.1, 5.9, 0> texture { LegTexture } }
      bounded_by { box { -1, 1 scale <2, 4, 1.2> translate <-5.8, 3.9, 0> } }
   }

//--- Slug's Body & Head

//--- Main Body Section
#declare B1 =
object {
  union {
    union {
      intersection {
        quadric { <0.073046018991965, -0.034925127830533, 0.073046018991965>, 0, 0, -1 }
        plane { y, 2.3 }
        plane { y, -2.3 inverse }
        rotate x*90
      }
      sphere { 0, 1 scale <4.05, 4.05, 2.6> translate z*-2.6 }
      sphere { 0, 1 scale <4.05, 4.05, 2.6> translate z*2.6 }
      scale <1, 0.8, 1> 
    }
    sphere { 0, 1 scale <1.9, 1.9, 1> rotate x*-20 translate <0, -0.8, -4.8> }
    sphere { 0, 1 scale <1.9, 1.9, 1> rotate x*20 translate <0, -0.8, 4.8> }
  } 
  texture { BodyTexture } 
  bounded_by { box { -1, 1 scale <4.2, 3.4, 6.2> } }
}

//--- Complete Body Section
#declare BS =
union {
  object { B1 translate y*7 }
  object { Leg rotate y*-90}
  object { Leg rotate y*90 }
  bounded_by { box { -1, 1 scale <4.2, 5.3, 7.8> translate y*5.1 } }
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//---- Head Horns
#declare Horn =
   union {

      sphere { 0, 0.97 texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.967528 }
            plane { x, 0.937605 inverse }
         }
         translate x*-0.967528
         scale <13.981666, 1, 1>
         translate x*-0.069200
         rotate y*180
         rotate y*134.452764
         texture { YourTexture }
      }
      sphere { 0, 0.94 translate <-0.2945, 0, -0.30018> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.937605 }
            plane { x, 0.907681 inverse }
         }
         translate x*-0.937605
         scale <13.981696, 1, 1>
         translate x*-0.067059
         rotate y*180
         rotate y*131.112482
         translate <-0.2945, 0, -0.30018>
         texture { YourTexture }
      }
      sphere { 0, 0.91 translate <-0.57101, 0, -0.61701> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.907681 }
            plane { x, 0.877758 inverse }
         }
         translate x*-0.907681
         scale <13.981624, 1, 1>
         translate x*-0.06492
         rotate y*180
         rotate y*127.772453
         translate <-0.57101, 0, -0.61701>
         texture { YourTexture }
      }

      sphere { 0, 0.88 translate <-0.82859, 0, -0.949410> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.877758 }
            plane { x, 0.847834 inverse }
         }
         translate x*-0.877758
         scale <13.981903, 1, 1>
         translate x*-0.062778
         rotate y*180
         rotate y*124.432247
         translate <-0.82859, 0, -0.949410>
         texture { YourTexture }
      }

      sphere { 0, 0.85 translate <-1.066370, 0, -1.296260> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.847834 }
            plane { x, 0.817911 inverse }
         }
         translate x*-0.847834
         scale <13.981642, 1, 1>
         translate x*-0.060639
         rotate y*180
         rotate y*121.091572
         translate <-1.066370, 0, -1.296260>
         texture { YourTexture }
      }
      sphere { 0, 0.82 translate <-1.28353, 0, -1.656370> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.817911 }
            plane { x, 0.787987 inverse }
         }
         translate x*-0.817911
         scale <13.981762, 1, 1>
         translate x*-0.058498
         rotate y*180
         rotate y*117.749657
         translate <-1.283530, 0, -1.656370>
         texture { YourTexture }
      }
      sphere { 0, 0.79 translate <-1.47933, 0, -2.028530> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.787987 }
            plane { x, 0.758064 inverse }
         }
         translate x*-0.787987
         scale <13.981669, 1, 1>
         translate x*-0.056359
         rotate y*180
         rotate y*114.410578
         translate <-1.479330, 0, -2.028530>
         texture { YourTexture }
      }
      sphere { 0, 0.76 translate <-1.65312, 0, -2.411460> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.758064 }
            plane { x, 0.728140 inverse }
         }
         translate x*-0.758064
         scale <13.981774, 1, 1>
         translate x*-0.054218
         rotate y*180
         rotate y*111.069694
         translate <-1.653120, 0, -2.411460>
         texture { YourTexture }
      }
      sphere { 0, 0.73 translate <-1.8043, 0, -2.803870> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.728140 }
            plane { x, 0.698216 inverse }
         }
         translate x*-0.728140
         scale <13.981721, 1, 1>
         translate x*-0.052078
         rotate y*180
         rotate y*107.729619
         translate <-1.804300, 0, -2.803870>
         texture { YourTexture }
      }
      sphere { 0, 0.7 translate <-1.93236, 0, -3.204420> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.698216 }
            plane { x, 0.668293 inverse }
         }
         translate x*-0.698216
         scale <13.981654, 1, 1>
         translate x*-0.049938
         rotate y*180
         rotate y*104.38884
         translate <-1.932360, 0, -3.204420>
         texture { YourTexture }
      }
      sphere { 0, 0.67 translate <-2.03686, 0, -3.611750> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.668293 }
            plane { x, 0.638369 inverse }
         }
         translate x*-0.668293
         scale <13.981766, 1, 1>
         translate x*-0.047797
         rotate y*180
         rotate y*101.048605
         translate <-2.036860, 0, -3.611750>
         texture { YourTexture }
      }
      sphere { 0, 0.64 translate <-2.11745, 0, -4.024480> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.638369 }
            plane { x, 0.608446 inverse }
         }
         translate x*-0.638369
         scale <13.981641, 1, 1>
         translate x*-0.045658
         rotate y*180
         rotate y*97.70908
         translate <-2.117450, 0, -4.024480>
         texture { YourTexture }
      }
      sphere { 0, 0.61 translate <-2.17386, 0, -4.441200> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.608446 }
            plane { x, 0.578522 inverse }
         }
         translate x*-0.608446
         scale <13.981646, 1, 1>
         translate x*-0.043517
         rotate y*180
         rotate y*94.366938
         translate <-2.173860, 0, -4.441200>
         texture { YourTexture }
      }
      sphere { 0, 0.58 translate <-2.20588, 0, -4.860500> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.578522 }
            plane { x, 0.548599 inverse }
         }
         translate x*-0.578522
         scale <13.981872, 1, 1>
         translate x*-0.041377
         rotate y*180
         rotate y*91.02736
         translate <-2.205880, 0, -4.860500>
         texture { YourTexture }
      }
      sphere { 0, 0.55 translate <-2.21342, 0, -5.280960> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.548599 }
            plane { x, 0.518675 inverse }
         }
         translate x*-0.548599
         scale <13.981703, 1, 1>
         translate x*-0.039237
         rotate y*180
         rotate y*87.687226
         translate <-2.21342, 0, -5.280960>
         texture { YourTexture }
      }
      sphere { 0, 0.52 translate <-2.19645, 0, -5.701140> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.518675 }
            plane { x, 0.488752 inverse }
         }
         translate x*-0.518675
         scale <13.981812, 1, 1>
         translate x*-0.037096
         rotate y*180
         rotate y*84.346076
         translate <-2.19645, 0, -5.701140>
         texture { YourTexture }
      }
      sphere { 0, 0.49 translate <-2.15502, 0, -6.119620> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.488752 }
            plane { x, 0.458828 inverse }
         }
         translate x*-0.488752
         scale <13.98163, 1, 1>
         translate x*-0.034957
         rotate y*180
         rotate y*81.006053
         translate <-2.15502, 0, -6.119620>
         texture { YourTexture }
      }
      sphere { 0, 0.46 translate <-2.08928, 0, -6.534970> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.458828 }
            plane { x, 0.428904 inverse }
         }
         translate x*-0.458828
         scale <13.981834, 1, 1>
         translate x*-0.032816
         rotate y*180
         rotate y*77.665821
         translate <-2.08928, 0, -6.534970>
         texture { YourTexture }
      }
      sphere { 0, 0.43 translate <-1.99945, 0, -6.945790> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.428904 }
            plane { x, 0.398981 inverse }
         }
         translate x*-0.428904
         scale <13.981628, 1, 1>
         translate x*-0.030676
         rotate y*180
         rotate y*74.32448
         translate <-1.99945, 0, -6.945790>
         texture { YourTexture }
      }
      sphere { 0, 0.4 translate <-1.88583, 0, -7.350670> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.398981 }
            plane { x, 0.369057 inverse }
         }
         translate x*-0.398981
         scale <13.981906, 1, 1>
         translate x*-0.028536
         rotate y*180
         rotate y*70.984254
         translate <-1.88583, 0, -7.350670>
         texture { YourTexture }
      }
      sphere { 0, 0.37 translate <-1.74881, 0, -7.748250> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.369057 }
            plane { x, 0.339134 inverse }
         }
         translate x*-0.369057
         scale <13.981535, 1, 1>
         translate x*-0.026396
         rotate y*180
         rotate y*67.643729
         translate <-1.74881, 0, -7.748250>
         texture { YourTexture }
      }
      sphere { 0, 0.34 translate <-1.58886, 0, -8.137160> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.339134 }
            plane { x, 0.309210 inverse }
         }
         translate x*-0.339134
         scale <13.981869, 1, 1>
         translate x*-0.024255
         rotate y*180
         rotate y*64.303868
         translate <-1.58886, 0, -8.137160>
         texture { YourTexture }
      }
      sphere { 0, 0.31 translate <-1.40652, 0, -8.516100> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.309210 }
            plane { x, 0.279287 inverse }
         }
         translate x*-0.30921
         scale <13.981526, 1, 1>
         translate x*-0.022116
         rotate y*180
         rotate y*60.962732
         translate <-1.40652, 0, -8.516100>
         texture { YourTexture }
      }
      sphere { 0, 0.28 translate <-1.20241, 0, -8.883760> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.279287 }
            plane { x, 0.249363 inverse }
         }
         translate x*-0.279287
         scale <13.981816, 1, 1>
         translate x*-0.019975
         rotate y*180
         rotate y*57.622437
         translate <-1.20241, 0, -8.883760>
         texture { YourTexture }
      }
      sphere { 0, 0.25 translate <-0.97722, 0, -9.238910> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.249363 }
            plane { x, 0.219439 inverse }
         }
         translate x*-0.249363
         scale <13.981649, 1, 1>
         translate x*-0.017835
         rotate y*180
         rotate y*54.281761
         translate <-0.97722, 0, -9.238910>
         texture { YourTexture }
      }
      sphere { 0, 0.22 translate <-0.73172, 0, -9.580330> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.219439 }
            plane { x, 0.189516 inverse }
         }
         translate x*-0.219439
         scale <13.981634, 1, 1>
         translate x*-0.015695
         rotate y*180
         rotate y*50.942491
         translate <-0.73172, 0, -9.580330>
         texture { YourTexture }
      }
      sphere { 0, 0.19 translate <-0.46675, 0, -9.906870> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.189516 }
            plane { x, 0.159592 inverse }
         }
         translate x*-0.189516
         scale <13.98181, 1, 1>
         translate x*-0.013554
         rotate y*180
         rotate y*47.602125
         translate <-0.46675, 0, -9.906870>
         texture { YourTexture }
      }
      sphere { 0, 0.16 translate <-0.1832, 0, -10.217420> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.159592 }
            plane { x, 0.129669 inverse }
         }
         translate x*-0.159592
         scale <13.981724, 1, 1>
         translate x*-0.011414
         rotate y*180
         rotate y*44.260069
         translate <-0.1832, 0, -10.217420>
         texture { YourTexture }
      }
      sphere { 0, 0.13 translate <0.11797, 0, -10.510910> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.129669 }
            plane { x, 0.099745 inverse }
         }
         translate x*-0.129669
         scale <13.981898, 1, 1>
         translate x*-0.009274
         rotate y*180
         rotate y*40.920355
         translate <0.11797, 0, -10.510910>
         texture { YourTexture }
      }
      sphere { 0, 0.1 translate <0.43573, 0, -10.786360> texture { YourTexture } }
      object { Connector_2
         clipped_by {
            plane { x, 0.099745 }
            plane { x, 0.069822 inverse }
         }
         translate x*-0.099745
         scale <13.981494, 1, 1>
         translate x*-0.007134
         rotate y*180
         rotate y*37.580056
         translate <0.43573, 0, -10.786360>
         texture { YourTexture }
      }
      sphere { 0, 0.07 translate <0.76899, 0, -11.042820> texture { YourTexture } }
      bounded_by { sphere { 0, 7.040532 translate <-0.90794, 0, -5.071410> } }
   }

//---- Torus's for Head
#declare MT1 = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -32.04, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 28.8,  0, 0, 0, 0, 1, 0, -32.04, 0, 207.36   > }
#declare MT2 = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -20,    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 16,    0, 0, 0, 0, 1, 0, -20,    0,  64      > }
#declare MT3 = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0,  -6.8,  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,  6.16, 0, 0, 0, 0, 1, 0,  -6.8,  0,   9.4864 > }

//---- Small Curved Fang
#declare Fang =
object {
  difference {
    cylinder { 0, y, 1 scale <1.1, 1, 1> translate <0.9, 0, -0.2> }
    cylinder { 0, y, 1 translate <1.2, 0, -0.15> }
    plane { y, 0 rotate z*-7 translate x*2 inverse}
    plane { y, 0 rotate z*7 translate x*2 }
  }
  texture {
    pigment {
      gradient z
      colour_map {
        [0 0.1 colour White colour Wheat]
        [0.1 0.3 colour Wheat colour Gold]
        [0.3 1 colour Gold colour Red]
      }
    }
    finish { ambient 0.3 diffuse 0.4 phong 1 }
    scale 1
    translate z*-1.2
  }
  bounded_by { box { -1, 1 scale <4, 2, 4> translate <0.9, 0, -0.3> } }
  scale <1, 0.8, 1>
  translate <-2.6, 0, -3.4>
}

//---- Head Section
//---- Complete Head
#declare Head =
union {
  union {
    object {
      union {
        difference {
          sphere { 0, 1 scale <4.25, 4.25, 4> translate z*-2.8 }
          sphere { 0, 1 scale <4.8, 4.8, 4.4> translate z*-4.8 }
        }
        object { MT1 rotate x*90 scale <1, 1, 1.1> translate z*-2.8 }
        object { MT2 rotate x*90 scale <1.1, 1.1, 1.7> translate z*-1.3 }
      }
      texture { BodyTexture }
      bounded_by { box { -6, 6 translate z*-1.5 } }
    }
    //--- Mouth
    object {
      union {
        object { MT2 rotate x*90 scale <1.1, 1.1, 1> translate z*-2.8 }
        object { MT3 rotate x*90 translate z*2.4 }
        object { Disk_Z scale <2, 2, 0.01> translate z*-2.4 }
      }
      texture { HeadCheese }
      bounded_by { box { -6, 6 translate z*-1.5 } }
    }
    object { Fang rotate 0 }
    object { Fang rotate z*30 }
    object { Fang rotate z*60 }
    object { Fang rotate z*90 }
    object { Fang rotate z*120 }
    object { Fang rotate z*150 }
    object { Fang rotate z*180 }
    object { Fang rotate z*210 }
    object { Fang rotate z*240 }
    object { Fang rotate z*270 }
    object { Fang rotate z*300 }
    object { Fang rotate z*330 }
    union {
      object { Horn translate <-4, 0, -2> rotate z*-45 }
      object { Horn translate <-4, 0, -2> rotate z*45 }
      object { Horn translate <-4, 0, -2> rotate z*135 }
      object { Horn translate <-4, 0, -2> rotate z*225 }
      scale 1
    }
    scale <1.1, 1, 1.1>
    rotate y*-90
    translate <1.5, 7, 0> 
  }
  object { BS }
}

//----- Body Translated in +Z direction for ground sweep
#declare BS1 = object { BS translate z*15 }

//---- Complete Slug in a Left Twist
union {
  //--- Tail
  object { BS  rotate y*90 translate y*10 rotate x*-15 translate <15, -10, 0> } 
  object { BS  rotate y*90 translate y*10 rotate x*-30 translate <15, -10, 0> } 
  object { BS  rotate y*90 translate y*10 rotate x*-45 translate <15, -10, 0> } 
  object { BS  rotate y*90 translate y*10 rotate x*-60 translate <15, -10, 0> } 
  object { BS  rotate y*90 translate y*10 rotate x*-75 translate <15, -10, 0> } 
  object { BS  rotate y*90 translate y*10 rotate x*-90 translate <15, -10, 0> } 
  object { BS  rotate y*90 translate y*10 rotate x*-105 translate <15, -10, 0> } 
  object { BS1 }
  object { BS1 rotate y*22.5 }
  object { BS1 rotate y*45 }
  object { BS1 rotate y*67.5 }
  object { BS1 rotate y*90 }
  object { BS  translate y*-15 rotate z*-18 translate <0, 15, 15> }
  object { BS  translate y*-15 rotate z*-36 translate <0, 15, 15> }
  object { BS  rotate x*9 translate y*-15 rotate z*-54 translate <0, 15, 15> }
  object { BS  rotate x*18 translate y*-15 rotate z*-72 translate <0, 15, 15> }
  object { BS  rotate x*27 translate y*-15 rotate z*-90 translate <0, 15, 15> }
  object { BS  rotate z*-90 rotate y*-36 translate z*15 rotate x*-15 translate <-15, 15, 0> } 
  object { BS  rotate z*-90 rotate y*-45 translate z*15 rotate x*-30 translate <-15, 15, 0> } 
  object { BS  rotate z*-90 rotate y*-54 translate z*15 rotate x*-45 translate <-15, 15, 0> } 
  object { BS  rotate z*-90 rotate y*-63 translate z*15 rotate x*-60 translate <-15, 15, 0> } 
  object { BS  rotate z*-90 rotate y*-72 translate z*15 rotate x*-75 translate <-15, 15, 0> } 
  object { BS  rotate z*-90 rotate y*-81 translate z*15 rotate x*-90 translate <-15, 15, 0> } 
  object { BS  rotate z*-90 rotate y*-81 translate z*15 rotate x*-105 translate <-15, 15, 0> } 
  object { Head rotate y*180 rotate z*-90 rotate y*-90 translate z*15 rotate x*-120 translate <-15, 15, 0> } 
  rotate y*-45
  scale 23
  translate <-260, 800, -1100>
  //--- to lazy to compute bound
}